/* Copyright (c) 2000, 2014 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   The YP Server is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The YP Server is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the YP Server; see the file COPYING. If
   not, write to the Free Software Foundation, Inc., 51 Franklin Street,
   Suite 500, Boston, MA 02110-1335, USA. */

#ifndef __ACCESS_H__
#define __ACCESS_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <rpc/rpc.h>

/* access.c */
extern void load_config (void);
extern int is_valid_domain (const char *domain);
extern int is_valid (struct svc_req *rqstp, const char *map,
		     const char *domain);

/* securenets.c */
extern int load_securenets (void);
extern int securenet_host (struct netconfig *nconf, struct netbuf *nbuf);
extern void dump_securenets (void);

/* systemd */
extern void announce_ready (void);

#endif
