#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.3'
__CHEETAH_versionTuple__ = (3, 2, 3, 'final', 0)
__CHEETAH_genTime__ = 1558054970.1837788
__CHEETAH_genTimestamp__ = 'Fri May 17 11:02:50 2019'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-3.0.0/xpdeint/xsil2graphics2/RImport.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class RImport(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(RImport, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: Creates text to import data from XSIL files into R. at line 30, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''Creates text to import data from XSIL files into R.''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def generateVariableName(self, xsilVariable, xsilObjectNumber, **KWS):



        ## CHEETAH: generated from @def generateVariableName(xsilVariable, xsilObjectNumber) at line 36, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        return ''.join([str(VFFSL(SL,"xsilVariable.name",True)),'_',str(VFFSL(SL,"xsilObjectNumber",True)+1)])
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loadXSILFile(self, xsilFile, **KWS):



        ## CHEETAH: generated from @def loadXSILFile($xsilFile) at line 40, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        for objectNum, xsilObject in enumerate(xsilFile.xsilObjects): # generated from line 41, col 3
            if xsilObject.data.format == 'hdf5': # generated from line 42, col 5
                _v = VFFSL(SL,"handleHDF5XSILObject",False)(objectNum, xsilObject) # '${handleHDF5XSILObject(objectNum, xsilObject)}' on line 43, col 1
                if _v is not None: write(_filter(_v, rawExpr='${handleHDF5XSILObject(objectNum, xsilObject)}')) # from line 43, col 1.
            else: # generated from line 44, col 5
                raise Exception("No support for R output for XSIL format '%s'." % xsilObject.data.format)
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def handleHDF5XSILObject(self, objectNum, xsilObject, **KWS):



        ## CHEETAH: generated from @def handleHDF5XSILObject(objectNum, xsilObject) at line 51, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''tryCatch (library (hdf5),
          error = function (e) {
                      message (e)
                      cat ("\\n")
                      stop ("Install the hdf5 library for loading XSIL data", call. = FALSE)
                      return (NA)
          })

''')
        filename = xsilObject.data.filename
        write('''hdf5load ("''')
        _v = VFFSL(SL,"filename",True) # '${filename}' on line 61, col 12
        if _v is not None: write(_filter(_v, rawExpr='${filename}')) # from line 61, col 12.
        write('''")
''')
        for var in xsilObject.independentVariables: # generated from line 62, col 3
            _v = VFFSL(SL,"var.name",True) # '${var.name}' on line 63, col 1
            if _v is not None: write(_filter(_v, rawExpr='${var.name}')) # from line 63, col 1.
            write('''.''')
            _v = VFFSL(SL,"objectNum",True)+1 # '${objectNum+1}' on line 63, col 13
            if _v is not None: write(_filter(_v, rawExpr='${objectNum+1}')) # from line 63, col 13.
            write(''' <- get ("''')
            _v = VFFSL(SL,"objectNum",True)+1 # '${objectNum+1}' on line 63, col 37
            if _v is not None: write(_filter(_v, rawExpr='${objectNum+1}')) # from line 63, col 37.
            write('''")$''')
            _v = VFFSL(SL,"var.name",True) # '${var.name}' on line 63, col 55
            if _v is not None: write(_filter(_v, rawExpr='${var.name}')) # from line 63, col 55.
            write('''
''')
        for var in xsilObject.dependentVariables: # generated from line 65, col 3
            _v = VFFSL(SL,"var.name",True) # '${var.name}' on line 66, col 1
            if _v is not None: write(_filter(_v, rawExpr='${var.name}')) # from line 66, col 1.
            write('''.''')
            _v = VFFSL(SL,"objectNum",True)+1 # '${objectNum+1}' on line 66, col 13
            if _v is not None: write(_filter(_v, rawExpr='${objectNum+1}')) # from line 66, col 13.
            write(''' <- get ("''')
            _v = VFFSL(SL,"objectNum",True)+1 # '${objectNum+1}' on line 66, col 37
            if _v is not None: write(_filter(_v, rawExpr='${objectNum+1}')) # from line 66, col 37.
            write('''")$''')
            _v = VFFSL(SL,"var.name",True) # '${var.name}' on line 66, col 55
            if _v is not None: write(_filter(_v, rawExpr='${var.name}')) # from line 66, col 55.
            write('''
''')
        write('''rm ("''')
        _v = VFFSL(SL,"objectNum",True)+1 # '${objectNum+1}' on line 68, col 6
        if _v is not None: write(_filter(_v, rawExpr='${objectNum+1}')) # from line 68, col 6.
        write('''")
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # RImport.tmpl
        # 
        # Created by Rafael Laboissiere on 2013-01-04.
        # 
        # Based on MatlabOctaveImport.tmpl, which was:
        # 
        # Created by Joe Hope on 2009-01-07.
        # Modified by Gregory Bogomiagkov and Liam Madge on 2013-07-18.
        # 
        # Copyright (c) 2009-2013, Joe Hope and Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''





''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    defaultExtension = 'r'

    stringFormat = '.12e'

    name = 'R'

    _mainCheetahMethod_for_RImport = 'respond'

## END CLASS DEFINITION

if not hasattr(RImport, '_initCheetahAttributes'):
    templateAPIClass = getattr(RImport,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(RImport)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=RImport()).run()


