#include "udposix.h"
#include <stdio.h>
#include "xgks.h"

static int	wsid_x11	= 1;
static int	wsid_mo		= 2;
static int	wsid_wiss	= 3;
static int	trans_id	= 1;


    static void
openplot() 
{
    float	xmin, xmax, ymin, ymax;

    /*
     * Open the GKS plot package.
     * Opens X11 workstation (iwk=#1) and/or metafile (iwk=#2) for plotting.
     * Sets transformation #1 from Plot-Board (PB) WCs (inches) to NDCs.
     */

    /* Open GKS */ {
	int	errfile	= 6;
	int	memory	= 0;

	(void) gopks_(&errfile, &memory);
    }

    /* Open and activate X11 workstation. */ {
	int	wtype	= 4;
	int	conid	= 0;

	(void) gopwk_(&wsid_x11, &conid, &wtype);
	(void) gacwk_(&wsid_x11);
    }

    /* Make whole X11 gks-window the workstation window. */
    xmin = 0;
    xmax = 1;
    ymin = 0;
    ymax = .8;
    (void) gswkwn_(&wsid_x11, &xmin, &xmax, &ymin, &ymax);

    /* Open and activate metafile "workstation". */ {
	char	*mo_path	= "meta1.gks";
	int	len	= strlen(mo_path);
	int	wtype	= 2;
	int	conid	= 0;

	(void) gescid_(mo_path, len);
	(void) gopwk_(&wsid_mo, &conid, &wtype);
	(void) gacwk_(&wsid_mo);
	(void) gswkwn_(&wsid_mo, &xmin, &xmax, &ymin, &ymax);
    }

    /* Open and activate WISS "workstation". */ {
	int	wtype	= 3;
	int	conid	= 0;

	(void) gopwk_(&wsid_wiss, &conid, &wtype);
	(void) gacwk_(&wsid_wiss);
    }

    /*
     * Define a Plot-Board-World-Coord (PBWC) system in inches
     * with bounds based on NDC window shape.
     * (WCs will be 10 times larger than NDC's)
     */
    (void) gsvp_(&trans_id, &xmin, &xmax, &ymin, &ymax);
    xmin *= 10;
    xmax *= 10;
    ymin *= 10;
    ymax *= 10;
    (void) gswn_(&trans_id, &xmin, &xmax, &ymin, &ymax);

    (void) gselnt_(&trans_id);
}


    static void
setclrmap(ncolors, red, grn, blu)
    int		ncolors;
    int		*red, *grn, *blu;
{
    int		i;

    /* Set color map. */
    for (i = 0; i < ncolors; ++i) {
	float	r	= red[i]/255.0;
	float	g	= grn[i]/255.0;
	float	b	= blu[i]/255.0;

	(void) gscr_(&wsid_x11, &i, &r, &g, &b);
	(void) gscr_(&wsid_mo,  &i, &r, &g, &b);
    }
}


    static void
closeplot()
{
    /* Close the X11 workstation. */
    (void) gdawk_(&wsid_x11);
    (void) gclwk_(&wsid_x11);

    /* Close the meta-workstation. */
    (void) gdawk_(&wsid_mo);
    (void) gclwk_(&wsid_mo);

    /* Close the WISS workstation. */
    (void) gdawk_(&wsid_wiss);
    (void) gclwk_(&wsid_wiss);

    /* Close GKS. */
    (void) gclks_();
}


    static
WaitForBreak(wsid)
    Gint            wsid;
{
    Gchoice         init;
    Gchoicerec      record;
    Glimit          earea;

    earea.xmin = 0.0;
    earea.xmax = 1279.0;
    earea.ymin = 0.0;
    earea.ymax = 1023.0;

    init.status = GC_NOCHOICE;
    init.choice = 0;
    record.pet1.data = NULL;
    ginitchoice(wsid, 1, &init, 1, &earea, &record);
    gsetchoicemode(wsid, 1, GREQUEST, GECHO);
    for (; init.status != GC_NONE;)
	greqchoice(wsid, 1, &init);
}


main()
{
    int		ired[256], igrn[256], iblu[256];
    int		ncolors;
    int		i;

    /* Set color map. */
    (void) printf("Give ncolors (try 16 and 17, for example): ");
    (void) scanf("%d", &ncolors);

    /*Open plot. */
    openplot();

    ired[0] = 255;
    igrn[0] = 255;
    iblu[0] = 255;

    for (i = 1; i < ncolors; ++i) {
        ired[i] = 0;
        igrn[i] = 0;
        iblu[i] = 0;
    }
    setclrmap(ncolors, ired, igrn, iblu);

    /* Plot  polyline. */
    for (i = 0; i < 40; ++i) {
	int	npts	= 2;
	float	x[2], y[2];

	(void) printf("Plotting polyline = %d\n", i);

        x[0]	= 1.0 + (i+1)*0.1;
        y[0]	= 1.0;
        x[1]	= x[0];
        y[1]	= y[0] + 1.0;

	(void) gpl_(&npts, x, y);
    }

    /* Finish plotting. */
    WaitForBreak(wsid_x11);
    closeplot();
}
