/* Copyright (C) 2024 The PARI group.

This file is part of the PARI-XEUS package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. */

#ifndef XEUS_GP_CONFIG_HPP
#define XEUS_GP_CONFIG_HPP

// Project version
#define XEUS_GP_VERSION_MAJOR 0
#define XEUS_GP_VERSION_MINOR 1
#define XEUS_GP_VERSION_PATCH 0

// Composing the version string from major, minor and patch
#define XEUS_GP_CONCATENATE(A, B) XEUS_GP_CONCATENATE_IMPL(A, B)
#define XEUS_GP_CONCATENATE_IMPL(A, B) A##B
#define XEUS_GP_STRINGIFY(a) XEUS_GP_STRINGIFY_IMPL(a)
#define XEUS_GP_STRINGIFY_IMPL(a) #a

#define XEUS_GP_VERSION XEUS_GP_STRINGIFY(XEUS_GP_CONCATENATE(XEUS_GP_VERSION_MAJOR,   \
                 XEUS_GP_CONCATENATE(.,XEUS_GP_CONCATENATE(XEUS_GP_VERSION_MINOR,   \
                                  XEUS_GP_CONCATENATE(.,XEUS_GP_VERSION_PATCH)))))

#ifdef _WIN32
    #ifdef XEUS_GP_EXPORTS
        #define XEUS_GP_API __declspec(dllexport)
    #else
        #define XEUS_GP_API __declspec(dllimport)
    #endif
#else
    #define XEUS_GP_API
#endif

#endif
