// Working part of WManager
//
// Copyright (C) 1999  M. Tessmer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef WManager_H
#define WManager_H


// SYSTEM INCLUDES /////////////////////////////////
#include <string>                                 // standard string class
#include <fstream>                                // file streams

// PROJECT INCLUDES ///////////////////////////////////////////////////////////
#include "Interface.H"


// LOCAL INCLUDES /////////////////////////////////////////////////////////////
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Browser.H>

//: wmanager base class
// It is simply the main app class.
class WManager {
public:
  
  //: Constructor
  WManager();
  
  //: Destructor
  ~WManager();

  //: Initialize the interface
  void 
  Init();

  //: Check commandline arguments
  //
  //! param: argc - No. of arguments
  //! param: argv - Array of arguments
  int
  CheckArguments(int    argc,
		 char** argv);

  //: Parse configuration file
  void
  ParseFile();

  //: Enter the Fltk run loop
  //
  //! param: argc - No. of arguments
  //! param: argv - Array of arguments
  void
  Run(int    argc,
      char** argv);
  
  
private:
  Interface* _Interface;
  std::string*    _ConfigurationFilename;

  void
  _ParseConfigurationFile(std::ifstream* filestream);

  void
  _TokenizeAndAddToBrowser(char* entry);

  char*
  _CutString(const char* str,
	     const char* sub);
};

#endif // WManager_H
