/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.util;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.GeometryData;
import org.j3d.geom.IntersectionUtils;

public class J3DIntersectionUtils
extends IntersectionUtils {
    private Transform3D reverseTx = new Transform3D();

    public boolean rayUnknownGeometry(Point3d point3d, Vector3d vector3d, float f, GeometryData geometryData, Transform3D transform3D, Point3d point3d2, boolean bl) {
        boolean bl2 = false;
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        switch (geometryData.geometryType) {
            case 1: {
                bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.vertexCount / 3, point3d2, bl);
                break;
            }
            case 2: {
                bl2 = this.rayQuadArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.vertexCount / 4, point3d2, bl);
                break;
            }
            case 3: {
                bl2 = this.rayTriangleStripArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.stripCounts, geometryData.numStrips, point3d2, bl);
                break;
            }
            case 4: {
                bl2 = this.rayTriangleFanArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.stripCounts, geometryData.numStrips, point3d2, bl);
                break;
            }
            case 5: {
                bl2 = this.rayIndexedQuadArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.indexes, geometryData.indexesCount, point3d2, bl);
                break;
            }
            case 6: {
                bl2 = this.rayIndexedTriangleArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.indexes, geometryData.indexesCount, point3d2, bl);
            }
        }
        if (bl2) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayUnknownGeometry(Point3d point3d, Vector3d vector3d, float f, GeometryArray geometryArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        Object object = geometryArray.getUserData();
        if (object instanceof GeometryData) {
            return this.rayUnknownGeometry(point3d, vector3d, f, (GeometryData)object, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof TriangleArray) {
            return this.rayTriangleArray(point3d, vector3d, f, (TriangleArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof QuadArray) {
            return this.rayQuadArray(point3d, vector3d, f, (QuadArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof TriangleStripArray) {
            return this.rayTriangleStripArray(point3d, vector3d, f, (TriangleStripArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof TriangleFanArray) {
            return this.rayTriangleFanArray(point3d, vector3d, f, (TriangleFanArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof IndexedTriangleArray) {
            return this.rayIndexedTriangleArray(point3d, vector3d, f, (IndexedTriangleArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof IndexedQuadArray) {
            return this.rayIndexedQuadArray(point3d, vector3d, f, (IndexedQuadArray)geometryArray, transform3D, point3d2, bl);
        }
        return false;
    }

    public boolean rayTriangleArray(Point3d point3d, Vector3d vector3d, float f, TriangleArray triangleArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!triangleArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        int n = triangleArray.getVertexFormat();
        int n2 = triangleArray.getVertexCount();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        if ((n & 0x100) != 0) {
            float[] fArray = triangleArray.getInterleavedVertices();
            int n3 = 0;
            int n4 = 0;
            if ((n & 0x20) != 0) {
                n3 += 2 * triangleArray.getTexCoordSetCount();
            } else if ((n & 0x40) != 0) {
                n3 += 3 * triangleArray.getTexCoordSetCount();
            } else if ((n & 0x400) != 0) {
                n3 += 4 * triangleArray.getTexCoordSetCount();
            }
            if ((n & 4) != 0) {
                n3 += 3;
            } else if ((n & 0xC) != 0) {
                n3 += 4;
            }
            if ((n & 2) != 0) {
                n3 += 3;
            }
            for (int i = n3; i < fArray.length; i += n3) {
                this.workingCoords[n4++] = fArray[i++];
                this.workingCoords[n4++] = fArray[i++];
                this.workingCoords[n4++] = fArray[i++];
            }
        } else {
            triangleArray.getCoordinates(0, this.workingCoords);
        }
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, this.workingCoords, n2 / 3, point3d2, bl);
        if (bl2) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayQuadArray(Point3d point3d, Vector3d vector3d, float f, QuadArray quadArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!quadArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        int n = quadArray.getVertexFormat();
        int n2 = quadArray.getVertexCount();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 4];
        }
        if ((n & 0x100) != 0) {
            float[] fArray = quadArray.getInterleavedVertices();
            int n3 = 0;
            int n4 = 0;
            if ((n & 0x20) != 0) {
                n3 += 2 * quadArray.getTexCoordSetCount();
            } else if ((n & 0x40) != 0) {
                n3 += 3 * quadArray.getTexCoordSetCount();
            } else if ((n & 0x400) != 0) {
                n3 += 4 * quadArray.getTexCoordSetCount();
            }
            if ((n & 4) != 0) {
                n3 += 3;
            } else if ((n & 0xC) != 0) {
                n3 += 4;
            }
            if ((n & 2) != 0) {
                n3 += 3;
            }
            for (int i = n3; i < fArray.length; i += n3) {
                this.workingCoords[n4++] = fArray[i++];
                this.workingCoords[n4++] = fArray[i++];
                this.workingCoords[n4++] = fArray[i++];
                this.workingCoords[n4++] = fArray[i++];
            }
        } else {
            quadArray.getCoordinates(0, this.workingCoords);
        }
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, this.workingCoords, n2 / 4, point3d2, bl);
        if (bl2) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayTriangleStripArray(Point3d point3d, Vector3d vector3d, float f, TriangleStripArray triangleStripArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!triangleStripArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        int n = triangleStripArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = triangleStripArray.getVertexCount();
        int n3 = triangleStripArray.getNumStrips();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        if (this.workingStrips == null || this.workingStrips.length != n3) {
            this.workingStrips = new int[n3];
        }
        triangleStripArray.getCoordinates(0, this.workingCoords);
        triangleStripArray.getStripVertexCounts(this.workingStrips);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayTriangleStripArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingStrips, n3, point3d2, bl);
        if (bl2 && !bl) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayTriangleFanArray(Point3d point3d, Vector3d vector3d, float f, TriangleFanArray triangleFanArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!triangleFanArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        int n = triangleFanArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = triangleFanArray.getVertexCount();
        int n3 = triangleFanArray.getNumStrips();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        if (this.workingStrips == null || this.workingStrips.length != n3) {
            this.workingStrips = new int[n3];
        }
        triangleFanArray.getCoordinates(0, this.workingCoords);
        triangleFanArray.getStripVertexCounts(this.workingStrips);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayTriangleFanArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingStrips, n3, point3d2, bl);
        if (bl2 && !bl) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayIndexedTriangleArray(Point3d point3d, Vector3d vector3d, float f, IndexedTriangleArray indexedTriangleArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!indexedTriangleArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        if (!indexedTriangleArray.getCapability(9)) {
            throw new IllegalStateException("Not allowed to read indexes");
        }
        int n = indexedTriangleArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = indexedTriangleArray.getVertexCount();
        int n3 = indexedTriangleArray.getIndexCount();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        if (this.workingIndicies == null || this.workingIndicies.length != n3) {
            this.workingIndicies = new int[n3];
        }
        indexedTriangleArray.getCoordinates(0, this.workingCoords);
        indexedTriangleArray.getCoordinateIndices(0, this.workingIndicies);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayIndexedTriangleArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingIndicies, n3, point3d2, bl);
        if (bl2 && !bl) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayIndexedQuadArray(Point3d point3d, Vector3d vector3d, float f, IndexedQuadArray indexedQuadArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!indexedQuadArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        if (!indexedQuadArray.getCapability(9)) {
            throw new IllegalStateException("Not allowed to read indexes");
        }
        int n = indexedQuadArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = indexedQuadArray.getVertexCount();
        int n3 = indexedQuadArray.getIndexCount();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        if (this.workingIndicies == null || this.workingIndicies.length != n3) {
            this.workingIndicies = new int[n3];
        }
        indexedQuadArray.getCoordinates(0, this.workingCoords);
        indexedQuadArray.getCoordinateIndices(0, this.workingIndicies);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayIndexedQuadArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingIndicies, n3, point3d2, bl);
        if (bl2 && !bl) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    private void transformPicks(Transform3D transform3D, Point3d point3d, Vector3d vector3d) {
        transform3D.transform(point3d, this.pickStart);
        transform3D.transform(vector3d, this.pickDir);
    }
}

