/*---------------------------------------------------------------------------*\

    Simple time tracking structure.

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#include "timer.h"
#include "generic.h"


void Timer::start()
{
	m_start = GenerictimeGetTime();
}

bool Timer::check_timeout(unsigned int elapsed)
{
	if( m_start == 0 ) return false;
	return GenerictimeGetTime() - m_start > elapsed * 1000;
}

bool Timer::check_timeout_ms(unsigned long elapsedms)
{
	if( m_start == 0 ) return false;
	return GenerictimeGetTime() - m_start > elapsedms;
}

