/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.
This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

#include <stdlib.h>
#include "apriltag.h"

apriltag_family_t *tag36h10_create()
{
   apriltag_family_t *tf = (apriltag_family_t *)calloc(1, sizeof(apriltag_family_t));
#ifdef WINRT
   tf->name = _strdup("tag36h10");
#else
   tf->name = strdup("tag36h10");
#endif
   tf->h = 10;
   tf->ncodes = 2320;
   tf->codes = (uint64_t *)calloc(2320, sizeof(uint64_t));
   tf->codes[0] = 0x00000001a42f9469UL;
   tf->codes[1] = 0x000000021a48c08dUL;
   tf->codes[2] = 0x000000026dfdbc5dUL;
   tf->codes[3] = 0x00000002d19b78fbUL;
   tf->codes[4] = 0x000000031c5557dfUL;
   tf->codes[5] = 0x00000003f2b3d349UL;
   tf->codes[6] = 0x00000003e6d4a7a5UL;
   tf->codes[7] = 0x000000043d6dfb6dUL;
   tf->codes[8] = 0x00000005688d2affUL;
   tf->codes[9] = 0x000000054663b474UL;
   tf->codes[10] = 0x000000067fd759e4UL;
   tf->codes[11] = 0x000000073b196d82UL;
   tf->codes[12] = 0x00000007de71c630UL;
   tf->codes[13] = 0x00000008492722d4UL;
   tf->codes[14] = 0x0000000835407afaUL;
   tf->codes[15] = 0x0000000893a6fe16UL;
   tf->codes[16] = 0x000000095668d348UL;
   tf->codes[17] = 0x00000009c20e37a4UL;
   tf->codes[18] = 0x0000000a19bb676cUL;
   tf->codes[19] = 0x0000000ad1355c1bUL;
   tf->codes[20] = 0x0000000b2ab4ac53UL;
   tf->codes[21] = 0x0000000b14f27095UL;
   tf->codes[22] = 0x0000000bef6b014dUL;
   tf->codes[23] = 0x0000000c9ecbadc7UL;
   tf->codes[24] = 0x0000000e1996a6bdUL;
   tf->codes[25] = 0x0000000edc588fcbUL;
   tf->codes[26] = 0x0000000f26d9d7a1UL;
   tf->codes[27] = 0x0000000035e79c1aUL;
   tf->codes[28] = 0x00000001644f74a8UL;
   tf->codes[29] = 0x00000001bfda85e0UL;
   tf->codes[30] = 0x000000020573db2aUL;
   tf->codes[31] = 0x000000027614bfd6UL;
   tf->codes[32] = 0x00000002daf26b72UL;
   tf->codes[33] = 0x0000000332930a98UL;
   tf->codes[34] = 0x00000003176c5674UL;
   tf->codes[35] = 0x00000003892ad2d0UL;
   tf->codes[36] = 0x00000003fd4d26acUL;
   tf->codes[37] = 0x00000004b88a1fcaUL;
   tf->codes[38] = 0x0000000555b6b579UL;
   tf->codes[39] = 0x00000006103880d7UL;
   tf->codes[40] = 0x00000006045e58fbUL;
   tf->codes[41] = 0x00000006dedf28a3UL;
   tf->codes[42] = 0x000000072766f249UL;
   tf->codes[43] = 0x00000007e4a0c77fUL;
   tf->codes[44] = 0x0000000973ba8e61UL;
   tf->codes[45] = 0x0000000965fd5285UL;
   tf->codes[46] = 0x00000009d99bd6a9UL;
   tf->codes[47] = 0x0000000a221264e6UL;
   tf->codes[48] = 0x0000000a1455fccaUL;
   tf->codes[49] = 0x0000000a7cb3193eUL;
   tf->codes[50] = 0x0000000aead44d92UL;
   tf->codes[51] = 0x0000000ad50ac954UL;
   tf->codes[52] = 0x0000000b2f0bb19cUL;
   tf->codes[53] = 0x0000000cba043aa2UL;
   tf->codes[54] = 0x0000000d73d7f6b4UL;
   tf->codes[55] = 0x0000000d6d189310UL;
   tf->codes[56] = 0x0000000f41278885UL;
   tf->codes[57] = 0x00000001c45306afUL;
   tf->codes[58] = 0x0000000222b4420bUL;
   tf->codes[59] = 0x00000002d70ceeb1UL;
   tf->codes[60] = 0x0000000392cb439fUL;
   tf->codes[61] = 0x000000045d1179eeUL;
   tf->codes[62] = 0x000000057a79d05cUL;
   tf->codes[63] = 0x000000062bc91dd6UL;
   tf->codes[64] = 0x000000073ca773c0UL;
   tf->codes[65] = 0x00000008b3da6eb0UL;
   tf->codes[66] = 0x00000009c5a521c7UL;
   tf->codes[67] = 0x0000000a812a1881UL;
   tf->codes[68] = 0x0000000adeab4859UL;
   tf->codes[69] = 0x0000000b3402b213UL;
   tf->codes[70] = 0x0000000b9171667fUL;
   tf->codes[71] = 0x0000000f5ac6918cUL;
   tf->codes[72] = 0x00000000549b1cfcUL;
   tf->codes[73] = 0x00000000b2744a58UL;
   tf->codes[74] = 0x00000000ae12ceb4UL;
   tf->codes[75] = 0x00000002f8aaab94UL;
   tf->codes[76] = 0x000000038db1c43bUL;
   tf->codes[77] = 0x00000004be190989UL;
   tf->codes[78] = 0x000000051bef9565UL;
   tf->codes[79] = 0x0000000505a8d1c3UL;
   tf->codes[80] = 0x0000000575ce25bfUL;
   tf->codes[81] = 0x000000068ac14eb1UL;
   tf->codes[82] = 0x00000006fd1bca45UL;
   tf->codes[83] = 0x0000000854752994UL;
   tf->codes[84] = 0x00000009e96b442aUL;
   tf->codes[85] = 0x0000000afb308f74UL;
   tf->codes[86] = 0x0000000cd9c8ca44UL;
   tf->codes[87] = 0x0000000d23c9b28eUL;
   tf->codes[88] = 0x0000000d07277423UL;
   tf->codes[89] = 0x0000000e8b3a6959UL;
   tf->codes[90] = 0x0000000f44bc546fUL;
   tf->codes[91] = 0x000000010e4aa7f3UL;
   tf->codes[92] = 0x000000029971cc68UL;
   tf->codes[93] = 0x000000062d7b0b94UL;
   tf->codes[94] = 0x00000008c22aac77UL;
   tf->codes[95] = 0x00000008b46d70d3UL;
   tf->codes[96] = 0x0000000a43373b0dUL;
   tf->codes[97] = 0x0000000e2efd2c74UL;
   tf->codes[98] = 0x0000000f5f4587e6UL;
   tf->codes[99] = 0x000000001b82bfa0UL;
   tf->codes[100] = 0x00000000642bef7aUL;
   tf->codes[101] = 0x00000001e576f881UL;
   tf->codes[102] = 0x00000002a290cda7UL;
   tf->codes[103] = 0x00000003b1ae80b1UL;
   tf->codes[104] = 0x000000053b9317e3UL;
   tf->codes[105] = 0x00000005833ac709UL;
   tf->codes[106] = 0x00000005f25d3ff5UL;
   tf->codes[107] = 0x0000000648fcef3dUL;
   tf->codes[108] = 0x000000068d6350d6UL;
   tf->codes[109] = 0x00000008064a4da6UL;
   tf->codes[110] = 0x000000092b76e736UL;
   tf->codes[111] = 0x00000009157102b0UL;
   tf->codes[112] = 0x00000009eef0de60UL;
   tf->codes[113] = 0x0000000b098e9306UL;
   tf->codes[114] = 0x0000000b63e94718UL;
   tf->codes[115] = 0x0000000c1241e99bUL;
   tf->codes[116] = 0x0000000eab42b39fUL;
   tf->codes[117] = 0x0000000fca2a422dUL;
   tf->codes[118] = 0x0000000007f86a4bUL;
   tf->codes[119] = 0x0000000124962550UL;
   tf->codes[120] = 0x00000001fe977988UL;
   tf->codes[121] = 0x0000000300a8b4c4UL;
   tf->codes[122] = 0x000000076c2b21a1UL;
   tf->codes[123] = 0x0000000932f76619UL;
   tf->codes[124] = 0x00000009994e9b51UL;
   tf->codes[125] = 0x0000000a634fcb8bUL;
   tf->codes[126] = 0x0000000b6d92c074UL;
   tf->codes[127] = 0x0000000bcbf53858UL;
   tf->codes[128] = 0x0000000c0c3a0d7eUL;
   tf->codes[129] = 0x000000001c31a9c3UL;
   tf->codes[130] = 0x00000000d5a694d5UL;
   tf->codes[131] = 0x000000012f2fc41dUL;
   tf->codes[132] = 0x00000005a342598aUL;
   tf->codes[133] = 0x00000006466af138UL;
   tf->codes[134] = 0x000000081eb68f22UL;
   tf->codes[135] = 0x000000098e885eb6UL;
   tf->codes[136] = 0x0000000ab594f405UL;
   tf->codes[137] = 0x0000000b19f201a1UL;
   tf->codes[138] = 0x0000000d44832643UL;
   tf->codes[139] = 0x0000000fdc915802UL;
   tf->codes[140] = 0x00000000ee4f05dcUL;
   tf->codes[141] = 0x00000003043aa2a6UL;
   tf->codes[142] = 0x00000003765d7a9aUL;
   tf->codes[143] = 0x00000005468500abUL;
   tf->codes[144] = 0x000000059d38dc6bUL;
   tf->codes[145] = 0x000000060b5e288fUL;
   tf->codes[146] = 0x00000009539ba6dfUL;
   tf->codes[147] = 0x00000009a93219d2UL;
   tf->codes[148] = 0x0000000ad81ab160UL;
   tf->codes[149] = 0x0000000abe7d650cUL;
   tf->codes[150] = 0x0000000beb8dd89eUL;
   tf->codes[151] = 0x0000000bd5432e10UL;
   tf->codes[152] = 0x000000009aafb509UL;
   tf->codes[153] = 0x000000014f535a9bUL;
   tf->codes[154] = 0x0000000202956e9dUL;
   tf->codes[155] = 0x00000003d64508f8UL;
   tf->codes[156] = 0x00000005babe994eUL;
   tf->codes[157] = 0x00000006d1c1e752UL;
   tf->codes[158] = 0x000000094cb57d7bUL;
   tf->codes[159] = 0x00000009a45c8c11UL;
   tf->codes[160] = 0x0000000a7f4dd4c9UL;
   tf->codes[161] = 0x0000000d6ab9426bUL;
   tf->codes[162] = 0x0000000da6766828UL;
   tf->codes[163] = 0x0000000f1608f9bcUL;
   tf->codes[164] = 0x000000016ad49fb6UL;
   tf->codes[165] = 0x00000006da68e61fUL;
   tf->codes[166] = 0x00000006ce0e03bbUL;
   tf->codes[167] = 0x0000000a0404d752UL;
   tf->codes[168] = 0x0000000e066e102fUL;
   tf->codes[169] = 0x00000002f9d00546UL;
   tf->codes[170] = 0x000000039878a9e4UL;
   tf->codes[171] = 0x000000049521229cUL;
   tf->codes[172] = 0x00000008a70b85a9UL;
   tf->codes[173] = 0x000000096ecdad9dUL;
   tf->codes[174] = 0x00000009b5300ed7UL;
   tf->codes[175] = 0x0000000d08e19cd0UL;
   tf->codes[176] = 0x0000000e1dbbf0a6UL;
   tf->codes[177] = 0x0000000ef012435cUL;
   tf->codes[178] = 0x00000006ecd2fc10UL;
   tf->codes[179] = 0x0000000749a519f4UL;
   tf->codes[180] = 0x000000091b715e4cUL;
   tf->codes[181] = 0x000000090f17dae8UL;
   tf->codes[182] = 0x0000000975d0ae16UL;
   tf->codes[183] = 0x00000009ced1f6deUL;
   tf->codes[184] = 0x0000000ba3660c0bUL;
   tf->codes[185] = 0x0000000d1b1c9d9dUL;
   tf->codes[186] = 0x0000000d77fa492bUL;
   tf->codes[187] = 0x0000000de0bdcdc7UL;
   tf->codes[188] = 0x0000000e2472e389UL;
   tf->codes[189] = 0x000000039ee6b70eUL;
   tf->codes[190] = 0x00000007a8ad48b3UL;
   tf->codes[191] = 0x0000000b4ee1682eUL;
   tf->codes[192] = 0x0000000bb8a7ec82UL;
   tf->codes[193] = 0x000000007cd0404dUL;
   tf->codes[194] = 0x000000011d68ecc7UL;
   tf->codes[195] = 0x000000046cbd039dUL;
   tf->codes[196] = 0x00000004b634dd1aUL;
   tf->codes[197] = 0x000000063c6d44e0UL;
   tf->codes[198] = 0x0000000981a82ea0UL;
   tf->codes[199] = 0x0000000a93f25d5fUL;
   tf->codes[200] = 0x0000000a8795d9fbUL;
   tf->codes[201] = 0x0000000b5d3c69a3UL;
   tf->codes[202] = 0x0000000f56912854UL;
   tf->codes[203] = 0x00000001f86096b4UL;
   tf->codes[204] = 0x00000001ee865210UL;
   tf->codes[205] = 0x000000024bf5c67cUL;
   tf->codes[206] = 0x000000037a5d0beeUL;
   tf->codes[207] = 0x00000003c2fcd384UL;
   tf->codes[208] = 0x00000005324bc851UL;
   tf->codes[209] = 0x00000005886a7099UL;
   tf->codes[210] = 0x0000000b72fa2c2cUL;
   tf->codes[211] = 0x0000000fc92eb5b5UL;
   tf->codes[212] = 0x0000000422e4a0c6UL;
   tf->codes[213] = 0x000000059b17b310UL;
   tf->codes[214] = 0x00000008e7d2e941UL;
   tf->codes[215] = 0x0000000943f50c2dUL;
   tf->codes[216] = 0x000000093db38889UL;
   tf->codes[217] = 0x0000000d3c56115cUL;
   tf->codes[218] = 0x0000000ec3097940UL;
   tf->codes[219] = 0x0000000f0c8e4c64UL;
   tf->codes[220] = 0x000000015a1a2b44UL;
   tf->codes[221] = 0x000000031885e859UL;
   tf->codes[222] = 0x00000003c77ec56fUL;
   tf->codes[223] = 0x0000000665489b09UL;
   tf->codes[224] = 0x0000000ac8831e70UL;
   tf->codes[225] = 0x0000000b0559325eUL;
   tf->codes[226] = 0x0000000d9d4e401bUL;
   tf->codes[227] = 0x00000001618bca4bUL;
   tf->codes[228] = 0x00000006cd54c849UL;
   tf->codes[229] = 0x0000000717d5b003UL;
   tf->codes[230] = 0x0000000acb7e0f3dUL;
   tf->codes[231] = 0x0000000db2c90514UL;
   tf->codes[232] = 0x0000000edb75ab84UL;
   tf->codes[233] = 0x00000002d2d82857UL;
   tf->codes[234] = 0x000000095fb613c6UL;
   tf->codes[235] = 0x00000009c1f187c8UL;
   tf->codes[236] = 0x0000000b1521d0f9UL;
   tf->codes[237] = 0x0000000f252b178dUL;
   tf->codes[238] = 0x00000003fe0f8640UL;
   tf->codes[239] = 0x00000005ca93c171UL;
   tf->codes[240] = 0x00000009dad88605UL;
   tf->codes[241] = 0x0000000b32a795d4UL;
   tf->codes[242] = 0x0000000d0273d2e4UL;
   tf->codes[243] = 0x0000000d7034b6d8UL;
   tf->codes[244] = 0x000000021d211a8bUL;
   tf->codes[245] = 0x000000032f7b66d5UL;
   tf->codes[246] = 0x000000097f46e061UL;
   tf->codes[247] = 0x0000000a3a80d947UL;
   tf->codes[248] = 0x0000000af24f7511UL;
   tf->codes[249] = 0x000000017760c682UL;
   tf->codes[250] = 0x00000002f17d53f8UL;
   tf->codes[251] = 0x00000005768d8553UL;
   tf->codes[252] = 0x00000005ccac399bUL;
   tf->codes[253] = 0x0000000b363443b6UL;
   tf->codes[254] = 0x000000086e868835UL;
   tf->codes[255] = 0x0000000d1f31c586UL;
   tf->codes[256] = 0x0000000e3c1f8c18UL;
   tf->codes[257] = 0x0000000dfb29b8f1UL;
   tf->codes[258] = 0x000000012545997cUL;
   tf->codes[259] = 0x00000003c9b87c9cUL;
   tf->codes[260] = 0x0000000650afcedaUL;
   tf->codes[261] = 0x00000007cc5d2d4dUL;
   tf->codes[262] = 0x0000000e97f2c6b4UL;
   tf->codes[263] = 0x0000000bcf094d17UL;
   tf->codes[264] = 0x0000000c2b6fd1b3UL;
   tf->codes[265] = 0x000000055b7539e1UL;
   tf->codes[266] = 0x00000006563c3099UL;
   tf->codes[267] = 0x00000006cbcaa475UL;
   tf->codes[268] = 0x0000000711ebf8bfUL;
   tf->codes[269] = 0x0000000beacf0872UL;
   tf->codes[270] = 0x0000000152bf7dd3UL;
   tf->codes[271] = 0x00000002d9e666a9UL;
   tf->codes[272] = 0x00000008aadf624cUL;
   tf->codes[273] = 0x0000000ae04840c3UL;
   tf->codes[274] = 0x0000000b89fceccbUL;
   tf->codes[275] = 0x0000000391534881UL;
   tf->codes[276] = 0x00000006d3b626f3UL;
   tf->codes[277] = 0x0000000b8cd3f384UL;
   tf->codes[278] = 0x000000056e622ea0UL;
   tf->codes[279] = 0x000000072da9effcUL;
   tf->codes[280] = 0x00000009d9dc3195UL;
   tf->codes[281] = 0x00000009b5bab5bbUL;
   tf->codes[282] = 0x0000000a2255635fUL;
   tf->codes[283] = 0x0000000b3d6b2a41UL;
   tf->codes[284] = 0x0000000e1e78a0caUL;
   tf->codes[285] = 0x00000006f166d850UL;
   tf->codes[286] = 0x00000006ed013c3cUL;
   tf->codes[287] = 0x0000000974124e7aUL;
   tf->codes[288] = 0x0000000b9c237103UL;
   tf->codes[289] = 0x000000012a55c948UL;
   tf->codes[290] = 0x00000006e6e02db3UL;
   tf->codes[291] = 0x0000000bb970b4aeUL;
   tf->codes[292] = 0x0000000cb5e92956UL;
   tf->codes[293] = 0x000000024a8a8519UL;
   tf->codes[294] = 0x00000005e4e6a504UL;
   tf->codes[295] = 0x0000000cce402a5bUL;
   tf->codes[296] = 0x0000000ead45ac6bUL;
   tf->codes[297] = 0x0000000b7e065329UL;
   tf->codes[298] = 0x00000002c9b38934UL;
   tf->codes[299] = 0x0000000550a5f272UL;
   tf->codes[300] = 0x00000009af15026bUL;
   tf->codes[301] = 0x0000000c43acbba9UL;
   tf->codes[302] = 0x000000003c4f2ed0UL;
   tf->codes[303] = 0x00000005a6df5a79UL;
   tf->codes[304] = 0x0000000acf8a733eUL;
   tf->codes[305] = 0x0000000e05408ed3UL;
   tf->codes[306] = 0x000000060787293bUL;
   tf->codes[307] = 0x000000089e95533fUL;
   tf->codes[308] = 0x0000000dcb673abcUL;
   tf->codes[309] = 0x0000000e0ea10fdaUL;
   tf->codes[310] = 0x0000000efa4f932eUL;
   tf->codes[311] = 0x000000045e988b2bUL;
   tf->codes[312] = 0x00000005d2c11c5eUL;
   tf->codes[313] = 0x0000000b84be5c13UL;
   tf->codes[314] = 0x000000050629a003UL;
   tf->codes[315] = 0x00000005e11c1dd3UL;
   tf->codes[316] = 0x000000012111629fUL;
   tf->codes[317] = 0x00000002365f3381UL;
   tf->codes[318] = 0x00000004cf5d41c0UL;
   tf->codes[319] = 0x00000008d957e5b5UL;
   tf->codes[320] = 0x000000025b88ce2cUL;
   tf->codes[321] = 0x000000041ec563d3UL;
   tf->codes[322] = 0x0000000c3884919fUL;
   tf->codes[323] = 0x00000004ffd91f28UL;
   tf->codes[324] = 0x0000000d6211be2eUL;
   tf->codes[325] = 0x00000002c6c33e2bUL;
   tf->codes[326] = 0x00000009b062517dUL;
   tf->codes[327] = 0x00000009a605d5d1UL;
   tf->codes[328] = 0x0000000c93615ffbUL;
   tf->codes[329] = 0x00000000587aa508UL;
   tf->codes[330] = 0x0000000ae741eba5UL;
   tf->codes[331] = 0x00000004b232ba75UL;
   tf->codes[332] = 0x00000009d68187b1UL;
   tf->codes[333] = 0x0000000a253c3b79UL;
   tf->codes[334] = 0x0000000bae55c0a6UL;
   tf->codes[335] = 0x0000000d0eaa3172UL;
   tf->codes[336] = 0x0000000c0c2dbd49UL;
   tf->codes[337] = 0x0000000d1d37d23fUL;
   tf->codes[338] = 0x0000000e952ecf4fUL;
   tf->codes[339] = 0x0000000a51239d5eUL;
   tf->codes[340] = 0x0000000f6e416099UL;
   tf->codes[341] = 0x0000000da4923cf8UL;
   tf->codes[342] = 0x000000055cd5bbbfUL;
   tf->codes[343] = 0x000000067fad4a0dUL;
   tf->codes[344] = 0x00000006f802d5abUL;
   tf->codes[345] = 0x00000004c90df6abUL;
   tf->codes[346] = 0x0000000cc0aad0e1UL;
   tf->codes[347] = 0x0000000745207f2bUL;
   tf->codes[348] = 0x0000000b516ad892UL;
   tf->codes[349] = 0x00000008da9ca7d8UL;
   tf->codes[350] = 0x0000000ba7517799UL;
   tf->codes[351] = 0x0000000b13811fcdUL;
   tf->codes[352] = 0x00000000328436caUL;
   tf->codes[353] = 0x00000005965ad68fUL;
   tf->codes[354] = 0x0000000e6b65823fUL;
   tf->codes[355] = 0x0000000951a1abf3UL;
   tf->codes[356] = 0x000000095cce7616UL;
   tf->codes[357] = 0x0000000ca003fe57UL;
   tf->codes[358] = 0x0000000d5ee5d32bUL;
   tf->codes[359] = 0x00000002d6d58f8eUL;
   tf->codes[360] = 0x0000000bee25c778UL;
   tf->codes[361] = 0x000000021cac7ed2UL;
   tf->codes[362] = 0x00000007b982415fUL;
   tf->codes[363] = 0x0000000237a92d3eUL;
   tf->codes[364] = 0x000000065c2a898aUL;
   tf->codes[365] = 0x00000002a67c67d0UL;
   tf->codes[366] = 0x0000000492c37445UL;
   tf->codes[367] = 0x0000000e66713585UL;
   tf->codes[368] = 0x0000000adb041611UL;
   tf->codes[369] = 0x00000009b5ed4c88UL;
   tf->codes[370] = 0x0000000f2f751a83UL;
   tf->codes[371] = 0x000000005a5db231UL;
   tf->codes[372] = 0x00000008478d5037UL;
   tf->codes[373] = 0x00000005e2954c13UL;
   tf->codes[374] = 0x00000000d8597d1dUL;
   tf->codes[375] = 0x0000000537116e24UL;
   tf->codes[376] = 0x00000007ce063461UL;
   tf->codes[377] = 0x0000000a79a20302UL;
   tf->codes[378] = 0x0000000b8016f46aUL;
   tf->codes[379] = 0x0000000ebeb44bdcUL;
   tf->codes[380] = 0x0000000206e7cff7UL;
   tf->codes[381] = 0x00000000d2870a69UL;
   tf->codes[382] = 0x00000004e21e723aUL;
   tf->codes[383] = 0x00000006a59590e7UL;
   tf->codes[384] = 0x0000000a522a2e9bUL;
   tf->codes[385] = 0x0000000c2ec8f44fUL;
   tf->codes[386] = 0x000000003e51273cUL;
   tf->codes[387] = 0x000000056bab7c9bUL;
   tf->codes[388] = 0x0000000b3a92fa7eUL;
   tf->codes[389] = 0x0000000f4a993d4bUL;
   tf->codes[390] = 0x00000008b80884b7UL;
   tf->codes[391] = 0x00000008a5339f30UL;
   tf->codes[392] = 0x0000000690c7389dUL;
   tf->codes[393] = 0x00000009f34cb283UL;
   tf->codes[394] = 0x0000000cd0febc20UL;
   tf->codes[395] = 0x0000000f579a2a82UL;
   tf->codes[396] = 0x00000003ba18373fUL;
   tf->codes[397] = 0x000000068fddad38UL;
   tf->codes[398] = 0x00000007ca529286UL;
   tf->codes[399] = 0x0000000df93cd25bUL;
   tf->codes[400] = 0x00000007d18313a9UL;
   tf->codes[401] = 0x0000000febd825c0UL;
   tf->codes[402] = 0x0000000898d72da2UL;
   tf->codes[403] = 0x0000000c2d8c5adeUL;
   tf->codes[404] = 0x000000060b797eeaUL;
   tf->codes[405] = 0x00000007281731bdUL;
   tf->codes[406] = 0x0000000b48a4940aUL;
   tf->codes[407] = 0x0000000d7e28a20dUL;
   tf->codes[408] = 0x000000006d0aac8eUL;
   tf->codes[409] = 0x00000002f418d6e8UL;
   tf->codes[410] = 0x000000045ce7d55fUL;
   tf->codes[411] = 0x0000000bb3415aa6UL;
   tf->codes[412] = 0x0000000f592d643dUL;
   tf->codes[413] = 0x00000000c556e7e9UL;
   tf->codes[414] = 0x0000000dede56c4eUL;
   tf->codes[415] = 0x0000000075f63628UL;
   tf->codes[416] = 0x0000000778f69c5bUL;
   tf->codes[417] = 0x0000000b0add7ab7UL;
   tf->codes[418] = 0x0000000d86f0b737UL;
   tf->codes[419] = 0x00000006d3092589UL;
   tf->codes[420] = 0x0000000776618a1bUL;
   tf->codes[421] = 0x0000000ecec99b8cUL;
   tf->codes[422] = 0x000000038a56d5b3UL;
   tf->codes[423] = 0x0000000e0cb464d1UL;
   tf->codes[424] = 0x00000000b9385f3aUL;
   tf->codes[425] = 0x0000000ba42a64f5UL;
   tf->codes[426] = 0x0000000938bb73f3UL;
   tf->codes[427] = 0x0000000a7691cb01UL;
   tf->codes[428] = 0x000000086a986dadUL;
   tf->codes[429] = 0x0000000447ed963bUL;
   tf->codes[430] = 0x0000000b6bcab900UL;
   tf->codes[431] = 0x0000000a348c9079UL;
   tf->codes[432] = 0x000000071812b90bUL;
   tf->codes[433] = 0x0000000be867b1a9UL;
   tf->codes[434] = 0x00000007807672aeUL;
   tf->codes[435] = 0x0000000f52c97520UL;
   tf->codes[436] = 0x000000005f6dabb7UL;
   tf->codes[437] = 0x00000001321e1472UL;
   tf->codes[438] = 0x0000000e44ab0b16UL;
   tf->codes[439] = 0x000000031b1b920fUL;
   tf->codes[440] = 0x0000000e7a916c37UL;
   tf->codes[441] = 0x0000000ec3a095ddUL;
   tf->codes[442] = 0x0000000e1cc9b481UL;
   tf->codes[443] = 0x000000046209b37bUL;
   tf->codes[444] = 0x000000047f0aa439UL;
   tf->codes[445] = 0x00000000d7b31befUL;
   tf->codes[446] = 0x000000052db78a32UL;
   tf->codes[447] = 0x0000000ed3b35ea8UL;
   tf->codes[448] = 0x00000005b1f58572UL;
   tf->codes[449] = 0x0000000acf866c7dUL;
   tf->codes[450] = 0x0000000fa2be6544UL;
   tf->codes[451] = 0x0000000774737a28UL;
   tf->codes[452] = 0x0000000bcf8fe9b1UL;
   tf->codes[453] = 0x0000000fdfc4ac80UL;
   tf->codes[454] = 0x0000000a0aef3457UL;
   tf->codes[455] = 0x00000005d93f4f4aUL;
   tf->codes[456] = 0x0000000a314ac7faUL;
   tf->codes[457] = 0x0000000b52221849UL;
   tf->codes[458] = 0x0000000b5d908dacUL;
   tf->codes[459] = 0x0000000ec20c9ce2UL;
   tf->codes[460] = 0x0000000da5563b12UL;
   tf->codes[461] = 0x000000057257c59bUL;
   tf->codes[462] = 0x0000000ef0e8f782UL;
   tf->codes[463] = 0x0000000f9d2b3dc4UL;
   tf->codes[464] = 0x0000000ab8097620UL;
   tf->codes[465] = 0x0000000b99a08acaUL;
   tf->codes[466] = 0x0000000064fe5b8bUL;
   tf->codes[467] = 0x000000019255e746UL;
   tf->codes[468] = 0x0000000aab6d88b0UL;
   tf->codes[469] = 0x0000000e011adc1bUL;
   tf->codes[470] = 0x00000003214f657cUL;
   tf->codes[471] = 0x0000000093f917b4UL;
   tf->codes[472] = 0x000000091f0c7859UL;
   tf->codes[473] = 0x0000000bcd3a5171UL;
   tf->codes[474] = 0x00000000afd4cb29UL;
   tf->codes[475] = 0x00000008787d5924UL;
   tf->codes[476] = 0x000000024f3a8b55UL;
   tf->codes[477] = 0x00000002ae32d017UL;
   tf->codes[478] = 0x000000067af72a45UL;
   tf->codes[479] = 0x00000008fe87d42aUL;
   tf->codes[480] = 0x0000000902c5df3fUL;
   tf->codes[481] = 0x00000002f2500693UL;
   tf->codes[482] = 0x0000000868a4733cUL;
   tf->codes[483] = 0x00000005dd4c95d9UL;
   tf->codes[484] = 0x000000097210f5f2UL;
   tf->codes[485] = 0x000000023f0de89fUL;
   tf->codes[486] = 0x000000084ce8a4b5UL;
   tf->codes[487] = 0x000000034eb80e3dUL;
   tf->codes[488] = 0x0000000532c70decUL;
   tf->codes[489] = 0x000000013b90cb54UL;
   tf->codes[490] = 0x0000000c3dfe6cb7UL;
   tf->codes[491] = 0x00000008b03d0badUL;
   tf->codes[492] = 0x000000090bacd3e5UL;
   tf->codes[493] = 0x0000000afa0bc824UL;
   tf->codes[494] = 0x0000000a38fe08f8UL;
   tf->codes[495] = 0x0000000fa758ea36UL;
   tf->codes[496] = 0x0000000fe0862d3cUL;
   tf->codes[497] = 0x00000001ace4f7edUL;
   tf->codes[498] = 0x0000000e04bac135UL;
   tf->codes[499] = 0x000000063e99b95aUL;
   tf->codes[500] = 0x0000000b010d68e1UL;
   tf->codes[501] = 0x0000000ce9352b2bUL;
   tf->codes[502] = 0x000000082838db6fUL;
   tf->codes[503] = 0x0000000d3bf04d59UL;
   tf->codes[504] = 0x0000000c9df5aec3UL;
   tf->codes[505] = 0x0000000a4e8aafeeUL;
   tf->codes[506] = 0x00000006b1db1459UL;
   tf->codes[507] = 0x00000006ba3217d0UL;
   tf->codes[508] = 0x0000000e5c73549cUL;
   tf->codes[509] = 0x000000037c2679dfUL;
   tf->codes[510] = 0x0000000732d69874UL;
   tf->codes[511] = 0x000000073ce98c9eUL;
   tf->codes[512] = 0x00000004cc0f5c5eUL;
   tf->codes[513] = 0x000000008f1b8c73UL;
   tf->codes[514] = 0x0000000ef1b22865UL;
   tf->codes[515] = 0x000000006f5eb759UL;
   tf->codes[516] = 0x00000001476bea11UL;
   tf->codes[517] = 0x000000078ba48850UL;
   tf->codes[518] = 0x000000074ac468d5UL;
   tf->codes[519] = 0x00000008ed2a2869UL;
   tf->codes[520] = 0x0000000a0d4f4fcdUL;
   tf->codes[521] = 0x00000002401bcfacUL;
   tf->codes[522] = 0x0000000af4852356UL;
   tf->codes[523] = 0x0000000e49487115UL;
   tf->codes[524] = 0x0000000678ebe495UL;
   tf->codes[525] = 0x00000003afec50b5UL;
   tf->codes[526] = 0x0000000ff853144eUL;
   tf->codes[527] = 0x0000000ca35def53UL;
   tf->codes[528] = 0x000000087328bda4UL;
   tf->codes[529] = 0x0000000d258703b5UL;
   tf->codes[530] = 0x000000071152a781UL;
   tf->codes[531] = 0x00000004dd323e43UL;
   tf->codes[532] = 0x00000004812c5a59UL;
   tf->codes[533] = 0x000000057bd1d082UL;
   tf->codes[534] = 0x0000000456266e15UL;
   tf->codes[535] = 0x00000006b9fccad6UL;
   tf->codes[536] = 0x00000004abe3b07bUL;
   tf->codes[537] = 0x0000000baf59cfceUL;
   tf->codes[538] = 0x000000056d6932fcUL;
   tf->codes[539] = 0x0000000fd158446cUL;
   tf->codes[540] = 0x0000000363f31ca6UL;
   tf->codes[541] = 0x000000093c9eecceUL;
   tf->codes[542] = 0x000000033930d57fUL;
   tf->codes[543] = 0x000000062c9dcfbbUL;
   tf->codes[544] = 0x00000006f52475c4UL;
   tf->codes[545] = 0x0000000950d51d55UL;
   tf->codes[546] = 0x000000095c430b37UL;
   tf->codes[547] = 0x00000007424acdf9UL;
   tf->codes[548] = 0x00000005e59f504fUL;
   tf->codes[549] = 0x00000007abe9fe84UL;
   tf->codes[550] = 0x00000001462e4fb3UL;
   tf->codes[551] = 0x00000005b346387fUL;
   tf->codes[552] = 0x0000000adcf80432UL;
   tf->codes[553] = 0x0000000dbcf4c50eUL;
   tf->codes[554] = 0x0000000213274059UL;
   tf->codes[555] = 0x00000007d0da7a11UL;
   tf->codes[556] = 0x0000000d9c5de950UL;
   tf->codes[557] = 0x0000000334edcf91UL;
   tf->codes[558] = 0x0000000eaadbf8b8UL;
   tf->codes[559] = 0x00000004fd450926UL;
   tf->codes[560] = 0x00000009a8af56b0UL;
   tf->codes[561] = 0x000000028b062348UL;
   tf->codes[562] = 0x000000086bd1c31dUL;
   tf->codes[563] = 0x00000000d15dd6c2UL;
   tf->codes[564] = 0x00000008cc9d14c6UL;
   tf->codes[565] = 0x0000000d0b9038c4UL;
   tf->codes[566] = 0x0000000b445f90b9UL;
   tf->codes[567] = 0x0000000c3378c977UL;
   tf->codes[568] = 0x0000000197aa5976UL;
   tf->codes[569] = 0x0000000f5879d3e2UL;
   tf->codes[570] = 0x00000002ec330e97UL;
   tf->codes[571] = 0x00000004bcab4ba7UL;
   tf->codes[572] = 0x0000000185b91b99UL;
   tf->codes[573] = 0x00000009a64ecebfUL;
   tf->codes[574] = 0x0000000e8b66c585UL;
   tf->codes[575] = 0x00000005e1e848ecUL;
   tf->codes[576] = 0x0000000a24ca255bUL;
   tf->codes[577] = 0x00000006a0d7dfc7UL;
   tf->codes[578] = 0x0000000770e1711aUL;
   tf->codes[579] = 0x00000007e34402b4UL;
   tf->codes[580] = 0x0000000525ceff8cUL;
   tf->codes[581] = 0x000000089a56e0c9UL;
   tf->codes[582] = 0x0000000ee1401ffcUL;
   tf->codes[583] = 0x0000000b13cfa633UL;
   tf->codes[584] = 0x0000000327aa9b9aUL;
   tf->codes[585] = 0x000000077383d86dUL;
   tf->codes[586] = 0x0000000eb6d7283eUL;
   tf->codes[587] = 0x00000004ba294b54UL;
   tf->codes[588] = 0x000000026c84d5d9UL;
   tf->codes[589] = 0x00000001c2c5adc0UL;
   tf->codes[590] = 0x0000000694e6ec3cUL;
   tf->codes[591] = 0x00000000f3064d10UL;
   tf->codes[592] = 0x00000006b7c9d416UL;
   tf->codes[593] = 0x0000000d7d74bd89UL;
   tf->codes[594] = 0x0000000e11232372UL;
   tf->codes[595] = 0x00000004d84369e0UL;
   tf->codes[596] = 0x0000000f7de40249UL;
   tf->codes[597] = 0x0000000b64950611UL;
   tf->codes[598] = 0x0000000a0724a19bUL;
   tf->codes[599] = 0x0000000688eef9abUL;
   tf->codes[600] = 0x00000003c7a3a2eaUL;
   tf->codes[601] = 0x000000049cd79585UL;
   tf->codes[602] = 0x00000006c35bff78UL;
   tf->codes[603] = 0x0000000456a31970UL;
   tf->codes[604] = 0x00000004205eb8ecUL;
   tf->codes[605] = 0x00000002717c22e3UL;
   tf->codes[606] = 0x0000000763d127fbUL;
   tf->codes[607] = 0x0000000865548e6fUL;
   tf->codes[608] = 0x00000004f1dcc597UL;
   tf->codes[609] = 0x0000000279dcfca4UL;
   tf->codes[610] = 0x0000000aad1f2e05UL;
   tf->codes[611] = 0x00000006437570c6UL;
   tf->codes[612] = 0x0000000d68b74cd9UL;
   tf->codes[613] = 0x0000000ec82e7216UL;
   tf->codes[614] = 0x00000004223b2229UL;
   tf->codes[615] = 0x00000009c12a8582UL;
   tf->codes[616] = 0x0000000c073eb63dUL;
   tf->codes[617] = 0x000000068b779e29UL;
   tf->codes[618] = 0x000000061157ce5fUL;
   tf->codes[619] = 0x000000050f6ebec2UL;
   tf->codes[620] = 0x000000035f4e4b1cUL;
   tf->codes[621] = 0x0000000f909c56d6UL;
   tf->codes[622] = 0x00000009c4b78474UL;
   tf->codes[623] = 0x0000000b8160eb1eUL;
   tf->codes[624] = 0x00000005e3d256f8UL;
   tf->codes[625] = 0x000000021919b529UL;
   tf->codes[626] = 0x0000000d4c7b6226UL;
   tf->codes[627] = 0x00000005190049a8UL;
   tf->codes[628] = 0x0000000ad869eab6UL;
   tf->codes[629] = 0x0000000a10b3759aUL;
   tf->codes[630] = 0x0000000917560e43UL;
   tf->codes[631] = 0x00000002c5d651d7UL;
   tf->codes[632] = 0x0000000eb2c8e47cUL;
   tf->codes[633] = 0x0000000bc131902dUL;
   tf->codes[634] = 0x00000007e883469bUL;
   tf->codes[635] = 0x000000091d991bfeUL;
   tf->codes[636] = 0x000000020c3a7704UL;
   tf->codes[637] = 0x00000002b3b53f8fUL;
   tf->codes[638] = 0x00000008978b2c6aUL;
   tf->codes[639] = 0x000000091138b228UL;
   tf->codes[640] = 0x0000000529f08e2cUL;
   tf->codes[641] = 0x0000000979342793UL;
   tf->codes[642] = 0x000000098137dcc3UL;
   tf->codes[643] = 0x00000003a9c6e139UL;
   tf->codes[644] = 0x0000000f898abd5eUL;
   tf->codes[645] = 0x0000000ce2585f36UL;
   tf->codes[646] = 0x0000000968312f45UL;
   tf->codes[647] = 0x00000002994a6ec2UL;
   tf->codes[648] = 0x0000000ca6685871UL;
   tf->codes[649] = 0x0000000a3af94337UL;
   tf->codes[650] = 0x000000003f628d34UL;
   tf->codes[651] = 0x00000001e9617f6cUL;
   tf->codes[652] = 0x0000000a34ed1a9cUL;
   tf->codes[653] = 0x00000002c22028b4UL;
   tf->codes[654] = 0x0000000fdeb13f3aUL;
   tf->codes[655] = 0x000000002d85e3acUL;
   tf->codes[656] = 0x0000000957491696UL;
   tf->codes[657] = 0x0000000ac42bab89UL;
   tf->codes[658] = 0x0000000e3753d50fUL;
   tf->codes[659] = 0x0000000b712a307aUL;
   tf->codes[660] = 0x00000008b7c1c2caUL;
   tf->codes[661] = 0x00000008893cb8f8UL;
   tf->codes[662] = 0x00000005abc4467fUL;
   tf->codes[663] = 0x00000005f1aa96c0UL;
   tf->codes[664] = 0x0000000b7dcde504UL;
   tf->codes[665] = 0x0000000c3cd9ca20UL;
   tf->codes[666] = 0x00000000af48c055UL;
   tf->codes[667] = 0x0000000f4e10477bUL;
   tf->codes[668] = 0x000000012b45078cUL;
   tf->codes[669] = 0x000000010af764c6UL;
   tf->codes[670] = 0x000000023d8b32d5UL;
   tf->codes[671] = 0x000000036f1e9c47UL;
   tf->codes[672] = 0x0000000e847bd756UL;
   tf->codes[673] = 0x00000004c3b4e455UL;
   tf->codes[674] = 0x000000064d42e688UL;
   tf->codes[675] = 0x0000000cf5218b7aUL;
   tf->codes[676] = 0x0000000cdc1605e4UL;
   tf->codes[677] = 0x00000006250bba26UL;
   tf->codes[678] = 0x0000000be6c4770aUL;
   tf->codes[679] = 0x0000000982331a23UL;
   tf->codes[680] = 0x0000000dfd090dcaUL;
   tf->codes[681] = 0x0000000506bc18d5UL;
   tf->codes[682] = 0x0000000109d7375cUL;
   tf->codes[683] = 0x0000000680ca4a7eUL;
   tf->codes[684] = 0x0000000a6e1c91e1UL;
   tf->codes[685] = 0x0000000688f44350UL;
   tf->codes[686] = 0x0000000ad470ae05UL;
   tf->codes[687] = 0x0000000f3ff0a79eUL;
   tf->codes[688] = 0x0000000326f26fbeUL;
   tf->codes[689] = 0x00000004105901beUL;
   tf->codes[690] = 0x000000032ed82cd9UL;
   tf->codes[691] = 0x000000009916c638UL;
   tf->codes[692] = 0x00000001d0025ed6UL;
   tf->codes[693] = 0x00000004aeaec114UL;
   tf->codes[694] = 0x000000098af27931UL;
   tf->codes[695] = 0x0000000968f79b3bUL;
   tf->codes[696] = 0x0000000ed4b906d5UL;
   tf->codes[697] = 0x000000061ae9b2e4UL;
   tf->codes[698] = 0x000000059b82a3f5UL;
   tf->codes[699] = 0x0000000550eb833bUL;
   tf->codes[700] = 0x000000017b69fd4bUL;
   tf->codes[701] = 0x000000073d569e02UL;
   tf->codes[702] = 0x000000063dba43f8UL;
   tf->codes[703] = 0x0000000f6cb4cb8aUL;
   tf->codes[704] = 0x0000000d6258181bUL;
   tf->codes[705] = 0x0000000e86109784UL;
   tf->codes[706] = 0x0000000fa5a660eaUL;
   tf->codes[707] = 0x00000004f9815064UL;
   tf->codes[708] = 0x000000075d8db35dUL;
   tf->codes[709] = 0x0000000546f94888UL;
   tf->codes[710] = 0x000000058df2d00aUL;
   tf->codes[711] = 0x00000006a779d19bUL;
   tf->codes[712] = 0x0000000ea1b4e76bUL;
   tf->codes[713] = 0x000000014870eef0UL;
   tf->codes[714] = 0x000000055429f855UL;
   tf->codes[715] = 0x0000000e86b71b9fUL;
   tf->codes[716] = 0x0000000d333c2d43UL;
   tf->codes[717] = 0x000000042733ecd4UL;
   tf->codes[718] = 0x0000000d16ba12efUL;
   tf->codes[719] = 0x00000003b69c3d5cUL;
   tf->codes[720] = 0x00000004a5c07666UL;
   tf->codes[721] = 0x0000000a84634048UL;
   tf->codes[722] = 0x000000021a2c4b26UL;
   tf->codes[723] = 0x0000000573be1892UL;
   tf->codes[724] = 0x0000000730bd1d40UL;
   tf->codes[725] = 0x0000000eed055d81UL;
   tf->codes[726] = 0x00000007e815e7a6UL;
   tf->codes[727] = 0x00000008ab11c883UL;
   tf->codes[728] = 0x000000050283e7d2UL;
   tf->codes[729] = 0x0000000c8a795b85UL;
   tf->codes[730] = 0x000000047a229dc5UL;
   tf->codes[731] = 0x000000012b9e108cUL;
   tf->codes[732] = 0x0000000caa2034dbUL;
   tf->codes[733] = 0x0000000a62f9ae47UL;
   tf->codes[734] = 0x000000093979dcfaUL;
   tf->codes[735] = 0x00000005fb8fd985UL;
   tf->codes[736] = 0x000000025bf32ccbUL;
   tf->codes[737] = 0x00000007ae9a5ee5UL;
   tf->codes[738] = 0x0000000b10665d2eUL;
   tf->codes[739] = 0x0000000ed0c2b0e6UL;
   tf->codes[740] = 0x00000002c72c25fdUL;
   tf->codes[741] = 0x0000000d74f444d2UL;
   tf->codes[742] = 0x00000009b0db80cbUL;
   tf->codes[743] = 0x000000055c8e43deUL;
   tf->codes[744] = 0x0000000d77253912UL;
   tf->codes[745] = 0x000000084cfd9ea0UL;
   tf->codes[746] = 0x00000001615ba8c5UL;
   tf->codes[747] = 0x0000000503884d62UL;
   tf->codes[748] = 0x0000000fc53328a8UL;
   tf->codes[749] = 0x0000000f547a6153UL;
   tf->codes[750] = 0x0000000ca97160cfUL;
   tf->codes[751] = 0x000000095e440434UL;
   tf->codes[752] = 0x00000006fa4c125dUL;
   tf->codes[753] = 0x0000000a420cfe45UL;
   tf->codes[754] = 0x0000000af8147dfbUL;
   tf->codes[755] = 0x000000012e90ddeaUL;
   tf->codes[756] = 0x0000000f14c3cb5eUL;
   tf->codes[757] = 0x0000000966579d6aUL;
   tf->codes[758] = 0x00000004447c94d0UL;
   tf->codes[759] = 0x000000032336aceaUL;
   tf->codes[760] = 0x0000000c75d077dfUL;
   tf->codes[761] = 0x0000000b7e72837eUL;
   tf->codes[762] = 0x000000051d24ed1eUL;
   tf->codes[763] = 0x000000093fb67f5cUL;
   tf->codes[764] = 0x000000085cedc1b2UL;
   tf->codes[765] = 0x00000003ca6c5d2bUL;
   tf->codes[766] = 0x000000032269be93UL;
   tf->codes[767] = 0x0000000120ed410cUL;
   tf->codes[768] = 0x0000000fe115d3d4UL;
   tf->codes[769] = 0x00000000a045ed79UL;
   tf->codes[770] = 0x000000083e2846deUL;
   tf->codes[771] = 0x00000004e7a34f3bUL;
   tf->codes[772] = 0x00000005078cae37UL;
   tf->codes[773] = 0x0000000c831aa1f0UL;
   tf->codes[774] = 0x000000079de6b9b6UL;
   tf->codes[775] = 0x00000008e39b1ad2UL;
   tf->codes[776] = 0x000000066bdb37a5UL;
   tf->codes[777] = 0x00000004a79f5da7UL;
   tf->codes[778] = 0x0000000cd9693b30UL;
   tf->codes[779] = 0x00000000dc69a07aUL;
   tf->codes[780] = 0x00000008649a002fUL;
   tf->codes[781] = 0x0000000932887d37UL;
   tf->codes[782] = 0x00000003926b6a74UL;
   tf->codes[783] = 0x0000000c5d4f8ff8UL;
   tf->codes[784] = 0x0000000ea290f911UL;
   tf->codes[785] = 0x0000000360e344e9UL;
   tf->codes[786] = 0x00000007fa9e8a19UL;
   tf->codes[787] = 0x0000000b1d0c16c3UL;
   tf->codes[788] = 0x00000001bbe55ddcUL;
   tf->codes[789] = 0x0000000825cdaea9UL;
   tf->codes[790] = 0x000000004f67f00fUL;
   tf->codes[791] = 0x0000000d3df43a25UL;
   tf->codes[792] = 0x0000000b07b349a2UL;
   tf->codes[793] = 0x0000000716a39611UL;
   tf->codes[794] = 0x0000000aa0fc66b7UL;
   tf->codes[795] = 0x0000000f928fca14UL;
   tf->codes[796] = 0x0000000697c299d3UL;
   tf->codes[797] = 0x00000006dea5d945UL;
   tf->codes[798] = 0x000000038cee4ea7UL;
   tf->codes[799] = 0x00000004e67ea7b6UL;
   tf->codes[800] = 0x000000024deb4062UL;
   tf->codes[801] = 0x0000000e4428a670UL;
   tf->codes[802] = 0x00000008fdb1ad13UL;
   tf->codes[803] = 0x0000000318ff0e1cUL;
   tf->codes[804] = 0x000000008c148b5dUL;
   tf->codes[805] = 0x0000000dbf90b839UL;
   tf->codes[806] = 0x000000003ea5b027UL;
   tf->codes[807] = 0x000000042b077ba9UL;
   tf->codes[808] = 0x0000000b528450e0UL;
   tf->codes[809] = 0x0000000a1256cbfdUL;
   tf->codes[810] = 0x00000004798a8e57UL;
   tf->codes[811] = 0x00000001fdc0d38fUL;
   tf->codes[812] = 0x0000000146329edcUL;
   tf->codes[813] = 0x0000000fa0f94b03UL;
   tf->codes[814] = 0x000000056c6f0e19UL;
   tf->codes[815] = 0x000000006db661a7UL;
   tf->codes[816] = 0x0000000681addf27UL;
   tf->codes[817] = 0x00000000d1eded30UL;
   tf->codes[818] = 0x0000000765c3d6e7UL;
   tf->codes[819] = 0x00000001ba6ae5adUL;
   tf->codes[820] = 0x00000005e0b49af4UL;
   tf->codes[821] = 0x000000033176fa1cUL;
   tf->codes[822] = 0x000000064ca46a3aUL;
   tf->codes[823] = 0x0000000389363b6fUL;
   tf->codes[824] = 0x00000008cc072db9UL;
   tf->codes[825] = 0x0000000b25f03d8fUL;
   tf->codes[826] = 0x000000056aa81ab1UL;
   tf->codes[827] = 0x00000002b1c37b54UL;
   tf->codes[828] = 0x0000000ac1c3279dUL;
   tf->codes[829] = 0x0000000669af74edUL;
   tf->codes[830] = 0x000000064816db93UL;
   tf->codes[831] = 0x0000000254f44a17UL;
   tf->codes[832] = 0x0000000c1f5fc290UL;
   tf->codes[833] = 0x0000000ebca3a222UL;
   tf->codes[834] = 0x000000020e75e68bUL;
   tf->codes[835] = 0x0000000d3bb4dfc2UL;
   tf->codes[836] = 0x00000008d9167a74UL;
   tf->codes[837] = 0x0000000b6de37939UL;
   tf->codes[838] = 0x0000000f7a9a93d6UL;
   tf->codes[839] = 0x00000009aab08164UL;
   tf->codes[840] = 0x00000006d186ddfcUL;
   tf->codes[841] = 0x000000004d3e529cUL;
   tf->codes[842] = 0x0000000a53e2a5c4UL;
   tf->codes[843] = 0x0000000d5e40b964UL;
   tf->codes[844] = 0x00000009a1d76463UL;
   tf->codes[845] = 0x00000007ad6a8eccUL;
   tf->codes[846] = 0x000000030b0c9279UL;
   tf->codes[847] = 0x0000000351e5b489UL;
   tf->codes[848] = 0x0000000bba967fe0UL;
   tf->codes[849] = 0x0000000ab3d8bf17UL;
   tf->codes[850] = 0x000000016c42b17aUL;
   tf->codes[851] = 0x00000009744fae63UL;
   tf->codes[852] = 0x000000077a3f2d39UL;
   tf->codes[853] = 0x000000083c0190acUL;
   tf->codes[854] = 0x00000008d016cba0UL;
   tf->codes[855] = 0x00000005eb9f1e35UL;
   tf->codes[856] = 0x00000006349c2c93UL;
   tf->codes[857] = 0x0000000f5a15e641UL;
   tf->codes[858] = 0x00000007a5bc8c86UL;
   tf->codes[859] = 0x000000065b6b9834UL;
   tf->codes[860] = 0x0000000b756618a7UL;
   tf->codes[861] = 0x0000000d297dc208UL;
   tf->codes[862] = 0x00000003d6cfca2aUL;
   tf->codes[863] = 0x0000000c26e4a930UL;
   tf->codes[864] = 0x00000003afd2df57UL;
   tf->codes[865] = 0x00000007f990decdUL;
   tf->codes[866] = 0x00000006665a2f43UL;
   tf->codes[867] = 0x0000000345d16f4fUL;
   tf->codes[868] = 0x0000000322e392bdUL;
   tf->codes[869] = 0x0000000567baa5deUL;
   tf->codes[870] = 0x00000004a6412121UL;
   tf->codes[871] = 0x0000000a102338a6UL;
   tf->codes[872] = 0x0000000b130fd768UL;
   tf->codes[873] = 0x000000072a30a317UL;
   tf->codes[874] = 0x0000000e4b71cd71UL;
   tf->codes[875] = 0x0000000ad4b2ceebUL;
   tf->codes[876] = 0x00000001da4e11cfUL;
   tf->codes[877] = 0x0000000d5df39b45UL;
   tf->codes[878] = 0x000000081622faa8UL;
   tf->codes[879] = 0x000000098f38af5cUL;
   tf->codes[880] = 0x000000025397c292UL;
   tf->codes[881] = 0x00000002cfcdb0d7UL;
   tf->codes[882] = 0x0000000d24542679UL;
   tf->codes[883] = 0x000000004f04f5f4UL;
   tf->codes[884] = 0x0000000254842f2cUL;
   tf->codes[885] = 0x0000000c6fce4a81UL;
   tf->codes[886] = 0x00000001518648bfUL;
   tf->codes[887] = 0x000000029ead8e85UL;
   tf->codes[888] = 0x0000000dc1435a6bUL;
   tf->codes[889] = 0x0000000c8ebc91afUL;
   tf->codes[890] = 0x0000000bcc94c093UL;
   tf->codes[891] = 0x00000008285d6a81UL;
   tf->codes[892] = 0x00000005b5cca263UL;
   tf->codes[893] = 0x000000005279a4fdUL;
   tf->codes[894] = 0x00000008c7dc69a7UL;
   tf->codes[895] = 0x0000000963e0b3fcUL;
   tf->codes[896] = 0x0000000e38519cb6UL;
   tf->codes[897] = 0x0000000e84af68a5UL;
   tf->codes[898] = 0x0000000d20ee188dUL;
   tf->codes[899] = 0x000000074fdc8660UL;
   tf->codes[900] = 0x000000056f95f633UL;
   tf->codes[901] = 0x0000000f5d2233bfUL;
   tf->codes[902] = 0x0000000ecb3c9815UL;
   tf->codes[903] = 0x0000000c21a3cee6UL;
   tf->codes[904] = 0x00000001558f2f83UL;
   tf->codes[905] = 0x00000008ea10ea50UL;
   tf->codes[906] = 0x00000007ededa109UL;
   tf->codes[907] = 0x00000004d4c5e25dUL;
   tf->codes[908] = 0x0000000130e15fa7UL;
   tf->codes[909] = 0x000000064c873cc7UL;
   tf->codes[910] = 0x000000035a0225a3UL;
   tf->codes[911] = 0x0000000d37aefb27UL;
   tf->codes[912] = 0x0000000b441d8903UL;
   tf->codes[913] = 0x00000002339f650bUL;
   tf->codes[914] = 0x0000000c52d79fa9UL;
   tf->codes[915] = 0x0000000a28badc40UL;
   tf->codes[916] = 0x0000000e2b99967cUL;
   tf->codes[917] = 0x00000008726656b3UL;
   tf->codes[918] = 0x0000000124e07029UL;
   tf->codes[919] = 0x00000008582b1dabUL;
   tf->codes[920] = 0x00000004eb90cbeeUL;
   tf->codes[921] = 0x0000000bff16b8acUL;
   tf->codes[922] = 0x0000000a408251fdUL;
   tf->codes[923] = 0x00000004feccced5UL;
   tf->codes[924] = 0x0000000edda7bf1cUL;
   tf->codes[925] = 0x000000055a0d37b2UL;
   tf->codes[926] = 0x00000000dd9dc90eUL;
   tf->codes[927] = 0x0000000a537c9ad8UL;
   tf->codes[928] = 0x00000008b007aeb4UL;
   tf->codes[929] = 0x00000006e17fbab4UL;
   tf->codes[930] = 0x00000000d03559e3UL;
   tf->codes[931] = 0x000000066fb4aaacUL;
   tf->codes[932] = 0x0000000d06449a6bUL;
   tf->codes[933] = 0x0000000528bb1818UL;
   tf->codes[934] = 0x000000048f0d8baeUL;
   tf->codes[935] = 0x0000000834d540b7UL;
   tf->codes[936] = 0x000000023d5d9ab9UL;
   tf->codes[937] = 0x00000001a13b04d1UL;
   tf->codes[938] = 0x0000000bd30cc9afUL;
   tf->codes[939] = 0x0000000e392c0fb4UL;
   tf->codes[940] = 0x0000000fd5d4e8bdUL;
   tf->codes[941] = 0x0000000cbc646d45UL;
   tf->codes[942] = 0x0000000348db96b7UL;
   tf->codes[943] = 0x0000000e32e54c5fUL;
   tf->codes[944] = 0x000000062446b63fUL;
   tf->codes[945] = 0x0000000ea47a2c4dUL;
   tf->codes[946] = 0x00000008d4d99969UL;
   tf->codes[947] = 0x0000000d01d6d0d2UL;
   tf->codes[948] = 0x00000001862cef24UL;
   tf->codes[949] = 0x0000000ed64fe4baUL;
   tf->codes[950] = 0x0000000d48b40fecUL;
   tf->codes[951] = 0x000000030aa27a14UL;
   tf->codes[952] = 0x00000008b2fcfdceUL;
   tf->codes[953] = 0x0000000943824f9aUL;
   tf->codes[954] = 0x0000000bab9f8d09UL;
   tf->codes[955] = 0x00000003204c129fUL;
   tf->codes[956] = 0x0000000823a36283UL;
   tf->codes[957] = 0x00000005a0b07693UL;
   tf->codes[958] = 0x0000000437949450UL;
   tf->codes[959] = 0x00000004ad8ca4c5UL;
   tf->codes[960] = 0x0000000ec979f418UL;
   tf->codes[961] = 0x0000000e4ed18627UL;
   tf->codes[962] = 0x00000008cd5d978dUL;
   tf->codes[963] = 0x00000005b33248f0UL;
   tf->codes[964] = 0x0000000bf5ac9f64UL;
   tf->codes[965] = 0x0000000bd427f795UL;
   tf->codes[966] = 0x0000000d19d39539UL;
   tf->codes[967] = 0x00000009f4a46c35UL;
   tf->codes[968] = 0x0000000532019548UL;
   tf->codes[969] = 0x0000000b0ebce22cUL;
   tf->codes[970] = 0x0000000b91133fbcUL;
   tf->codes[971] = 0x00000006f1983636UL;
   tf->codes[972] = 0x00000008f898fed7UL;
   tf->codes[973] = 0x0000000e642bf2ccUL;
   tf->codes[974] = 0x0000000a8841dfe9UL;
   tf->codes[975] = 0x0000000c6b879b48UL;
   tf->codes[976] = 0x00000007ad82cc2eUL;
   tf->codes[977] = 0x0000000651977fc1UL;
   tf->codes[978] = 0x00000004dcf4f025UL;
   tf->codes[979] = 0x0000000c94950e6cUL;
   tf->codes[980] = 0x00000002595c6eddUL;
   tf->codes[981] = 0x0000000d4490ebe6UL;
   tf->codes[982] = 0x00000004105ad270UL;
   tf->codes[983] = 0x0000000903d8c8efUL;
   tf->codes[984] = 0x000000062531ad0bUL;
   tf->codes[985] = 0x00000001c1fd55b3UL;
   tf->codes[986] = 0x0000000d27d4ced8UL;
   tf->codes[987] = 0x0000000dc62f305bUL;
   tf->codes[988] = 0x00000001e2557e49UL;
   tf->codes[989] = 0x0000000495c28cedUL;
   tf->codes[990] = 0x00000009c279d9dbUL;
   tf->codes[991] = 0x000000052aa6cef5UL;
   tf->codes[992] = 0x00000007ea533ab1UL;
   tf->codes[993] = 0x0000000d7d49e37bUL;
   tf->codes[994] = 0x0000000e8c5c7424UL;
   tf->codes[995] = 0x00000008137f4da1UL;
   tf->codes[996] = 0x0000000ae13670b3UL;
   tf->codes[997] = 0x00000000de97bd57UL;
   tf->codes[998] = 0x00000000759a6643UL;
   tf->codes[999] = 0x0000000d646248dfUL;
   tf->codes[1000] = 0x0000000f5f13b6a3UL;
   tf->codes[1001] = 0x0000000d12b2ecadUL;
   tf->codes[1002] = 0x0000000205cccbb8UL;
   tf->codes[1003] = 0x0000000fe6a5b5f2UL;
   tf->codes[1004] = 0x0000000d1995e567UL;
   tf->codes[1005] = 0x000000091d0f2174UL;
   tf->codes[1006] = 0x0000000360e9ebefUL;
   tf->codes[1007] = 0x0000000d304c9653UL;
   tf->codes[1008] = 0x00000007eb43d360UL;
   tf->codes[1009] = 0x00000009b24edb22UL;
   tf->codes[1010] = 0x00000005aeb87d49UL;
   tf->codes[1011] = 0x000000073a745811UL;
   tf->codes[1012] = 0x0000000e1fd08936UL;
   tf->codes[1013] = 0x000000033eeb68a9UL;
   tf->codes[1014] = 0x00000006367edc20UL;
   tf->codes[1015] = 0x000000036fd414d2UL;
   tf->codes[1016] = 0x00000002e6722e78UL;
   tf->codes[1017] = 0x00000006c7a9c15eUL;
   tf->codes[1018] = 0x00000002330d46f7UL;
   tf->codes[1019] = 0x0000000b6bc7a6e8UL;
   tf->codes[1020] = 0x000000043eb954aaUL;
   tf->codes[1021] = 0x000000005eadcf50UL;
   tf->codes[1022] = 0x000000063e43b4eaUL;
   tf->codes[1023] = 0x00000000351ca1f1UL;
   tf->codes[1024] = 0x00000008b5682648UL;
   tf->codes[1025] = 0x0000000c28f03f9aUL;
   tf->codes[1026] = 0x0000000636bfe005UL;
   tf->codes[1027] = 0x00000004ca1054e5UL;
   tf->codes[1028] = 0x0000000440ed66c9UL;
   tf->codes[1029] = 0x00000006e60f6fbcUL;
   tf->codes[1030] = 0x00000006d94e25eeUL;
   tf->codes[1031] = 0x0000000adfe9ec25UL;
   tf->codes[1032] = 0x0000000f0cb53616UL;
   tf->codes[1033] = 0x0000000cb19d69aaUL;
   tf->codes[1034] = 0x0000000ff898685eUL;
   tf->codes[1035] = 0x000000066ea208d6UL;
   tf->codes[1036] = 0x00000005dadebaf0UL;
   tf->codes[1037] = 0x0000000f3f7afea5UL;
   tf->codes[1038] = 0x0000000a96739522UL;
   tf->codes[1039] = 0x000000039a0ef88eUL;
   tf->codes[1040] = 0x0000000626acbb6eUL;
   tf->codes[1041] = 0x0000000ce0e42f8dUL;
   tf->codes[1042] = 0x0000000883ae2d8fUL;
   tf->codes[1043] = 0x0000000619bd4ce7UL;
   tf->codes[1044] = 0x0000000be466b665UL;
   tf->codes[1045] = 0x000000079e154eaeUL;
   tf->codes[1046] = 0x000000073e2a0a7aUL;
   tf->codes[1047] = 0x00000005ec94e92cUL;
   tf->codes[1048] = 0x0000000898bc6465UL;
   tf->codes[1049] = 0x0000000abce956ebUL;
   tf->codes[1050] = 0x00000002b21e8995UL;
   tf->codes[1051] = 0x000000086364e87dUL;
   tf->codes[1052] = 0x0000000d58212c13UL;
   tf->codes[1053] = 0x00000008b8c39e93UL;
   tf->codes[1054] = 0x00000000a1546c8bUL;
   tf->codes[1055] = 0x00000008abbe32b5UL;
   tf->codes[1056] = 0x0000000e8a4a2512UL;
   tf->codes[1057] = 0x0000000ad5ee178bUL;
   tf->codes[1058] = 0x000000069cc1e886UL;
   tf->codes[1059] = 0x00000005bc2f8d35UL;
   tf->codes[1060] = 0x00000001bbcd0982UL;
   tf->codes[1061] = 0x00000001fd969b1aUL;
   tf->codes[1062] = 0x0000000ae9e4251bUL;
   tf->codes[1063] = 0x00000009afc001adUL;
   tf->codes[1064] = 0x000000069e9d82f9UL;
   tf->codes[1065] = 0x000000092f852ed7UL;
   tf->codes[1066] = 0x0000000adb6d7fe1UL;
   tf->codes[1067] = 0x000000067b91999dUL;
   tf->codes[1068] = 0x0000000fa2600b99UL;
   tf->codes[1069] = 0x0000000d6735277eUL;
   tf->codes[1070] = 0x0000000f836268edUL;
   tf->codes[1071] = 0x0000000b7911c708UL;
   tf->codes[1072] = 0x000000013427930eUL;
   tf->codes[1073] = 0x0000000f24a44da1UL;
   tf->codes[1074] = 0x0000000ed2f760e0UL;
   tf->codes[1075] = 0x0000000920508584UL;
   tf->codes[1076] = 0x00000009f1b07e2bUL;
   tf->codes[1077] = 0x000000032c15b482UL;
   tf->codes[1078] = 0x0000000ffcd64b43UL;
   tf->codes[1079] = 0x0000000a055b6498UL;
   tf->codes[1080] = 0x0000000b2a107a8bUL;
   tf->codes[1081] = 0x0000000191147253UL;
   tf->codes[1082] = 0x00000009c214bb01UL;
   tf->codes[1083] = 0x00000008bb616abdUL;
   tf->codes[1084] = 0x00000001ef7dea4aUL;
   tf->codes[1085] = 0x00000009dd6d225dUL;
   tf->codes[1086] = 0x000000095563112cUL;
   tf->codes[1087] = 0x000000001e4d0569UL;
   tf->codes[1088] = 0x0000000f21a51b18UL;
   tf->codes[1089] = 0x0000000686d2a5ebUL;
   tf->codes[1090] = 0x000000032032674aUL;
   tf->codes[1091] = 0x0000000c3d902590UL;
   tf->codes[1092] = 0x0000000856c92019UL;
   tf->codes[1093] = 0x000000058ebdcd91UL;
   tf->codes[1094] = 0x0000000df2c7f9aeUL;
   tf->codes[1095] = 0x000000089d852225UL;
   tf->codes[1096] = 0x0000000862c4110dUL;
   tf->codes[1097] = 0x0000000dc7df8185UL;
   tf->codes[1098] = 0x0000000c16e1da36UL;
   tf->codes[1099] = 0x00000005a6749140UL;
   tf->codes[1100] = 0x00000000e94d9865UL;
   tf->codes[1101] = 0x000000032ec4b2feUL;
   tf->codes[1102] = 0x0000000c80777c94UL;
   tf->codes[1103] = 0x00000006869a7d57UL;
   tf->codes[1104] = 0x00000008de18dc8eUL;
   tf->codes[1105] = 0x0000000c98cc7379UL;
   tf->codes[1106] = 0x000000079a6fa3a2UL;
   tf->codes[1107] = 0x00000008b854287dUL;
   tf->codes[1108] = 0x000000055bcd493bUL;
   tf->codes[1109] = 0x0000000f3ddb56ecUL;
   tf->codes[1110] = 0x0000000d15ec6405UL;
   tf->codes[1111] = 0x0000000316f82362UL;
   tf->codes[1112] = 0x000000039676e2a1UL;
   tf->codes[1113] = 0x00000004044e831aUL;
   tf->codes[1114] = 0x00000008444cf83bUL;
   tf->codes[1115] = 0x000000064658814cUL;
   tf->codes[1116] = 0x0000000d7ad48a68UL;
   tf->codes[1117] = 0x0000000d5eb72583UL;
   tf->codes[1118] = 0x0000000e11057b5dUL;
   tf->codes[1119] = 0x0000000b7e3cd622UL;
   tf->codes[1120] = 0x0000000a6a2f9c78UL;
   tf->codes[1121] = 0x0000000a5924afe8UL;
   tf->codes[1122] = 0x000000040a92e9baUL;
   tf->codes[1123] = 0x0000000367a3950fUL;
   tf->codes[1124] = 0x00000008dee1ebe9UL;
   tf->codes[1125] = 0x000000052b717d05UL;
   tf->codes[1126] = 0x00000009a5691e7dUL;
   tf->codes[1127] = 0x0000000d454d2e0fUL;
   tf->codes[1128] = 0x0000000fd8b299e9UL;
   tf->codes[1129] = 0x0000000b2b1b84c2UL;
   tf->codes[1130] = 0x00000004eacf400bUL;
   tf->codes[1131] = 0x000000081eb4687eUL;
   tf->codes[1132] = 0x00000005cd851fa7UL;
   tf->codes[1133] = 0x00000001c285ea35UL;
   tf->codes[1134] = 0x00000008ac9fdc95UL;
   tf->codes[1135] = 0x00000001b612a6c3UL;
   tf->codes[1136] = 0x000000094f92a63aUL;
   tf->codes[1137] = 0x00000007debaf7c8UL;
   tf->codes[1138] = 0x00000008cbcb7d94UL;
   tf->codes[1139] = 0x0000000e439689eaUL;
   tf->codes[1140] = 0x00000000932e63d2UL;
   tf->codes[1141] = 0x0000000f3f641704UL;
   tf->codes[1142] = 0x00000001acb5259eUL;
   tf->codes[1143] = 0x0000000321ea6e39UL;
   tf->codes[1144] = 0x000000061c65c02fUL;
   tf->codes[1145] = 0x00000004282e42f2UL;
   tf->codes[1146] = 0x00000001dd4ff338UL;
   tf->codes[1147] = 0x0000000d91e27631UL;
   tf->codes[1148] = 0x0000000d93927fceUL;
   tf->codes[1149] = 0x00000004d40d6ae7UL;
   tf->codes[1150] = 0x00000005bbfd1359UL;
   tf->codes[1151] = 0x000000088bd393feUL;
   tf->codes[1152] = 0x00000002535b3fd7UL;
   tf->codes[1153] = 0x0000000b705488d3UL;
   tf->codes[1154] = 0x00000009aa688843UL;
   tf->codes[1155] = 0x00000009fa55ccf0UL;
   tf->codes[1156] = 0x000000002cf10ca5UL;
   tf->codes[1157] = 0x00000008235e2861UL;
   tf->codes[1158] = 0x00000002610f1f02UL;
   tf->codes[1159] = 0x0000000b203fbac1UL;
   tf->codes[1160] = 0x0000000e05f02f3cUL;
   tf->codes[1161] = 0x0000000b0d0e50adUL;
   tf->codes[1162] = 0x0000000244eee955UL;
   tf->codes[1163] = 0x00000004c5beb90dUL;
   tf->codes[1164] = 0x000000013343b3c4UL;
   tf->codes[1165] = 0x000000021bf9a392UL;
   tf->codes[1166] = 0x0000000be95ecb69UL;
   tf->codes[1167] = 0x0000000bc65857e2UL;
   tf->codes[1168] = 0x00000008185173f4UL;
   tf->codes[1169] = 0x0000000c3f6d059dUL;
   tf->codes[1170] = 0x000000035c94e74aUL;
   tf->codes[1171] = 0x0000000f72a083a3UL;
   tf->codes[1172] = 0x00000005b36eab8fUL;
   tf->codes[1173] = 0x0000000aa28606bbUL;
   tf->codes[1174] = 0x0000000447d407bdUL;
   tf->codes[1175] = 0x0000000d47eafc61UL;
   tf->codes[1176] = 0x00000004e4dd872fUL;
   tf->codes[1177] = 0x0000000abd276950UL;
   tf->codes[1178] = 0x0000000b999bc572UL;
   tf->codes[1179] = 0x00000008e0c5cee3UL;
   tf->codes[1180] = 0x00000009fd2442d0UL;
   tf->codes[1181] = 0x0000000bcb568051UL;
   tf->codes[1182] = 0x0000000b87a1635bUL;
   tf->codes[1183] = 0x0000000b3557c1e5UL;
   tf->codes[1184] = 0x0000000ce9b07f46UL;
   tf->codes[1185] = 0x00000000b6dfcfd2UL;
   tf->codes[1186] = 0x000000028a540e7bUL;
   tf->codes[1187] = 0x0000000bb04666c4UL;
   tf->codes[1188] = 0x0000000b7baf38c6UL;
   tf->codes[1189] = 0x0000000c37168124UL;
   tf->codes[1190] = 0x0000000ca3c9589dUL;
   tf->codes[1191] = 0x00000003529b99c0UL;
   tf->codes[1192] = 0x0000000e8afab685UL;
   tf->codes[1193] = 0x0000000bdc566027UL;
   tf->codes[1194] = 0x00000003f1ded61bUL;
   tf->codes[1195] = 0x0000000ce9930acdUL;
   tf->codes[1196] = 0x000000008aa447dbUL;
   tf->codes[1197] = 0x000000077a696e73UL;
   tf->codes[1198] = 0x00000000eb44d17bUL;
   tf->codes[1199] = 0x0000000c5d9c164dUL;
   tf->codes[1200] = 0x00000001f98d7237UL;
   tf->codes[1201] = 0x000000056a327041UL;
   tf->codes[1202] = 0x0000000e9ecd1e58UL;
   tf->codes[1203] = 0x00000000c2e0c7f4UL;
   tf->codes[1204] = 0x0000000abf4a1a5eUL;
   tf->codes[1205] = 0x00000009395c523eUL;
   tf->codes[1206] = 0x0000000d014134faUL;
   tf->codes[1207] = 0x00000005fbd62cadUL;
   tf->codes[1208] = 0x0000000b247b4af6UL;
   tf->codes[1209] = 0x0000000413f6fb3bUL;
   tf->codes[1210] = 0x000000061c6ea7c4UL;
   tf->codes[1211] = 0x00000008015ac6a5UL;
   tf->codes[1212] = 0x00000000baf0e3ddUL;
   tf->codes[1213] = 0x0000000ba1215e4aUL;
   tf->codes[1214] = 0x0000000b01a9b92eUL;
   tf->codes[1215] = 0x0000000c1516251fUL;
   tf->codes[1216] = 0x000000001d0eeda9UL;
   tf->codes[1217] = 0x0000000cf17f566fUL;
   tf->codes[1218] = 0x00000003203947b3UL;
   tf->codes[1219] = 0x00000007c92be543UL;
   tf->codes[1220] = 0x0000000c320f34b8UL;
   tf->codes[1221] = 0x00000006b1ff7e93UL;
   tf->codes[1222] = 0x000000029d39ef02UL;
   tf->codes[1223] = 0x0000000eda7b1139UL;
   tf->codes[1224] = 0x0000000cca47d853UL;
   tf->codes[1225] = 0x00000007ad24144dUL;
   tf->codes[1226] = 0x00000007b082f234UL;
   tf->codes[1227] = 0x0000000a6ec32320UL;
   tf->codes[1228] = 0x0000000cf89eda25UL;
   tf->codes[1229] = 0x0000000b64064998UL;
   tf->codes[1230] = 0x0000000fa2314616UL;
   tf->codes[1231] = 0x0000000d21789ac2UL;
   tf->codes[1232] = 0x0000000d3c8d0f5dUL;
   tf->codes[1233] = 0x00000006bac87d8dUL;
   tf->codes[1234] = 0x00000001ff1311bdUL;
   tf->codes[1235] = 0x00000002a1584b86UL;
   tf->codes[1236] = 0x0000000b23dc8745UL;
   tf->codes[1237] = 0x0000000eda5fcd76UL;
   tf->codes[1238] = 0x0000000a7a9261d0UL;
   tf->codes[1239] = 0x0000000512745cf6UL;
   tf->codes[1240] = 0x00000002fc13fa8bUL;
   tf->codes[1241] = 0x0000000e733958d3UL;
   tf->codes[1242] = 0x0000000a057fc27dUL;
   tf->codes[1243] = 0x0000000b4ffd8bbcUL;
   tf->codes[1244] = 0x00000002abff4fb6UL;
   tf->codes[1245] = 0x00000001d148a214UL;
   tf->codes[1246] = 0x0000000d3c3c41fbUL;
   tf->codes[1247] = 0x00000000cf542a81UL;
   tf->codes[1248] = 0x0000000ee518b8dbUL;
   tf->codes[1249] = 0x00000005d97028faUL;
   tf->codes[1250] = 0x00000000dd153679UL;
   tf->codes[1251] = 0x0000000d8e1610b5UL;
   tf->codes[1252] = 0x0000000575122babUL;
   tf->codes[1253] = 0x0000000090fec0a7UL;
   tf->codes[1254] = 0x00000005aa2ee7deUL;
   tf->codes[1255] = 0x0000000116ae8273UL;
   tf->codes[1256] = 0x000000016991092eUL;
   tf->codes[1257] = 0x00000003ab370aa5UL;
   tf->codes[1258] = 0x00000003f0c514e6UL;
   tf->codes[1259] = 0x0000000340ce20adUL;
   tf->codes[1260] = 0x0000000d1cbbebb8UL;
   tf->codes[1261] = 0x0000000aff5b363dUL;
   tf->codes[1262] = 0x00000002f31fb255UL;
   tf->codes[1263] = 0x00000005b7e53a8aUL;
   tf->codes[1264] = 0x000000058d91de7cUL;
   tf->codes[1265] = 0x00000006fdf2521fUL;
   tf->codes[1266] = 0x000000080d755cb9UL;
   tf->codes[1267] = 0x0000000cf8c9903bUL;
   tf->codes[1268] = 0x00000000ab7ef0c7UL;
   tf->codes[1269] = 0x00000003c61bf489UL;
   tf->codes[1270] = 0x0000000fbfd14815UL;
   tf->codes[1271] = 0x0000000baa647e90UL;
   tf->codes[1272] = 0x0000000daf22defeUL;
   tf->codes[1273] = 0x00000001a54cfe57UL;
   tf->codes[1274] = 0x000000054d061818UL;
   tf->codes[1275] = 0x0000000158deb36dUL;
   tf->codes[1276] = 0x0000000a7955893aUL;
   tf->codes[1277] = 0x0000000409b1960bUL;
   tf->codes[1278] = 0x000000021cfed67eUL;
   tf->codes[1279] = 0x0000000b478f7f56UL;
   tf->codes[1280] = 0x00000002ff42f95dUL;
   tf->codes[1281] = 0x000000048a06d3ecUL;
   tf->codes[1282] = 0x0000000170957703UL;
   tf->codes[1283] = 0x00000003925ece98UL;
   tf->codes[1284] = 0x0000000d929cec5bUL;
   tf->codes[1285] = 0x0000000aa5813ee5UL;
   tf->codes[1286] = 0x00000009fb913a1eUL;
   tf->codes[1287] = 0x0000000465854b47UL;
   tf->codes[1288] = 0x00000008ac8a7343UL;
   tf->codes[1289] = 0x000000084451853bUL;
   tf->codes[1290] = 0x000000049987e033UL;
   tf->codes[1291] = 0x000000075cd03c35UL;
   tf->codes[1292] = 0x0000000cf326e2c1UL;
   tf->codes[1293] = 0x0000000ed14fdb95UL;
   tf->codes[1294] = 0x000000031a390e60UL;
   tf->codes[1295] = 0x0000000a1959d956UL;
   tf->codes[1296] = 0x00000001985d18b3UL;
   tf->codes[1297] = 0x00000000b6b8bb85UL;
   tf->codes[1298] = 0x0000000dc3fa4c95UL;
   tf->codes[1299] = 0x00000003645fcf45UL;
   tf->codes[1300] = 0x00000006c2146e60UL;
   tf->codes[1301] = 0x00000008bdeaf7d6UL;
   tf->codes[1302] = 0x00000005d0d268cfUL;
   tf->codes[1303] = 0x00000008df1d5b62UL;
   tf->codes[1304] = 0x000000077506eed4UL;
   tf->codes[1305] = 0x00000005bebc26a3UL;
   tf->codes[1306] = 0x0000000c78584caaUL;
   tf->codes[1307] = 0x00000007ee6685bdUL;
   tf->codes[1308] = 0x00000000d8af0a56UL;
   tf->codes[1309] = 0x0000000e3a0db991UL;
   tf->codes[1310] = 0x0000000625de434dUL;
   tf->codes[1311] = 0x0000000582318bceUL;
   tf->codes[1312] = 0x00000003ebe2bc3cUL;
   tf->codes[1313] = 0x0000000ebd301053UL;
   tf->codes[1314] = 0x00000005f579e6d7UL;
   tf->codes[1315] = 0x0000000e9810d2aeUL;
   tf->codes[1316] = 0x0000000b893145b4UL;
   tf->codes[1317] = 0x0000000a7e7836d1UL;
   tf->codes[1318] = 0x0000000679dac13bUL;
   tf->codes[1319] = 0x00000008d99e4704UL;
   tf->codes[1320] = 0x00000001c7234de5UL;
   tf->codes[1321] = 0x0000000f23b8b6dbUL;
   tf->codes[1322] = 0x0000000de8a6f02fUL;
   tf->codes[1323] = 0x0000000bd2026bf8UL;
   tf->codes[1324] = 0x0000000bb3903264UL;
   tf->codes[1325] = 0x0000000ede8048afUL;
   tf->codes[1326] = 0x000000060161ef64UL;
   tf->codes[1327] = 0x00000008fc791a5bUL;
   tf->codes[1328] = 0x00000006a4546243UL;
   tf->codes[1329] = 0x0000000bc8187b47UL;
   tf->codes[1330] = 0x0000000ff2ca8dcaUL;
   tf->codes[1331] = 0x00000006bf71b837UL;
   tf->codes[1332] = 0x000000078b8d1fe8UL;
   tf->codes[1333] = 0x0000000e738cdd2aUL;
   tf->codes[1334] = 0x00000007aa80d490UL;
   tf->codes[1335] = 0x0000000fd1026293UL;
   tf->codes[1336] = 0x0000000c96fe6ad3UL;
   tf->codes[1337] = 0x000000083f0f4f7bUL;
   tf->codes[1338] = 0x000000075cb39786UL;
   tf->codes[1339] = 0x0000000b6ef13bddUL;
   tf->codes[1340] = 0x0000000f6a89f8a5UL;
   tf->codes[1341] = 0x000000099a14349eUL;
   tf->codes[1342] = 0x00000001ce6c16e5UL;
   tf->codes[1343] = 0x0000000a7597498fUL;
   tf->codes[1344] = 0x0000000145206424UL;
   tf->codes[1345] = 0x0000000013c9c5b3UL;
   tf->codes[1346] = 0x0000000d25775fc6UL;
   tf->codes[1347] = 0x000000072311ca63UL;
   tf->codes[1348] = 0x0000000936d4cfe7UL;
   tf->codes[1349] = 0x00000009ce43a505UL;
   tf->codes[1350] = 0x0000000663594c01UL;
   tf->codes[1351] = 0x000000042d1be7b6UL;
   tf->codes[1352] = 0x000000080b1dc92dUL;
   tf->codes[1353] = 0x000000020e8e5b75UL;
   tf->codes[1354] = 0x00000000c2337a9eUL;
   tf->codes[1355] = 0x000000058ae29f6bUL;
   tf->codes[1356] = 0x000000090c553143UL;
   tf->codes[1357] = 0x00000005b06da028UL;
   tf->codes[1358] = 0x00000009415b2520UL;
   tf->codes[1359] = 0x00000005dabcde8bUL;
   tf->codes[1360] = 0x0000000d3c804332UL;
   tf->codes[1361] = 0x0000000028d103dbUL;
   tf->codes[1362] = 0x00000007be4cf210UL;
   tf->codes[1363] = 0x000000056f76dd52UL;
   tf->codes[1364] = 0x00000003877e1a3bUL;
   tf->codes[1365] = 0x00000001f93eb430UL;
   tf->codes[1366] = 0x00000000588972acUL;
   tf->codes[1367] = 0x0000000c76cd7eb1UL;
   tf->codes[1368] = 0x0000000852596e61UL;
   tf->codes[1369] = 0x00000006fa0ead03UL;
   tf->codes[1370] = 0x0000000d78be2bb6UL;
   tf->codes[1371] = 0x000000056fdd6fd1UL;
   tf->codes[1372] = 0x0000000e265b0ebdUL;
   tf->codes[1373] = 0x0000000cc715a846UL;
   tf->codes[1374] = 0x0000000ffb1e87a8UL;
   tf->codes[1375] = 0x0000000d9893a834UL;
   tf->codes[1376] = 0x0000000054c56923UL;
   tf->codes[1377] = 0x000000063bbaac88UL;
   tf->codes[1378] = 0x000000076a5585d4UL;
   tf->codes[1379] = 0x0000000607b37e59UL;
   tf->codes[1380] = 0x0000000ee4d4018bUL;
   tf->codes[1381] = 0x00000007ef2d8dc5UL;
   tf->codes[1382] = 0x0000000c1c2d4285UL;
   tf->codes[1383] = 0x00000001e0be0a7bUL;
   tf->codes[1384] = 0x00000009fbdac67eUL;
   tf->codes[1385] = 0x0000000dc5c74ca1UL;
   tf->codes[1386] = 0x00000008366e2f1cUL;
   tf->codes[1387] = 0x0000000abf1e4843UL;
   tf->codes[1388] = 0x00000007b55f4dacUL;
   tf->codes[1389] = 0x00000003d6150197UL;
   tf->codes[1390] = 0x00000004e034c8dbUL;
   tf->codes[1391] = 0x000000063df500dfUL;
   tf->codes[1392] = 0x000000034b89afd5UL;
   tf->codes[1393] = 0x00000000a5ddabc7UL;
   tf->codes[1394] = 0x00000009ee6ff8ecUL;
   tf->codes[1395] = 0x00000003cdd9a682UL;
   tf->codes[1396] = 0x0000000a8d46f842UL;
   tf->codes[1397] = 0x00000005fec25f7dUL;
   tf->codes[1398] = 0x00000004216835cfUL;
   tf->codes[1399] = 0x00000001624430f9UL;
   tf->codes[1400] = 0x000000018afb5b6cUL;
   tf->codes[1401] = 0x00000009ffd34c8eUL;
   tf->codes[1402] = 0x000000095d5882edUL;
   tf->codes[1403] = 0x00000002e28d07cfUL;
   tf->codes[1404] = 0x0000000fd9163bc2UL;
   tf->codes[1405] = 0x0000000a5d0833d8UL;
   tf->codes[1406] = 0x00000003ebaf5bfdUL;
   tf->codes[1407] = 0x000000089a7a3e54UL;
   tf->codes[1408] = 0x000000085d3f7dd8UL;
   tf->codes[1409] = 0x00000008af8d1ba1UL;
   tf->codes[1410] = 0x0000000a5b4e01b7UL;
   tf->codes[1411] = 0x00000009f1accb0aUL;
   tf->codes[1412] = 0x00000002fe5fcb31UL;
   tf->codes[1413] = 0x00000002c4484bedUL;
   tf->codes[1414] = 0x0000000a124de2eeUL;
   tf->codes[1415] = 0x000000051471f700UL;
   tf->codes[1416] = 0x000000014f7195f8UL;
   tf->codes[1417] = 0x00000003ab7e9700UL;
   tf->codes[1418] = 0x00000004542a74bfUL;
   tf->codes[1419] = 0x00000009a01158f7UL;
   tf->codes[1420] = 0x00000001f288d502UL;
   tf->codes[1421] = 0x0000000af0834285UL;
   tf->codes[1422] = 0x0000000c936df23fUL;
   tf->codes[1423] = 0x00000002d38ea826UL;
   tf->codes[1424] = 0x0000000b1966249aUL;
   tf->codes[1425] = 0x0000000bc43458d4UL;
   tf->codes[1426] = 0x000000011eb6a09cUL;
   tf->codes[1427] = 0x0000000d49d9986cUL;
   tf->codes[1428] = 0x0000000dd9067c0eUL;
   tf->codes[1429] = 0x0000000ce383aa71UL;
   tf->codes[1430] = 0x00000000739c5a2fUL;
   tf->codes[1431] = 0x0000000770f58eaaUL;
   tf->codes[1432] = 0x0000000a5d87da4dUL;
   tf->codes[1433] = 0x0000000401b685acUL;
   tf->codes[1434] = 0x0000000c65512bc1UL;
   tf->codes[1435] = 0x00000006999d7387UL;
   tf->codes[1436] = 0x0000000e23d36997UL;
   tf->codes[1437] = 0x0000000e30f1d174UL;
   tf->codes[1438] = 0x000000016e46fc04UL;
   tf->codes[1439] = 0x0000000200efa090UL;
   tf->codes[1440] = 0x000000018d86ea94UL;
   tf->codes[1441] = 0x0000000b75de5761UL;
   tf->codes[1442] = 0x00000009e50de39dUL;
   tf->codes[1443] = 0x0000000d7a0a0161UL;
   tf->codes[1444] = 0x0000000537a63844UL;
   tf->codes[1445] = 0x0000000e4f4de023UL;
   tf->codes[1446] = 0x0000000c5b83066fUL;
   tf->codes[1447] = 0x0000000b9a2f9eb6UL;
   tf->codes[1448] = 0x000000082a761d43UL;
   tf->codes[1449] = 0x00000007088ad873UL;
   tf->codes[1450] = 0x00000005b512f418UL;
   tf->codes[1451] = 0x0000000a373cf2e4UL;
   tf->codes[1452] = 0x00000005937d7c89UL;
   tf->codes[1453] = 0x0000000cca051304UL;
   tf->codes[1454] = 0x00000007a84e3efbUL;
   tf->codes[1455] = 0x000000074d80c91bUL;
   tf->codes[1456] = 0x00000004ad73e91dUL;
   tf->codes[1457] = 0x0000000490cea84aUL;
   tf->codes[1458] = 0x000000052e4f1987UL;
   tf->codes[1459] = 0x0000000ec811379eUL;
   tf->codes[1460] = 0x0000000b4f570589UL;
   tf->codes[1461] = 0x00000005a6c46e81UL;
   tf->codes[1462] = 0x0000000ca857badaUL;
   tf->codes[1463] = 0x0000000bb9c86860UL;
   tf->codes[1464] = 0x0000000b2632ee04UL;
   tf->codes[1465] = 0x00000003f597b324UL;
   tf->codes[1466] = 0x00000007df14d546UL;
   tf->codes[1467] = 0x00000005978d3925UL;
   tf->codes[1468] = 0x000000098498767bUL;
   tf->codes[1469] = 0x000000015966a839UL;
   tf->codes[1470] = 0x00000006923743efUL;
   tf->codes[1471] = 0x000000052f38b460UL;
   tf->codes[1472] = 0x00000006a2df69edUL;
   tf->codes[1473] = 0x000000084151f66cUL;
   tf->codes[1474] = 0x00000001ee304eabUL;
   tf->codes[1475] = 0x0000000a082ae4afUL;
   tf->codes[1476] = 0x00000000de4e6afaUL;
   tf->codes[1477] = 0x00000008131b4166UL;
   tf->codes[1478] = 0x0000000af5b7967aUL;
   tf->codes[1479] = 0x000000016d942f84UL;
   tf->codes[1480] = 0x0000000dab10053eUL;
   tf->codes[1481] = 0x0000000cce886f54UL;
   tf->codes[1482] = 0x000000039bc89ef4UL;
   tf->codes[1483] = 0x0000000a5b7d9067UL;
   tf->codes[1484] = 0x00000002fb039e23UL;
   tf->codes[1485] = 0x000000006d82231dUL;
   tf->codes[1486] = 0x000000003a946dd7UL;
   tf->codes[1487] = 0x00000008b719555cUL;
   tf->codes[1488] = 0x00000005352ece13UL;
   tf->codes[1489] = 0x0000000904fb9151UL;
   tf->codes[1490] = 0x0000000c7d7cc8d1UL;
   tf->codes[1491] = 0x0000000d20511b70UL;
   tf->codes[1492] = 0x0000000f2411eeb8UL;
   tf->codes[1493] = 0x00000005b4a24ed9UL;
   tf->codes[1494] = 0x0000000c00fe866fUL;
   tf->codes[1495] = 0x0000000eb118811aUL;
   tf->codes[1496] = 0x0000000cabf21b14UL;
   tf->codes[1497] = 0x0000000052e3a95fUL;
   tf->codes[1498] = 0x0000000506d306f1UL;
   tf->codes[1499] = 0x000000022cd662d4UL;
   tf->codes[1500] = 0x000000089161da55UL;
   tf->codes[1501] = 0x00000007db947827UL;
   tf->codes[1502] = 0x0000000b70b47976UL;
   tf->codes[1503] = 0x0000000814e4e0edUL;
   tf->codes[1504] = 0x00000008cb8f07f3UL;
   tf->codes[1505] = 0x0000000b6979fdc4UL;
   tf->codes[1506] = 0x0000000b0eebb6b0UL;
   tf->codes[1507] = 0x00000005ec980ef2UL;
   tf->codes[1508] = 0x00000004b53ccab8UL;
   tf->codes[1509] = 0x00000009c80770e3UL;
   tf->codes[1510] = 0x0000000b7ee43a52UL;
   tf->codes[1511] = 0x0000000a8ef24d04UL;
   tf->codes[1512] = 0x00000009ec4f67e6UL;
   tf->codes[1513] = 0x0000000d5f2fb080UL;
   tf->codes[1514] = 0x0000000efc528d35UL;
   tf->codes[1515] = 0x0000000db181ccfbUL;
   tf->codes[1516] = 0x000000039330efd0UL;
   tf->codes[1517] = 0x00000001a7dd101aUL;
   tf->codes[1518] = 0x00000004ac3982ecUL;
   tf->codes[1519] = 0x00000007037e17dcUL;
   tf->codes[1520] = 0x0000000366188495UL;
   tf->codes[1521] = 0x000000002458d8a7UL;
   tf->codes[1522] = 0x00000005f004f923UL;
   tf->codes[1523] = 0x00000004fe549703UL;
   tf->codes[1524] = 0x00000004d33fc825UL;
   tf->codes[1525] = 0x0000000016f29207UL;
   tf->codes[1526] = 0x0000000a5b2b61a0UL;
   tf->codes[1527] = 0x0000000d9ea2cb3fUL;
   tf->codes[1528] = 0x000000009d5e3b9bUL;
   tf->codes[1529] = 0x00000004e473ff93UL;
   tf->codes[1530] = 0x000000051e981524UL;
   tf->codes[1531] = 0x000000068db475adUL;
   tf->codes[1532] = 0x0000000def9cdca4UL;
   tf->codes[1533] = 0x000000044a257b51UL;
   tf->codes[1534] = 0x000000050a9ee66aUL;
   tf->codes[1535] = 0x00000007b40b799bUL;
   tf->codes[1536] = 0x00000004111f2de4UL;
   tf->codes[1537] = 0x0000000cfcfb6b09UL;
   tf->codes[1538] = 0x0000000f2412713aUL;
   tf->codes[1539] = 0x00000008d799e9ddUL;
   tf->codes[1540] = 0x0000000534748e45UL;
   tf->codes[1541] = 0x000000032f291f51UL;
   tf->codes[1542] = 0x0000000030363bd3UL;
   tf->codes[1543] = 0x000000012906d84dUL;
   tf->codes[1544] = 0x00000006bd9344a9UL;
   tf->codes[1545] = 0x000000061a5524f1UL;
   tf->codes[1546] = 0x0000000a94d8e02bUL;
   tf->codes[1547] = 0x000000082d03a557UL;
   tf->codes[1548] = 0x0000000468cdf94aUL;
   tf->codes[1549] = 0x0000000bdd69de40UL;
   tf->codes[1550] = 0x0000000ea8853fd9UL;
   tf->codes[1551] = 0x0000000d6caf9343UL;
   tf->codes[1552] = 0x000000001755e839UL;
   tf->codes[1553] = 0x0000000badf446deUL;
   tf->codes[1554] = 0x0000000fe70eae5aUL;
   tf->codes[1555] = 0x00000001f3817ad1UL;
   tf->codes[1556] = 0x000000091db0de1aUL;
   tf->codes[1557] = 0x0000000c1fc0df55UL;
   tf->codes[1558] = 0x0000000b55de01ccUL;
   tf->codes[1559] = 0x000000066c5829bdUL;
   tf->codes[1560] = 0x000000033cb31ff9UL;
   tf->codes[1561] = 0x0000000ad671f856UL;
   tf->codes[1562] = 0x0000000534431aefUL;
   tf->codes[1563] = 0x0000000d30fd939aUL;
   tf->codes[1564] = 0x0000000826d24c57UL;
   tf->codes[1565] = 0x0000000d40d5f1b1UL;
   tf->codes[1566] = 0x000000058f22448cUL;
   tf->codes[1567] = 0x000000083611d663UL;
   tf->codes[1568] = 0x0000000f4df3f635UL;
   tf->codes[1569] = 0x00000001c1071941UL;
   tf->codes[1570] = 0x00000000f870bccbUL;
   tf->codes[1571] = 0x000000013a62329eUL;
   tf->codes[1572] = 0x00000006d6e094a0UL;
   tf->codes[1573] = 0x000000013c44a6a7UL;
   tf->codes[1574] = 0x0000000129bc445bUL;
   tf->codes[1575] = 0x000000059ee90dfdUL;
   tf->codes[1576] = 0x00000000e0a5171aUL;
   tf->codes[1577] = 0x00000005f92372baUL;
   tf->codes[1578] = 0x00000008638592efUL;
   tf->codes[1579] = 0x000000000d72f3b5UL;
   tf->codes[1580] = 0x0000000bc7e60a8cUL;
   tf->codes[1581] = 0x0000000ce5895c63UL;
   tf->codes[1582] = 0x0000000e41b1ca5dUL;
   tf->codes[1583] = 0x0000000e615ea62cUL;
   tf->codes[1584] = 0x00000006993e2180UL;
   tf->codes[1585] = 0x00000000cc37d82cUL;
   tf->codes[1586] = 0x000000026af573f3UL;
   tf->codes[1587] = 0x00000001eb95a424UL;
   tf->codes[1588] = 0x000000050e5fbc99UL;
   tf->codes[1589] = 0x0000000fb89b34b2UL;
   tf->codes[1590] = 0x00000009571a8d0fUL;
   tf->codes[1591] = 0x00000009d1a63a99UL;
   tf->codes[1592] = 0x00000009a033e7e7UL;
   tf->codes[1593] = 0x0000000d77b20f8cUL;
   tf->codes[1594] = 0x0000000ed2ce19b0UL;
   tf->codes[1595] = 0x00000005731543c1UL;
   tf->codes[1596] = 0x0000000a59b97f53UL;
   tf->codes[1597] = 0x00000001b3503950UL;
   tf->codes[1598] = 0x00000007cc1f4899UL;
   tf->codes[1599] = 0x00000003b5a20f14UL;
   tf->codes[1600] = 0x00000003fb33bf95UL;
   tf->codes[1601] = 0x000000024850c92fUL;
   tf->codes[1602] = 0x0000000e3e322563UL;
   tf->codes[1603] = 0x0000000ba303ab82UL;
   tf->codes[1604] = 0x00000005a004a3cbUL;
   tf->codes[1605] = 0x00000001bc3a579dUL;
   tf->codes[1606] = 0x0000000bc3dd3ba0UL;
   tf->codes[1607] = 0x0000000df582df03UL;
   tf->codes[1608] = 0x0000000dfd57af2cUL;
   tf->codes[1609] = 0x00000003863e1da0UL;
   tf->codes[1610] = 0x0000000dac52e26fUL;
   tf->codes[1611] = 0x00000008eb863556UL;
   tf->codes[1612] = 0x000000094d19e451UL;
   tf->codes[1613] = 0x00000001d50d8f5fUL;
   tf->codes[1614] = 0x000000027d1987deUL;
   tf->codes[1615] = 0x00000000aadc2f1eUL;
   tf->codes[1616] = 0x0000000d55af6b1dUL;
   tf->codes[1617] = 0x0000000737fe1509UL;
   tf->codes[1618] = 0x0000000a49e0fe3bUL;
   tf->codes[1619] = 0x00000002a49eeaf9UL;
   tf->codes[1620] = 0x00000000c946b05cUL;
   tf->codes[1621] = 0x0000000ca43c3583UL;
   tf->codes[1622] = 0x000000019f868513UL;
   tf->codes[1623] = 0x000000069cbd7558UL;
   tf->codes[1624] = 0x00000005043e7034UL;
   tf->codes[1625] = 0x0000000616e82885UL;
   tf->codes[1626] = 0x0000000fd919ba26UL;
   tf->codes[1627] = 0x0000000b50ca391fUL;
   tf->codes[1628] = 0x0000000c1c578673UL;
   tf->codes[1629] = 0x0000000d4cb35af7UL;
   tf->codes[1630] = 0x0000000f82970fb0UL;
   tf->codes[1631] = 0x00000002fe746c03UL;
   tf->codes[1632] = 0x00000008a89c5009UL;
   tf->codes[1633] = 0x00000006228cb500UL;
   tf->codes[1634] = 0x000000027ea5af6bUL;
   tf->codes[1635] = 0x0000000dbce2be47UL;
   tf->codes[1636] = 0x0000000bd304a07cUL;
   tf->codes[1637] = 0x0000000436d1ffecUL;
   tf->codes[1638] = 0x0000000e616c764aUL;
   tf->codes[1639] = 0x0000000e50868951UL;
   tf->codes[1640] = 0x000000008cb63318UL;
   tf->codes[1641] = 0x000000006a39fbc8UL;
   tf->codes[1642] = 0x0000000d42cede82UL;
   tf->codes[1643] = 0x0000000814c745ceUL;
   tf->codes[1644] = 0x0000000d9032244bUL;
   tf->codes[1645] = 0x0000000e20bc0e5aUL;
   tf->codes[1646] = 0x00000002ce95450bUL;
   tf->codes[1647] = 0x000000015cae0ea8UL;
   tf->codes[1648] = 0x00000004a2ff168fUL;
   tf->codes[1649] = 0x00000003c6b4fe2fUL;
   tf->codes[1650] = 0x00000001999a6d47UL;
   tf->codes[1651] = 0x0000000df7755c04UL;
   tf->codes[1652] = 0x00000000e2da75e1UL;
   tf->codes[1653] = 0x0000000cfb8748c2UL;
   tf->codes[1654] = 0x00000006472c5913UL;
   tf->codes[1655] = 0x0000000ca51e4ce0UL;
   tf->codes[1656] = 0x000000034f2ca384UL;
   tf->codes[1657] = 0x00000007b305ce7cUL;
   tf->codes[1658] = 0x0000000f3704894aUL;
   tf->codes[1659] = 0x000000055945c075UL;
   tf->codes[1660] = 0x0000000104252729UL;
   tf->codes[1661] = 0x0000000b16e409ffUL;
   tf->codes[1662] = 0x00000003676f5fc8UL;
   tf->codes[1663] = 0x00000008b9ba144fUL;
   tf->codes[1664] = 0x0000000a322964e9UL;
   tf->codes[1665] = 0x000000009841268bUL;
   tf->codes[1666] = 0x00000008c8912053UL;
   tf->codes[1667] = 0x0000000db2e4f8d1UL;
   tf->codes[1668] = 0x000000062a58cbf4UL;
   tf->codes[1669] = 0x000000034a15524cUL;
   tf->codes[1670] = 0x00000000e73ea403UL;
   tf->codes[1671] = 0x000000038492c5dcUL;
   tf->codes[1672] = 0x0000000865ab5b6dUL;
   tf->codes[1673] = 0x0000000b638c0fbdUL;
   tf->codes[1674] = 0x000000085ce2ca0eUL;
   tf->codes[1675] = 0x0000000e45949e30UL;
   tf->codes[1676] = 0x00000000431f7881UL;
   tf->codes[1677] = 0x00000004f8626706UL;
   tf->codes[1678] = 0x0000000f59c896ceUL;
   tf->codes[1679] = 0x00000008d4e37dd7UL;
   tf->codes[1680] = 0x000000072e5e016bUL;
   tf->codes[1681] = 0x000000019c9570a6UL;
   tf->codes[1682] = 0x0000000eb0e55828UL;
   tf->codes[1683] = 0x0000000f3cb02a1bUL;
   tf->codes[1684] = 0x0000000b609ff814UL;
   tf->codes[1685] = 0x0000000dab87f876UL;
   tf->codes[1686] = 0x000000076d547356UL;
   tf->codes[1687] = 0x0000000b9f95ae4eUL;
   tf->codes[1688] = 0x000000063a65e9e3UL;
   tf->codes[1689] = 0x0000000b6838a991UL;
   tf->codes[1690] = 0x000000012b64eb81UL;
   tf->codes[1691] = 0x0000000c59ced5a6UL;
   tf->codes[1692] = 0x0000000d715aecdbUL;
   tf->codes[1693] = 0x0000000b4291fe13UL;
   tf->codes[1694] = 0x000000006d0d0693UL;
   tf->codes[1695] = 0x0000000f98794c86UL;
   tf->codes[1696] = 0x00000005c816d4d8UL;
   tf->codes[1697] = 0x0000000c947590ffUL;
   tf->codes[1698] = 0x000000080bb44a94UL;
   tf->codes[1699] = 0x0000000f59bd80c8UL;
   tf->codes[1700] = 0x0000000df761d2bcUL;
   tf->codes[1701] = 0x0000000217a8fb51UL;
   tf->codes[1702] = 0x000000093d47240dUL;
   tf->codes[1703] = 0x0000000761920193UL;
   tf->codes[1704] = 0x0000000e4e5eba29UL;
   tf->codes[1705] = 0x0000000eeca76549UL;
   tf->codes[1706] = 0x0000000a1bbfc9c4UL;
   tf->codes[1707] = 0x0000000c711b2477UL;
   tf->codes[1708] = 0x0000000325b5a666UL;
   tf->codes[1709] = 0x0000000ce05f41f2UL;
   tf->codes[1710] = 0x00000003da9c4cffUL;
   tf->codes[1711] = 0x0000000120c47b51UL;
   tf->codes[1712] = 0x0000000cd32263aeUL;
   tf->codes[1713] = 0x0000000e799e7548UL;
   tf->codes[1714] = 0x0000000ae372d335UL;
   tf->codes[1715] = 0x0000000063ddbda3UL;
   tf->codes[1716] = 0x0000000267fac28cUL;
   tf->codes[1717] = 0x000000001fc9d86bUL;
   tf->codes[1718] = 0x000000017641543bUL;
   tf->codes[1719] = 0x0000000c72e347daUL;
   tf->codes[1720] = 0x00000006ffd0717aUL;
   tf->codes[1721] = 0x00000003c30cb70fUL;
   tf->codes[1722] = 0x00000000820ea2bdUL;
   tf->codes[1723] = 0x00000003e9d4bf2bUL;
   tf->codes[1724] = 0x0000000a3c30b85cUL;
   tf->codes[1725] = 0x0000000f9f0118dfUL;
   tf->codes[1726] = 0x0000000e4b9fe4d3UL;
   tf->codes[1727] = 0x000000029c0611aeUL;
   tf->codes[1728] = 0x0000000a8c35fa15UL;
   tf->codes[1729] = 0x00000001b9e934caUL;
   tf->codes[1730] = 0x0000000480cb9d1bUL;
   tf->codes[1731] = 0x0000000bf800f039UL;
   tf->codes[1732] = 0x0000000c84dca5d6UL;
   tf->codes[1733] = 0x00000007bc72f527UL;
   tf->codes[1734] = 0x00000007b9239faeUL;
   tf->codes[1735] = 0x00000007d89ef157UL;
   tf->codes[1736] = 0x00000007ac85a437UL;
   tf->codes[1737] = 0x0000000d16f6d1beUL;
   tf->codes[1738] = 0x0000000edf98b6ffUL;
   tf->codes[1739] = 0x0000000e8686dc27UL;
   tf->codes[1740] = 0x00000004859dce4bUL;
   tf->codes[1741] = 0x0000000041627612UL;
   tf->codes[1742] = 0x0000000fc09cbd90UL;
   tf->codes[1743] = 0x0000000fdae828b9UL;
   tf->codes[1744] = 0x00000008e8ab9aacUL;
   tf->codes[1745] = 0x0000000e3c3a5acbUL;
   tf->codes[1746] = 0x0000000df138b3f6UL;
   tf->codes[1747] = 0x000000068b6499ceUL;
   tf->codes[1748] = 0x0000000bf229a907UL;
   tf->codes[1749] = 0x0000000c5565d691UL;
   tf->codes[1750] = 0x00000008f8119c05UL;
   tf->codes[1751] = 0x000000096751f8e6UL;
   tf->codes[1752] = 0x0000000ac2f319d4UL;
   tf->codes[1753] = 0x0000000dc9a8a43bUL;
   tf->codes[1754] = 0x000000023e877e11UL;
   tf->codes[1755] = 0x00000006bd59226fUL;
   tf->codes[1756] = 0x000000059360ec26UL;
   tf->codes[1757] = 0x0000000e9afc1dd5UL;
   tf->codes[1758] = 0x0000000de69624a6UL;
   tf->codes[1759] = 0x0000000de54a22a7UL;
   tf->codes[1760] = 0x0000000ea27ba143UL;
   tf->codes[1761] = 0x00000008bcdef6a3UL;
   tf->codes[1762] = 0x00000004779f40beUL;
   tf->codes[1763] = 0x000000065a1a6cbcUL;
   tf->codes[1764] = 0x0000000f31b71b67UL;
   tf->codes[1765] = 0x00000001dee9ec9bUL;
   tf->codes[1766] = 0x0000000a8bbd546bUL;
   tf->codes[1767] = 0x00000004d77af897UL;
   tf->codes[1768] = 0x000000053be52417UL;
   tf->codes[1769] = 0x00000009ab39f2e2UL;
   tf->codes[1770] = 0x0000000c7672be23UL;
   tf->codes[1771] = 0x000000085bb59414UL;
   tf->codes[1772] = 0x0000000f77b6f781UL;
   tf->codes[1773] = 0x0000000aecf29f03UL;
   tf->codes[1774] = 0x00000003ea7deeb5UL;
   tf->codes[1775] = 0x000000053154616bUL;
   tf->codes[1776] = 0x0000000f0ad4172eUL;
   tf->codes[1777] = 0x0000000ac97900c4UL;
   tf->codes[1778] = 0x000000024af96431UL;
   tf->codes[1779] = 0x0000000742dcac09UL;
   tf->codes[1780] = 0x0000000b77612a7cUL;
   tf->codes[1781] = 0x000000043f8e0b06UL;
   tf->codes[1782] = 0x0000000b9af4d04cUL;
   tf->codes[1783] = 0x00000005f0c0eeb7UL;
   tf->codes[1784] = 0x0000000beed5d839UL;
   tf->codes[1785] = 0x0000000594bc055fUL;
   tf->codes[1786] = 0x0000000bf3d4ee51UL;
   tf->codes[1787] = 0x000000036dc329e7UL;
   tf->codes[1788] = 0x00000006292a913dUL;
   tf->codes[1789] = 0x0000000853afc28dUL;
   tf->codes[1790] = 0x00000008f669cd4dUL;
   tf->codes[1791] = 0x000000035d67967dUL;
   tf->codes[1792] = 0x0000000a1ba1cda9UL;
   tf->codes[1793] = 0x0000000475e70d85UL;
   tf->codes[1794] = 0x0000000db124355eUL;
   tf->codes[1795] = 0x0000000b7464de4bUL;
   tf->codes[1796] = 0x0000000210a5d6ecUL;
   tf->codes[1797] = 0x00000003f3b26a00UL;
   tf->codes[1798] = 0x00000003b654ab0bUL;
   tf->codes[1799] = 0x00000005461eabb8UL;
   tf->codes[1800] = 0x0000000add3bc40fUL;
   tf->codes[1801] = 0x00000000223eae50UL;
   tf->codes[1802] = 0x0000000d0a8f290dUL;
   tf->codes[1803] = 0x000000070ec2982dUL;
   tf->codes[1804] = 0x00000000e98ba15aUL;
   tf->codes[1805] = 0x00000001bf087c2eUL;
   tf->codes[1806] = 0x00000006e98233f2UL;
   tf->codes[1807] = 0x0000000b06e2c22bUL;
   tf->codes[1808] = 0x000000045483b62dUL;
   tf->codes[1809] = 0x00000002fadab9aeUL;
   tf->codes[1810] = 0x0000000112d8a187UL;
   tf->codes[1811] = 0x0000000c1a9043c6UL;
   tf->codes[1812] = 0x000000007abad130UL;
   tf->codes[1813] = 0x000000092fd1710eUL;
   tf->codes[1814] = 0x0000000f55801505UL;
   tf->codes[1815] = 0x0000000f42daa0b3UL;
   tf->codes[1816] = 0x000000063e7b4d45UL;
   tf->codes[1817] = 0x0000000f976ab37bUL;
   tf->codes[1818] = 0x000000059c9833d0UL;
   tf->codes[1819] = 0x000000098cbdb021UL;
   tf->codes[1820] = 0x0000000da67a27caUL;
   tf->codes[1821] = 0x0000000d0e6edf39UL;
   tf->codes[1822] = 0x0000000d8fdd70b9UL;
   tf->codes[1823] = 0x00000006b86d3b06UL;
   tf->codes[1824] = 0x00000003979ed2b7UL;
   tf->codes[1825] = 0x000000046a8a0a6cUL;
   tf->codes[1826] = 0x0000000fba0b5f5fUL;
   tf->codes[1827] = 0x0000000c34a9713dUL;
   tf->codes[1828] = 0x0000000840e7387cUL;
   tf->codes[1829] = 0x0000000ca04d9f6aUL;
   tf->codes[1830] = 0x000000076073e651UL;
   tf->codes[1831] = 0x0000000e6f2fca96UL;
   tf->codes[1832] = 0x0000000daef51fa4UL;
   tf->codes[1833] = 0x00000007824e6073UL;
   tf->codes[1834] = 0x0000000dbbb9e428UL;
   tf->codes[1835] = 0x000000064bda5a5dUL;
   tf->codes[1836] = 0x0000000d3944a8beUL;
   tf->codes[1837] = 0x0000000895b7c247UL;
   tf->codes[1838] = 0x0000000a8a092b5eUL;
   tf->codes[1839] = 0x00000008454ae0f6UL;
   tf->codes[1840] = 0x00000001a3109cc6UL;
   tf->codes[1841] = 0x0000000411731a19UL;
   tf->codes[1842] = 0x0000000ee3ccd9e5UL;
   tf->codes[1843] = 0x0000000865688814UL;
   tf->codes[1844] = 0x000000084c59bdd7UL;
   tf->codes[1845] = 0x0000000bdf4f34e2UL;
   tf->codes[1846] = 0x0000000192b2633cUL;
   tf->codes[1847] = 0x0000000f7c30ff94UL;
   tf->codes[1848] = 0x0000000bbd0187c5UL;
   tf->codes[1849] = 0x000000036858be42UL;
   tf->codes[1850] = 0x00000007cf38933fUL;
   tf->codes[1851] = 0x0000000b1c48417eUL;
   tf->codes[1852] = 0x000000077b63288cUL;
   tf->codes[1853] = 0x0000000794af1c0eUL;
   tf->codes[1854] = 0x0000000b5afd4a02UL;
   tf->codes[1855] = 0x000000092e67eb6bUL;
   tf->codes[1856] = 0x00000006253569e5UL;
   tf->codes[1857] = 0x00000001405ca65fUL;
   tf->codes[1858] = 0x00000004ca61bba3UL;
   tf->codes[1859] = 0x000000006fe876e9UL;
   tf->codes[1860] = 0x0000000c25b98680UL;
   tf->codes[1861] = 0x00000000bd52f241UL;
   tf->codes[1862] = 0x0000000de92bdbc6UL;
   tf->codes[1863] = 0x00000007114244f7UL;
   tf->codes[1864] = 0x0000000c92109927UL;
   tf->codes[1865] = 0x000000011246d25fUL;
   tf->codes[1866] = 0x0000000878963531UL;
   tf->codes[1867] = 0x0000000b8f639289UL;
   tf->codes[1868] = 0x0000000edd1ee2dcUL;
   tf->codes[1869] = 0x00000002dd27bd83UL;
   tf->codes[1870] = 0x00000005b77fb633UL;
   tf->codes[1871] = 0x000000092d244feaUL;
   tf->codes[1872] = 0x0000000ff29f378bUL;
   tf->codes[1873] = 0x0000000cd74b01dfUL;
   tf->codes[1874] = 0x0000000caee75d99UL;
   tf->codes[1875] = 0x000000032a7950e7UL;
   tf->codes[1876] = 0x00000008ab7143d0UL;
   tf->codes[1877] = 0x00000004a396d396UL;
   tf->codes[1878] = 0x000000027cc982aaUL;
   tf->codes[1879] = 0x0000000748ffbcacUL;
   tf->codes[1880] = 0x00000007dc1212dbUL;
   tf->codes[1881] = 0x000000060491f30fUL;
   tf->codes[1882] = 0x00000006462a44c5UL;
   tf->codes[1883] = 0x0000000f693b3934UL;
   tf->codes[1884] = 0x00000002c85c32c8UL;
   tf->codes[1885] = 0x000000058842e73aUL;
   tf->codes[1886] = 0x000000039c5c936aUL;
   tf->codes[1887] = 0x000000059da18b06UL;
   tf->codes[1888] = 0x0000000b0c4be569UL;
   tf->codes[1889] = 0x0000000b38429749UL;
   tf->codes[1890] = 0x000000014d177c42UL;
   tf->codes[1891] = 0x0000000b2890755cUL;
   tf->codes[1892] = 0x0000000c316f3c01UL;
   tf->codes[1893] = 0x000000097a978118UL;
   tf->codes[1894] = 0x00000006e3af9c97UL;
   tf->codes[1895] = 0x0000000b16bfcf5bUL;
   tf->codes[1896] = 0x0000000fbdedeaa1UL;
   tf->codes[1897] = 0x000000062d2efff3UL;
   tf->codes[1898] = 0x0000000221e13b03UL;
   tf->codes[1899] = 0x00000006f189a8f4UL;
   tf->codes[1900] = 0x0000000ba3c855cfUL;
   tf->codes[1901] = 0x00000004d9b593f1UL;
   tf->codes[1902] = 0x000000070bdb83c4UL;
   tf->codes[1903] = 0x00000007be402a75UL;
   tf->codes[1904] = 0x0000000acbb1dcf6UL;
   tf->codes[1905] = 0x00000006d76dd708UL;
   tf->codes[1906] = 0x00000004210a8723UL;
   tf->codes[1907] = 0x0000000e4a9e3182UL;
   tf->codes[1908] = 0x00000000b86ea177UL;
   tf->codes[1909] = 0x0000000589c7c8dfUL;
   tf->codes[1910] = 0x0000000728f649ccUL;
   tf->codes[1911] = 0x0000000235daf936UL;
   tf->codes[1912] = 0x0000000ed5b13b07UL;
   tf->codes[1913] = 0x00000009838cc62bUL;
   tf->codes[1914] = 0x0000000699ea0fb3UL;
   tf->codes[1915] = 0x0000000533af329dUL;
   tf->codes[1916] = 0x00000000486ec47dUL;
   tf->codes[1917] = 0x0000000ea7e7874dUL;
   tf->codes[1918] = 0x0000000ae99ea9c5UL;
   tf->codes[1919] = 0x000000037e02d2d5UL;
   tf->codes[1920] = 0x0000000b92cf5ea1UL;
   tf->codes[1921] = 0x0000000e8c6fa527UL;
   tf->codes[1922] = 0x000000093ac59f00UL;
   tf->codes[1923] = 0x0000000a5876d0fbUL;
   tf->codes[1924] = 0x000000042664d4abUL;
   tf->codes[1925] = 0x0000000672c67c2fUL;
   tf->codes[1926] = 0x0000000a499d1a9bUL;
   tf->codes[1927] = 0x00000001c55c99a8UL;
   tf->codes[1928] = 0x00000005d5644f76UL;
   tf->codes[1929] = 0x0000000149b6cd96UL;
   tf->codes[1930] = 0x00000005d19a752aUL;
   tf->codes[1931] = 0x0000000fa5fce591UL;
   tf->codes[1932] = 0x00000005380ec50cUL;
   tf->codes[1933] = 0x0000000dea0d752dUL;
   tf->codes[1934] = 0x00000001faf5309bUL;
   tf->codes[1935] = 0x0000000e3b7a775eUL;
   tf->codes[1936] = 0x0000000173d59edbUL;
   tf->codes[1937] = 0x0000000b8e38cca5UL;
   tf->codes[1938] = 0x00000001e43cad4eUL;
   tf->codes[1939] = 0x000000027dedf623UL;
   tf->codes[1940] = 0x0000000da72d480fUL;
   tf->codes[1941] = 0x000000099434d76fUL;
   tf->codes[1942] = 0x00000008e06320e5UL;
   tf->codes[1943] = 0x000000012cc5d9b3UL;
   tf->codes[1944] = 0x0000000d4ec00d0aUL;
   tf->codes[1945] = 0x00000008fa256ec8UL;
   tf->codes[1946] = 0x00000002a7755b41UL;
   tf->codes[1947] = 0x0000000649598f17UL;
   tf->codes[1948] = 0x0000000048a9ea61UL;
   tf->codes[1949] = 0x0000000b749bbe4dUL;
   tf->codes[1950] = 0x000000059e4c9da2UL;
   tf->codes[1951] = 0x000000050395f36cUL;
   tf->codes[1952] = 0x00000006b07149d2UL;
   tf->codes[1953] = 0x00000004f9406d7fUL;
   tf->codes[1954] = 0x000000092febe987UL;
   tf->codes[1955] = 0x0000000d7bf93ed2UL;
   tf->codes[1956] = 0x00000001e66cc0f3UL;
   tf->codes[1957] = 0x00000006c48e37c0UL;
   tf->codes[1958] = 0x00000003ad8159d5UL;
   tf->codes[1959] = 0x000000048f41fbc8UL;
   tf->codes[1960] = 0x0000000cd5f40d31UL;
   tf->codes[1961] = 0x00000004d9d50e50UL;
   tf->codes[1962] = 0x0000000377552d44UL;
   tf->codes[1963] = 0x0000000d6400b5bfUL;
   tf->codes[1964] = 0x0000000205260a56UL;
   tf->codes[1965] = 0x0000000c319eaf12UL;
   tf->codes[1966] = 0x0000000bb3016818UL;
   tf->codes[1967] = 0x0000000194c9caa5UL;
   tf->codes[1968] = 0x00000003205df053UL;
   tf->codes[1969] = 0x00000008dbf64dc8UL;
   tf->codes[1970] = 0x00000005cc34b609UL;
   tf->codes[1971] = 0x00000007d2367f18UL;
   tf->codes[1972] = 0x000000020d6cee2eUL;
   tf->codes[1973] = 0x0000000c9f86c18eUL;
   tf->codes[1974] = 0x0000000e2b1f4620UL;
   tf->codes[1975] = 0x000000009c52f03eUL;
   tf->codes[1976] = 0x000000007d8b9b31UL;
   tf->codes[1977] = 0x00000002b85f049fUL;
   tf->codes[1978] = 0x0000000e0b542614UL;
   tf->codes[1979] = 0x0000000d0f06b745UL;
   tf->codes[1980] = 0x0000000df7b0f962UL;
   tf->codes[1981] = 0x0000000d7b41890fUL;
   tf->codes[1982] = 0x000000024baf7927UL;
   tf->codes[1983] = 0x0000000cc63c5347UL;
   tf->codes[1984] = 0x0000000c9dbe3e8eUL;
   tf->codes[1985] = 0x000000052b1c7225UL;
   tf->codes[1986] = 0x000000073f558c8dUL;
   tf->codes[1987] = 0x0000000542702b85UL;
   tf->codes[1988] = 0x0000000578f18fddUL;
   tf->codes[1989] = 0x0000000a76cf36efUL;
   tf->codes[1990] = 0x0000000a3cb92407UL;
   tf->codes[1991] = 0x0000000b7ad6cd05UL;
   tf->codes[1992] = 0x00000006d0f34533UL;
   tf->codes[1993] = 0x0000000416083d1bUL;
   tf->codes[1994] = 0x00000002bdb7fab0UL;
   tf->codes[1995] = 0x000000029619e1d2UL;
   tf->codes[1996] = 0x0000000fe824f4c1UL;
   tf->codes[1997] = 0x00000007a5ff22b9UL;
   tf->codes[1998] = 0x00000005be7f7ce2UL;
   tf->codes[1999] = 0x00000004140ddebeUL;
   tf->codes[2000] = 0x0000000ec104f338UL;
   tf->codes[2001] = 0x00000003c6ea6417UL;
   tf->codes[2002] = 0x00000004c68c4841UL;
   tf->codes[2003] = 0x0000000738550624UL;
   tf->codes[2004] = 0x000000095d52ffbeUL;
   tf->codes[2005] = 0x00000001211a3407UL;
   tf->codes[2006] = 0x000000085c2667c7UL;
   tf->codes[2007] = 0x0000000d3fcfc70aUL;
   tf->codes[2008] = 0x000000062c79fa03UL;
   tf->codes[2009] = 0x0000000e5a01d1deUL;
   tf->codes[2010] = 0x000000021a6f78c0UL;
   tf->codes[2011] = 0x000000067a9d08d0UL;
   tf->codes[2012] = 0x00000003521d86a9UL;
   tf->codes[2013] = 0x0000000821858962UL;
   tf->codes[2014] = 0x00000000238c9ab4UL;
   tf->codes[2015] = 0x0000000d377e444eUL;
   tf->codes[2016] = 0x00000009b4db4370UL;
   tf->codes[2017] = 0x0000000326d40d28UL;
   tf->codes[2018] = 0x0000000cca399d64UL;
   tf->codes[2019] = 0x000000029e717061UL;
   tf->codes[2020] = 0x000000081c257536UL;
   tf->codes[2021] = 0x0000000b5398ff6fUL;
   tf->codes[2022] = 0x00000006246d505dUL;
   tf->codes[2023] = 0x000000052de44206UL;
   tf->codes[2024] = 0x0000000d4bfe70a7UL;
   tf->codes[2025] = 0x00000001256f3bbfUL;
   tf->codes[2026] = 0x0000000e18dca845UL;
   tf->codes[2027] = 0x0000000cadc6270eUL;
   tf->codes[2028] = 0x0000000ceecebcf9UL;
   tf->codes[2029] = 0x000000030490b131UL;
   tf->codes[2030] = 0x00000003499eae73UL;
   tf->codes[2031] = 0x0000000e407687b5UL;
   tf->codes[2032] = 0x00000000d16a1b5cUL;
   tf->codes[2033] = 0x00000000aed4fc7cUL;
   tf->codes[2034] = 0x0000000977235aceUL;
   tf->codes[2035] = 0x0000000e45bc089cUL;
   tf->codes[2036] = 0x0000000d1c7e8b0fUL;
   tf->codes[2037] = 0x0000000c801f2a62UL;
   tf->codes[2038] = 0x00000009bb982febUL;
   tf->codes[2039] = 0x0000000c2ade21d5UL;
   tf->codes[2040] = 0x0000000e664c4cdcUL;
   tf->codes[2041] = 0x0000000b5b1b7d8dUL;
   tf->codes[2042] = 0x000000057e319e42UL;
   tf->codes[2043] = 0x0000000a62708260UL;
   tf->codes[2044] = 0x00000004d49e8e90UL;
   tf->codes[2045] = 0x00000000cb5f349aUL;
   tf->codes[2046] = 0x000000097f8c8487UL;
   tf->codes[2047] = 0x0000000bf26ecbd1UL;
   tf->codes[2048] = 0x00000006a22fc93fUL;
   tf->codes[2049] = 0x0000000f40123ad5UL;
   tf->codes[2050] = 0x0000000f2864b84fUL;
   tf->codes[2051] = 0x000000052b894393UL;
   tf->codes[2052] = 0x0000000aeac3e443UL;
   tf->codes[2053] = 0x000000064a6e37e9UL;
   tf->codes[2054] = 0x00000005ff905511UL;
   tf->codes[2055] = 0x00000000f9368ae9UL;
   tf->codes[2056] = 0x0000000304c961d1UL;
   tf->codes[2057] = 0x0000000901e3d5efUL;
   tf->codes[2058] = 0x00000003d9c9e1eaUL;
   tf->codes[2059] = 0x000000014af08310UL;
   tf->codes[2060] = 0x0000000f7d5f48faUL;
   tf->codes[2061] = 0x00000004cc90c712UL;
   tf->codes[2062] = 0x000000093eb3c4f2UL;
   tf->codes[2063] = 0x0000000c64af2ee0UL;
   tf->codes[2064] = 0x0000000ee9b0b880UL;
   tf->codes[2065] = 0x000000059e9f00c4UL;
   tf->codes[2066] = 0x0000000f0e385a56UL;
   tf->codes[2067] = 0x0000000013e3176aUL;
   tf->codes[2068] = 0x000000022cefe2bfUL;
   tf->codes[2069] = 0x0000000e8d646da2UL;
   tf->codes[2070] = 0x0000000fa07e9914UL;
   tf->codes[2071] = 0x000000064a342dc3UL;
   tf->codes[2072] = 0x0000000029436fdeUL;
   tf->codes[2073] = 0x00000003f436a788UL;
   tf->codes[2074] = 0x0000000ebce59d33UL;
   tf->codes[2075] = 0x0000000d1cc417e5UL;
   tf->codes[2076] = 0x0000000bdabb3afcUL;
   tf->codes[2077] = 0x00000002b075aa91UL;
   tf->codes[2078] = 0x0000000cf479bc86UL;
   tf->codes[2079] = 0x00000001bc69c922UL;
   tf->codes[2080] = 0x0000000f70bed102UL;
   tf->codes[2081] = 0x000000073fba7412UL;
   tf->codes[2082] = 0x0000000dad289c99UL;
   tf->codes[2083] = 0x000000025fa19a7eUL;
   tf->codes[2084] = 0x0000000a5a248105UL;
   tf->codes[2085] = 0x000000059c85904fUL;
   tf->codes[2086] = 0x0000000587368f7aUL;
   tf->codes[2087] = 0x00000006ddf6cd9bUL;
   tf->codes[2088] = 0x0000000276aaeac2UL;
   tf->codes[2089] = 0x000000039793390eUL;
   tf->codes[2090] = 0x0000000ee79121bdUL;
   tf->codes[2091] = 0x000000043b22f813UL;
   tf->codes[2092] = 0x0000000137d42357UL;
   tf->codes[2093] = 0x000000067857c8bdUL;
   tf->codes[2094] = 0x000000046cf4e741UL;
   tf->codes[2095] = 0x00000001d18cd171UL;
   tf->codes[2096] = 0x0000000a9806c31fUL;
   tf->codes[2097] = 0x000000006605176cUL;
   tf->codes[2098] = 0x00000000f592c1acUL;
   tf->codes[2099] = 0x00000007265a10a4UL;
   tf->codes[2100] = 0x0000000e89d3f153UL;
   tf->codes[2101] = 0x0000000b2c1d25d5UL;
   tf->codes[2102] = 0x0000000fc221a68cUL;
   tf->codes[2103] = 0x000000021bc5cb0fUL;
   tf->codes[2104] = 0x00000007d8865a48UL;
   tf->codes[2105] = 0x000000014fb6a9c1UL;
   tf->codes[2106] = 0x0000000826702ff5UL;
   tf->codes[2107] = 0x0000000c875eecddUL;
   tf->codes[2108] = 0x0000000334906e55UL;
   tf->codes[2109] = 0x0000000e75f38920UL;
   tf->codes[2110] = 0x0000000e68cc8585UL;
   tf->codes[2111] = 0x0000000e21989dadUL;
   tf->codes[2112] = 0x0000000991c0a54fUL;
   tf->codes[2113] = 0x0000000afc2e4db2UL;
   tf->codes[2114] = 0x000000049215ae09UL;
   tf->codes[2115] = 0x00000004414dd21cUL;
   tf->codes[2116] = 0x0000000270102c2bUL;
   tf->codes[2117] = 0x0000000d74d46724UL;
   tf->codes[2118] = 0x0000000d8ba0e6cfUL;
   tf->codes[2119] = 0x00000004924c591cUL;
   tf->codes[2120] = 0x000000014a218727UL;
   tf->codes[2121] = 0x0000000ec649a317UL;
   tf->codes[2122] = 0x000000040506e864UL;
   tf->codes[2123] = 0x00000004a5fce324UL;
   tf->codes[2124] = 0x0000000432da3920UL;
   tf->codes[2125] = 0x0000000be6c87867UL;
   tf->codes[2126] = 0x000000096d47ab50UL;
   tf->codes[2127] = 0x000000013b26554aUL;
   tf->codes[2128] = 0x000000042d294c1aUL;
   tf->codes[2129] = 0x000000043a8f4537UL;
   tf->codes[2130] = 0x0000000ec9981703UL;
   tf->codes[2131] = 0x00000009d23e9feaUL;
   tf->codes[2132] = 0x0000000a5e63c741UL;
   tf->codes[2133] = 0x0000000b590555a7UL;
   tf->codes[2134] = 0x0000000af5cc76d0UL;
   tf->codes[2135] = 0x000000036f6807beUL;
   tf->codes[2136] = 0x0000000d9e7509baUL;
   tf->codes[2137] = 0x000000008e7485e6UL;
   tf->codes[2138] = 0x0000000ca410c173UL;
   tf->codes[2139] = 0x000000034c0efac9UL;
   tf->codes[2140] = 0x0000000aa8dd95f8UL;
   tf->codes[2141] = 0x000000092ff8e340UL;
   tf->codes[2142] = 0x00000002fcf617e5UL;
   tf->codes[2143] = 0x0000000f4ee3deeaUL;
   tf->codes[2144] = 0x0000000ec3675f06UL;
   tf->codes[2145] = 0x000000011d3034ccUL;
   tf->codes[2146] = 0x000000053d80da67UL;
   tf->codes[2147] = 0x00000002ffd3e2edUL;
   tf->codes[2148] = 0x0000000701c5dbcaUL;
   tf->codes[2149] = 0x0000000fd41bd301UL;
   tf->codes[2150] = 0x0000000176d0d999UL;
   tf->codes[2151] = 0x000000084a7a607aUL;
   tf->codes[2152] = 0x00000003a4cd4f6eUL;
   tf->codes[2153] = 0x000000029fd854f3UL;
   tf->codes[2154] = 0x0000000239143be4UL;
   tf->codes[2155] = 0x0000000c1d83b7ceUL;
   tf->codes[2156] = 0x00000003998e35f9UL;
   tf->codes[2157] = 0x0000000c9cade2feUL;
   tf->codes[2158] = 0x000000067a7ce5f8UL;
   tf->codes[2159] = 0x000000058096eb5eUL;
   tf->codes[2160] = 0x0000000129003b1aUL;
   tf->codes[2161] = 0x000000058cd60dd3UL;
   tf->codes[2162] = 0x00000007ec9c978cUL;
   tf->codes[2163] = 0x00000008209b7fc6UL;
   tf->codes[2164] = 0x0000000b1a07b065UL;
   tf->codes[2165] = 0x00000002f8c5d980UL;
   tf->codes[2166] = 0x0000000ec68f5262UL;
   tf->codes[2167] = 0x00000009f6738ae8UL;
   tf->codes[2168] = 0x0000000e240da32dUL;
   tf->codes[2169] = 0x000000029a692dd3UL;
   tf->codes[2170] = 0x000000093a2fc212UL;
   tf->codes[2171] = 0x000000090a7ad415UL;
   tf->codes[2172] = 0x000000038462d719UL;
   tf->codes[2173] = 0x000000088d09ed64UL;
   tf->codes[2174] = 0x0000000629414143UL;
   tf->codes[2175] = 0x0000000f37f54627UL;
   tf->codes[2176] = 0x0000000f654223daUL;
   tf->codes[2177] = 0x00000009866d0462UL;
   tf->codes[2178] = 0x000000039b7e344bUL;
   tf->codes[2179] = 0x0000000e29b0d31eUL;
   tf->codes[2180] = 0x00000004d26f996bUL;
   tf->codes[2181] = 0x0000000ca999e2d4UL;
   tf->codes[2182] = 0x000000048244cecaUL;
   tf->codes[2183] = 0x0000000db430a091UL;
   tf->codes[2184] = 0x0000000b20a09f71UL;
   tf->codes[2185] = 0x000000089d7a977dUL;
   tf->codes[2186] = 0x0000000d0c7d781fUL;
   tf->codes[2187] = 0x000000045dbd608bUL;
   tf->codes[2188] = 0x00000005f0eaf573UL;
   tf->codes[2189] = 0x00000004b72a881eUL;
   tf->codes[2190] = 0x00000006721d71acUL;
   tf->codes[2191] = 0x0000000aea5b5257UL;
   tf->codes[2192] = 0x0000000729da786eUL;
   tf->codes[2193] = 0x0000000b7bbb055eUL;
   tf->codes[2194] = 0x000000033c26e035UL;
   tf->codes[2195] = 0x0000000bbb1faaf3UL;
   tf->codes[2196] = 0x0000000a7acc30bcUL;
   tf->codes[2197] = 0x00000001ce0841a4UL;
   tf->codes[2198] = 0x0000000244d1d408UL;
   tf->codes[2199] = 0x0000000cde684816UL;
   tf->codes[2200] = 0x00000000f8fb4cdaUL;
   tf->codes[2201] = 0x0000000706c97e43UL;
   tf->codes[2202] = 0x0000000c971d3afbUL;
   tf->codes[2203] = 0x0000000fda0d9c09UL;
   tf->codes[2204] = 0x0000000016b86da3UL;
   tf->codes[2205] = 0x0000000fad3fd2e5UL;
   tf->codes[2206] = 0x0000000bac1633c9UL;
   tf->codes[2207] = 0x00000002309feea7UL;
   tf->codes[2208] = 0x00000000033737bbUL;
   tf->codes[2209] = 0x00000009aed89097UL;
   tf->codes[2210] = 0x000000068538abb5UL;
   tf->codes[2211] = 0x0000000828f7850dUL;
   tf->codes[2212] = 0x000000072432d95dUL;
   tf->codes[2213] = 0x0000000261a8e5a9UL;
   tf->codes[2214] = 0x0000000a200eb1b2UL;
   tf->codes[2215] = 0x0000000c3de7f043UL;
   tf->codes[2216] = 0x0000000bf74c5970UL;
   tf->codes[2217] = 0x00000006dd1481b8UL;
   tf->codes[2218] = 0x0000000aa94bbef6UL;
   tf->codes[2219] = 0x0000000da7e65697UL;
   tf->codes[2220] = 0x0000000bc3ab5693UL;
   tf->codes[2221] = 0x0000000fac70dbecUL;
   tf->codes[2222] = 0x000000011c7b546dUL;
   tf->codes[2223] = 0x0000000f2f1877aeUL;
   tf->codes[2224] = 0x0000000ddfd559cbUL;
   tf->codes[2225] = 0x0000000213843237UL;
   tf->codes[2226] = 0x0000000d35629a71UL;
   tf->codes[2227] = 0x000000066b966ff8UL;
   tf->codes[2228] = 0x0000000f7c3d2b42UL;
   tf->codes[2229] = 0x0000000d2a9bf013UL;
   tf->codes[2230] = 0x000000082aade491UL;
   tf->codes[2231] = 0x000000080a74d66aUL;
   tf->codes[2232] = 0x0000000c23180cd5UL;
   tf->codes[2233] = 0x000000013bc699afUL;
   tf->codes[2234] = 0x0000000568f373afUL;
   tf->codes[2235] = 0x00000004e8f6cb22UL;
   tf->codes[2236] = 0x00000000236593daUL;
   tf->codes[2237] = 0x0000000c06d419daUL;
   tf->codes[2238] = 0x0000000fb63c9338UL;
   tf->codes[2239] = 0x0000000c58ea0e62UL;
   tf->codes[2240] = 0x00000003f129af28UL;
   tf->codes[2241] = 0x00000001bc5d8e7cUL;
   tf->codes[2242] = 0x00000005a0cce5a2UL;
   tf->codes[2243] = 0x000000012138fcc9UL;
   tf->codes[2244] = 0x00000006475b47b3UL;
   tf->codes[2245] = 0x000000036127061cUL;
   tf->codes[2246] = 0x0000000a66ea1c90UL;
   tf->codes[2247] = 0x0000000c7622d06fUL;
   tf->codes[2248] = 0x00000007b06f9883UL;
   tf->codes[2249] = 0x000000017f9dd0f5UL;
   tf->codes[2250] = 0x00000004f7d20a59UL;
   tf->codes[2251] = 0x000000080ca1778dUL;
   tf->codes[2252] = 0x000000034bf99f09UL;
   tf->codes[2253] = 0x0000000b1f6b20ffUL;
   tf->codes[2254] = 0x0000000ddc248171UL;
   tf->codes[2255] = 0x000000079adedf2dUL;
   tf->codes[2256] = 0x0000000e7b8ec414UL;
   tf->codes[2257] = 0x00000001660b1a2aUL;
   tf->codes[2258] = 0x0000000596131143UL;
   tf->codes[2259] = 0x0000000ed5876f22UL;
   tf->codes[2260] = 0x0000000ccf196212UL;
   tf->codes[2261] = 0x00000005a7da3ed3UL;
   tf->codes[2262] = 0x00000005d7c1c564UL;
   tf->codes[2263] = 0x0000000ebf3b80d4UL;
   tf->codes[2264] = 0x00000000fbb5da08UL;
   tf->codes[2265] = 0x0000000751b26b7fUL;
   tf->codes[2266] = 0x0000000f646e15e0UL;
   tf->codes[2267] = 0x000000048cf268f5UL;
   tf->codes[2268] = 0x0000000681ff913eUL;
   tf->codes[2269] = 0x00000008a60709eeUL;
   tf->codes[2270] = 0x0000000ee8aa3c19UL;
   tf->codes[2271] = 0x0000000d74c7190bUL;
   tf->codes[2272] = 0x0000000403a516f6UL;
   tf->codes[2273] = 0x000000043859f5e7UL;
   tf->codes[2274] = 0x0000000674b05601UL;
   tf->codes[2275] = 0x000000029dc78f7bUL;
   tf->codes[2276] = 0x0000000f871a0d9cUL;
   tf->codes[2277] = 0x0000000149cd7e80UL;
   tf->codes[2278] = 0x0000000e0ebb3dadUL;
   tf->codes[2279] = 0x0000000cfd60dc21UL;
   tf->codes[2280] = 0x0000000fcac192f3UL;
   tf->codes[2281] = 0x0000000da0bb9f49UL;
   tf->codes[2282] = 0x0000000377891815UL;
   tf->codes[2283] = 0x00000008cf831888UL;
   tf->codes[2284] = 0x0000000d8ad9cff2UL;
   tf->codes[2285] = 0x000000066ef37c63UL;
   tf->codes[2286] = 0x0000000289532c5dUL;
   tf->codes[2287] = 0x000000045d8a5400UL;
   tf->codes[2288] = 0x0000000452111b4dUL;
   tf->codes[2289] = 0x0000000be9b62af0UL;
   tf->codes[2290] = 0x00000004a7fa60afUL;
   tf->codes[2291] = 0x0000000f38ab400eUL;
   tf->codes[2292] = 0x0000000329b05789UL;
   tf->codes[2293] = 0x00000005edba3023UL;
   tf->codes[2294] = 0x00000005f48632e5UL;
   tf->codes[2295] = 0x0000000c44562244UL;
   tf->codes[2296] = 0x0000000781f865e7UL;
   tf->codes[2297] = 0x00000004868de42dUL;
   tf->codes[2298] = 0x0000000b7d2aafddUL;
   tf->codes[2299] = 0x00000000652863c6UL;
   tf->codes[2300] = 0x00000009c8c0a919UL;
   tf->codes[2301] = 0x0000000a566fd21eUL;
   tf->codes[2302] = 0x0000000d42a60c7aUL;
   tf->codes[2303] = 0x00000003b2fa8afeUL;
   tf->codes[2304] = 0x00000004feead808UL;
   tf->codes[2305] = 0x00000004e08205a5UL;
   tf->codes[2306] = 0x00000002ca3d8a2fUL;
   tf->codes[2307] = 0x0000000983fc5a57UL;
   tf->codes[2308] = 0x0000000c23db45c9UL;
   tf->codes[2309] = 0x0000000a37e0ba04UL;
   tf->codes[2310] = 0x00000005f510ba05UL;
   tf->codes[2311] = 0x00000001601a2ff1UL;
   tf->codes[2312] = 0x000000030cccbfe0UL;
   tf->codes[2313] = 0x00000003880f5176UL;
   tf->codes[2314] = 0x00000000ea5aee4fUL;
   tf->codes[2315] = 0x0000000b1b166fdbUL;
   tf->codes[2316] = 0x00000007b3ca3761UL;
   tf->codes[2317] = 0x000000064fae3ebfUL;
   tf->codes[2318] = 0x0000000447b9e7acUL;
   tf->codes[2319] = 0x0000000d9f564f30UL;
   tf->nbits = 36;
   tf->bit_x = (uint32_t *)calloc(36, sizeof(uint32_t));
   tf->bit_y = (uint32_t *)calloc(36, sizeof(uint32_t));
   tf->bit_x[0] = 1;
   tf->bit_y[0] = 1;
   tf->bit_x[1] = 2;
   tf->bit_y[1] = 1;
   tf->bit_x[2] = 3;
   tf->bit_y[2] = 1;
   tf->bit_x[3] = 4;
   tf->bit_y[3] = 1;
   tf->bit_x[4] = 5;
   tf->bit_y[4] = 1;
   tf->bit_x[5] = 2;
   tf->bit_y[5] = 2;
   tf->bit_x[6] = 3;
   tf->bit_y[6] = 2;
   tf->bit_x[7] = 4;
   tf->bit_y[7] = 2;
   tf->bit_x[8] = 3;
   tf->bit_y[8] = 3;
   tf->bit_x[9] = 6;
   tf->bit_y[9] = 1;
   tf->bit_x[10] = 6;
   tf->bit_y[10] = 2;
   tf->bit_x[11] = 6;
   tf->bit_y[11] = 3;
   tf->bit_x[12] = 6;
   tf->bit_y[12] = 4;
   tf->bit_x[13] = 6;
   tf->bit_y[13] = 5;
   tf->bit_x[14] = 5;
   tf->bit_y[14] = 2;
   tf->bit_x[15] = 5;
   tf->bit_y[15] = 3;
   tf->bit_x[16] = 5;
   tf->bit_y[16] = 4;
   tf->bit_x[17] = 4;
   tf->bit_y[17] = 3;
   tf->bit_x[18] = 6;
   tf->bit_y[18] = 6;
   tf->bit_x[19] = 5;
   tf->bit_y[19] = 6;
   tf->bit_x[20] = 4;
   tf->bit_y[20] = 6;
   tf->bit_x[21] = 3;
   tf->bit_y[21] = 6;
   tf->bit_x[22] = 2;
   tf->bit_y[22] = 6;
   tf->bit_x[23] = 5;
   tf->bit_y[23] = 5;
   tf->bit_x[24] = 4;
   tf->bit_y[24] = 5;
   tf->bit_x[25] = 3;
   tf->bit_y[25] = 5;
   tf->bit_x[26] = 4;
   tf->bit_y[26] = 4;
   tf->bit_x[27] = 1;
   tf->bit_y[27] = 6;
   tf->bit_x[28] = 1;
   tf->bit_y[28] = 5;
   tf->bit_x[29] = 1;
   tf->bit_y[29] = 4;
   tf->bit_x[30] = 1;
   tf->bit_y[30] = 3;
   tf->bit_x[31] = 1;
   tf->bit_y[31] = 2;
   tf->bit_x[32] = 2;
   tf->bit_y[32] = 5;
   tf->bit_x[33] = 2;
   tf->bit_y[33] = 4;
   tf->bit_x[34] = 2;
   tf->bit_y[34] = 3;
   tf->bit_x[35] = 3;
   tf->bit_y[35] = 4;
   tf->width_at_border = 8;
   tf->total_width = 10;
   tf->reversed_border = false;
   return tf;
}

void tag36h10_destroy(apriltag_family_t *tf)
{
   free(tf->codes);
   free(tf->bit_x);
   free(tf->bit_y);
   free(tf->name);
   free(tf);
}
