#!/usr/bin/python

##
## Copyright (C) 2011-2012 Andrew Atkinson
##
##-------------------------------------------------------------------
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.
##-------------------------------------------------------------------

import sys
import os


class ProgramInfo:
    def __init__(self):
        self.version = '1.2.4working'
        self.manversion = '1.2.1'
        self.name = 'TopParser'
        self.copyright = '(C) 2011 - 2013 Andrew Atkinson'
        self.developer = 'Andrew Atkinson'
        self.docwriter = 'Graham Mullan'
        self.website = 'https://bitbucket.org/AndrewA/topparser'
        self.icon = 'Images/topparser.ico'

        if not os.path.exists(self.icon):
            self.icon = os.path.join(os.path.dirname(__file__), self.icon)

        self.description = """TopParser converts PocketTopo top files to
different survey programs (currenly Therion and Survex)
"""

        self.licence = """
    TopParser is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>."""


class Defaults:
    def __init__(self):
        #File Locations (FStructure)
        self.copytop = True
        self.pockettopo = "~"
        self.projectroot = "."
        self.surveydir = "."
        self.addnamedir = True
        self.rawdir = "PocketTopo"
        self.insurveydir = True
        self.overwrite = False
        self.process = True
        self.open3d = True
        self.dsuffix = "th"
        self.viewer = 'aven'
        self.openfiles = True
        self.th2edit = 'xplan'
        self.add2rep = False
        self.repository = 'hg'

        #thfile
        self.dothfile = True
        self.dosvxfile = False
        self.addlrud = False
        self.lrudangle = "30"
        self.dataorder = ['from', 'to', 'tape', 'compass', 'clino']
        self.addroll = False
        self.importth2plan = True
        self.importth2elev = True
        self.importth2proj = False
        self.docopyright = True
        self.cright = "GNU GPL"
        self.docavers = True
        self.caverlist = [{'Name': "Andrew Atkinson",
                            "Notes": True, "Instruments": False,
                             "Dog": False, "Explorer": False},
                             {'Name': "Alison Moody",
                                 "Notes": False, "Instruments": True,
                             "Dog": False, "Explorer": False}]
        self.instrument = "UBSS DistoX1"
        self.doexplo = False
        self.samedate = True
        self.explodate = '2000.01.01'
        self.addplanmap = True
        self.pmapsuffix = 'M'
        self.emapsuffix = 'ME'
        self.addelevmap = True
        self.pscraps = 1
        self.escraps = 1
        self.addprojmap = False
        self.pemapsuffix = 'E###'
        self.pescraps = 1
#        self.pemapsuffixangle = True

        #th2 plan
        self.doplan = True
        self.plansuffix = ""
        self.ins_pscraps = True
        #pscraps in thfile as well
        self.pscrapsuffix = "SP"
        self.ins_pxscraps = True
        self.planxsuffix = "SPX"
        self.planscale = 100
        self.planDPI = 200
        self.plangrid = 1

        #th2 Extended elevation
        self.doelevation = True
        self.elevsuffix = "Ee"
        self.ins_escraps = True
        #escraps in thfile as well
        self.escrapsuffix = "SE"
        self.ins_exscraps = True
        self.exscraps = True
        self.elevpxsuffix = "SEXP"
        self.elevvxsuffix = "SEXE"
        self.elevscale = 100
        self.elevDPI = 200
        self.elevgrid = 1

        #th2 Projected Elevation
        self.doprojection = False
        self.projangle = 0
        self.projsuffix = "E###"
#        self.anglesuffixfile = True
        self.ins_pescraps = True
        self.pescrapsuffix = "SE###_"
#        self.anglesuffixscrap = True
        self.projscale = 100
        self.projDPI = 200
        self.projgrid = 1

        #config
        self.dothconfig = True
        self.configname = "thconfig"
        self.layout = "common_layout.th"
        self.thconfigtext = """source ##NAME##.th
# Change name to the main therion file


#Surveys to output
#-----------------

#export map -proj plan -layout local -o ##NAME##.pdf
#Produces plan of cave, on a single sheet

#export map -proj extended -layout local -o ##NAME##Ee.pdf

export model -fmt survex -o ##NAME##th.3d
#Survex file showing centre line only

#export model -o ##NAME##.lox
#3d therion model to be viewed in the therion viewer

#export map -proj plan -o ##NAME##_Walls.3d
#Survex file showing walls only

layout local
debug off
map-header 0 0 ne
#symbol-hide group cave-centreline
endlayout
"""
        var = variables()

        #OS variables
        os_suffix = '_win' if sys.platform.startswith('win') else '_linux'
        self.xtherion = var['xtherion' + os_suffix]
        self.therion = var['therion' + os_suffix]
        self.loch = var['loch' + os_suffix]
        self.aven = var['aven' + os_suffix]
        self.cavern = var['cavern' + os_suffix]


def variables():
    var = {}
    var['aven_linux'] = 'aven'
    var['aven_win'] = r'"C:\Program Files\Survex\aven.exe"'
    var['cavern_linux'] = 'cavern'
    var['cavern_win'] = r'"C:\Program Files\Survex\cavern.exe"'
    var['loch_linux'] = 'loch'
    var['loch_win'] = r'"C:\Program Files\Therion\loch.exe"'
    var['therion_linux'] = 'therion'
    var['therion_win'] = r'"C:\Program Files\Therion\therion.exe"'
    var['xtherion_linux'] = 'xtherion'
    var['xtherion_win'] = r'''"C:\Program Files\Therion\bin\wish84.exe" "C:\Program Files\Therion\xtherion.tcl"'''
    return var
