#include "CommandlineOptions.hh"
#include "ComputeTriangs.hh"

int main(const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing a minimal triangulation of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  if (CommandlineOptions::verbose()) {
    return ComputeTriangs(ComputeTriangs::COMPUTE_ALL
			  | ComputeTriangs::OUTPUT_TRIANGS
			  | ComputeTriangs::FINDMIN).run();
  }
  else {
    return ComputeTriangs(ComputeTriangs::COMPUTE_ALL
			  | ComputeTriangs::FINDMIN).run();
  }
}

// eof points2mintriang.cc
