/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <string>
#include <list>
#include <iostream>

#include "http.hh"
#include "posix.hh"
#include "basic.hh"

#include "swac_repository.hh"



bool Tswac_package::load(std::string table, std::string path, xmlXPathContextPtr xpath_ctxt, std::string xpath) {
	return db.query("INSERT INTO `" + table + "` (path, packid, version, format) VALUES (" +
		db.str(path) + ", " +
		db.str(xpath_evaluate(xpath + "id", xpath_ctxt)) + ", " +
		db.str(xpath_evaluate(xpath + "version", xpath_ctxt)) + ", " +		
		db.str(xpath_evaluate(xpath + "audio/format", xpath_ctxt)) +
	");");
}


bool Tswac_package::load(std::string table, std::string path) {
	std::string xml(path);
	xml += "package.xml";

	if (createFromFile(xml.c_str())) {
		xmlXPathContextPtr xpath_ctxt = xmlXPathNewContext(doc);
		xpath_ctxt->node = xmlDocGetRootElement(doc);
		load(table, path, xpath_ctxt, "/package/");
		xmlXPathFreeContext(xpath_ctxt); 
		return true;
	}

	print_error("Can not read XML file \"" + path + "\"");
	return false;
}



bool Tswac_repository_http::read_dom(std::string root) {
	xmlXPathContextPtr xpath_ctxt = xmlXPathNewContext(doc);
	if (xpath_ctxt == NULL)
		return false;

	xmlXPathObjectPtr xpathObjPackages = xmlXPathEvalExpression(BAD_CAST "//repository/directory", xpath_ctxt);
	xmlNodeSetPtr packages;
	if (xpathObjPackages != NULL and (packages = xpathObjPackages->nodesetval) != NULL)
		for (int i = 0; i < packages->nodeNr; i++) {
			xpath_ctxt->node = packages->nodeTab[i];
			Tswac_package::load("packages_available", root + xpath_evaluate("./@path", xpath_ctxt), xpath_ctxt, "./package/");
		}

	xmlXPathFreeObject(xpathObjPackages);
	xmlXPathFreeContext(xpath_ctxt); 
	return true;
}

bool Tswac_repository_http::create_dom(std::string url) {
	xmlURIPtr uri = xmlParseURI(url.c_str());

	if (uri == NULL) 
		return false;

	FILE * f = http_fopen(uri);
	bool success = createFromStreamBz2(f, url.c_str());
	fclose(f);
	xmlFreeURI(uri);

	if (!success) {
		print_error("Unable to parse file \"" + url + "\n");
		return false;
	}
	return true;
}



bool Tswac_repository_http::load(std::string url) {
	if (create_dom(url + "repository.xml.bz2")) {
		read_dom(url);
		clear_dom();
		return true;
	}
	return false;
}


bool Tswac_repository_local::load(std::string path) {
	std::list<std::string> list;
	list_subdirs(path, &list);	
	for (std::list<std::string>::iterator it = list.begin(); it != list.end(); it++)
		if (fileexists(*it + "package.xml") &&  fileexists(*it + "index.xml.bz2"))
			Tswac_package::load("packages_available", "file://" + *it);
	return true;
}



