# Rust API client for motis-openapi-sdk

This is the MOTIS routing API.


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: v1
- Package version: v1
- Generator version: 7.10.0
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `motis-openapi-sdk` and add the following to `Cargo.toml` under `[dependencies]`:

```
motis-openapi-sdk = { path = "./motis-openapi-sdk" }
```

## Documentation for API Endpoints

All URIs are relative to *https://europe.motis-project.de*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DebugApi* | [**footpaths**](docs/DebugApi.md#footpaths) | **GET** /api/debug/footpaths | Prints all footpaths of a timetable location (track, bus stop, etc.)
*GeocodeApi* | [**geocode**](docs/GeocodeApi.md#geocode) | **GET** /api/v1/geocode | Autocompletion & geocoding that resolves user input addresses including coordinates
*GeocodeApi* | [**one_to_many**](docs/GeocodeApi.md#one_to_many) | **GET** /api/v1/one-to-many | Street routing from one to many places or many to one. The order in the response array corresponds to the order of coordinates of the \\`many\\` parameter in the query. 
*GeocodeApi* | [**reverse_geocode**](docs/GeocodeApi.md#reverse_geocode) | **GET** /api/v1/reverse-geocode | Translate coordinates to the closest address(es)/places/stops.
*MapApi* | [**initial**](docs/MapApi.md#initial) | **GET** /api/v1/map/initial | initial location to view the map at after loading based on where public transport should be visible
*MapApi* | [**levels**](docs/MapApi.md#levels) | **GET** /api/v1/map/levels | Get all available levels for a map section
*MapApi* | [**stops**](docs/MapApi.md#stops) | **GET** /api/v1/map/stops | Get all stops for a map section
*MapApi* | [**trips**](docs/MapApi.md#trips) | **GET** /api/v1/map/trips | Given a area frame (box defined by top right and bottom left corner) and a time frame, it returns all trips and their respective shapes that operate in this area + time frame. Trips are filtered by zoom level. On low zoom levels, only long distance trains will be shown while on high zoom levels, also metros, buses and trams will be returned. 
*RoutingApi* | [**plan**](docs/RoutingApi.md#plan) | **GET** /api/v1/plan | Computes optimal connections from one place to another.
*TimetableApi* | [**stoptimes**](docs/TimetableApi.md#stoptimes) | **GET** /api/v1/stoptimes | Get the next N departures or arrivals of a stop sorted by time
*TimetableApi* | [**trip**](docs/TimetableApi.md#trip) | **GET** /api/v1/trip | Get a trip as itinerary


## Documentation For Models

 - [Area](docs/Area.md)
 - [Direction](docs/Direction.md)
 - [Duration](docs/Duration.md)
 - [EncodedPolyline](docs/EncodedPolyline.md)
 - [Footpath](docs/Footpath.md)
 - [Footpaths200Response](docs/Footpaths200Response.md)
 - [Initial200Response](docs/Initial200Response.md)
 - [Itinerary](docs/Itinerary.md)
 - [Leg](docs/Leg.md)
 - [Match](docs/Match.md)
 - [Mode](docs/Mode.md)
 - [PedestrianProfile](docs/PedestrianProfile.md)
 - [Place](docs/Place.md)
 - [Plan200Response](docs/Plan200Response.md)
 - [Rental](docs/Rental.md)
 - [RentalFormFactor](docs/RentalFormFactor.md)
 - [RentalPropulsionType](docs/RentalPropulsionType.md)
 - [RentalReturnConstraint](docs/RentalReturnConstraint.md)
 - [StepInstruction](docs/StepInstruction.md)
 - [StopTime](docs/StopTime.md)
 - [Stoptimes200Response](docs/Stoptimes200Response.md)
 - [TripInfo](docs/TripInfo.md)
 - [TripSegment](docs/TripSegment.md)
 - [VertexType](docs/VertexType.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

felix@triptix.tech

