% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goSlimSummary.R
\name{goSlimSummary}
\alias{goSlimSummary}
\alias{GOSlimSummary}
\title{GO Slim Summary}
\usage{
goSlimSummary(
  organism = "hsapiens",
  geneList,
  outputFile,
  outputType = "pdf",
  isOutput = TRUE,
  cache = NULL,
  hostName = "https://www.webgestalt.org"
)
}
\arguments{
\item{organism}{Currently, WebGestaltR supports 12 organisms. Users can use the function
\code{listOrganism} to check available organisms. Users can also input \code{others} to
perform the enrichment analysis for other organisms not supported by WebGestaltR. For
other organisms, users need to provide the functional categories, interesting list and
reference list (for ORA method). Because WebGestaltR does not perform the ID mapping for
the other organisms, the above data should have the same ID type.}

\item{geneList}{A list of input genes.}

\item{outputFile}{Output file name.}

\item{outputType}{File format of the plot: \code{pdf}, \code{bmp} or \code{png}.}

\item{isOutput}{Boolean if a plot is save to \code{outputFile}.}

\item{cache}{A directory to save data cache for reuse. Defaults to \code{NULL} and disabled.}

\item{hostName}{The server URL for accessing data. Mostly for development purposes.}
}
\value{
A list of the summary result.
}
\description{
Outputs a brief summary of input genes based on GO Slim data.
}
