% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{makeAverage1merSub}
\alias{makeAverage1merSub}
\title{Make a 1-mer substitution model by averaging over a 5-mer substitution model}
\usage{
makeAverage1merSub(sub5mer)
}
\arguments{
\item{sub5mer}{a 4x1024 matrix such as that returned by 
\code{createSubstitutionMatrix} and that returned by
\code{makeDegenerate5merSub} with \code{extended=FALSE}.
Column names should correspond to 5-mers containing the 
central 1-mer to mutate from. Row names should correspond to 
nucleotides to mutate into. Nucleotides should include 
"A", "T", "G", and "C" (case-insensitive).}
}
\value{
A 4x4 matrix with row names representing nucleotides to mutate from and column
          names representing nucleotides to mutate into. Rates are normalized by row.
}
\description{
\code{makeAverage1merSub} averages substitution rates in a 5-mer substitution model
to derive a 1-mer substitution model.
}
\details{
For example, the substitution rate from "A" to "T" in the resultant 1-mer model
          is derived by averaging the substitution rates into a "T" of all the 5-mers that 
          have an "A" as their central 1-mer.
}
\examples{
# Make a degenerate 5-mer model (4x1024) based on HKL_S1F (4x4)
degenerate5merSub <- makeDegenerate5merSub(sub1mer = HKL_S1F)

# Now make a 1-mer model by averaging over the degenerate 5-mer model
# Expected to get back HKL_S1F
makeAverage1merSub(sub5mer = degenerate5merSub)

}
\seealso{
See \link{makeDegenerate5merSub} for making a degenerate 5-mer substitution 
          model based on a 1-mer substitution model.
}
