% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R, R/convenience.R
\name{DimHeatmap}
\alias{DimHeatmap}
\alias{PCHeatmap}
\title{Dimensional reduction heatmap}
\usage{
DimHeatmap(
  object,
  dims = 1,
  nfeatures = 30,
  cells = NULL,
  reduction = "pca",
  disp.min = -2.5,
  disp.max = NULL,
  balanced = TRUE,
  projected = FALSE,
  ncol = NULL,
  fast = TRUE,
  raster = TRUE,
  slot = "scale.data",
  assays = NULL,
  combine = TRUE
)

PCHeatmap(object, ...)
}
\arguments{
\item{object}{Seurat object}

\item{dims}{Dimensions to plot}

\item{nfeatures}{Number of genes to plot}

\item{cells}{A list of cells to plot. If numeric, just plots the top cells.}

\item{reduction}{Which dimmensional reduction to use}

\item{disp.min}{Minimum display value (all values below are clipped)}

\item{disp.max}{Maximum display value (all values above are clipped); defaults to 2.5
if \code{slot} is 'scale.data', 6 otherwise}

\item{balanced}{Plot an equal number of genes with both + and - scores.}

\item{projected}{Use the full projected dimensional reduction}

\item{ncol}{Number of columns to plot}

\item{fast}{If true, use \code{image} to generate plots; faster than using ggplot2, but not customizable}

\item{raster}{If true, plot with geom_raster, else use geom_tile. geom_raster may look blurry on
some viewing applications such as Preview due to how the raster is interpolated. Set this to FALSE
if you are encountering that issue (note that plots may take longer to produce/render).}

\item{slot}{Data slot to use, choose from 'raw.data', 'data', or 'scale.data'}

\item{assays}{A vector of assays to pull data from}

\item{combine}{Combine plots into a single \code{\link[patchwork]{patchwork}ed}
ggplot object. If \code{FALSE}, return a list of ggplot objects}

\item{...}{Extra parameters passed to \code{DimHeatmap}}
}
\value{
No return value by default. If using fast = FALSE, will return a
\code{\link[patchwork]{patchwork}ed} ggplot object if combine = TRUE, otherwise
returns a list of ggplot objects
}
\description{
Draws a heatmap focusing on a principal component. Both cells and genes are sorted by their
principal component scores. Allows for nice visualization of sources of heterogeneity in the dataset.
}
\examples{
data("pbmc_small")
DimHeatmap(object = pbmc_small)

}
\seealso{
\code{\link[graphics]{image}} \code{\link[ggplot2]{geom_raster}}
}
\concept{convenience}
\concept{visualization}
