% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{meanRecurrenceTime}
\alias{meanRecurrenceTime}
\title{Mean recurrence time}
\usage{
meanRecurrenceTime(object)
}
\arguments{
\item{object}{the markovchain object}
}
\value{
For a Markov chain it outputs is a named vector with the expected 
  time to first return to a state when the chain starts there.
  States present in the vector are only the recurrent ones. If the matrix
  is ergodic (i.e. irreducible), then all states are present in the output
  and order is the same as states order for the Markov chain
}
\description{
Computes the expected time to return to a recurrent state
  in case the Markov chain starts there
}
\examples{
m <- matrix(1 / 10 * c(6,3,1,
                       2,3,5,
                       4,1,5), ncol = 3, byrow = TRUE)
mc <- new("markovchain", states = c("s","c","r"), transitionMatrix = m)
meanRecurrenceTime(mc)

}
\references{
C. M. Grinstead and J. L. Snell. Introduction to Probability.
American Mathematical Soc., 2012.
}
\author{
Ignacio Cordón
}
