% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-client-credentials.R
\name{req_oauth_client_credentials}
\alias{req_oauth_client_credentials}
\title{OAuth authentication with client credentials}
\usage{
req_oauth_client_credentials(req, client, scope = NULL, token_params = list())
}
\arguments{
\item{req}{A \link{request}.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
A modified HTTP \link{request}.
}
\description{
This uses \code{\link[=oauth_flow_client_credentials]{oauth_flow_client_credentials()}} to generate an access token,
which is then used to authentication the request with \code{\link[=req_auth_bearer_token]{req_auth_bearer_token()}}.
The token is cached in memory.
}
\examples{
client <- oauth_client("example", "https://example.com/get_token")
req <- request("https://example.com")

req \%>\% req_oauth_client_credentials(client)
}
