% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/askpass.R
\name{askpass}
\alias{askpass}
\title{Password Prompt Utility}
\usage{
askpass(prompt = "Please enter your password: ")
}
\arguments{
\item{prompt}{the string printed when prompting the user for input.}
}
\description{
Prompt the user for a password to authenticate or read a protected key.
By default, this function automatically uses the most appropriate method
based on the user platform and front-end. Users or IDEs can override this
and set a custom password entry function via the \code{askpass} option.
}
\details{
By default \code{askpass()} returns \code{NULL} in non-interactive sessions.
(These include knitr runs and testthat tests.)
If you want to force a password prompt in non-interactive sessions,
set the \code{rlib_interactive} option to \code{TRUE}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(rlib_interactive = TRUE)
}\if{html}{\out{</div>}}
}
\examples{
\donttest{
# Prompt user for passwd
pw <- askpass("Please enter your password")
}
}
