% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-extraction.r
\name{Extraction methods}
\alias{Extraction methods}
\alias{names.DPT}
\alias{names.DiffusionMap}
\alias{[[.DPT}
\alias{[[.DiffusionMap}
\alias{$.DPT}
\alias{$.DiffusionMap}
\alias{names,DiffusionMap-method}
\alias{names,DPT-method}
\alias{[[,DiffusionMap,character,missing-method}
\alias{[[,DPT,character,missing-method}
\alias{$,DiffusionMap-method}
\alias{$,DPT-method}
\title{Extraction methods}
\usage{
\S4method{names}{DiffusionMap}(x)

\S4method{names}{DPT}(x)

\S4method{[[}{DiffusionMap,character,missing}(x, i, j, ...)

\S4method{[[}{DPT,character,missing}(x, i, j, ...)

\S4method{$}{DiffusionMap}(x, name)

\S4method{$}{DPT}(x, name)
}
\arguments{
\item{x}{\code{\link{DiffusionMap}} or \code{\link{DPT}}  object}

\item{i, name}{Name of a diffusion component \code{'DCx'}, \code{'DPTx'}, \code{'Branch'} or column from the data}

\item{j}{N/A}

\item{...}{ignored}
}
\value{
The names or data row, see respective generics.
}
\description{
Extract common information from objects.
Apart from the input data's branches,
you can extract diffusion components via \code{$DCx}.
From \code{\link{DPT}} objects, you can also extract the branch label via \code{$Branch},
or the diffusion pseudo time for a numbered cell via \code{$DPTx}.
}
\examples{
data(guo)
dm <- DiffusionMap(guo)
dm$DC1        # A diffusion component
dm$Actb       # A gene expression vector
dm$num_cells  # Phenotype metadata

dpt <- DPT(dm)
dm$Branch
dm$DPT1

}
\seealso{
\link[base]{Extract}, \code{\link[base]{names}} for the generics. \link{DiffusionMap accession methods}, \link{DiffusionMap methods}, \link{Coercion methods} for more
}
