% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoupleR-pre.R
\name{check_corr}
\alias{check_corr}
\title{Check correlation (colinearity)}
\usage{
check_corr(
  network,
  .source = "source",
  .target = "target",
  .mor = "mor",
  .likelihood = NULL
)
}
\arguments{
\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{.mor}{Column with edge mode of regulation (i.e. mor).}

\item{.likelihood}{Deprecated argument. Now it will always be set to 1.}
}
\value{
Correlation pairs tibble.
}
\description{
Checks the correlation across the regulators in a network.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")
net <- readRDS(file.path(inputs_dir, "net.rds"))
check_corr(net, .source='source')
}
