# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class EventTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.insights.v1.calls("CAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                   .events.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://insights.twilio.com/v1/Voice/CAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Events',
        ))

    def test_read_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Events?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "next_page_url": null,
                    "key": "events",
                    "url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Events?PageSize=50&Page=0"
                },
                "events": [
                    {
                        "timestamp": "2019-09-19T22:15:23Z",
                        "call_sid": "CA03a02b156c6faa96c86906f7e9ad0f38",
                        "account_sid": "AC998c10b68cbfda9f67277f7d8f4439c9",
                        "edge": "sdk_edge",
                        "group": "connection",
                        "name": "error",
                        "level": "ERROR",
                        "sdk_edge": {
                            "error": {
                                "code": 31600
                            },
                            "metadata": {
                                "client_name": "GTI9300323095d271b890c91568931321395",
                                "location": {
                                    "lat": 37.4192,
                                    "lon": -122.0574
                                },
                                "city": "Mountain View",
                                "country_code": "US",
                                "country_subdivision": "California",
                                "ip_address": "108.177.7.83",
                                "sdk": {
                                    "type": "twilio-voice-android",
                                    "version": "4.5.1",
                                    "platform": "android",
                                    "selected_region": "gll",
                                    "os": {
                                        "name": "android",
                                        "version": "4.3"
                                    },
                                    "device": {
                                        "model": "GT-I9300",
                                        "type": "GT-I9300",
                                        "vendor": "samsung",
                                        "arch": "armeabi-v7a"
                                    }
                                }
                            }
                        },
                        "client_edge": null,
                        "carrier_edge": null,
                        "sip_edge": null
                    }
                ]
            }
            '''
        ))

        actual = self.client.insights.v1.calls("CAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .events.list()

        self.assertIsNotNone(actual)

    def test_read_deep_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 10,
                    "page_size": 5,
                    "first_page_url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Events?PageSize=5&Page=0",
                    "previous_page_url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Events?PageSize=5&Page=9&PageToken=DP10",
                    "next_page_url": null,
                    "key": "events",
                    "url": "https://insights.twilio.com/v1/Voice/CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Events?PageSize=5&Page=10"
                },
                "events": [
                    {
                        "timestamp": "2019-09-19T22:15:23Z",
                        "call_sid": "CA03a02b156c6faa96c86906f7e9ad0f38",
                        "account_sid": "AC998c10b68cbfda9f67277f7d8f4439c9",
                        "edge": "sdk_edge",
                        "group": "connection",
                        "name": "error",
                        "level": "ERROR",
                        "sdk_edge": {
                            "error": {
                                "code": 31600
                            },
                            "metadata": {
                                "client_name": "GTI9300323095d271b890c91568931321395",
                                "location": {
                                    "lat": 37.4192,
                                    "lon": -122.0574
                                },
                                "city": "Mountain View",
                                "country_code": "US",
                                "country_subdivision": "California",
                                "ip_address": "108.177.7.83",
                                "sdk": {
                                    "type": "twilio-voice-android",
                                    "version": "4.5.1",
                                    "platform": "android",
                                    "selected_region": "gll",
                                    "os": {
                                        "name": "android",
                                        "version": "4.3"
                                    },
                                    "device": {
                                        "model": "GT-I9300",
                                        "type": "GT-I9300",
                                        "vendor": "samsung",
                                        "arch": "armeabi-v7a"
                                    }
                                }
                            }
                        },
                        "client_edge": null,
                        "carrier_edge": null,
                        "sip_edge": null
                    }
                ]
            }
            '''
        ))

        actual = self.client.insights.v1.calls("CAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .events.list()

        self.assertIsNotNone(actual)
