"""
Table of energy-dependent neutron cross-sections.

dict(("element", isotope or None): [[energy (eV), Re(a), Im(a), |a|], ...])

From Lynn and Seeger (1990)
"""

ENERGY_DEPENDENT_TABLES = {
    ("Sm", None): [
        [0.01,  1.24, -1.16,  1.70],
        [0.02,  0.96, -1.42,  1.72],
        [0.03,  0.64, -1.79,  1.90],
        [0.04,  0.30, -2.29,  2.31],
        [0.05, -0.04, -3.01,  3.01],
        [0.06, -0.29, -4.04,  4.05],
        [0.07, -0.25, -5.45,  5.46],
        [0.08,  0.48, -7.20,  7.21],
        [0.09,  2.31, -8.74,  9.04],
        [0.10,  4.98, -9.10, 10.38],
        [0.11,  7.29, -7.99, 10.82],
        [0.12,  8.49, -6.23, 10.54],
        [0.13,  8.80, -4.64,  9.95],
        [0.14,  8.65, -3.45,  9.31],
        [0.15,  8.33, -2.60,  8.73],
        [0.16,  7.99, -2.01,  8.24],
        [0.17,  7.66, -1.59,  7.82],
        [0.18,  7.36, -1.28,  7.47],
        [0.19,  7.10, -1.05,  7.17],
        [0.20,  6.86, -0.88,  6.92],
        [0.21,  6.66, -0.74,  6.70],
        [0.22,  6.49, -0.64,  6.52],
        [0.23,  6.33, -0.55,  6.35],
        [0.24,  6.19, -0.48,  6.21],
        [0.25,  6.06, -0.43,  6.08],
        [0.26,  5.95, -0.38,  5.97],
        [0.27,  5.85, -0.34,  5.86],
        [0.28,  5.76, -0.31,  5.77],
        [0.29,  5.68, -0.28,  5.68],
        [0.30,  5.60, -0.25,  5.61],
        [0.31,  5.53, -0.23,  5.54],
        [0.32,  5.47, -0.21,  5.47],
        [0.33,  5.41, -0.20,  5.41],
        [0.34,  5.35, -0.18,  5.35],
        [0.35,  5.30, -0.17,  5.30],
        [0.36,  5.25, -0.16,  5.25],
        [0.37,  5.20, -0.15,  5.20],
        [0.38,  5.16, -0.14,  5.16],
        [0.39,  5.12, -0.13,  5.12],
        [0.40,  5.08, -0.12,  5.08],
        [0.41,  5.04, -0.12,  5.05],
        [0.42,  5.01, -0.11,  5.01],
        [0.43,  4.98, -0.10,  4.98],
        [0.44,  4.94, -0.10,  4.95],
        [0.45,  4.91, -0.09,  4.91],
        [0.46,  4.88, -0.09,  4.89],
        [0.47,  4.86, -0.09,  4.86],
        [0.48,  4.83, -0.08,  4.83],
        [0.49,  4.80, -0.08,  4.81],
        [0.50,  4.78, -0.08,  4.78],
    ],

    ("Sm", 149): [
        [0.01, -15.84,  -8.30, 17.88],
        [0.02, -17.87, -10.22, 20.59],
        [0.03, -20.16, -12.84, 23.90],
        [0.04, -22.63, -16.48, 28.00],
        [0.05, -25.09, -21.66, 33.14],
        [0.06, -26.89, -29.02, 39.56],
        [0.07, -26.56, -39.21, 47.36],
        [0.08, -21.31, -51.76, 55.98],
        [0.09,  -8.14, -62.85, 63.38],
        [0.10,  11.02, -65.46, 66.38],
        [0.11,  27.67, -57.44, 63.75],
        [0.12,  36.31, -44.83, 57.69],
        [0.13,  38.48, -33.39, 50.94],
        [0.14,  37.41, -24.79, 44.88],
        [0.15,  35.16, -18.72, 39.83],
        [0.16,  32.66, -14.45, 35.71],
        [0.17,  30.28, -11.41, 32.36],
        [0.18,  28.14,  -9.20, 29.60],
        [0.19,  26.25,  -7.55, 27.31],
        [0.20,  24.59,  -6.30, 25.38],
        [0.21,  23.14,  -5.34, 23.74],
        [0.22,  21.86,  -4.57, 22.33],
        [0.23,  20.73,  -3.96, 21.11],
        [0.24,  19.73,  -3.47, 20.03],
        [0.25,  18.84,  -3.06, 19.08],
        [0.26,  18.03,  -2.72, 18.24],
        [0.27,  17.31,  -2.44, 17.48],
        [0.28,  16.65,  -2.20, 16.79],
        [0.29,  16.05,  -1.99, 16.17],
        [0.30,  15.50,  -1.82, 15.61],
        [0.31,  14.99,  -1.66, 15.09],
        [0.32,  14.53,  -1.53, 14.61],
        [0.33,  14.09,  -1.41, 14.17],
        [0.34,  13.69,  -1.31, 13.75],
        [0.35,  13.32,  -1.22, 13.37],
        [0.36,  12.97,  -1.14, 13.02],
        [0.37,  12.64,  -1.06, 12.68],
        [0.38,  12.33,  -1.00, 12.37],
        [0.39,  12.03,  -0.94, 12.07],
        [0.40,  11.75,  -0.89, 11.79],
        [0.41,  11.49,  -0.84, 11.52],
        [0.42,  11.24,  -0.79, 11.27],
        [0.43,  11.00,  -0.75, 11.03],
        [0.44,  10.78,  -0.72, 10.80],
        [0.45,  10.56,  -0.68, 10.58],
        [0.46,  10.35,  -0.65, 10.37],
        [0.47,  10.15,  -0.62, 10.17],
        [0.48,   9.96,  -0.60,  9.97],
        [0.49,   9.77,  -0.57,  9.79],
        [0.50,   9.59,  -0.55,  9.61],
    ],

    ("Eu", None): [
        [0.01,  7.28,  -1.64,  7.46],
        [0.02,  7.22,  -1.37,  7.35],
        [0.03,  7.12,  -1.15,  7.21],
        [0.04,  7.00,  -0.99,  7.07],
        [0.05,  6.88,  -0.87,  6.93],
        [0.06,  6.76,  -0.78,  6.80],
        [0.07,  6.64,  -0.71,  6.68],
        [0.08,  6.52,  -0.66,  6.55],
        [0.09,  6.41,  -0.63,  6.44],
        [0.10,  6.30,  -0.60,  6.32],
        [0.11,  6.18,  -0.58,  6.21],
        [0.12,  6.08,  -0.57,  6.10],
        [0.13,  5.97,  -0.57,  5.99],
        [0.14,  5.85,  -0.58,  5.88],
        [0.15,  5.74,  -0.59,  5.77],
        [0.16,  5.62,  -0.60,  5.66],
        [0.17,  5.50,  -0.62,  5.54],
        [0.18,  5.38,  -0.65,  5.42],
        [0.19,  5.24,  -0.69,  5.29],
        [0.20,  5.10,  -0.73,  5.16],
        [0.21,  4.96,  -0.79,  5.02],
        [0.22,  4.80,  -0.86,  4.87],
        [0.23,  4.63,  -0.94,  4.72],
        [0.24,  4.44,  -1.05,  4.57],
        [0.25,  4.25,  -1.18,  4.41],
        [0.26,  4.05,  -1.35,  4.27],
        [0.27,  3.84,  -1.57,  4.15],
        [0.28,  3.65,  -1.86,  4.09],
        [0.29,  3.50,  -2.21,  4.14],
        [0.30,  3.44,  -2.63,  4.33],
        [0.31,  3.53,  -3.03,  4.66],
        [0.32,  3.75,  -3.32,  5.01],
        [0.33,  3.96,  -3.40,  5.22],
        [0.34,  4.01,  -3.35,  5.23],
        [0.35,  3.87,  -3.31,  5.09],
        [0.36,  3.57,  -3.37,  4.91],
        [0.37,  3.17,  -3.38,  4.78],
        [0.38,  2.72,  -3.97,  4.81],
        [0.39,  2.24,  -4.56,  5.08],
        [0.40,  1.80,  -5.41,  5.70],
        [0.41,  1.45,  -6.57,  6.72],
        [0.42,  1.36,  -8.09,  8.20],
        [0.43,  1.75,  -9.97, 10.12],
        [0.44,  2.96, -12.02, 12.38],
        [0.45,  5.19, -13.75, 14.70],
        [0.46,  8.23, -14.44, 16.62],
        [0.47, 11.28, -13.72, 17.76],
        [0.48, 13.54, -11.97, 18.07],
        [0.49, 14.77,  -9.87, 17.77],
        [0.50, 15.20,  -7.94, 17.15],
        [0.51, 15.15,  -6.35, 16.43],
        [0.52, 14.86,  -5.11, 15.71],
        [0.53, 14.46,  -4.16, 15.05],
        [0.54, 14.04,  -3.44, 14.45],
        [0.55, 13.63,  -2.87, 13.93],
        [0.56, 13.25,  -2.43, 13.47],
        [0.57, 12.89,  -2.08, 13.06],
        [0.58, 12.57,  -1.80, 12.70],
        [0.59, 12.28,  -1.58, 12.38],
        [0.60, 12.02,  -1.39, 12.10],
    ],

    ("Eu", 151): [
        [0.01,  6.62,  -3.33,  7.41],
        [0.02,  6.49,  -2.76,  7.05],
        [0.03,  6.28,  -2.31,  6.69],
        [0.04,  6.04,  -1.98,  6.35],
        [0.05,  5.78,  -1.73,  6.03],
        [0.06,  5.53,  -1.54,  5.73],
        [0.07,  5.28,  -1.39,  5.46],
        [0.08,  5.03,  -1.29,  5.19],
        [0.09,  4.79,  -1.21,  4.94],
        [0.10,  4.56,  -1.15,  4.71],
        [0.11,  4.33,  -1.12,  4.47],
        [0.12,  4.10,  -1.10,  4.25],
        [0.13,  3.87,  -1.09,  4.02],
        [0.14,  3.64,  -1.10,  3.80],
        [0.15,  3.40,  -1.12,  3.58],
        [0.16,  3.16,  -1.15,  3.36],
        [0.17,  2.90,  -1.20,  3.14],
        [0.18,  2.64,  -1.26,  2.93],
        [0.19,  2.36,  -1.34,  2.72],
        [0.20,  2.07,  -1.43,  2.52],
        [0.21,  1.76,  -1.55,  2.34],
        [0.22,  1.43,  -1.69,  2.21],
        [0.23,  1.08,  -1.86,  2.15],
        [0.24,  0.69,  -2.09,  2.20],
        [0.25,  0.29,  -2.37,  2.38],
        [0.26, -0.14,  -2.72,  2.72],
        [0.27, -0.57,  -3.18,  3.23],
        [0.28, -0.98,  -3.77,  3.90],
        [0.29, -1.29,  -4.51,  4.69],
        [0.30, -1.40,  -5.38,  5.56],
        [0.31, -1.21,  -6.23,  6.35],
        [0.32, -0.76,  -6.82,  6.86],
        [0.33, -0.32,  -7.00,  7.01],
        [0.34, -0.21,  -6.90,  6.90],
        [0.35, -0.51,  -6.81,  6.83],
        [0.36, -1.14,  -6.93,  7.03],
        [0.37, -1.97,  -7.37,  7.63],
        [0.38, -2.92,  -8.18,  8.69],
        [0.39, -3.91,  -9.42, 10.20],
        [0.40, -4.84, -11.19, 12.19],
        [0.41, -5.56, -13.61, 14.70],
        [0.42, -5.75, -16.79, 17.75],
        [0.43, -4.93, -20.72, 21.30],
        [0.44, -2.42, -25.01, 25.13],
        [0.45,  2.26, -28.61, 28.70],
        [0.46,  8.61, -30.05, 31.26],
        [0.47, 14.98, -28.56, 32.25],
        [0.48, 19.69, -24.90, 31.74],
        [0.49, 22.27, -20.52, 30.28],
        [0.50, 23.17, -16.48, 28.43],
        [0.51, 23.06, -13.17, 26.55],
        [0.52, 22.45, -10.58, 24.81],
        [0.53, 21.62,  -8.59, 23.27],
        [0.54, 20.74,  -7.07, 21.91],
        [0.55, 19.89,  -5.89, 20.74],
        [0.56, 19.08,  -4.97, 19.72],
        [0.57, 18.35,  -4.25, 18.83],
        [0.58, 17.68,  -3.66, 18.05],
        [0.59, 17.07,  -3.19, 17.37],
        [0.60, 16.52,  -2.80, 16.76],
    ],

    ("Gd", None): [
        [0.002,  1.04, -10.73, 10.78],
        [0.004,  1.28, -11.07, 11.14],
        [0.006,  1.54, -11.40, 11.50],
        [0.008,  1.84, -11.73, 11.87],
        [0.010,  2.16, -12.04, 12.23],
        [0.012,  2.51, -12.34, 12.59],
        [0.014,  2.89, -12.62, 12.95],
        [0.016,  3.29, -12.88, 13.30],
        [0.018,  3.72, -13.12, 13.64],
        [0.020,  4.17, -13.33, 13.97],
        [0.022,  4.65, -13.51, 14.28],
        [0.024,  5.14, -13.65, 14.59],
        [0.026,  5.65, -13.76, 14.87],
        [0.028,  6.16, -13.83, 15.14],
        [0.030,  6.68, -13.86, 15.38],
        [0.032,  7.21, -13.85, 15.61],
        [0.034,  7.73, -13.80, 15.82],
        [0.036,  8.24, -13.71, 16.00],
        [0.038,  8.74, -13.59, 16.16],
        [0.04,  9.22, -13.43, 16.29],
        [0.05, 11.31, -12.21, 16.64],
        [0.06, 12.70, -10.59, 16.54],
        [0.07, 13.45,  -8.92, 16.14],
        [0.08, 13.72,  -7.42, 15.60],
        [0.09, 13.69,  -6.16, 15.01],
        [0.10, 13.49,  -5.13, 14.43],
        [0.11, 13.20,  -4.30, 13.89],
        [0.12, 12.88,  -3.64, 13.39],
        [0.13, 12.56,  -3.11, 12.94],
        [0.14, 12.25,  -2.68, 12.53],
        [0.15, 11.95,  -2.33, 12.17],
        [0.16, 11.67,  -2.04, 11.85],
        [0.17, 11.42,  -1.80, 11.56],
        [0.18, 11.18,  -1.60, 11.30],
        [0.19, 10.97,  -1.43, 11.06],
        [0.20, 10.77,  -1.29, 10.85],
        [0.21, 10.59,  -1.17, 10.65],
        [0.22, 10.42,  -1.06, 10.47],
        [0.23, 10.27,  -0.97, 10.31],
        [0.24, 10.12,  -0.89, 10.16],
        [0.25,  9.99,  -0.82, 10.02],
        [0.26,  9.87,  -0.76,  9.90],
        [0.27,  9.75,  -0.71,  9.78],
        [0.28,  9.65,  -0.66,  9.67],
        [0.29,  9.55,  -0.62,  9.57],
        [0.30,  9.46,  -0.58,  9.48],
        [0.31,  9.37,  -0.54,  9.39],
        [0.32,  9.29,  -0.51,  9.30],
        [0.33,  9.21,  -0.48,  9.23],
        [0.34,  9.14,  -0.46,  9.15],
        [0.35,  9.07,  -0.44,  9.08],
        [0.36,  9.01,  -0.41,  9.02],
        [0.37,  8.95,  -0.39,  8.96],
        [0.38,  8.89,  -0.38,  8.90],
        [0.39,  8.84,  -0.36,  8.85],
        [0.40,  8.79,  -0.34,  8.79],
        [0.41,  8.74,  -0.33,  8.74],
        [0.42,  8.69,  -0.32,  8.70],
        [0.43,  8.65,  -0.31,  8.65],
        [0.44,  8.61,  -0.29,  8.61],
        [0.45,  8.57,  -0.28,  8.57],
        [0.46,  8.53,  -0.27,  8.53],
        [0.47,  8.49,  -0.26,  8.49],
        [0.48,  8.45,  -0.26,  8.46],
        [0.49,  8.42,  -0.25,  8.42],
        [0.50,  8.39,  -0.24,  8.39],
    ],

    ("Gd", 155): [
        [0.001, -0.06, -13.35, 13.35],
        [0.002,  0.09, -13.56, 13.56],
        [0.003,  0.25, -13.76, 13.76],
        [0.004,  0.42, -13.97, 13.97],
        [0.005,  0.60, -14.17, 14.18],
        [0.006,  0.78, -14.36, 14.38],
        [0.007,  0.98, -14.56, 14.59],
        [0.008,  1.18, -14.75, 14.80],
        [0.009,  1.40, -14.93, 14.99],
        [0.010,  1.62, -15.11, 15.20],
        [0.011,  1.85, -15.28, 15.40],
        [0.012,  2.09, -15.45, 15.59],
        [0.013,  2.34, -15.61, 15.79],
        [0.014,  2.59, -15.77, 15.98],
        [0.015,  2.86, -15.91, 16.17],
        [0.016,  3.13, -16.05, 16.35],
        [0.017,  3.41, -16.18, 16.53],
        [0.018,  3.69, -16.30, 16.71],
        [0.019,  3.98, -16.41, 16.88],
        [0.020,  4.28, -16.51, 17.05],
        [0.021,  4.58, -16.60, 17.22],
        [0.022,  4.89, -16.68, 17.38],
        [0.023,  5.20, -16.74, 17.53],
        [0.024,  5.51, -16.80, 17.68],
        [0.025,  5.83, -16.84, 17.82],
        [0.026,  6.15, -16.87, 17.96],
        [0.027,  6.47, -16.89, 18.09],
        [0.028,  6.79, -16.90, 18.21],
        [0.029,  7.11, -16.90, 18.33],
        [0.030,  7.43, -16.88, 18.44],
        [0.031,  7.75, -16.85, 18.54],
        [0.032,  8.07, -16.81, 18.64],
        [0.033,  8.38, -16.75, 18.73],
        [0.034,  8.69, -16.69, 18.82],
        [0.035,  9.00, -16.61, 18.90],
        [0.036,  9.31, -16.52, 18.96],
        [0.037,  9.60, -16.43, 19.03],
        [0.038,  9.89, -16.32, 19.09],
        [0.039, 10.18, -16.20, 19.14],
        [0.040, 10.46, -16.08, 19.18],
        [0.042, 11.00, -15.79, 19.25],
        [0.044, 11.50, -15.48, 19.29],
        [0.046, 11.98, -15.14, 19.31],
        [0.048, 12.41, -14.78, 19.30],
        [0.05, 12.82, -14.40, 19.28],
        [0.06, 14.31, -12.35, 18.91],
        [0.07, 15.05, -10.34, 18.26],
        [0.08, 15.27,  -8.56, 17.50],
        [0.09, 15.16,  -7.09, 16.73],
        [0.10, 14.87,  -5.90, 16.00],
        [0.11, 14.50,  -4.94, 15.32],
        [0.12, 14.10,  -4.18, 14.71],
        [0.13, 13.71,  -3.56, 14.16],
        [0.14, 13.33,  -3.07, 13.67],
        [0.15, 12.97,  -2.66, 13.24],
        [0.16, 12.64,  -2.33, 12.85],
        [0.17, 12.33,  -2.05, 12.50],
        [0.18, 12.05,  -1.82, 12.18],
        [0.19, 11.79,  -1.62, 11.90],
        [0.20, 11.55,  -1.46, 11.64],
        [0.21, 11.33,  -1.31, 11.41],
        [0.22, 11.13,  -1.19, 11.20],
        [0.23, 10.95,  -1.08, 11.00],
        [0.24, 10.78,  -0.99, 10.82],
        [0.25, 10.62,  -0.91, 10.66],
        [0.26, 10.47,  -0.84, 10.50],
        [0.27, 10.33,  -0.77, 10.36],
        [0.28, 10.21,  -0.72, 10.23],
        [0.29, 10.09,  -0.67, 10.11],
        [0.30,  9.98,  -0.62, 10.00],
        [0.31,  9.87,  -0.58,  9.89],
        [0.32,  9.78,  -0.54,  9.79],
        [0.33,  9.68,  -0.51,  9.70],
        [0.34,  9.60,  -0.48,  9.61],
        [0.35,  9.52,  -0.45,  9.53],
        [0.36,  9.44,  -0.42,  9.45],
        [0.37,  9.37,  -0.40,  9.38],
        [0.38,  9.30,  -0.38,  9.31],
        [0.39,  9.23,  -0.36,  9.24],
        [0.40,  9.17,  -0.34,  9.18],
        [0.41,  9.11,  -0.33,  9.12],
        [0.42,  9.06,  -0.31,  9.06],
        [0.43,  9.00,  -0.30,  9.01],
        [0.44,  8.95,  -0.28,  8.96],
        [0.45,  8.90,  -0.27,  8.91],
        [0.46,  8.86,  -0.26,  8.86],
        [0.47,  8.81,  -0.25,  8.82],
        [0.48,  8.77,  -0.24,  8.77],
        [0.49,  8.73,  -0.23,  8.73],
        [0.50,  8.69,  -0.22,  8.69],
    ],

    ("Gd", 157): [
        [0.001, -24.36, -54.67, 59.85],
        [0.002, -23.81, -55.56, 60.44],
        [0.003, -23.22, -56.44, 61.03],
        [0.004, -22.61, -57.32, 61.62],
        [0.005, -21.96, -58.19, 62.20],
        [0.006, -21.27, -59.06, 62.77],
        [0.007, -20.54, -59.92, 63.34],
        [0.008, -19.78, -60.76, 63.90],
        [0.009, -18.99, -61.60, 64.46],
        [0.010, -18.15, -62.42, 65.01],
        [0.011, -17.28, -63.22, 65.54],
        [0.012, -16.37, -64.00, 66.06],
        [0.013, -15.42, -64.77, 66.58],
        [0.014, -14.44, -65.50, 67.08],
        [0.015, -13.42, -66.21, 67.56],
        [0.016, -12.37, -66.90, 68.03],
        [0.017, -11.28, -67.55, 68.48],
        [0.018, -10.16, -68.16, 68.92],
        [0.019,  -9.00, -68.75, 69.34],
        [0.020,  -7.82, -69.30, 69.74],
        [0.021,  -6.61, -69.80, 70.11],
        [0.022,  -5.37, -70.27, 70.47],
        [0.023,  -4.11, -70.69, 70.81],
        [0.024,  -2.83, -71.07, 71.12],
        [0.025,  -1.53, -71.40, 71.42],
        [0.026,  -0.21, -71.68, 71.68],
        [0.027,   1.12, -71.92, 71.93],
        [0.028,   2.47, -72.10, 72.14],
        [0.029,   3.82, -72.24, 72.34],
        [0.030,   5.18, -72.32, 72.50],
        [0.031,   6.55, -72.35, 72.65],
        [0.032,   7.91, -72.33, 72.76],
        [0.033,   9.27, -72.26, 72.85],
        [0.034,  10.63, -72.14, 72.92],
        [0.035,  11.97, -71.96, 72.95],
        [0.036,  13.31, -71.74, 72.97],
        [0.037,  14.63, -71.47, 72.95],
        [0.038,  15.94, -71.15, 72.91],
        [0.039,  17.22, -70.78, 72.85],
        [0.040,  18.49, -70.37, 72.76],
        [0.041,  19.73, -69.91, 72.64],
        [0.042,  20.94, -69.42, 72.51],
        [0.043,  22.13, -68.88, 72.35],
        [0.044,  23.28, -68.31, 72.17],
        [0.045,  24.41, -67.70, 71.96],
        [0.046,  25.50, -67.05, 71.74],
        [0.047,  26.56, -66.38, 71.50],
        [0.048,  27.59, -65.68, 71.24],
        [0.049,  28.58, -64.95, 70.96],
        [0.050,  29.53, -64.19, 70.66],
        [0.051,  30.45, -63.42, 70.35],
        [0.052,  31.32, -62.62, 70.02],
        [0.053,  32.16, -61.81, 69.67],
        [0.054,  32.97, -60.98, 69.32],
        [0.055,  33.73, -60.13, 68.95],
        [0.06,  37.01, -55.79, 66.95],
        [0.07,  41.07, -47.07, 62.47],
        [0.08,  42.60, -39.18, 57.87],
        [0.09,  42.50, -32.51, 53.51],
        [0.10,  41.49, -27.08, 49.54],
        [0.11,  40.02, -22.71, 46.01],
        [0.12,  38.36, -19.22, 42.91],
        [0.13,  36.67, -16.42, 40.18],
        [0.14,  35.03, -14.15, 37.78],
        [0.15,  33.48, -12.30, 35.67],
        [0.16,  32.04, -10.79, 33.81],
        [0.17,  30.70,  -9.53, 32.15],
        [0.18,  29.47,  -8.48, 30.67],
        [0.19,  28.34,  -7.60, 29.35],
        [0.20,  27.31,  -6.85, 28.15],
        [0.21,  26.35,  -6.21, 27.07],
        [0.22,  25.48,  -5.65, 26.10],
        [0.23,  24.67,  -5.17, 25.20],
        [0.24,  23.92,  -4.76, 24.39],
        [0.25,  23.23,  -4.39, 23.64],
        [0.26,  22.59,  -4.07, 22.95],
        [0.27,  21.99,  -3.78, 22.32],
        [0.28,  21.44,  -3.53, 21.73],
        [0.29,  20.92,  -3.30, 21.18],
        [0.30,  20.44,  -3.10, 20.67],
        [0.31,  19.99,  -2.92, 20.20],
        [0.32,  19.56,  -2.75, 19.75],
        [0.33,  19.16,  -2.60, 19.34],
        [0.34,  18.79,  -2.47, 18.95],
        [0.35,  18.43,  -2.34, 18.58],
        [0.36,  18.10,  -2.23, 18.24],
        [0.37,  17.78,  -2.13, 17.91],
        [0.38,  17.49,  -2.03, 17.60],
        [0.39,  17.20,  -1.95, 17.31],
        [0.40,  16.93,  -1.86, 17.04],
        [0.41,  16.68,  -1.79, 16.77],
        [0.42,  16.43,  -1.72, 16.52],
        [0.43,  16.20,  -1.66, 16.29],
        [0.44,  15.98,  -1.60, 16.06],
        [0.45,  15.77,  -1.54, 15.85],
        [0.46,  15.57,  -1.49, 15.64],
        [0.47,  15.38,  -1.44, 15.44],
        [0.48,  15.19,  -1.40, 15.26],
        [0.49,  15.02,  -1.36, 15.08],
        [0.50,  14.85,  -1.32, 14.90],
    ],

    ("Dy", 164): [
        [0.05, 48.74, -0.80, 48.75],
        [0.10, 48.07, -0.82, 48.08],
        [0.15, 47.42, -0.83, 47.43],
        [0.20, 46.80, -0.83, 46.80],
        [0.25, 46.19, -0.83, 46.19],
        [0.30, 45.60, -0.83, 45.60],
        [0.35, 45.02, -0.83, 45.03],
        [0.40, 44.47, -0.82, 44.48],
        [0.45, 43.93, -0.82, 43.94],
        [0.50, 43.40, -0.81, 43.41],
        [0.55, 42.89, -0.80, 42.90],
    ],

    ("Er", None): [
        [0.01, 8.13, -0.04,  8.13],
        [0.02, 8.12, -0.04,  8.12],
        [0.03, 8.11, -0.04,  8.11],
        [0.04, 8.10, -0.05,  8.10],
        [0.05, 8.09, -0.05,  8.09],
        [0.06, 8.08, -0.05,  8.08],
        [0.07, 8.07, -0.05,  8.07],
        [0.08, 8.06, -0.06,  8.06],
        [0.09, 8.05, -0.06,  8.06],
        [0.10, 8.04, -0.06,  8.04],
        [0.11, 8.03, -0.06,  8.03],
        [0.12, 8.01, -0.07,  8.02],
        [0.13, 8.00, -0.07,  8.00],
        [0.14, 7.99, -0.07,  7.99],
        [0.15, 7.97, -0.08,  7.97],
        [0.16, 7.96, -0.08,  7.96],
        [0.17, 7.94, -0.09,  7.94],
        [0.18, 7.92, -0.09,  7.92],
        [0.19, 7.90, -0.10,  7.90],
        [0.20, 7.88, -0.11,  7.88],
        [0.21, 7.86, -0.11,  7.86],
        [0.22, 7.83, -0.12,  7.84],
        [0.23, 7.81, -0.13,  7.81],
        [0.24, 7.78, -0.14,  7.78],
        [0.25, 7.75, -0.15,  7.76],
        [0.26, 7.72, -0.17,  7.72],
        [0.27, 7.69, -0.18,  7.69],
        [0.28, 7.65, -0.20,  7.65],
        [0.29, 7.61, -0.22,  7.61],
        [0.30, 7.57, -0.24,  7.57],
        [0.31, 7.52, -0.27,  7.52],
        [0.32, 7.46, -0.30,  7.47],
        [0.33, 7.41, -0.34,  7.41],
        [0.34, 7.34, -0.39,  7.35],
        [0.35, 7.27, -0.44,  7.28],
        [0.36, 7.19, -0.52,  7.21],
        [0.37, 7.11, -0.61,  7.13],
        [0.38, 7.02, -0.72,  7.06],
        [0.39, 6.92, -0.87,  6.98],
        [0.40, 6.84, -1.05,  6.92],
        [0.41, 6.76, -1.30,  6.89],
        [0.42, 6.74, -1.61,  6.93],
        [0.43, 6.80, -2.00,  7.09],
        [0.44, 7.02, -2.41,  7.42],
        [0.45, 7.42, -2.76,  7.92],
        [0.46, 7.97, -2.92,  8.49],
        [0.47, 8.52, -2.82,  8.98],
        [0.48, 8.92, -2.53,  9.27],
        [0.49, 9.12, -2.18,  9.37],
        [0.50, 9.16, -1.87,  9.35],
        [0.51, 9.11, -1.65,  9.25],
        [0.52, 9.01, -1.52,  9.13],
        [0.53, 8.89, -1.47,  9.01],
        [0.54, 8.80, -1.51,  8.92],
        [0.55, 8.75, -1.62,  8.90],
        [0.56, 8.78, -1.79,  8.96],
        [0.57, 8.95, -1.97,  9.16],
        [0.58, 9.24, -2.07,  9.47],
        [0.59, 9.58, -2.01,  9.79],
        [0.60, 9.87, -1.80, 10.03],
    ],

    ("Er", 167): [
        [0.01,  3.90,  -0.17,  3.90],
        [0.02,  3.86,  -0.17,  3.87],
        [0.03,  3.82,  -0.18,  3.83],
        [0.04,  3.79,  -0.19,  3.79],
        [0.05,  3.75,  -0.19,  3.75],
        [0.06,  3.70,  -0.20,  3.71],
        [0.07,  3.66,  -0.21,  3.66],
        [0.08,  3.61,  -0.22,  3.62],
        [0.09,  3.56,  -0.23,  3.57],
        [0.10,  3.51,  -0.25,  3.52],
        [0.11,  3.46,  -0.26,  3.47],
        [0.12,  3.40,  -0.27,  3.41],
        [0.13,  3.34,  -0.29,  3.35],
        [0.14,  3.28,  -0.30,  3.29],
        [0.15,  3.21,  -0.32,  3.23],
        [0.16,  3.14,  -0.34,  3.16],
        [0.17,  3.07,  -0.36,  3.09],
        [0.18,  2.99,  -0.38,  3.01],
        [0.19,  2.90,  -0.41,  2.93],
        [0.20,  2.82,  -0.44,  2.85],
        [0.21,  2.72,  -0.47,  2.76],
        [0.22,  2.62,  -0.50,  2.66],
        [0.23,  2.51,  -0.54,  2.56],
        [0.24,  2.39,  -0.59,  2.46],
        [0.25,  2.26,  -0.64,  2.35],
        [0.26,  2.12,  -0.69,  2.23],
        [0.27,  1.97,  -0.76,  2.11],
        [0.28,  1.81,  -0.83,  1.99],
        [0.29,  1.64,  -0.92,  1.88],
        [0.30,  1.44,  -1.02,  1.77],
        [0.31,  1.23,  -1.14,  1.68],
        [0.32,  1.00,  -1.28,  1.62],
        [0.33,  0.75,  -1.45,  1.63],
        [0.34,  0.46,  -1.65,  1.72],
        [0.35,  0.15,  -1.90,  1.91],
        [0.36, -0.18,  -2.21,  2.22],
        [0.37, -0.55,  -2.60,  2.66],
        [0.38, -0.95,  -3.10,  3.24],
        [0.39, -1.36,  -3.74,  3.98],
        [0.40, -1.75,  -4.57,  4.89],
        [0.41, -2.06,  -5.64,  6.00],
        [0.42, -2.18,  -7.01,  7.34],
        [0.43, -1.90,  -8.67,  8.88],
        [0.44, -0.96, -10.48, 10.52],
        [0.45,  0.81, -12.01, 12.04],
        [0.46,  3.22, -12.70, 13.10],
        [0.47,  5.62, -12.26, 13.49],
        [0.48,  7.35, -10.99, 13.22],
        [0.49,  8.22,  -9.47, 12.54],
        [0.50,  8.40,  -8.14, 11.70],
        [0.51,  8.17,  -7.16, 10.86],
        [0.52,  7.73,  -6.58, 10.15],
        [0.53,  7.24,  -6.38,  9.65],
        [0.54,  6.82,  -6.54,  9.45],
        [0.55,  6.60,  -7.03,  9.64],
        [0.56,  6.76,  -7.79, 10.31],
        [0.57,  7.48,  -8.57, 11.37],
        [0.58,  8.75,  -9.00, 12.55],
        [0.59, 10.26,  -8.73, 13.47],
        [0.60, 11.49,  -7.81, 13.89],
    ],

    ("Yb", None): [
        [0.02, 12.36, -0.02, 12.36],
        [0.04, 12.35, -0.02, 12.35],
        [0.06, 12.35, -0.02, 12.35],
        [0.08, 12.34, -0.02, 12.34],
        [0.10, 12.34, -0.02, 12.34],
        [0.12, 12.33, -0.02, 12.33],
        [0.14, 12.33, -0.02, 12.33],
        [0.16, 12.32, -0.03, 12.32],
        [0.18, 12.32, -0.03, 12.32],
        [0.20, 12.32, -0.03, 12.32],
        [0.22, 12.31, -0.03, 12.31],
        [0.24, 12.31, -0.03, 12.31],
        [0.26, 12.30, -0.03, 12.30],
        [0.28, 12.30, -0.03, 12.30],
        [0.30, 12.29, -0.03, 12.29],
        [0.32, 12.28, -0.03, 12.28],
        [0.34, 12.28, -0.03, 12.28],
        [0.36, 12.27, -0.04, 12.27],
        [0.38, 12.27, -0.04, 12.27],
        [0.40, 12.26, -0.04, 12.26],
        [0.42, 12.25, -0.04, 12.25],
        [0.44, 12.24, -0.04, 12.24],
        [0.46, 12.23, -0.05, 12.23],
        [0.48, 12.22, -0.05, 12.22],
        [0.50, 12.21, -0.06, 12.21],
        [0.52, 12.19, -0.07, 12.19],
        [0.54, 12.17, -0.10, 12.17],
        [0.56, 12.15, -0.15, 12.15],
        [0.58, 12.17, -0.23, 12.17],
        [0.60, 12.28, -0.28, 12.29],
        [0.62, 12.37, -0.20, 12.37],
        [0.64, 12.37, -0.13, 12.37],
        [0.66, 12.35, -0.09, 12.35],
        [0.68, 12.33, -0.07, 12.33],
        [0.70, 12.32, -0.06, 12.32],
        [0.72, 12.30, -0.06, 12.30],
        [0.74, 12.29, -0.05, 12.29],
        [0.76, 12.28, -0.05, 12.28],
        [0.78, 12.27, -0.05, 12.27],
        [0.80, 12.27, -0.05, 12.27],
    ],

    ("Yb", 168): [
        [0.02,  -3.95,   -0.61,   3.99],
        [0.04,  -4.34,   -0.66,   4.39],
        [0.06,  -4.76,   -0.71,   4.81],
        [0.08,  -5.22,   -0.76,   5.27],
        [0.10,  -5.71,   -0.82,   5.76],
        [0.12,  -6.24,   -0.90,   6.30],
        [0.14,  -6.81,   -0.98,   6.88],
        [0.16,  -7.44,   -1.07,   7.52],
        [0.18,  -8.13,   -1.17,   8.21],
        [0.20,  -8.88,   -1.29,   8.98],
        [0.22,  -9.72,   -1.43,   9.82],
        [0.24, -10.64,   -1.60,  10.76],
        [0.26, -11.67,   -1.79,  11.81],
        [0.28, -12.83,   -2.03,  12.99],
        [0.30, -14.14,   -2.31,  14.33],
        [0.32, -15.63,   -2.65,  15.85],
        [0.34, -17.34,   -3.08,  17.61],
        [0.36, -19.33,   -3.61,  19.66],
        [0.38, -21.66,   -4.30,  22.08],
        [0.40, -24.42,   -5.20,  24.97],
        [0.42, -27.75,   -6.41,  28.48],
        [0.44, -31.84,   -8.08,  32.85],
        [0.46, -36.93,  -10.49,  38.39],
        [0.48, -43.43,  -14.12,  45.67],
        [0.50, -51.87,  -19.91,  55.56],
        [0.52, -62.92,  -29.83,  69.63],
        [0.54, -76.75,  -48.32,  90.69],
        [0.56, -88.95,  -85.36, 123.28],
        [0.58, -71.67, -152.27, 168.29],
        [0.60,  23.93, -191.11, 192.60],
        [0.62,  96.96, -130.07, 162.24],
        [0.64,  99.91,  -71.89, 123.09],
        [0.66,  86.20,  -41.89,  95.84],
        [0.68,  73.22,  -26.63,  77.91],
        [0.70,  63.08,  -18.21,  65.65],
        [0.72,  55.33,  -13.17,  56.87],
        [0.74,  49.33,   -9.94,  50.32],
        [0.76,  44.58,   -7.76,  45.25],
        [0.78,  40.76,   -6.23,  41.23],
        [0.80,  37.62,   -5.10,  37.97],
    ],

    ("Yb", 174): [
        [0.05, 19.18, -0.04, 19.18],
        [0.10, 19.15, -0.04, 19.15],
        [0.15, 19.12, -0.05, 19.12],
        [0.20, 19.10, -0.05, 19.10],
        [0.25, 19.07, -0.06, 19.07],
        [0.30, 19.04, -0.06, 19.04],
        [0.35, 19.01, -0.07, 19.01],
        [0.40, 18.98, -0.07, 18.98],
        [0.45, 18.95, -0.07, 18.95],
        [0.50, 18.92, -0.07, 18.92],
        [0.55, 18.89, -0.08, 18.89],
    ],

    ("Lu", 176): [
        [0.01,  6.30, -0.44,  6.31],
        [0.02,  6.16, -0.52,  6.18],
        [0.03,  6.00, -0.61,  6.03],
        [0.04,  5.82, -0.74,  5.87],
        [0.05,  5.62, -0.89,  5.69],
        [0.06,  5.38, -1.10,  5.49],
        [0.07,  5.10, -1.37,  5.28],
        [0.08,  4.79, -1.76,  5.10],
        [0.09,  4.46, -2.30,  5.02],
        [0.10,  4.15, -3.09,  5.17],
        [0.11,  3.98, -4.23,  5.81],
        [0.12,  4.27, -5.77,  7.18],
        [0.13,  5.49, -7.48,  9.27],
        [0.14,  7.83, -8.44, 11.51],
        [0.15, 10.35, -7.86, 12.99],
        [0.16, 11.88, -6.25, 13.42],
        [0.17, 12.36, -4.63, 13.20],
        [0.18, 12.28, -3.40, 12.74],
        [0.19, 11.99, -2.54, 12.26],
        [0.20, 11.66, -1.95, 11.82],
        [0.21, 11.34, -1.54, 11.44],
        [0.22, 11.06, -1.25, 11.13],
        [0.23, 10.81, -1.04, 10.86],
        [0.24, 10.59, -0.88, 10.63],
        [0.25, 10.41, -0.76, 10.44],
        [0.26, 10.25, -0.67, 10.27],
        [0.27, 10.10, -0.59, 10.12],
        [0.28,  9.98, -0.54,  9.99],
        [0.29,  9.87, -0.49,  9.88],
        [0.30,  9.77, -0.45,  9.78],
        [0.31,  9.68, -0.42,  9.69],
        [0.32,  9.60, -0.39,  9.61],
        [0.33,  9.53, -0.37,  9.54],
        [0.34,  9.47, -0.35,  9.48],
        [0.35,  9.41, -0.34,  9.42],
        [0.36,  9.36, -0.33,  9.36],
        [0.37,  9.31, -0.32,  9.31],
        [0.38,  9.26, -0.31,  9.27],
        [0.39,  9.22, -0.30,  9.22],
        [0.40,  9.18, -0.29,  9.19],
        [0.41,  9.14, -0.29,  9.15],
        [0.42,  9.11, -0.28,  9.12],
        [0.43,  9.08, -0.28,  9.08],
        [0.44,  9.05, -0.27,  9.05],
        [0.45,  9.02, -0.27,  9.03],
        [0.46,  9.00, -0.27,  9.00],
        [0.47,  8.97, -0.26,  8.98],
        [0.48,  8.95, -0.26,  8.95],
        [0.49,  8.93, -0.26,  8.93],
        [0.50,  8.91, -0.26,  8.91],
    ],
}