// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepFeat_Builder_HeaderFile
#define _BRepFeat_Builder_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <BOPCol_MapOfShape.hxx>
#include <Standard_Integer.hxx>
#include <BOPAlgo_BOP.hxx>
#include <Standard_Boolean.hxx>
#include <BOPCol_ListOfShape.hxx>
#include <BOPCol_DataMapOfShapeListOfShape.hxx>
#include <BOPCol_DataMapOfShapeShape.hxx>
#include <BOPCol_BaseAllocator.hxx>
class TopoDS_Shape;
class TopTools_ListOfShape;
class TopoDS_Face;


//! Provides a basic tool to implement features topological
//! operations. The main goal of the algorithm is to perform
//! the result of the operation according to the
//! kept parts of the tool.
//! Input data: a) DS;
//! b) The kept parts of the tool;
//! If the map of the kept parts of the tool
//! is not filled boolean operation of the
//! given type will be performed;
//! c) Operation required.
//! Steps: a) Fill myShapes, myRemoved maps;
//! b) Rebuild edges and faces;
//! c) Build images of the object;
//! d) Build the result of the operation.
//! Result: Result shape of the operation required.
class BRepFeat_Builder  : public BOPAlgo_BOP
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT BRepFeat_Builder();
Standard_EXPORT virtual ~BRepFeat_Builder();
  
  //! Clears internal fields and arguments.
  Standard_EXPORT virtual   void Clear() ;
  
  //! Initialyzes the object of local boolean operation.
  Standard_EXPORT   void Init (const TopoDS_Shape& theShape) ;
  
  //! Initialyzes the arguments of local boolean operation.
  Standard_EXPORT   void Init (const TopoDS_Shape& theShape, const TopoDS_Shape& theTool) ;
  
  //! Sets the operation of local boolean operation.
  //! If theFuse = 0 than the operation is CUT, otherwise FUSE.
  Standard_EXPORT   void SetOperation (const Standard_Integer theFuse) ;
  
  //! Sets the operation of local boolean operation.
  //! If theFlag = TRUE it means that no selection of parts
  //! of the tool is needed, t.e. no second part. In that case
  //! if theFuse = 0 than operation is COMMON, otherwise CUT21.
  //! If theFlag = FALSE SetOperation(theFuse) function  is called.
  Standard_EXPORT   void SetOperation (const Standard_Integer theFuse, const Standard_Boolean theFlag) ;
  
  //! Collects parts of the tool.
  Standard_EXPORT   void PartsOfTool (TopTools_ListOfShape& theLT) ;
  
  //! Initialyzes parts of the tool for second step of algorithm.
  //! Collects shapes and all sub-shapes into myShapes map.
  Standard_EXPORT   void KeepParts (const TopTools_ListOfShape& theIm) ;
  
  //! Adds shape theS and all its sub-shapes into myShapes map.
  Standard_EXPORT   void KeepPart (const TopoDS_Shape& theS) ;
  
  //! Main function to build the result of the
  //! local operation required.
  Standard_EXPORT   void PerformResult() ;
  
  //! Rebuilds faces in accordance with the kept parts of the tool.
  Standard_EXPORT   void RebuildFaces() ;
  
  //! Rebuilds edges in accordance with the kept parts of the tool.
  Standard_EXPORT   void RebuildEdge (const TopoDS_Shape& theE, const TopoDS_Face& theF, const BOPCol_MapOfShape& theME, BOPCol_ListOfShape& aLEIm) ;
  
  //! Collects the images of the object, that contains in
  //! the images of the tool.
  Standard_EXPORT   void CheckSolidImages() ;
  
  //! Collects the removed parts of the tool into myRemoved map.
  Standard_EXPORT   void FillRemoved() ;
  
  //! Adds the shape S and its sub-shapes into myRemoved map.
  Standard_EXPORT   void FillRemoved (const TopoDS_Shape& theS, BOPCol_MapOfShape& theM) ;




protected:

  
  //! Prepares builder of local operation.
  Standard_EXPORT virtual   void Prepare() ;
  
  //! Function is redefined to avoid the usage of removed faces.
  Standard_EXPORT virtual   void FillIn3DParts (BOPCol_DataMapOfShapeListOfShape& theInParts, BOPCol_DataMapOfShapeShape& theDraftSolids, const BOPCol_BaseAllocator& theAllocator) ;


  BOPCol_MapOfShape myShapes;
  BOPCol_MapOfShape myRemoved;
  Standard_Integer myFuse;


private:





};







#endif // _BRepFeat_Builder_HeaderFile
