/*
 * @file    TestInternalConsistencyChecks.java
 * @brief   Tests the internal consistency validation.
 *
 * @author  Akiya Jouraku (Java conversion)
 * @author  Sarah Keating 
 * 
 * ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
 *
 * DO NOT EDIT THIS FILE.
 *
 * This file was generated automatically by converting the file located at
 * src/sbml/test/TestInternalConsistencyChecks.cpp
 * using the conversion program dev/utilities/translateTests/translateTests.pl.
 * Any changes made here will be lost the next time the file is regenerated.
 *
 * -----------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright (C) 2020 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. University of Heidelberg, Heidelberg, Germany
 *     3. University College London, London, UK
 *
 * Copyright 2005-2010 California Institute of Technology.
 * Copyright 2002-2005 California Institute of Technology and
 *                     Japan Science and Technology Corporation.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * -----------------------------------------------------------------------------
 */

package org.sbml.libsbml.test.sbml;

import org.sbml.libsbml.*;

import java.io.File;
import java.lang.AssertionError;

public class TestInternalConsistencyChecks {

  static void assertTrue(boolean condition) throws AssertionError
  {
    if (condition == true)
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      return;
    }
    else if ( (a == null) || (b == null) )
    {
      throw new AssertionError();
    }
    else if (a.equals(b))
    {
      return;
    }

    throw new AssertionError();
  }

  static void assertNotEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      throw new AssertionError();
    }
    else if ( (a == null) || (b == null) )
    {
      return;
    }
    else if (a.equals(b))
    {
      throw new AssertionError();
    }
  }

  static void assertEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(int a, int b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(int a, int b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }

  public void test_internal_consistency_check_20306()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    FunctionDefinition fd = m.createFunctionDefinition();
    fd.setId("fd");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20306 );
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    fd.setMath(ast);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20307()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    FunctionDefinition fd = m.createFunctionDefinition();
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    fd.setMath(ast);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20307 );
    fd.setId("fd");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20419()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    UnitDefinition ud = m.createUnitDefinition();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20419 );
    ud.setId("ud");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20421()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    UnitDefinition ud = m.createUnitDefinition();
    ud.setId("ud");
    Unit u = ud.createUnit();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 4 );
    assertTrue( d.getError(0).getErrorId() == 20421 );
    assertTrue( d.getError(1).getErrorId() == 20421 );
    assertTrue( d.getError(2).getErrorId() == 20421 );
    assertTrue( d.getError(3).getErrorId() == 20421 );
    u.setKind(libsbml.UNIT_KIND_MOLE);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 3 );
    assertTrue( d.getError(0).getErrorId() == 20421 );
    assertTrue( d.getError(1).getErrorId() == 20421 );
    assertTrue( d.getError(2).getErrorId() == 20421 );
    u.setExponent(1.0);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 2 );
    assertTrue( d.getError(0).getErrorId() == 20421 );
    assertTrue( d.getError(1).getErrorId() == 20421 );
    u.setScale(0);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20421 );
    u.setMultiplier(1.0);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20517()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 2 );
    assertTrue( d.getError(0).getErrorId() == 20517 );
    assertTrue( d.getError(1).getErrorId() == 20517 );
    c.setId("c");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20517 );
    c.setConstant(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20623()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    c.setConstant(true);
    Species s = m.createSpecies();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 5 );
    assertTrue( d.getError(0).getErrorId() == 20623 );
    assertTrue( d.getError(1).getErrorId() == 20614 );
    assertTrue( d.getError(2).getErrorId() == 20623 );
    assertTrue( d.getError(3).getErrorId() == 20623 );
    assertTrue( d.getError(4).getErrorId() == 20623 );
    s.setId("s");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 4 );
    assertTrue( d.getError(0).getErrorId() == 20614 );
    assertTrue( d.getError(1).getErrorId() == 20623 );
    assertTrue( d.getError(2).getErrorId() == 20623 );
    assertTrue( d.getError(3).getErrorId() == 20623 );
    s.setCompartment("c");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 3 );
    assertTrue( d.getError(0).getErrorId() == 20623 );
    assertTrue( d.getError(1).getErrorId() == 20623 );
    assertTrue( d.getError(2).getErrorId() == 20623 );
    s.setHasOnlySubstanceUnits(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 2 );
    assertTrue( d.getError(0).getErrorId() == 20623 );
    assertTrue( d.getError(1).getErrorId() == 20623 );
    s.setBoundaryCondition(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20623 );
    s.setConstant(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20706()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Parameter p = m.createParameter();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 2 );
    assertTrue( d.getError(0).getErrorId() == 20706 );
    assertTrue( d.getError(1).getErrorId() == 20706 );
    p.setId("c");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20706 );
    p.setConstant(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20804()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    InitialAssignment ia = m.createInitialAssignment();
    ia.setSymbol("fd");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20804 );
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    ia.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20805()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    InitialAssignment ia = m.createInitialAssignment();
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    ia.setMath(ast);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20805 );
    ia.setSymbol("fd");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20907_alg()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    AlgebraicRule r = m.createAlgebraicRule();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20907 );
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    r.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20907_assign()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    AssignmentRule r = m.createAssignmentRule();
    r.setVariable("fd");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20907 );
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    r.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20907_rate()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    RateRule r = m.createRateRule();
    r.setVariable("fd");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20907 );
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    r.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20908()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    AssignmentRule r = m.createAssignmentRule();
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    r.setMath(ast);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20908 );
    r.setVariable("fd");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_20909()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    RateRule r = m.createRateRule();
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    r.setMath(ast);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20909 );
    r.setVariable("fd");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21007()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Constraint r = m.createConstraint();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21007 );
    ASTNode ast = libsbml.parseFormula("lambda(x, 2*x)");
    r.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21101()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Reaction r = m.createReaction();
    r.setId("r");
    r.setReversible(true);
    r.setFast(false);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21101 );
    SpeciesReference sr = r.createReactant();
    sr.setSpecies("s");
    sr.setConstant(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21110()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Reaction r = m.createReaction();
    SpeciesReference sr = r.createProduct();
    sr.setSpecies("s");
    sr.setConstant(true);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 3 );
    assertTrue( d.getError(0).getErrorId() == 21110 );
    assertTrue( d.getError(1).getErrorId() == 21110 );
    assertTrue( d.getError(2).getErrorId() == 21110 );
    r.setId("r");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 2 );
    assertTrue( d.getError(0).getErrorId() == 21110 );
    assertTrue( d.getError(1).getErrorId() == 21110 );
    r.setReversible(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21110 );
    r.setFast(false);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21116()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Reaction r = m.createReaction();
    r.setId("r");
    r.setReversible(true);
    r.setFast(false);
    SpeciesReference sr = r.createReactant();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 2 );
    assertTrue( d.getError(0).getErrorId() == 21116 );
    assertTrue( d.getError(1).getErrorId() == 21116 );
    sr.setSpecies("s");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21116 );
    sr.setConstant(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21117()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Reaction r = m.createReaction();
    r.setId("r");
    r.setReversible(true);
    r.setFast(false);
    SpeciesReference sr = r.createReactant();
    sr.setSpecies("s");
    sr.setConstant(true);
    ModifierSpeciesReference msr = r.createModifier();
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21117 );
    msr.setSpecies("s");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21130()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Reaction r = m.createReaction();
    r.setId("r");
    r.setReversible(true);
    r.setFast(false);
    SpeciesReference sr = r.createReactant();
    sr.setSpecies("s");
    sr.setConstant(true);
    KineticLaw kl = r.createKineticLaw();
    LocalParameter lp = kl.createLocalParameter();
    lp.setId("s");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21130 );
    ASTNode ast = libsbml.parseFormula("2*x");
    kl.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21172()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Reaction r = m.createReaction();
    r.setId("r");
    r.setReversible(true);
    r.setFast(false);
    SpeciesReference sr = r.createReactant();
    sr.setSpecies("s");
    sr.setConstant(true);
    KineticLaw kl = r.createKineticLaw();
    ASTNode ast = libsbml.parseFormula("2*x");
    kl.setMath(ast);
    LocalParameter lp = kl.createLocalParameter();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21172 );
    lp.setId("pp");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21201()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Event r = m.createEvent();
    r.setUseValuesFromTriggerTime(true);
    EventAssignment ea = r.createEventAssignment();
    ea.setVariable("s");
    ASTNode ast = libsbml.parseFormula("2*x");
    ea.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21201 );
    Trigger t = r.createTrigger();
    t.setPersistent(true);
    t.setInitialValue(false);
    t.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21203()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Event r = m.createEvent();
    r.setUseValuesFromTriggerTime(true);
    ASTNode ast = libsbml.parseFormula("2*x");
    Trigger t = r.createTrigger();
    t.setMath(ast);
    t.setPersistent(true);
    t.setInitialValue(false);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    //assertTrue( d.getError(0).getErrorId() == 21203 );
    EventAssignment ea = r.createEventAssignment();
    ea.setVariable("ea");
    ea.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21209()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Event r = m.createEvent();
    r.setUseValuesFromTriggerTime(true);
    EventAssignment ea = r.createEventAssignment();
    ea.setVariable("s");
    ASTNode ast = libsbml.parseFormula("2*x");
    ea.setMath(ast);
    Trigger t = r.createTrigger();
    t.setPersistent(true);
    t.setInitialValue(false);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21209 );
    t.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21210()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Event r = m.createEvent();
    r.setUseValuesFromTriggerTime(true);
    ASTNode ast = libsbml.parseFormula("2*x");
    Trigger t = r.createTrigger();
    t.setMath(ast);
    t.setPersistent(true);
    t.setInitialValue(false);
    EventAssignment ea = r.createEventAssignment();
    ea.setVariable("ea");
    ea.setMath(ast);
    Delay delay = r.createDelay();
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21210 );
    delay.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21213()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Event r = m.createEvent();
    r.setUseValuesFromTriggerTime(true);
    EventAssignment ea = r.createEventAssignment();
    ea.setVariable("s");
    ASTNode ast = libsbml.parseFormula("2*x");
    Trigger t = r.createTrigger();
    t.setPersistent(true);
    t.setInitialValue(false);
    t.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21213 );
    ea.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21214()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Event r = m.createEvent();
    r.setUseValuesFromTriggerTime(true);
    EventAssignment ea = r.createEventAssignment();
    ASTNode ast = libsbml.parseFormula("2*x");
    ea.setMath(ast);
    Trigger t = r.createTrigger();
    t.setPersistent(true);
    t.setInitialValue(false);
    t.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21214 );
    ea.setVariable("s");
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21225()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Event r = m.createEvent();
    EventAssignment ea = r.createEventAssignment();
    ea.setVariable("s");
    ASTNode ast = libsbml.parseFormula("2*x");
    ea.setMath(ast);
    Trigger t = r.createTrigger();
    t.setPersistent(true);
    t.setInitialValue(false);
    t.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21225 );
    r.setUseValuesFromTriggerTime(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21226()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Event r = m.createEvent();
    r.setUseValuesFromTriggerTime(true);
    EventAssignment ea = r.createEventAssignment();
    ea.setVariable("s");
    ASTNode ast = libsbml.parseFormula("2*x");
    ea.setMath(ast);
    Trigger t = r.createTrigger();
    t.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 2 );
    assertTrue( d.getError(0).getErrorId() == 21226 );
    assertTrue( d.getError(1).getErrorId() == 21226 );
    t.setPersistent(true);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21226 );
    t.setInitialValue(false);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_21231()
  {
    SBMLDocument d = new SBMLDocument(3,1);
    long errors;
    Model m = d.createModel();
    Event r = m.createEvent();
    r.setUseValuesFromTriggerTime(true);
    ASTNode ast = libsbml.parseFormula("2*x");
    Trigger t = r.createTrigger();
    t.setMath(ast);
    t.setPersistent(true);
    t.setInitialValue(false);
    EventAssignment ea = r.createEventAssignment();
    ea.setVariable("ea");
    ea.setMath(ast);
    Priority prior = r.createPriority();
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21231 );
    prior.setMath(ast);
    d.getErrorLog().clearLog();
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99901()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Compartment c = new Compartment(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    long dim = 2;
    c.setSpatialDimensions(dim);
    c.setId("c");
    m.addCompartment(c);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 10103 );
    d = null;
  }

  public void test_internal_consistency_check_99902()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Compartment c = new Compartment(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    c.setCompartmentType("hh");
    c.setId("c");
    m.addCompartment(c);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 10103 );
    d = null;
  }

  public void test_internal_consistency_check_99903()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Compartment c = new Compartment(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    c.setConstant(true);
    c.setId("c");
    m.addCompartment(c);
    Rule r = m.createAssignmentRule();
    r.setVariable("c");
    r.setFormula("2*3");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 3 );
    d = null;
  }

  public void test_internal_consistency_check_99903_localparam()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Parameter p = new Parameter(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    Reaction r = m.createReaction();
    r.setId("r");
    SpeciesReference sr = r.createReactant();
    sr.setSpecies("s");
    KineticLaw kl = r.createKineticLaw();
    kl.setFormula("2");
    p.setId("p");
    p.setConstant(false);
    kl.addParameter(p);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99903_param()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Parameter p = new Parameter(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    p.setConstant(true);
    p.setId("c");
    m.addParameter(p);
    Rule r = m.createAssignmentRule();
    r.setVariable("c");
    r.setFormula("2*3");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 2 );
    d = null;
  }

  public void test_internal_consistency_check_99904()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Compartment c = new Compartment(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    c.setId("c");
    c.setMetaId("mmm");
    m.addCompartment(c);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 10103 );
    d = null;
  }

  public void test_internal_consistency_check_99904_kl()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    KineticLaw kl = new KineticLaw(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(1,2,false);
    Compartment c = m.createCompartment();
    c.setId("cc");
    Reaction r = m.createReaction();
    r.setId("r");
    SpeciesReference sr = r.createReactant();
    sr.setSpecies("s");
    kl.setFormula("2");
    kl.setMetaId("mmm");
    r.setKineticLaw(kl);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99904_model()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    d.setLevelAndVersion(1,2,false);
    Model m = new Model(2,4);
    Compartment c = m.createCompartment();
    c.setId("cc");
    m.setMetaId("mmm");
    d.setModel(m);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20201 );
    d = null;
  }

  public void test_internal_consistency_check_99904_param()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Parameter p = new Parameter(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    p.setId("p");
    p.setMetaId("mmm");
    m.addParameter(p);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99904_react()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Reaction r = new Reaction(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    r.setId("r");
    r.setMetaId("mmm");
    m.addReaction(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99904_rule_alg()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Rule r = new AlgebraicRule(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    r.setMetaId("mmm");
    r.setFormula("2");
    m.addRule(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99904_rule_assign()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Rule r = new AssignmentRule(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    c.setConstant(false);
    r.setVariable("cc");
    r.setFormula("2");
    r.setMetaId("mmm");
    m.addRule(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99904_rule_rate()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Rule r = new RateRule(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    c.setConstant(false);
    r.setVariable("cc");
    r.setFormula("2");
    r.setMetaId("mmm");
    m.addRule(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99904_species()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Species s = new Species(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    s.setCompartment("c");
    s.setId("s");
    s.setMetaId("mmm");
    m.addSpecies(s);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99904_speciesRef()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    SpeciesReference sr = new SpeciesReference(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    Species s = m.createSpecies();
    s.setId("s");
    s.setCompartment("c");
    Reaction r = m.createReaction();
    r.setId("r");
    sr.setSpecies("s");
    sr.setMetaId("mmm");
    r.addProduct(sr);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21101 );
    d = null;
  }

  public void test_internal_consistency_check_99904_unit()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Unit u = new Unit(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    UnitDefinition ud = m.createUnitDefinition();
    ud.setId("ud");
    u.setMetaId("mmm");
    u.setKind(libsbml.UNIT_KIND_MOLE);
    ud.addUnit(u);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99904_unitdef()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    UnitDefinition u = new UnitDefinition(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    u.setId("ud");
    u.setMetaId("mmm");
    u.createUnit();
    m.addUnitDefinition(u);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99905()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Compartment c = new Compartment(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    c.setId("c");
    c.setSBOTerm(2);
    m.addCompartment(c);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 10103 );
    d = null;
  }

  public void test_internal_consistency_check_99905_ct()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    CompartmentType ct = new CompartmentType(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(2,2,false);
    ct.setId("ct");
    ct.setSBOTerm(5);
    m.addCompartmentType(ct);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99905_delay()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Delay delay = new Delay(2,4);
    Event e = new Event(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(2,2,false);
    delay.setSBOTerm(5);
    e.setDelay(delay);
    m.addEvent(e);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99905_species()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Species s = new Species(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    s.setId("s");
    s.setCompartment("c");
    s.setSBOTerm(2);
    m.addSpecies(s);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99905_st()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    SpeciesType ct = new SpeciesType(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(2,2,false);
    ct.setId("st");
    ct.setSBOTerm(5);
    m.addSpeciesType(ct);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99905_stoichmath()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    StoichiometryMath sm = new StoichiometryMath(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(2,2,false);
    Species s = m.createSpecies();
    s.setId("s");
    Compartment c = m.createCompartment();
    c.setId("c");
    s.setCompartment("c");
    Reaction r = m.createReaction();
    r.setId("r");
    SpeciesReference sr = r.createProduct();
    sr.setSpecies("s");
    sm.setSBOTerm(5);
    sr.setStoichiometryMath(sm);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99905_trigger()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Trigger trigger = new Trigger(2,4);
    Event e = new Event(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(2,2,false);
    trigger.setSBOTerm(5);
    e.setTrigger(trigger);
    m.addEvent(e);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99905_unit()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Unit u = new Unit(2,4);
    d.setLevelAndVersion(2,2,false);
    Model m = d.createModel();
    UnitDefinition ud = m.createUnitDefinition();
    ud.setId("ud");
    u.setKind(libsbml.UNIT_KIND_MOLE);
    u.setSBOTerm(9);
    ud.addUnit(u);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99905_unitdef()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    UnitDefinition u = new UnitDefinition(2,4);
    d.setLevelAndVersion(2,2,false);
    Model m = d.createModel();
    u.setId("ud");
    u.setSBOTerm(9);
    u.createUnit();
    m.addUnitDefinition(u);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99906()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Compartment c = new Compartment(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    c.setId("c");
    c.setUnits("mole");
    m.addCompartment(c);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 10103 );
    d = null;
  }

  public void test_internal_consistency_check_99907()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Compartment c = new Compartment(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    c.setId("c");
    c.unsetVolume();
    m.addCompartment(c);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 10103 );
    d = null;
  }

  public void test_internal_consistency_check_99908()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    CompartmentType ct = new CompartmentType(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(2,1,false);
    ct.setId("ct");
    m.addCompartmentType(ct);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99909()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Constraint ct = new Constraint(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(2,1,false);
    m.addConstraint(ct);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99910()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Event e = new Event(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(1,2,false);
    Compartment c = m.createCompartment();
    c.setId("cc");
    c.setConstant(false);
    m.addEvent(e);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99911_ea()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    d.setLevelAndVersion(2,1,false);
    long errors;
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    c.setConstant(false);
    Event e = m.createEvent();
    ASTNode ast = libsbml.parseFormula("2*x");
    Trigger t = e.createTrigger();
    t.setMath(ast);
    EventAssignment ea = new EventAssignment(2,4);
    ea.setVariable("c");
    ea.setSBOTerm(2);
    ea.setMath(ast);
    e.addEventAssignment(ea);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21203 );
    d = null;
  }

  public void test_internal_consistency_check_99911_event()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Event e = new Event(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(2,1,false);
    e.setSBOTerm(2);
    m.addEvent(e);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99911_fd()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Model m = d.createModel();
    FunctionDefinition fd = new FunctionDefinition(2,4);
    d.setLevelAndVersion(2,1,false);
    fd.setId("fd");
    fd.setSBOTerm(2);
    m.addFunctionDefinition(fd);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99911_kl()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    d.setLevelAndVersion(2,1,false);
    long errors;
    Model m = d.createModel();
    Reaction r = m.createReaction();
    r.setId("r");
    SpeciesReference sr = r.createReactant();
    sr.setSpecies("s");
    KineticLaw kl = new KineticLaw(2,4);
    kl.setSBOTerm(2);
    Parameter p = kl.createParameter();
    p.setId("p");
    r.setKineticLaw(kl);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99911_model()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    d.setLevelAndVersion(2,1,false);
    Model m = new Model(2,4);
    m.setSBOTerm(2);
    d.setModel(m);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 20201 );
    d = null;
  }

  public void test_internal_consistency_check_99911_param()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Model m = d.createModel();
    Parameter p = new Parameter(2,4);
    d.setLevelAndVersion(2,1,false);
    p.setId("p");
    p.setSBOTerm(2);
    m.addParameter(p);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99911_react()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Model m = d.createModel();
    Reaction r = new Reaction(2,4);
    d.setLevelAndVersion(2,1,false);
    r.setId("r");
    r.setSBOTerm(2);
    m.addReaction(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99911_rule_alg()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Model m = d.createModel();
    Rule r = new AlgebraicRule(2,4);
    d.setLevelAndVersion(2,1,false);
    r.setSBOTerm(2);
    m.addRule(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99911_rule_assign()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Model m = d.createModel();
    Parameter p = m.createParameter();
    p.setId("p");
    p.setConstant(false);
    Rule r = new AssignmentRule(2,4);
    d.setLevelAndVersion(2,1,false);
    r.setVariable("p");
    r.setSBOTerm(2);
    m.addRule(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99911_rule_rate()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Model m = d.createModel();
    Parameter p = m.createParameter();
    p.setId("p");
    p.setConstant(false);
    Rule r = new RateRule(2,4);
    d.setLevelAndVersion(2,1,false);
    r.setVariable("p");
    r.setSBOTerm(2);
    m.addRule(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99911_speciesRef()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    SpeciesReference sr = new SpeciesReference(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    Species s = m.createSpecies();
    s.setId("s");
    Reaction r = m.createReaction();
    r.setId("r");
    s.setCompartment("c");
    sr.setSpecies("s");
    sr.setSBOTerm(4);
    r.addReactant(sr);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21101 );
    d = null;
  }

  public void test_internal_consistency_check_99912()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    FunctionDefinition fd = new FunctionDefinition(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(1,2,false);
    Compartment c = m.createCompartment();
    c.setId("cc");
    c.setConstant(false);
    m.addFunctionDefinition(fd);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99913()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    InitialAssignment ia = new InitialAssignment(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(1,2,false);
    Compartment c = m.createCompartment();
    c.setId("cc");
    c.setConstant(false);
    m.addInitialAssignment(ia);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99914()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Model m = d.createModel();
    Rule r = new AlgebraicRule(2,4);
    d.setLevelAndVersion(2,1,false);
    r.setVariable("kk");
    m.addRule(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99915_alg()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Model m = d.createModel();
    Rule r = new AlgebraicRule(2,4);
    d.setLevelAndVersion(2,1,false);
    r.setUnits("kk");
    m.addRule(r);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99915_assign()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    c.setConstant(false);
    AssignmentRule r = m.createAssignmentRule();
    r.setL1TypeCode(libsbml.SBML_SPECIES_CONCENTRATION_RULE);
    r.setVariable("c");
    r.setFormula("2");
    r.setUnits("mmm");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99915_rate()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    c.setConstant(false);
    RateRule r = m.createRateRule();
    r.setL1TypeCode(libsbml.SBML_SPECIES_CONCENTRATION_RULE);
    r.setFormula("2");
    r.setVariable("c");
    r.setUnits("mmm");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99916_reaction()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Species s = new Species(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    Reaction r = m.createReaction();
    r.setId("r");
    SpeciesReference sr = r.createReactant();
    s.setId("s");
    s.setCompartment("c");
    s.setConstant(true);
    sr.setSpecies("s");
    m.addSpecies(s);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99916_rule()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Species s = new Species(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    s.setId("s");
    s.setCompartment("c");
    s.setConstant(true);
    m.addSpecies(s);
    Rule r = m.createAssignmentRule();
    r.setVariable("s");
    r.setFormula("2");
    errors = d.checkInternalConsistency();
    assertTrue( errors == 2 );
    d = null;
  }

  public void test_internal_consistency_check_99917()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Species s = new Species(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    s.setId("s");
    s.setCompartment("c");
    s.setSpatialSizeUnits("kkk");
    m.addSpecies(s);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99918()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Species s = new Species(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    s.setId("s");
    s.setCompartment("c");
    s.setSpeciesType("kkk");
    m.addSpecies(s);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99919()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Species s = new Species(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    s.setId("s");
    s.setCompartment("c");
    s.setHasOnlySubstanceUnits(true);
    m.addSpecies(s);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99920()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    SpeciesReference sr = new SpeciesReference(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    Species s = m.createSpecies();
    s.setId("s");
    Reaction r = m.createReaction();
    r.setId("r");
    s.setCompartment("c");
    sr.setSpecies("s");
    sr.setId("mmm");
    r.addProduct(sr);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21101 );
    d = null;
  }

  public void test_internal_consistency_check_99921()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    SpeciesReference sr = new SpeciesReference(2,4);
    d.setLevelAndVersion(2,1,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("c");
    Species s = m.createSpecies();
    s.setId("s");
    Reaction r = m.createReaction();
    r.setId("r");
    s.setCompartment("c");
    sr.setSpecies("s");
    sr.setName("mmm");
    r.addReactant(sr);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 1 );
    assertTrue( d.getError(0).getErrorId() == 21101 );
    d = null;
  }

  public void test_internal_consistency_check_99922()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    SpeciesType ct = new SpeciesType(2,4);
    Model m = d.createModel();
    ct.setId("st");
    d.setLevelAndVersion(2,1,false);
    m.addSpeciesType(ct);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99923()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    StoichiometryMath sm = new StoichiometryMath(2,4);
    Model m = d.createModel();
    d.setLevelAndVersion(1,2,false);
    Species s = m.createSpecies();
    s.setId("s");
    Compartment c = m.createCompartment();
    c.setId("c");
    s.setCompartment("c");
    Reaction r = m.createReaction();
    r.setId("r");
    SpeciesReference sr = r.createProduct();
    sr.setSpecies("s");
    sr.setStoichiometryMath(sm);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99924()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Unit u = new Unit(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    UnitDefinition ud = m.createUnitDefinition();
    ud.setId("ud");
    u.setKind(libsbml.UNIT_KIND_MOLE);
    u.setMultiplier(9);
    ud.addUnit(u);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  public void test_internal_consistency_check_99925()
  {
    SBMLDocument d = new SBMLDocument(2,4);
    long errors;
    Unit u = new Unit(2,4);
    d.setLevelAndVersion(1,2,false);
    Model m = d.createModel();
    Compartment c = m.createCompartment();
    c.setId("cc");
    UnitDefinition ud = m.createUnitDefinition();
    ud.setId("ud");
    u.setKind(libsbml.UNIT_KIND_MOLE);
    u.setOffset(9);
    ud.addUnit(u);
    errors = d.checkInternalConsistency();
    assertTrue( errors == 0 );
    d = null;
  }

  /**
   * Loads the SWIG-generated libSBML Java module when this class is
   * loaded, or reports a sensible diagnostic message about why it failed.
   */
  static
  {
    String varname;
    String shlibname;

    if (System.getProperty("mrj.version") != null)
    {
      varname = "DYLD_LIBRARY_PATH";    // We're on a Mac.
      shlibname = "libsbmlj.jnilib and/or libsbml.dylib";
    }
    else
    {
      varname = "LD_LIBRARY_PATH";      // We're not on a Mac.
      shlibname = "libsbmlj.so and/or libsbml.so";
    }

    try
    {
      System.loadLibrary("sbmlj");
      // For extra safety, check that the jar file is in the classpath.
      Class.forName("org.sbml.libsbml.libsbml");
    }
    catch (SecurityException e)
    {
      e.printStackTrace();
      System.err.println("Could not load the libSBML library files due to a"+
                         " security exception.\n");
      System.exit(1);
    }
    catch (UnsatisfiedLinkError e)
    {
      e.printStackTrace();
      System.err.println("Error: could not link with the libSBML library files."+
                         " It is likely\nyour " + varname +
                         " environment variable does not include the directories\n"+
                         "containing the " + shlibname + " library files.\n");
      System.exit(1);
    }
    catch (ClassNotFoundException e)
    {
      e.printStackTrace();
      System.err.println("Error: unable to load the file libsbmlj.jar."+
                         " It is likely\nyour -classpath option and CLASSPATH" +
                         " environment variable\n"+
                         "do not include the path to libsbmlj.jar.\n");
      System.exit(1);
    }
  }
}
