/*
 * ppdmacros.h: macro definitions
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * See the AUTHORS file for a list of people who have hacked on 
 * this code. 
 * See the ChangeLog file for a list of changes.
 *
 * Contents:
 * Several useful macro definitions for libppd.
 *
 */

#ifndef _PPD_MACROS_H_
#  define _PPD_MACROS_H_

// C++ magic...
#  ifdef __cplusplus
extern "C" {
#  endif			// __cplusplus
#define PPD_TYPE_CHOICE 0x08
#define PPD_TYPE_OPTION 0x07
#define PPD_TYPE_GROUP 0x06
#define PPD_TYPE_CONSTRAINT 0x05
#define PPD_TYPE_SIZE 0x04
#define PPD_TYPE_EMULATOR 0x03
#define PPD_TYPE_PROFILE 0x02
#define PPD_TYPE_FILE 0x01
#define PPD_CHECK_TYPE(obj, otype)        (((PpdObject *) obj)->id == otype ? TRUE : FALSE)
#define PPD_CAST_FAILED(otype)           ((g_log (G_LOG_DOMAIN,      \
                G_LOG_LEVEL_CRITICAL,                                \
                "file %s: line %d (%s): cast to %s failed.",         \
                __FILE__,                                            \
                __LINE__,                                            \
                __PRETTY_FUNCTION__,                                 \
                otype)))
  /* Macros to test an objects type */
#define PPD_IS_CHOICE(obj) ((PPD_CHECK_TYPE(obj, PPD_TYPE_CHOICE)))
#define PPD_IS_OPTION(obj) ((PPD_CHECK_TYPE(obj, PPD_TYPE_OPTION)))
#define PPD_IS_GROUP(obj) ((PPD_CHECK_TYPE(obj, PPD_TYPE_GROUP)))
#define PPD_IS_CONSTRAINT(obj) ((PPD_CHECK_TYPE(obj, PPD_TYPE_CONSTRAINT)))
#define PPD_IS_SIZE(obj) ((PPD_CHECK_TYPE(obj, PPD_TYPE_SIZE)))
#define PPD_IS_EMULATOR(obj) ((PPD_CHECK_TYPE(obj, PPD_TYPE_EMULATOR)))
#define PPD_IS_PROFILE(obj) ((PPD_CHECK_TYPE(obj, PPD_TYPE_PROFILE)))
#define PPD_IS_FILE(obj) ((PPD_CHECK_TYPE(obj, PPD_TYPE_FILE)))
  /* Macros to cast an object */
#define PPD_CHOICE(obj) ((PPD_IS_CHOICE(obj) ? ((PpdChoice *) obj) :   \
                                      (PPD_CAST_FAILED("PpdChoice"),   \
			              NULL)))
#define PPD_OPTION(obj) ((PPD_IS_OPTION(obj) ? ((PpdOption *) obj) :   \
                                      (PPD_CAST_FAILED("PpdOption"),   \
			              NULL)))
#define PPD_GROUP(obj) ((PPD_IS_GROUP(obj) ? ((PpdGroup *) obj) :     \
                                      (PPD_CAST_FAILED("PpdGroup"),   \
			              NULL)))
#define PPD_CONSTRAINT(obj) ((PPD_IS_CONSTRAINT(obj) ? ((PpdConstraint *) obj) :    \
                                      (PPD_CAST_FAILED("PpdConstraint"),           \
			              NULL)))
#define PPD_SIZE(obj) ((PPD_IS_SIZE(obj) ? ((PpdSize *) obj) :         \
                                      (PPD_CAST_FAILED("PpdSize"),     \
			              NULL)))
#define PPD_EMULATOR(obj) ((PPD_IS_EMULATOR(obj) ? ((PpdEmulator *)    \
				      obj) :                           \
                                      (PPD_CAST_FAILED("PpdEmulator"), \
			              NULL)))
#define PPD_PROFILE(obj) ((PPD_IS_PROFILE(obj) ? ((PpdProfile *)       \
				      obj) :                           \
                                      (PPD_CAST_FAILED("PpdProfile"),  \
			              NULL)))
#define PPD_FILE(obj) ((PPD_IS_FILE(obj) ? ((PpdFile *) obj) :       \
                                      (PPD_CAST_FAILED("PpdFile"),   \
			              NULL)))
// C++ magic...
#  ifdef __cplusplus
}
#  endif			// __cplusplus
#endif				// !_PPD_MACROSS_H_
// End of ppdmacros.h
