/*

(C) 2009 Mika Ilmaranta <ilmis@nullnet.fi>

License: GPLv2

*/

#include <stdio.h>

#include "icmp_t.h"

static struct icmpmsg icmpmsgs[] = {
	{ 0, 0, "Echo Reply", "" },

	{ 1, 0, "Reserved", "" },
	{ 2, 0, "Reserved", "" },

	{ 3, 0, "Destination Unreachable", "Destination network unreachable" },
	{ 3, 1, "Destination Unreachable", "Destination host unreachable" },
	{ 3, 2, "Destination Unreachable", "Destination protocol unreachable" },
	{ 3, 3, "Destination Unreachable", "Destination port unreachable" },
	{ 3, 4, "Destination Unreachable", "Fragmentation required, and DF flag set" },
	{ 3, 5, "Destination Unreachable", "Source route failed" },
	{ 3, 6, "Destination Unreachable", "Destination network unknown" },
	{ 3, 7, "Destination Unreachable", "Destination host unknown" },
	{ 3, 8, "Destination Unreachable", "Source host isolated" },
	{ 3, 9, "Destination Unreachable", "Network administratively prohibited" },
	{ 3, 10, "Destination Unreachable", "Host administratively prohibited" },
	{ 3, 11, "Destination Unreachable", "Network unreachable for TOS" },
	{ 3, 12, "Destination Unreachable", "Host unreachable for TOS" },
	{ 3, 13, "Destination Unreachable", "Communication administratively prohibited" },

	{ 4, 0, "Source Quench", "Source quench (congestion control)" },

	{ 5, 0, "Redirect Message", "Redirect Datagram for the Network" },
	{ 5, 1, "Redirect Message", "Redirect Datagram for the Host" },
	{ 5, 2, "Redirect Message", "Redirect Datagram for the TOS & network" },
	{ 5, 3, "Redirect Message", "Redirect Datagram for the TOS & host" },

	{ 6, 0, "Alternate Host Address", "" },

	{ 7, 0, "Reserved", "" },

	{ 8, 0, "Echo Request", "Echo request (used to ping)" },

	{ 9, 0, "Router Advertisement", "Router Advertisement" },

	{ 10, 0, "Router Solicitation", "Router discovery/selection/solicitation" },

	{ 11, 0, "Time Exceeded", "TTL expired in transit" },
	{ 11, 1, "Time Exceeded", "Fragment reassembly time exceeded" },

	{ 12, 0, "Parameter Problem: Bad IP header", "Pointer indicates the error" },
	{ 12, 1, "Parameter Problem: Bad IP header", "Missing a required option" },
	{ 12, 2, "Parameter Problem: Bad IP header", "Bad length" },

	{ 13, 0, "Timestamp", "Timestamp" },

	{ 14, 0, "Timestamp Reply", "Timestamp reply" },

	{ 15, 0, "Information Request", "Information Request" },

	{ 16, 0, "Information Reply", "Information Reply" },

	{ 17, 0, "Address Mask Request", "Address Mask Request" },

	{ 18, 0, "Address Mask Reply", "Address Mask Reply" },

	{ 19, 0, "Reserved for security", "Reserved for security" },

	{ 20, 0, "Reserved for robustness experiment", "" },
	{ 21, 0, "Reserved for robustness experiment", "" },
	{ 22, 0, "Reserved for robustness experiment", "" },
	{ 23, 0, "Reserved for robustness experiment", "" },
	{ 24, 0, "Reserved for robustness experiment", "" },
	{ 25, 0, "Reserved for robustness experiment", "" },
	{ 26, 0, "Reserved for robustness experiment", "" },
	{ 27, 0, "Reserved for robustness experiment", "" },
	{ 28, 0, "Reserved for robustness experiment", "" },
	{ 29, 0, "Reserved for robustness experiment", "" },

	{ 30, 0, "Traceroute", "Information Request" },

	{ 31, 0, "Datagram Conversion Error", "" },

	{ 32, 0, "Mobile Host Redirect", "" },

	{ 33, 0, "Where-Are-You (originally meant for IPv6)", "" },

	{ 34, 0, "Here-I-Am (originally meant for IPv6)", "" },

	{ 35, 0, "Mobile Registration Request", "" },

	{ 36, 0, "Mobile Registration Reply", "" },

	{ 37, 0, "Domain Name Request", "" },

	{ 38, 0, "Domain Name Reply", "" },

	{ 39, 0, "SKIP Algorithm Discovery Protocol, Simple Key-Management for Internet Protocol", "" },

	{ 40, 0, "Photuris, Security failures", "" },

	{ 41, 0, "ICMP for experimental mobility protocols such as Seamoby [RFC4065]", "" },

	{ 42, 0, "Reserved", "" },
	{ 43, 0, "Reserved", "" },
	{ 44, 0, "Reserved", "" },
	{ 45, 0, "Reserved", "" },
	{ 46, 0, "Reserved", "" },
	{ 47, 0, "Reserved", "" },
	{ 48, 0, "Reserved", "" },
	{ 49, 0, "Reserved", "" },
	{ 50, 0, "Reserved", "" },
	{ 51, 0, "Reserved", "" },
	{ 52, 0, "Reserved", "" },
	{ 53, 0, "Reserved", "" },
	{ 54, 0, "Reserved", "" },
	{ 55, 0, "Reserved", "" },
	{ 56, 0, "Reserved", "" },
	{ 57, 0, "Reserved", "" },
	{ 58, 0, "Reserved", "" },
	{ 59, 0, "Reserved", "" },
	{ 60, 0, "Reserved", "" },
	{ 61, 0, "Reserved", "" },
	{ 62, 0, "Reserved", "" },
	{ 63, 0, "Reserved", "" },
	{ 64, 0, "Reserved", "" },
	{ 65, 0, "Reserved", "" },
	{ 66, 0, "Reserved", "" },
	{ 67, 0, "Reserved", "" },
	{ 68, 0, "Reserved", "" },
	{ 69, 0, "Reserved", "" },
	{ 70, 0, "Reserved", "" },
	{ 71, 0, "Reserved", "" },
	{ 72, 0, "Reserved", "" },
	{ 73, 0, "Reserved", "" },
	{ 74, 0, "Reserved", "" },
	{ 75, 0, "Reserved", "" },
	{ 76, 0, "Reserved", "" },
	{ 77, 0, "Reserved", "" },
	{ 78, 0, "Reserved", "" },
	{ 79, 0, "Reserved", "" },
	{ 80, 0, "Reserved", "" },
	{ 81, 0, "Reserved", "" },
	{ 82, 0, "Reserved", "" },
	{ 83, 0, "Reserved", "" },
	{ 84, 0, "Reserved", "" },
	{ 85, 0, "Reserved", "" },
	{ 86, 0, "Reserved", "" },
	{ 87, 0, "Reserved", "" },
	{ 88, 0, "Reserved", "" },
	{ 89, 0, "Reserved", "" },
	{ 90, 0, "Reserved", "" },
	{ 91, 0, "Reserved", "" },
	{ 92, 0, "Reserved", "" },
	{ 93, 0, "Reserved", "" },
	{ 94, 0, "Reserved", "" },
	{ 95, 0, "Reserved", "" },
	{ 96, 0, "Reserved", "" },
	{ 97, 0, "Reserved", "" },
	{ 98, 0, "Reserved", "" },
	{ 99, 0, "Reserved", "" },
	{ 100, 0, "Reserved", "" },
	{ 101, 0, "Reserved", "" },
	{ 102, 0, "Reserved", "" },
	{ 103, 0, "Reserved", "" },
	{ 104, 0, "Reserved", "" },
	{ 105, 0, "Reserved", "" },
	{ 106, 0, "Reserved", "" },
	{ 107, 0, "Reserved", "" },
	{ 108, 0, "Reserved", "" },
	{ 109, 0, "Reserved", "" },
	{ 110, 0, "Reserved", "" },
	{ 111, 0, "Reserved", "" },
	{ 112, 0, "Reserved", "" },
	{ 113, 0, "Reserved", "" },
	{ 114, 0, "Reserved", "" },
	{ 115, 0, "Reserved", "" },
	{ 116, 0, "Reserved", "" },
	{ 117, 0, "Reserved", "" },
	{ 118, 0, "Reserved", "" },
	{ 119, 0, "Reserved", "" },
	{ 120, 0, "Reserved", "" },
	{ 121, 0, "Reserved", "" },
	{ 122, 0, "Reserved", "" },
	{ 123, 0, "Reserved", "" },
	{ 124, 0, "Reserved", "" },
	{ 125, 0, "Reserved", "" },
	{ 126, 0, "Reserved", "" },
	{ 127, 0, "Reserved", "" },
	{ 128, 0, "Reserved", "" },
	{ 129, 0, "Reserved", "" },
	{ 130, 0, "Reserved", "" },
	{ 131, 0, "Reserved", "" },
	{ 132, 0, "Reserved", "" },
	{ 133, 0, "Reserved", "" },
	{ 134, 0, "Reserved", "" },
	{ 135, 0, "Reserved", "" },
	{ 136, 0, "Reserved", "" },
	{ 137, 0, "Reserved", "" },
	{ 138, 0, "Reserved", "" },
	{ 139, 0, "Reserved", "" },
	{ 140, 0, "Reserved", "" },
	{ 141, 0, "Reserved", "" },
	{ 142, 0, "Reserved", "" },
	{ 143, 0, "Reserved", "" },
	{ 144, 0, "Reserved", "" },
	{ 145, 0, "Reserved", "" },
	{ 146, 0, "Reserved", "" },
	{ 147, 0, "Reserved", "" },
	{ 148, 0, "Reserved", "" },
	{ 149, 0, "Reserved", "" },
	{ 150, 0, "Reserved", "" },
	{ 151, 0, "Reserved", "" },
	{ 152, 0, "Reserved", "" },
	{ 153, 0, "Reserved", "" },
	{ 154, 0, "Reserved", "" },
	{ 155, 0, "Reserved", "" },
	{ 156, 0, "Reserved", "" },
	{ 157, 0, "Reserved", "" },
	{ 158, 0, "Reserved", "" },
	{ 159, 0, "Reserved", "" },
	{ 160, 0, "Reserved", "" },
	{ 161, 0, "Reserved", "" },
	{ 162, 0, "Reserved", "" },
	{ 163, 0, "Reserved", "" },
	{ 164, 0, "Reserved", "" },
	{ 165, 0, "Reserved", "" },
	{ 166, 0, "Reserved", "" },
	{ 167, 0, "Reserved", "" },
	{ 168, 0, "Reserved", "" },
	{ 169, 0, "Reserved", "" },
	{ 170, 0, "Reserved", "" },
	{ 171, 0, "Reserved", "" },
	{ 172, 0, "Reserved", "" },
	{ 173, 0, "Reserved", "" },
	{ 174, 0, "Reserved", "" },
	{ 175, 0, "Reserved", "" },
	{ 176, 0, "Reserved", "" },
	{ 177, 0, "Reserved", "" },
	{ 178, 0, "Reserved", "" },
	{ 179, 0, "Reserved", "" },
	{ 180, 0, "Reserved", "" },
	{ 181, 0, "Reserved", "" },
	{ 182, 0, "Reserved", "" },
	{ 183, 0, "Reserved", "" },
	{ 184, 0, "Reserved", "" },
	{ 185, 0, "Reserved", "" },
	{ 186, 0, "Reserved", "" },
	{ 187, 0, "Reserved", "" },
	{ 188, 0, "Reserved", "" },
	{ 189, 0, "Reserved", "" },
	{ 190, 0, "Reserved", "" },
	{ 191, 0, "Reserved", "" },
	{ 192, 0, "Reserved", "" },
	{ 193, 0, "Reserved", "" },
	{ 194, 0, "Reserved", "" },
	{ 195, 0, "Reserved", "" },
	{ 196, 0, "Reserved", "" },
	{ 197, 0, "Reserved", "" },
	{ 198, 0, "Reserved", "" },
	{ 199, 0, "Reserved", "" },
	{ 200, 0, "Reserved", "" },
	{ 201, 0, "Reserved", "" },
	{ 202, 0, "Reserved", "" },
	{ 203, 0, "Reserved", "" },
	{ 204, 0, "Reserved", "" },
	{ 205, 0, "Reserved", "" },
	{ 206, 0, "Reserved", "" },
	{ 207, 0, "Reserved", "" },
	{ 208, 0, "Reserved", "" },
	{ 209, 0, "Reserved", "" },
	{ 210, 0, "Reserved", "" },
	{ 211, 0, "Reserved", "" },
	{ 212, 0, "Reserved", "" },
	{ 213, 0, "Reserved", "" },
	{ 214, 0, "Reserved", "" },
	{ 215, 0, "Reserved", "" },
	{ 216, 0, "Reserved", "" },
	{ 217, 0, "Reserved", "" },
	{ 218, 0, "Reserved", "" },
	{ 219, 0, "Reserved", "" },
	{ 220, 0, "Reserved", "" },
	{ 221, 0, "Reserved", "" },
	{ 222, 0, "Reserved", "" },
	{ 223, 0, "Reserved", "" },
	{ 224, 0, "Reserved", "" },
	{ 225, 0, "Reserved", "" },
	{ 226, 0, "Reserved", "" },
	{ 227, 0, "Reserved", "" },
	{ 228, 0, "Reserved", "" },
	{ 229, 0, "Reserved", "" },
	{ 230, 0, "Reserved", "" },
	{ 231, 0, "Reserved", "" },
	{ 232, 0, "Reserved", "" },
	{ 233, 0, "Reserved", "" },
	{ 234, 0, "Reserved", "" },
	{ 235, 0, "Reserved", "" },
	{ 236, 0, "Reserved", "" },
	{ 237, 0, "Reserved", "" },
	{ 238, 0, "Reserved", "" },
	{ 239, 0, "Reserved", "" },
	{ 240, 0, "Reserved", "" },
	{ 241, 0, "Reserved", "" },
	{ 242, 0, "Reserved", "" },
	{ 243, 0, "Reserved", "" },
	{ 244, 0, "Reserved", "" },
	{ 245, 0, "Reserved", "" },
	{ 246, 0, "Reserved", "" },
	{ 247, 0, "Reserved", "" },
	{ 248, 0, "Reserved", "" },
	{ 249, 0, "Reserved", "" },
	{ 250, 0, "Reserved", "" },
	{ 251, 0, "Reserved", "" },
	{ 252, 0, "Reserved", "" },
	{ 253, 0, "Reserved", "" },
	{ 254, 0, "Reserved", "" },
	{ 255, 0, "Reserved", "" },

	{ 256, 256, "impossible combination", "impossible combination" }
};

static struct icmpmsg icmperror =
	{ 256, 256, "unknown", "unknown" };

struct icmpmsg *stricmp(int type, int code)
{
	int i;

	if(type > 255) return &icmperror;

	for(i = 0; icmpmsgs[i].type <= type; i++)
		if(icmpmsgs[i].type == type && icmpmsgs[i].code == code) return(&(icmpmsgs[i]));

	for(i = 0; icmpmsgs[i].type <= type; i++)
		if(icmpmsgs[i].type == type) return(&(icmpmsgs[i]));

	return &icmperror;
}

/* EOF */
