/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_UI_DIARY_HEADER
#define LIFEOGRAPH_UI_DIARY_HEADER


#include "diary.hpp"
#include "dialog_sync.hpp"
#include "dialog_export.hpp"
#include "parser_paragraph.hpp"
#include "widgets/widget_entrylist.hpp"
#include "widgets/widget_entrypicker.hpp"


namespace LIFEO
{

class UIDiary
{
    public:
        static const int        MIN_WIDTH = 300; // pixels

                                UIDiary();

        void                    handle_login();
        void                    enable_editing();
        void                    handle_logout();

        void                    update_entry_list();
        //void                    update_entry_list_style();
        void                    update_sorting();

        void                    show_in_list( const DiaryElement* );
        void                    show_today();
        void                    show_prev_session_elem();

        void                    show_entry_Po( Entry*, const Gdk::Rectangle&& );

        void                    refresh_row( const Entry* );
        void                    handle_entry_title_changed( Entry* );

        Gtk::TreeRow            get_row( const Gtk::TreePath& );
        WidgetEntryList*        get_list() const
        { return m_TV_entries; }

        int                     get_entry_count() const
        { return m_entry_count; }
        int                     get_selected_count() const
        { return m_TV_entries->get_selection()->count_selected_rows(); }
        VecEntries              get_selected_entries() const
        { return m_TV_entries->m_multiple_entries.m_entries; }
        void                    do_for_each_selected_entry( const sigc::slot< void, Entry* >& s )
        { m_TV_entries->do_for_each_selected_entry( s ); }

        void                    update_startup_elem();

        Entry*                  add_entry( date_t, const Ustring&, bool = false );
        void                    add_chapter( date_t );

        void                    empty_trash();

    protected:
        // DIALOGS
        void                    start_dialog_password();
        void                    start_dialog_sync();
        void                    start_dialog_export();

        void                    open_diary_folder() const;

        void                    handle_language_changed();
        void                    handle_startup_type_changed();
        bool                    handle_startup_elem_drag_motion(
                    const Glib::RefPtr< Gdk::DragContext >&, int, int, guint );
        bool                    handle_startup_elem_dropped(
                    const Glib::RefPtr< Gdk::DragContext >&, int, int, guint );
        bool                    go_to_startup_elem( const Ustring& );

        void                    hide_entry_cur();
        void                    hide_entries_before();
        void                    hide_entries_after();
        void                    hide_entries_not_refing();

        void                    refresh_Po_diary();

        WidgetEntryList*        m_TV_entries;

        Gtk::Button*            m_B_logout;

        Gtk::RadioButton*       m_RB_sort_by_date;
        Gtk::RadioButton*       m_RB_sort_by_name;
        Gtk::RadioButton*       m_RB_sort_by_size;
        Gtk::RadioButton*       m_RB_sort_by_change;
        Gtk::Box*               m_Bx_entries_sort_by;
        Gtk::Box*               m_Bx_sort_tem;
        Gtk::RadioButton*       m_RB_sort_asc;
        Gtk::RadioButton*       m_RB_sort_desc;
        Gtk::RadioButton*       m_RB_sort_asc_tem;
        Gtk::RadioButton*       m_RB_sort_desc_tem;

        Gtk::Box*               m_Bx_entry_header;
        Gtk::Button*            m_B_today;
        Gtk::Button*            m_B_enable_edit;
        Gtk::MenuButton*        m_MB_logout;
        Gtk::Box*               m_Bx_logout;

        Gtk::MenuButton*        m_MB_diary;
        Gtk::MenuButton*        m_MB_tools;

        Gtk::Box*               m_Bx_search;

        Gtk::ModelButton*       m_B_open_folder;
        Gtk::Label*             m_L_size;
        Gtk::Label*             m_L_chapters;
        Gtk::Box*               m_Bx_options;
        Gtk::ComboBoxText*      m_CB_spellcheck;

        Gtk::ModelButton*       m_MoB_empty_trash;
        Gtk::ModelButton*       m_MoB_encryption;
        Gtk::ModelButton*       m_MoB_sync;

        // COMPLETION
        WidgetEntryPicker*      m_WEP_completion_tag;

        // STARTUP
        Gtk::ComboBoxText*      m_CB_startup_type;
        Gtk::Label*             m_L_startup_elem;
        WidgetEntryPicker*      m_W_startup_entry;

        // ENTRY MINI POPOVER
        Gtk::Popover*           m_Po_entry;
        Gtk::Box*               m_Bx_entry_edit;
        Gtk::Box*               m_Bx_entry_add_header;
        Gtk::Box*               m_Bx_entry_add_relative;
        Gtk::Box*               m_Bx_entry_add_top;
        Gtk::Box*               m_Bx_entry_hide;
        Gtk::ToggleButton*      m_TB_entry_trashed;
        Gtk::ToggleButton*      m_TB_entry_favorite;
        Gtk::RadioButton*       m_RB_entry_auto;
        Gtk::RadioButton*       m_RB_entry_todo;
        Gtk::RadioButton*       m_RB_entry_progressed;
        Gtk::RadioButton*       m_RB_entry_done;
        Gtk::RadioButton*       m_RB_entry_canceled;
        Gtk::Button*            m_B_entry_add_child;
        Gtk::Button*            m_B_entry_add_sibling;
        Action                  m_A_hide_entry_cur;
        Gtk::ModelButton*       m_MoB_entry_filter_referencers;

        Entry*                  m_p2entry_cur;

        // DIALOGS
        DialogSync*             m_dialog_sync{ nullptr };
        DialogExport*           m_dialog_export{ nullptr };

        // LISTING TMP VARIABLES
        void                    add_chapter_category_to_list( const CategoryChapters* );
        Gtk::TreeIter           add_entry_to_list( Entry*, std::map< date_t, Gtk::TreeRow >* );
        void                    fill_treepaths( const Gtk::TreeModel::Children& );
        int                     m_entry_count{ 0 };
        // following flag is set if a call to update_entry_list() also updates the calendar
        bool                    m_flag_calendar_updated{ false };

    friend class Lifeograph;
};

} // end of namespace LIFEO

#endif
