// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/kata-containers/kata-containers/src/runtime/virtcontainers/pkg/firecracker/client/models"
)

// PutMmdsReader is a Reader for the PutMmds structure.
type PutMmdsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PutMmdsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 204:
		result := NewPutMmdsNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 400:
		result := NewPutMmdsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		result := NewPutMmdsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPutMmdsNoContent creates a PutMmdsNoContent with default headers values
func NewPutMmdsNoContent() *PutMmdsNoContent {
	return &PutMmdsNoContent{}
}

/*PutMmdsNoContent handles this case with default header values.

MMDS data store created/updated.
*/
type PutMmdsNoContent struct {
}

func (o *PutMmdsNoContent) Error() string {
	return fmt.Sprintf("[PUT /mmds][%d] putMmdsNoContent ", 204)
}

func (o *PutMmdsNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPutMmdsBadRequest creates a PutMmdsBadRequest with default headers values
func NewPutMmdsBadRequest() *PutMmdsBadRequest {
	return &PutMmdsBadRequest{}
}

/*PutMmdsBadRequest handles this case with default header values.

MMDS data store cannot be created due to bad input.
*/
type PutMmdsBadRequest struct {
	Payload *models.Error
}

func (o *PutMmdsBadRequest) Error() string {
	return fmt.Sprintf("[PUT /mmds][%d] putMmdsBadRequest  %+v", 400, o.Payload)
}

func (o *PutMmdsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPutMmdsDefault creates a PutMmdsDefault with default headers values
func NewPutMmdsDefault(code int) *PutMmdsDefault {
	return &PutMmdsDefault{
		_statusCode: code,
	}
}

/*PutMmdsDefault handles this case with default header values.

Internal server error
*/
type PutMmdsDefault struct {
	_statusCode int

	Payload *models.Error
}

// Code gets the status code for the put mmds default response
func (o *PutMmdsDefault) Code() int {
	return o._statusCode
}

func (o *PutMmdsDefault) Error() string {
	return fmt.Sprintf("[PUT /mmds][%d] PutMmds default  %+v", o._statusCode, o.Payload)
}

func (o *PutMmdsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
