package CType::Function;

use 5.6.0;
use strict;
use warnings;

use CType;

no warnings 'recursion';

our @ISA = qw/CType/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $type = shift;
    my $params = shift;
    my $attributes = shift;
    my $variadic = shift;

    my $self = {type => $type,
                params => $params,
                attributes => $attributes,
                variadic => $variadic,
               };
    bless $self, $class;

    $self->process_attributes($attributes);

    return $self;
  }

sub set_inline
  {
    my $self = shift;
    $self->{inline} = shift;
  }

sub layout
  {
    my $self = shift;
    my $accept_incomplete = shift;
    my $namespace = shift;

    $_->layout(0, $namespace) foreach @{$self->{params}};
  }

sub describe
  {
    my $self = shift;

    my $type = $self->{type}->describe;
    my @params = map {$_->describe} @{$self->{params}};

    if (scalar @params == 0)
      {
        return "function taking no arguments, returning $type";
      }
    else
      {
        return "function taking (" . join(', ', @params) . "), returning $type";
      }
  }

sub dump_c
  {
    my $self = shift;
    my $skip_cpp = shift;
    my $name = shift;

    my $str = '';

    my $declarator = $name || "";
    my @params = map {$_->dump_c($skip_cpp)} @{$self->{params}};
    unless (scalar @params)
      {
        @params = ('void');
      }
    my $params = join(', ', @params);

    if ($self->{type}->capture_declarator)
      {
        $str .= $self->{type}->dump_c($skip_cpp, "$declarator($params)");
      }
    else
      {
        my $type = $self->{type}->dump_c($skip_cpp);
        $str .= "$type $declarator($params)";
      }
    return $str;
  }

sub capture_declarator
  {
    return 1;
  }

sub _check_interface
  {
    my $self = shift;
    my $other = shift;

    return 'both' unless $other->isa('CType::Function');

    my @ret;

    push @ret, $self->{type}->check_interface($other->{type});
    push @ret, 'both' if scalar @{$self->{params}} != scalar @{$other->{params}};
    foreach my $i (0 .. scalar @{$self->{params}} - 1)
      {
        last if $i >= scalar @{$other->{params}};
        push @ret, $self->{params}[$i]->check_interface($other->{params}[$i], 1);
      }

    return @ret;
  }

sub get_refs
  {
    my $self = shift;
    return ($self->{type}->get_refs, map {$_->get_refs} @{$self->{params}});
  }

1;
