#!/usr/bin/python
# -*- coding: utf-8 -*-
# pylint: disable=too-many-lines, too-many-statements, too-many-locals
# pylint: disable=too-many-instance-attributes, too-many-branches
# pylint: disable=invalid-name

"""
Constants for iapws97.py
"""

import numpy as np

# Boundary Region1-Region3
h13_s_Li = np.array([0, 1, 1, 3, 5, 6])
h13_s_Lj = np.array([0, -2, 2, -12, -4, -3])
h13_s_n = np.array([0.913965547600543, -0.430944856041991e-4, 0.603235694765419e2,
                    0.117518273082168e-17, 0.220000904781292, -0.690815545851641e2])

# t_hs
t_hs_Li = np.array([-12, -10, -8, -4, -3, -2, -2, -2, -2, 0, 1, 1, 1, 3, 3, 5, 6, 6, 8,
                    8, 8, 12, 12, 14, 14])
t_hs_Lj = np.array([10, 8, 3, 4, 3, -6, 2, 3, 4, 0, -3, -2, 10, -2, -1, -5, -6, -3, -8,
                    -2, -1, -12, -1, -12, 1])
t_hs_n = np.array([0.629096260829810e-3, -0.823453502583165e-3, 0.515446951519474e-7,
                   -0.117565945784945e1, 0.348519684726192e1, -0.507837382408313e-11,
                   -0.284637670005479e1, -0.236092263939673e1, 0.601492324973779e1,
                   0.148039650824546e1, 0.360075182221907e-3, -0.126700045009952e-1,
                   -0.122184332521413e7, 0.149276502463272, 0.698733471798484,
                   -0.252207040114321e-1, 0.147151930985213e-1, -0.108618917681849e1,
                   -0.936875039816322e-3, 0.819877897570217e2, -0.182041861521835e3,
                   0.261907376402688e-5, -0.291626417025961e5, 0.140660774926165e-4,
                   0.783237062349385e7])

# Psat_h
PSat_h_Li = np.array([0, 1, 1, 1, 1, 5, 7, 8, 14, 20, 22, 24, 28, 36])
PSat_h_Lj = np.array([0, 1, 3, 4, 36, 3, 0, 24, 16, 16, 3, 18, 8, 24])
PSat_h_n = np.array([0.600073641753024, -0.936203654849857e1, 0.246590798594147e2,
                     -0.107014222858224e3, -0.915821315805768e14, -0.862332011700662e4,
                     -0.235837344740032e2, 0.252304969384128e18, -0.389718771997719e19,
                     -0.333775713645296e23, 0.356499469636328e11, -0.148547544720641e27,
                     0.330611514838798e19, 0.813641294467829e38])

# Psat_s
PSat_s_Li = np.array([0, 1, 1, 4, 12, 12, 16, 24, 28, 32])
PSat_s_Lj = np.array([0, 1, 32, 7, 4, 14, 36, 10, 0, 18])
PSat_s_n = np.array([0.639767553612785, -0.129727445396014e2, -0.224595125848403e16,
                     0.177466741801846e7, 0.717079349571538e10, -0.378829107169011e18,
                     -0.955586736431328e35, 0.187269814676188e24, 0.119254746466473e12,
                     0.110649277244882e37])

# h1_s
h1_s_Li = np.array([0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 7, 8, 12, 12, 14, 14, 16, 20,
                    20, 22, 24, 28, 32, 32])
h1_s_Lj = np.array([14, 36, 3, 16, 0, 5, 4, 36, 4, 16, 24, 18, 24, 1, 4, 2, 4, 1, 22, 10,
                    12, 28, 8, 3, 0, 6, 8])
h1_s_n = np.array([0.332171191705237, 0.611217706323496e-3, -0.882092478906822e1,
                   -0.455628192543250, -0.263483840850452e-4, -0.223949661148062e2,
                   -0.428398660164013e1, -0.616679338856916, -0.146823031104040e2,
                   0.284523138727299e3, -0.113398503195444e3, 0.115671380760859e4,
                   0.395551267359325e3, -0.154891257229285e1, 0.194486637751291e2,
                   -0.357915139457043e1, -0.335369414148819e1, -0.664426796332460,
                   0.323321885383934e5, 0.331766744667084e4, -0.223501257931087e5,
                   0.573953875852936e7, 0.173226193407919e3, -0.363968822121321e-1,
                   0.834596332878346e-6, 0.503611916682674e1, 0.655444787064505e2])

# h3_s
h3a_s_Li = np.array([0, 0, 0, 0, 2, 3, 4, 4, 5, 5, 6, 7, 7, 7, 10, 10, 10, 32, 32])
h3a_s_Lj = np.array([1, 4, 10, 16, 1, 36, 3, 16, 20, 36, 4, 2, 28, 32, 14, 32, 36, 0, 6])
h3a_s_n = np.array([0.822673364673336, 0.181977213534479, -0.112000260313624e-1,
                    -0.746778287048033e-3, -0.179046263257381, 0.424220110836657e-1,
                    -0.341355823438768, -0.209881740853565e1, -0.822477343323596e1,
                    -0.499684082076008e1, 0.191413958471069, 0.581062241093136e-1,
                    -0.165505498701029e4, 0.158870443421201e4, -0.850623535172818e2,
                    -0.317714386511207e5, -0.945890406632871e5, -0.139273847088690e-5,
                    0.631052532240980])

# h2ab_s
h2ab_s_Li = np.array([1, 1, 2, 2, 4, 4, 7, 8, 8, 10, 12, 12, 18, 20, 24, 28, 28, 28, 28,
                      28, 32, 32, 32, 32, 32, 36, 36, 36, 36, 36])
h2ab_s_Lj = np.array([8, 24, 4, 32, 1, 2, 7, 5, 12, 1, 0, 7, 10, 12, 32, 8, 12, 20, 22, 24,
                      2, 7, 12, 14, 24, 10, 12, 20, 22, 28])
h2ab_s_n = np.array([-0.524581170928788e3, -0.926947218142218e7, -0.237385107491666e3,
                     0.210770155812776e11, -0.239494562010986e2, 0.221802480294197e3,
                     -0.510472533393438e7, 0.124981396109147e7, 0.200008436996201e10,
                     -0.815158509791035e3, -0.157612685637523e3, -0.114200422332791e11,
                     0.662364680776872e16, -0.227622818296144e19, -0.171048081348406e32,
                     0.660788766938091e16, 0.166320055886021e23, -0.218003784381501e30,
                     -0.787276140295618e30, 0.151062329700346e32, 0.795732170300541e7,
                     0.131957647355347e16, -0.325097068299140e24, -0.418600611419248e26,
                     0.297478906557467e35, -0.953588761745473e20, 0.166957699620939e25,
                     -0.175407764869978e33, 0.347581490626396e35, -0.710971318427851e39])

# h2c3b_s
h2c3b_s_Li = np.array([0, 0, 0, 1, 1, 5, 6, 7, 8, 8, 12, 16, 22, 22, 24, 36])
h2c3b_s_Lj = np.array([0, 3, 4, 0, 12, 36, 12, 16, 2, 20, 32, 36, 2, 32, 7, 20])
h2c3b_s_n = np.array([0.104351280732769e1, -0.227807912708513e1, 0.180535256723202e1,
                      0.420440834792042, -0.105721244834660e6, 0.436911607493884e25,
                      -0.328032702839753e12, -0.678686760804270e16, 0.743957464645363e4,
                      -0.356896445355761e20, 0.167590585186801e32, -0.355028625419105e38,
                      0.396611982166538e12, -0.414716268484468e41, 0.359080103867382e19,
                      -0.116994334851995e41])

# Region 1
Region1_Li = np.array([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4,
                       4, 4, 5, 8, 8, 21, 23, 29, 30, 31, 32])
Region1_Lj = np.array([-2, -1, 0, 1, 2, 3, 4, 5, -9, -7, -1, 0, 1, 3, -3, 0, 1, 3, 17, -4,
                       0, 6, -5, -2, 10, -8, -11, -6, -29, -31, -38, -39, -40, -41])
Region1_n = np.array([0.14632971213167, -0.84548187169114, -0.37563603672040e1,
                      0.33855169168385e1, -0.95791963387872, 0.15772038513228,
                      -0.16616417199501e-1, 0.81214629983568e-3, 0.28319080123804e-3,
                      -0.60706301565874e-3, -0.18990068218419e-1, -0.32529748770505e-1,
                      -0.21841717175414e-1, -0.52838357969930e-4, -0.47184321073267e-3,
                      -0.30001780793026e-3, 0.47661393906987e-4, -0.44141845330846e-5,
                      -0.72694996297594e-15, -0.31679644845054e-4, -0.28270797985312e-5,
                      -0.85205128120103e-9, -0.22425281908000e-5, -0.65171222895601e-6,
                      -0.14341729937924e-12, -0.40516996860117e-6, -0.12734301741641e-8,
                      -0.17424871230634e-9, -0.68762131295531e-18, 0.14478307828521e-19,
                      0.26335781662795e-22, -0.11947622640071e-22, 0.18228094581404e-23,
                      -0.93537087292458e-25])
Region1_n_Li_product = Region1_n * Region1_Li
Region1_n_Lj_product = Region1_n * Region1_Lj
Region1_n_Li_Lj_product = Region1_n * Region1_Li * Region1_Lj
Region1_Li_less_1 = Region1_Li - 1
Region1_Lj_less_1 = Region1_Lj - 1
Region1_Li_less_2 = Region1_Li - 2
Region1_Lj_less_2 = Region1_Lj - 2

# _Backward1_T_Ph
Backward1_T_Ph_Li = np.array([0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 3, 3, 4, 5, 6])
Backward1_T_Ph_Lj = np.array([0, 1, 2, 6, 22, 32, 0, 1, 2, 3, 4, 10, 32, 10, 32, 10, 32, 32, 32,
                              32])
Backward1_T_Ph_n = np.array([-0.23872489924521e3, 0.40421188637945e3, 0.11349746881718e3,
                             -0.58457616048039e1, -0.15285482413140e-3, -0.10866707695377e-5,
                             -0.13391744872602e2, 0.43211039183559e2, -0.54010067170506e2,
                             0.30535892203916e2, -0.65964749423638e1, 0.93965400878363e-2,
                             0.11573647505340e-6, -0.25858641282073e-4, -0.40644363084799e-8,
                             0.66456186191635e-7, 0.80670734103027e-10, -0.93477771213947e-12,
                             0.58265442020601e-14, -0.15020185953503e-16])

# _Backward1_T_Ps
Backward1_T_Ps_Li = np.array([0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 4])
Backward1_T_Ps_Lj = np.array([0, 1, 2, 3, 11, 31, 0, 1, 2, 3, 12, 31, 0, 1, 2, 9, 31, 10, 32, 32])
Backward1_T_Ps_n = np.array([0.17478268058307e3, 0.34806930892873e2, 0.65292584978455e1,
                             0.33039981775489, -0.19281382923196e-6, -0.24909197244573e-22,
                             -0.26107636489332, 0.22592965981586, -0.64256463395226e-1,
                             0.78876289270526e-2, 0.35672110607366e-9, 0.17332496994895e-23,
                             0.56608900654837e-3, -0.32635483139717e-3, 0.44778286690632e-4,
                             -0.51322156908507e-9, -0.42522657042207e-25, 0.26400441360689e-12,
                             0.78124600459723e-28, -0.30732199903668e-30])

# _Backward1_P_hs
Backward1_P_hs_Li = np.array([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 3, 4, 4, 5])
Backward1_P_hs_Lj = np.array([0, 1, 2, 4, 5, 6, 8, 14, 0, 1, 4, 6, 0, 1, 10, 4, 1, 4, 0])
Backward1_P_hs_n = np.array([-0.691997014660582, -0.183612548787560e2, -0.928332409297335e1,
                             0.659639569909906e2, -0.162060388912024e2, 0.450620017338667e3,
                             0.854680678224170e3, 0.607523214001162e4, 0.326487682621856e2,
                             -0.269408844582931e2, -0.319947848334300e3, -0.928354307043320e3,
                             0.303634537455249e2, -0.650540422444146e2, -0.430991316516130e4,
                             -0.747512324096068e3, 0.730000345529245e3, 0.114284032569021e4,
                             -0.436407041874559e3])
# Region 2
Region2_Ir = np.array([1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 5, 6, 6, 6, 7,
                       7, 7, 8, 8, 9, 10, 10, 10, 16, 16, 18, 20, 20, 20, 21, 22, 23, 24,
                       24, 24])
Region2_Jr = np.array([0, 1, 2, 3, 6, 1, 2, 4, 7, 36, 0, 1, 3, 6, 35, 1, 2, 3, 7, 3, 16, 35,
                       0, 11, 25, 8, 36, 13, 4, 10, 14, 29, 50, 57, 20, 35, 48, 21, 53, 39,
                       26, 40, 58])
Region2_nr = np.array([-0.0017731742473212999, -0.017834862292357999, -0.045996013696365003,
                       -0.057581259083432, -0.050325278727930002, -3.3032641670203e-05,
                       -0.00018948987516315, -0.0039392777243355001, -0.043797295650572998,
                       -2.6674547914087001e-05, 2.0481737692308999e-08,
                       4.3870667284435001e-07, -3.2277677238570002e-05, -0.0015033924542148,
                       -0.040668253562648998, -7.8847309559367001e-10,
                       1.2790717852285001e-08, 4.8225372718507002e-07,
                       2.2922076337661001e-06, -1.6714766451061001e-11,
                       -0.0021171472321354998, -23.895741934103999, -5.9059564324270004e-18,
                       -1.2621808899101e-06, -0.038946842435739003, 1.1256211360459e-11,
                       -8.2311340897998004, 1.9809712802088e-08, 1.0406965210174e-19,
                       -1.0234747095929e-13, -1.0018179379511e-09, -8.0882908646984998e-11,
                       0.10693031879409, -0.33662250574170999, 8.9185845355420999e-25,
                       3.0629316876231997e-13, -4.2002467698208001e-06,
                       -5.9056029685639003e-26, 3.7826947613457002e-06,
                       -1.2768608934681e-15, 7.3087610595061e-29, 5.5414715350778001e-17,
                       -9.4369707241209998e-07])
Region2_nr_Ir_product = Region2_nr * Region2_Ir
Region2_nr_Jr_product = Region2_nr * Region2_Jr
Region2_nr_Ir_Jr_product = Region2_nr * Region2_Ir * Region2_Jr
Region2_Ir_less_1 = Region2_Ir - 1
Region2_Ir_less_2 = Region2_Ir - 2
Region2_Jr_less_1 = Region2_Jr - 1
Region2_Jr_less_2 = Region2_Jr - 2

# Region 2 cp0
Region2_cp0_Jo = np.array([0, 1, -5, -4, -3, -2, -1, 2, 3])
Region2_cp0_no = np.array([-0.96927686500217E+01, 0.10086655968018E+02, -0.56087911283020E-02,
                  0.71452738081455E-01, -0.40710498223928E+00, 0.14240819171444E+01,
                  -0.43839511319450E+01, -0.28408632460772E+00, 0.21268463753307E-01])

# Backward2a_T_Ph
Backward2a_T_Ph_Li = np.array([0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,
                               3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7])
Backward2a_T_Ph_Lj = np.array([0, 1, 2, 3, 7, 20, 0, 1, 2, 3, 7, 9, 11, 18, 44, 0, 2, 7, 36, 38, 40,
                               42, 44, 24, 44, 12, 32, 44, 32, 36, 42, 34, 44, 28])
Backward2a_T_Ph_n = np.array([0.10898952318288e4, 0.84951654495535e3, -0.10781748091826e3,
                              0.33153654801263e2, -0.74232016790248e1, 0.11765048724356e2,
                              0.18445749355790e1, -0.41792700549624e1, 0.62478196935812e1,
                              -0.17344563108114e2, -0.20058176862096e3, 0.27196065473796e3,
                              -0.45511318285818e3, 0.30919688604755e4, 0.25226640357872e6,
                              -0.61707422868339e-2, -0.31078046629583, 0.11670873077107e2,
                              0.12812798404046e9, -0.98554909623276e9, 0.28224546973002e10,
                              -0.35948971410703e10, 0.17227349913197e10, -0.13551334240775e5,
                              0.12848734664650e8, 0.13865724283226e1, 0.23598832556514e6,
                              -0.13105236545054e8, 0.73999835474766e4, -0.55196697030060e6,
                              0.37154085996233e7, 0.19127729239660e5, -0.41535164835634e6,
                              -0.62459855192507e2])

# Backward2b_T_Ph
Backward2b_T_Ph_Li = np.array([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3,
                               3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 6, 7, 7, 9, 9])
Backward2b_T_Ph_Lj = np.array([0, 1, 2, 12, 18, 24, 28, 40, 0, 2, 6, 12, 18, 24, 28, 40, 2, 8, 18,
                               40, 1, 2, 12, 24, 2, 12, 18, 24, 28, 40, 18, 24, 40, 28, 2, 28, 1,
                               40])
Backward2b_T_Ph_n = np.array([0.14895041079516e4, 0.74307798314034e3, -0.97708318797837e2,
                              0.24742464705674e1, -0.63281320016026, 0.11385952129658e1,
                              -0.47811863648625, 0.85208123431544e-2, 0.93747147377932,
                              0.33593118604916e1, 0.33809355601454e1, 0.16844539671904,
                              0.73875745236695, -0.47128737436186, 0.15020273139707,
                              -0.21764114219750e-2, -0.21810755324761e-1, -0.10829784403677,
                              -0.46333324635812e-1, 0.71280351959551e-4, 0.11032831789999e-3,
                              0.18955248387902e-3, 0.30891541160537e-2, 0.13555504554949e-2,
                              0.28640237477456e-6, -0.10779857357512e-4, -0.76462712454814e-4,
                              0.14052392818316e-4, -0.31083814331434e-4, -0.10302738212103e-5,
                              0.28217281635040e-6, 0.12704902271945e-5, 0.73803353468292e-7,
                              -0.11030139238909e-7, -0.81456365207833e-13, -0.25180545682962e-10,
                              -0.17565233969407e-17, 0.86934156344163e-14])

# Backward2c_T_Ph
Backward2c_T_Ph_Li = np.array([-7, -7, -6, -6, -5, -5, -2, -2, -1, -1, 0, 0, 1, 1, 2, 6, 6, 6, 6, 6,
                               6, 6, 6])
Backward2c_T_Ph_Lj = np.array([0, 4, 0, 2, 0, 2, 0, 1, 0, 2, 0, 1, 4, 8, 4, 0, 1, 4, 10, 12, 16,
                               20, 22])
Backward2c_T_Ph_n = np.array([-0.32368398555242e13, 0.73263350902181e13, 0.35825089945447e12,
                              -0.58340131851590e12, -0.10783068217470e11, 0.20825544563171e11,
                              0.61074783564516e6, 0.85977722535580e6, -0.25745723604170e5,
                              0.31081088422714e5, 0.12082315865936e4, 0.48219755109255e3,
                              0.37966001272486e1, -0.10842984880077e2, -0.45364172676660e-1,
                              0.14559115658698e-12, 0.11261597407230e-11, -0.17804982240686e-10,
                              0.12324579690832e-6, -0.11606921130984e-5, 0.27846367088554e-4,
                              -0.59270038474176e-3, 0.12918582991878e-2])

# Backward2a_T_Ps
Backward2a_T_Ps_Li = np.array([-1.5, -1.5, -1.5, -1.5, -1.5, -1.5, -1.25, -1.25, -1.25, -1.0, -1.0,
                               -1.0, -1.0, -1.0, -1.0, -0.75, -0.75, -0.5, -0.5, -0.5, -0.5, -0.25,
                               -0.25, -0.25, -0.25, 0.25, 0.25, 0.25, 0.25, 0.5, 0.5, 0.5, 0.5, 0.5,
                               0.5, 0.5, 0.75, 0.75, 0.75, 0.75, 1.0, 1.0, 1.25, 1.25, 1.5, 1.5])
Backward2a_T_Ps_Lj = np.array([-24, -23, -19, -13, -11, -10, -19, -15, -6, -26, -21, -17, -16, -9,
                               -8, -15, -14, -26, -13, -9, -7, -27, -25, -11, -6, 1, 4, 8, 11, 0, 1,
                               5, 6, 10, 14, 16, 0, 4, 9, 17, 7, 18, 3, 15, 5, 18])
Backward2a_T_Ps_n = np.array([-0.39235983861984e6, 0.51526573827270e6, 0.40482443161048e5,
                              -0.32193790923902e3, 0.96961424218694e2, -0.22867846371773e2,
                              -0.44942914124357e6, -0.50118336020166e4, 0.35684463560015,
                              0.44235335848190e5, -0.13673388811708e5, 0.42163260207864e6,
                              0.22516925837475e5, 0.47442144865646e3, -0.14931130797647e3,
                              -0.19781126320452e6, -0.23554399470760e5, -0.19070616302076e5,
                              0.55375669883164e5, 0.38293691437363e4, -0.60391860580567e3,
                              0.19363102620331e4, 0.42660643698610e4, -0.59780638872718e4,
                              -0.70401463926862e3, 0.33836784107553e3, 0.20862786635187e2,
                              0.33834172656196e-1, -0.43124428414893e-4, 0.16653791356412e3,
                              -0.13986292055898e3, -0.78849547999872, 0.72132411753872e-1,
                              -0.59754839398283e-2, -0.12141358953904e-4, 0.23227096733871e-6,
                              -0.10538463566194e2, 0.20718925496502e1, -0.72193155260427e-1,
                              0.20749887081120e-6, -0.18340657911379e-1, 0.29036272348696e-6,
                              0.21037527893619, 0.25681239729999e-3, -0.12799002933781e-1,
                              -0.82198102652018e-5])

# Backward2b_T_Ps
Backward2b_T_Ps_Li = np.array([-6, -6, -5, -5, -4, -4, -4, -3, -3, -3, -3, -2, -2, -2, -2, -1, -1,
                               -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3,
                               4, 4, 5, 5, 5])
Backward2b_T_Ps_Lj = np.array([0, 11, 0, 11, 0, 1, 11, 0, 1, 11, 12, 0, 1, 6, 10, 0, 1, 5, 8, 9, 0,
                               1, 2, 4, 5, 6, 9, 0, 1, 2, 3, 7, 8, 0, 1, 5, 0, 1, 3, 0, 1, 0, 1, 2])
Backward2b_T_Ps_n = np.array([0.31687665083497e6, 0.20864175881858e2, -0.39859399803599e6,
                              -0.21816058518877e2, 0.22369785194242e6, -0.27841703445817e4,
                              0.99207436071480e1, -0.75197512299157e5, 0.29708605951158e4,
                              -0.34406878548526e1, 0.38815564249115, 0.17511295085750e5,
                              -0.14237112854449e4, 0.10943803364167e1, 0.89971619308495,
                              -0.33759740098958e4, 0.47162885818355e3, -0.19188241993679e1,
                              0.41078580492196, -0.33465378172097, 0.13870034777505e4,
                              -0.40663326195838e3, 0.41727347159610e2, 0.21932549434532e1,
                              -0.10320050009077e1, 0.35882943516703, 0.52511453726066e-2,
                              0.12838916450705e2, -0.28642437219381e1, 0.56912683664855,
                              -0.99962954584931e-1, -0.32632037778459e-2, 0.23320922576723e-3,
                              -0.15334809857450, 0.29072288239902e-1, 0.37534702741167e-3,
                              0.17296691702411e-2, -0.38556050844504e-3, -0.35017712292608e-4,
                              -0.14566393631492e-4, 0.56420857267269e-5, 0.41286150074605e-7,
                              -0.20684671118824e-7, 0.16409393674725e-8])

# Backward2c_T_Ps
Backward2c_T_Ps_Li = np.array([-2, -2, -1, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5,
                               5, 6, 6, 7, 7, 7, 7, 7])
Backward2c_T_Ps_Lj = np.array([0, 1, 0, 0, 1, 2, 3, 0, 1, 3, 4, 0, 1, 2, 0, 1, 5, 0, 1, 4, 0, 1, 2,
                               0, 1, 0, 1, 3, 4, 5])
Backward2c_T_Ps_n = np.array([0.90968501005365e3, 0.24045667088420e4, -0.59162326387130e3,
                              0.54145404128074e3, -0.27098308411192e3, 0.97976525097926e3,
                              -0.46966772959435e3, 0.14399274604723e2, -0.19104204230429e2,
                              0.53299167111971e1, -0.21252975375934e2, -0.31147334413760,
                              0.60334840894623, -0.42764839702509e-1, 0.58185597255259e-2,
                              -0.14597008284753e-1, 0.56631175631027e-2, -0.76155864584577e-4,
                              0.22440342919332e-3, -0.12561095013413e-4, 0.63323132660934e-6,
                              -0.20541989675375e-5, 0.36405370390082e-7, -0.29759897789215e-8,
                              0.10136618529763e-7, 0.59925719692351e-11, -0.20677870105164e-10,
                              -0.20874278181886e-10, 0.10162166825089e-9, -0.16429828281347e-9])

# Backward2a_P_hs
Backward2a_P_hs_Li = np.array([0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3,
                               3, 4, 5, 5, 6, 7])
Backward2a_P_hs_Lj = np.array([1, 3, 6, 16, 20, 22, 0, 1, 2, 3, 5, 6, 10, 16, 20, 22, 3, 16, 20, 0,
                               2, 3, 6, 16, 16, 3, 16, 3, 1])
Backward2a_P_hs_n = np.array([-0.182575361923032e-1, -0.125229548799536, 0.592290437320145,
                              0.604769706185122e1, 0.238624965444474e3, -0.298639090222922e3,
                              0.512250813040750e-1, -0.437266515606486, 0.413336902999504,
                              -0.516468254574773e1, -0.557014838445711e1, 0.128555037824478e2,
                              0.114144108953290e2, -0.119504225652714e3, -0.284777985961560e4,
                              0.431757846408006e4, 0.112894040802650e1, 0.197409186206319e4,
                              0.151612444706087e4, 0.141324451421235e-1, 0.585501282219601,
                              -0.297258075863012e1, 0.594567314847319e1, -0.623656565798905e4,
                              0.965986235133332e4, 0.681500934948134e1, -0.633207286824489e4,
                              -0.558919224465760e1, 0.400645798472063e-1])

# Backward2b_P_hs
Backward2b_P_hs_Li = np.array([0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 6,
                               6, 6, 7, 7, 8, 8, 8, 8, 12, 14])
Backward2b_P_hs_Lj = np.array([0, 1, 2, 4, 8, 0, 1, 2, 3, 5, 12, 1, 6, 18, 0, 1, 7, 12, 1, 16, 1,
                               12, 1, 8, 18, 1, 16, 1, 3, 14, 18, 10, 16])
Backward2b_P_hs_n = np.array([0.801496989929495e-1, -0.543862807146111, 0.337455597421283,
                              0.890555451157450e1, 0.313840736431485e3, 0.797367065977789,
                              -0.121616973556240e1, 0.872803386937477e1, -0.169769781757602e2,
                              -0.186552827328416e3, 0.951159274344237e5, -0.189168510120494e2,
                              -0.433407037194840e4, 0.543212633012715e9, 0.144793408386013,
                              0.128024559637516e3, -0.672309534071268e5, 0.336972380095287e8,
                              -0.586634196762720e3, -0.221403224769889e11, 0.171606668708389e4,
                              -0.570817595806302e9, -0.312109693178482e4, -0.207841384633010e7,
                              0.305605946157786e13, 0.322157004314333e4, 0.326810259797295e12,
                              -0.144104158934487e4, 0.410694867802691e3, 0.109077066873024e12,
                              -0.247964654258893e14, 0.188801906865134e10, -0.123651009018773e15])

# Backward2c_P_hs
Backward2c_P_hs_Li = np.array([0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 5,
                               5, 5, 5, 6, 6, 10, 12, 16])
Backward2c_P_hs_Lj = np.array([0, 1, 2, 3, 4, 8, 0, 2, 5, 8, 14, 2, 3, 7, 10, 18, 0, 5, 8, 16, 18,
                               18, 1, 4, 6, 14, 8, 18, 7, 7, 10])
Backward2c_P_hs_n = np.array([0.112225607199012, -0.339005953606712e1, -0.320503911730094e2,
                              -0.197597305104900e3, -0.407693861553446e3, 0.132943775222331e5,
                              0.170846839774007e1, 0.373694198142245e2, 0.358144365815434e4,
                              0.423014446424664e6, -0.751071025760063e9, 0.523446127607898e2,
                              -0.228351290812417e3, -0.960652417056937e6, -0.807059292526074e8,
                              0.162698017225669e13, 0.772465073604171, 0.463929973837746e5,
                              -0.137317885134128e8, 0.170470392630512e13, -0.251104628187308e14,
                              0.317748830835520e14, 0.538685623675312e2, -0.553089094625169e5,
                              -0.102861522421405e7, 0.204249418756234e13, 0.273918446626977e9,
                              -0.263963146312685e16, -0.107890854108088e10, -0.296492620980124e11,
                              -0.111754907323424e16])

# Region 3
Region3_Li = np.array([0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4,
                       4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 8, 9, 9, 10, 10, 11])
Region3_Lj = np.array([0, 1, 2, 7, 10, 12, 23, 2, 6, 15, 17, 0, 2, 6, 7, 22, 26, 0, 2, 4,
                       16, 26, 0, 2, 4, 26, 1, 3, 26, 0, 2, 26, 2, 26, 2, 26, 0, 1, 26])
Region3_n = np.array([-0.15732845290239e2, 0.20944396974307e2, -0.76867707878716e1,
                      0.26185947787954e1, -0.28080781148620e1, 0.12053369696517e1,
                      -0.84566812812502e-2, -0.12654315477714e1, -0.11524407806681e1,
                      0.88521043984318, -0.64207765181607, 0.38493460186671,
                      -0.85214708824206, 0.48972281541877e1, -0.30502617256965e1,
                      0.39420536879154e-1, 0.12558408424308, -0.27999329698710,
                      0.13899799569460e1, -0.20189915023570e1, -0.82147637173963e-2,
                      -0.47596035734923, 0.43984074473500e-1, -0.44476435428739,
                      0.90572070719733, .70522450087967, .10770512626332, -0.32913623258954,
                      -0.50871062041158, -0.22175400873096e-1, 0.94260751665092e-1,
                      0.16436278447961, -0.13503372241348e-1, -0.14834345352472e-1,
                      0.57922953628084e-3, 0.32308904703711e-2, 0.80964802996215e-4,
                      -0.16557679795037e-3, -0.44923899061815e-4])
Region3_n_Li_product = Region3_n * Region3_Li
Region3_n_Lj_product = Region3_n * Region3_Lj
Region3_n_Li_Lj_product = Region3_n * Region3_Li * Region3_Lj
Region3_Li_less_1 = Region3_Li - 1
Region3_Lj_less_1 = Region3_Lj - 1
Region3_Li_less_2 = Region3_Li - 2
Region3_Lj_less_2 = Region3_Lj - 2

# tab_P
tab_P_Li = np.array([0, 1, 2, -1, -2])
tab_P_n = np.array([0.154793642129415e4, -0.187661219490113e3, 0.213144632222113e2,
                    -0.191887498864292e4, 0.918419702359447e3])

# top_P
top_P_Li = np.array([0, 1, 2, -1, -2])
top_P_n = np.array([0.969461372400213e3, -0.332500170441278e3, 0.642859598466067e2,
                    0.773845935768222e3, -0.152313732937084e4])

# twx_P
twx_P_Li = np.array([0, 1, 2, -1, -2])
twx_P_n = np.array([0.728052609145380e1, 0.973505869861952e2, 0.147370491183191e2,
                    0.329196213998375e3, 0.873371668682417e3])

# Backward3a_V_Ph
Backward3a_v_Ph_Li = np.array([-12, -12, -12, -12, -10, -10, -10, -8, -8, -6, -6, -6, -4, -4, -3,
                               -2, -2, -1, -1, -1, -1, 0, 0, 1, 1, 1, 2, 2, 3, 4, 5, 8])
Backward3a_v_Ph_Lj = np.array([6, 8, 12, 18, 4, 7, 10, 5, 12, 3, 4, 22, 2, 3, 7, 3, 16, 0, 1, 2, 3,
                               0, 1, 0, 1, 2, 0, 2, 0, 2, 2, 2])
Backward3a_v_Ph_n = np.array([0.529944062966028e-2, -0.170099690234461, 0.111323814312927e2,
                              -0.217898123145125e4, -0.506061827980875e-3, 0.556495239685324,
                              -0.943672726094016e1, -0.297856807561527, 0.939353943717186e2,
                              0.192944939465981e-1, 0.421740664704763, -0.368914126282330e7,
                              -0.737566847600639e-2, -0.354753242424366, -0.199768169338727e1,
                              0.115456297059049e1, 0.568366875815960e4, 0.808169540124668e-2,
                              0.172416341519307, 0.104270175292927e1, -0.297691372792847,
                              0.560394465163593, 0.275234661176914, -0.148347894866012,
                              -0.651142513478515e-1, -0.292468715386302e1, 0.664876096952665e-1,
                              0.352335014263844e1, -0.146340792313332e-1, -0.224503486668184e1,
                              0.110533464706142e1, -0.408757344495612e-1])

# Backward3b_V_Ph
Backward3b_v_Ph_Li = np.array([-12, -12, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6, -6, -6, -4, -4, -4,
                               -3, -3, -2, -2, -1, -1, -1, -1, 0, 1, 1, 2, 2])
Backward3b_v_Ph_Lj = np.array([0, 1, 0, 1, 3, 6, 7, 8, 0, 1, 2, 5, 6, 10, 3, 6, 10, 0, 2, 1, 2, 0,
                               1, 4, 5, 0, 0, 1, 2, 6])
Backward3b_v_Ph_n = np.array([-0.225196934336318e-8, 0.140674363313486e-7, 0.233784085280560e-5,
                              -0.331833715229001e-4, 0.107956778514318e-2, -0.271382067378863,
                              0.107202262490333e1, -0.853821329075382, -0.215214194340526e-4,
                              0.769656088222730e-3, -0.431136580433864e-2, 0.453342167309331,
                              -0.507749535873652, -0.100475154528389e3, -0.219201924648793,
                              -0.321087965668917e1, 0.607567815637771e3, 0.557686450685932e-3,
                              0.187499040029550, 0.905368030448107e-2, 0.285417173048685,
                              0.329924030996098e-1, 0.239897419685483, 0.482754995951394e1,
                              -0.118035753702231e2, 0.169490044091791, -0.179967222507787e-1,
                              0.371810116332674e-1, -0.536288335065096e-1, 0.160697101092520e1])

# Backward3a_T_Ph
Backward3a_T_Ph_Li = np.array([-12, -12, -12, -12, -12, -12, -12, -12, -10, -10, -10, -8, -8, -8,
                               -8, -5, -3, -2, -2, -2, -1, -1, 0, 0, 1, 3, 3, 4, 4, 10, 12])
Backward3a_T_Ph_Lj = np.array([0, 1, 2, 6, 14, 16, 20, 22, 1, 5, 12, 0, 2, 4, 10, 2, 0, 1, 3, 4, 0,
                               2, 0, 1, 1, 0, 1, 0, 3, 4, 5])
Backward3a_T_Ph_n = np.array([-0.133645667811215e-6, 0.455912656802978e-5, -0.146294640700979e-4,
                              0.639341312970080e-2, 0.372783927268847e3, -0.718654377460447e4,
                              0.573494752103400e6, -0.267569329111439e7, -0.334066283302614e-4,
                              -0.245479214069597e-1, 0.478087847764996e2, 0.764664131818904e-5,
                              0.128350627676972e-2, 0.171219081377331e-1, -0.851007304583213e1,
                              -0.136513461629781e-1, -0.384460997596657e-5, 0.337423807911655e-2,
                              -0.551624873066791, 0.729202277107470, -0.992522757376041e-2,
                              -.119308831407288, .793929190615421, .454270731799386,
                              .20999859125991, -0.642109823904738e-2, -0.235155868604540e-1,
                              0.252233108341612e-2, -0.764885133368119e-2, 0.136176427574291e-1,
                              -0.133027883575669e-1])

# Backward3b_T_Ph
Backward3b_T_Ph_Li = np.array([-12, -12, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -6, -6, -6,
                               -4, -4, -3, -2, -2, -1, -1, -1, -1, -1, -1, 0, 0, 1, 3, 5, 6, 8])
Backward3b_T_Ph_Lj = np.array([0, 1, 0, 1, 5, 10, 12, 0, 1, 2, 4, 10, 0, 1, 2, 0, 1, 5, 0, 4, 2, 4,
                               6, 10, 14, 16, 0, 2, 1, 1, 1, 1, 1])
Backward3b_T_Ph_n = np.array([0.323254573644920e-4, -0.127575556587181e-3, -0.475851877356068e-3,
                              0.156183014181602e-2, 0.105724860113781, -0.858514221132534e2,
                              0.724140095480911e3, 0.296475810273257e-2, -0.592721983365988e-2,
                              -0.126305422818666e-1, -0.115716196364853, 0.849000969739595e2,
                              -0.108602260086615e-1, 0.154304475328851e-1, 0.750455441524466e-1,
                              0.252520973612982e-1, -0.602507901232996e-1, -0.307622221350501e1,
                              -0.574011959864879e-1, 0.503471360939849e1, -0.925081888584834,
                              0.391733882917546e1, -0.773146007130190e2, 0.949308762098587e4,
                              -0.141043719679409e7, 0.849166230819026e7, 0.861095729446704,
                              0.323346442811720, 0.873281936020439, -0.436653048526683,
                              0.286596714529479, -0.131778331276228, 0.676682064330275e-2])

# Backward3a_v_Ps
Backward3a_v_Ps_Li = np.array([-12, -12, -12, -10, -10, -10, -10, -8, -8, -8, -8, -6, -5, -4, -3,
                               -3, -2, -2, -1, -1, 0, 0, 0, 1, 2, 4, 5, 6])
Backward3a_v_Ps_Lj = np.array([10, 12, 14, 4, 8, 10, 20, 5, 6, 14, 16, 28, 1, 5, 2, 4, 3, 8, 1, 2,
                               0, 1, 3, 0, 0, 2, 2, 0])
Backward3a_v_Ps_n = np.array([0.795544074093975e2, -0.238261242984590e4, 0.176813100617787e5,
                              -0.110524727080379e-2, -0.153213833655326e2, 0.297544599376982e3,
                              -0.350315206871242e8, 0.277513761062119, -0.523964271036888,
                              -0.148011182995403e6, 0.160014899374266e7, 0.170802322663427e13,
                              0.246866996006494e-3, 0.165326084797980e1, -0.118008384666987,
                              0.253798642355900e1, 0.965127704669424, -0.282172420532826e2,
                              0.203224612353823, 0.110648186063513e1, 0.526127948451280,
                              0.277000018736321, 0.108153340501132e1, -0.744127885357893e-1,
                              0.164094443541384e-1, -0.680468275301065e-1, 0.257988576101640e-1,
                              -0.145749861944416e-3])

# Backward3b_v_Ps
Backward3b_v_Ps_Li = np.array([-12, -12, -12, -12, -12, -12, -10, -10, -10, -10, -8, -5, -5, -5, -4,
                               -4, -4, -4, -3, -2, -2, -2, -2, -2, -2, 0, 0, 0, 1, 1, 2])
Backward3b_v_Ps_Lj = np.array([0, 1, 2, 3, 5, 6, 0, 1, 2, 4, 0, 1, 2, 3, 0, 1, 2, 3, 1, 0, 1, 2, 3,
                               4, 12, 0, 1, 2, 0, 2, 2])
Backward3b_v_Ps_n = np.array([0.591599780322238e-4, -0.185465997137856e-2, 0.104190510480013e-1,
                              0.598647302038590e-2, -0.771391189901699, 0.172549765557036e1,
                              -0.467076079846526e-3, 0.134533823384439e-1, -0.808094336805495e-1,
                              0.508139374365767, 0.128584643361683e-2, -0.163899353915435e1,
                              0.586938199318063e1, -0.292466667918613e1, -0.614076301499537e-2,
                              0.576199014049172e1, -0.121613320606788e2, 0.167637540957944e1,
                              -0.744135838773463e1, 0.378168091437659e-1, 0.401432203027688e1,
                              0.160279837479185e2, 0.317848779347728e1, -0.358362310304853e1,
                              -0.115995260446827e7, 0.199256573577909, -0.122270624794624,
                              -0.191449143716586e2, -0.150448002905284e-1, 0.146407900162154e2,
                              -0.327477787188230e1])

# Backward3a_T_Ps
Backward3a_T_Ps_Li = np.array([-12, -12, -10, -10, -10, -10, -8, -8, -8, -8, -6, -6, -6, -5, -5, -5,
                               -4, -4, -4, -2, -2, -1, -1, 0, 0, 0, 1, 2, 2, 3, 8, 8, 10])
Backward3a_T_Ps_Lj = np.array([28, 32, 4, 10, 12, 14, 5, 7, 8, 28, 2, 6, 32, 0, 14, 32, 6, 10, 36,
                               1, 4, 1, 6, 0, 1, 4, 0, 0, 3, 2, 0, 1, 2])
Backward3a_T_Ps_n = np.array([0.150042008263875e10, -0.159397258480424e12, 0.502181140217975e-3,
                              -0.672057767855466e2, 0.145058545404456e4, -0.823889534888890e4,
                              -0.154852214233853, 0.112305046746695e2, -0.297000213482822e2,
                              0.438565132635495e11, 0.137837838635464e-2, -0.297478527157462e1,
                              0.971777947349413e13, -0.571527767052398e-4, 0.288307949778420e5,
                              -0.744428289262703e14, 0.128017324848921e2, -0.368275545889071e3,
                              0.664768904779177e16, 0.449359251958880e-1, -0.422897836099655e1,
                              -0.240614376434179, -0.474341365254924e1, 0.724093999126110,
                              0.923874349695897, 0.399043655281015e1, 0.384066651868009e-1,
                              -0.359344365571848e-2, -0.735196448821653, 0.188367048396131,
                              0.141064266818704e-3, -0.257418501496337e-2, 0.123220024851555e-2])

# Backward3b_T_Ps
Backward3b_T_Ps_Li = np.array([-12, -12, -12, -12, -8, -8, -8, -6, -6, -6, -5, -5, -5, -5, -5, -4,
                               -3, -3, -2, 0, 2, 3, 4, 5, 6, 8, 12, 14])
Backward3b_T_Ps_Lj = np.array([1, 3, 4, 7, 0, 1, 3, 0, 2, 4, 0, 1, 2, 4, 6, 12, 1, 6, 2, 0, 1, 1, 0,
                               24, 0, 3, 1, 2])
Backward3b_T_Ps_n = np.array([0.527111701601660, -0.401317830052742e2, 0.153020073134484e3,
                              -0.224799398218827e4, -0.193993484669048, -0.140467557893768e1,
                              0.426799878114024e2, 0.752810643416743, 0.226657238616417e2,
                              -0.622873556909932e3, -0.660823667935396, 0.841267087271658,
                              -0.253717501764397e2, 0.485708963532948e3, 0.880531517490555e3,
                              0.265015592794626e7, -0.359287150025783, -0.656991567673753e3,
                              0.241768149185367e1, 0.856873461222588, 0.655143675313458,
                              -0.213535213206406, 0.562974957606348e-2, -0.316955725450471e15,
                              -0.699997000152457e-3, 0.119845803210767e-1, 0.193848122022095e-4,
                              -0.215095749182309e-4])

# Backward3a_P_hs
Backward3a_P_hs_Li = np.array([0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 6, 7, 8, 10,
                               10, 14, 18, 20, 22, 22, 24, 28, 28, 32, 32])
Backward3a_P_hs_Lj = np.array([0, 1, 5, 0, 3, 4, 8, 14, 6, 16, 0, 2, 3, 0, 1, 4, 5, 28, 28, 24, 1,
                               32, 36, 22, 28, 36, 16, 28, 36, 16, 36, 10, 28])
Backward3a_P_hs_n = np.array([0.770889828326934e1, -0.260835009128688e2, 0.267416218930389e3,
                              0.172221089496844e2, -0.293542332145970e3, 0.614135601882478e3,
                              -0.610562757725674e5, -0.651272251118219e8, 0.735919313521937e5,
                              -0.116646505914191e11, 0.355267086434461e2, -0.596144543825955e3,
                              -0.475842430145708e3, 0.696781965359503e2, 0.335674250377312e3,
                              0.250526809130882e5, 0.146997380630766e6, 0.538069315091534e20,
                              0.143619827291346e22, 0.364985866165994e20, -0.254741561156775e4,
                              0.240120197096563e28, -0.393847464679496e30, 0.147073407024852e25,
                              -0.426391250432059e32, 0.194509340621077e39, 0.666212132114896e24,
                              0.706777016552858e34, 0.175563621975576e42, 0.108408607429124e29,
                              0.730872705175151e44, 0.159145847398870e25, 0.377121605943324e41])

# Backward3b_P_hs
Backward3b_P_hs_Li = np.array([-12, -12, -12, -12, -12, -10, -10, -10, -10, -8, -8, -6, -6, -6, -6,
                               -5, -4, -4, -4, -3, -3, -3, -3, -2, -2, -1, 0, 2, 2, 5, 6, 8, 10, 14,
                               14])
Backward3b_P_hs_Lj = np.array([2, 10, 12, 14, 20, 2, 10, 14, 18, 2, 8, 2, 6, 7, 8, 10, 4, 5, 8, 1,
                               3, 5, 6, 0, 1, 0, 3, 0, 1, 0, 1, 1, 1, 3, 7])
Backward3b_P_hs_n = np.array([0.125244360717979e-12, -0.126599322553713e-1, 0.506878030140626e1,
                              0.317847171154202e2, -0.391041161399932e6, -0.975733406392044e-10,
                              -0.186312419488279e2, 0.510973543414101e3, 0.373847005822362e6,
                              0.299804024666572e-7, 0.200544393820342e2, -0.498030487662829e-5,
                              -0.102301806360030e2, 0.552819126990325e2, -0.206211367510878e3,
                              -0.794012232324823e4, 0.782248472028153e1, -0.586544326902468e2,
                              0.355073647696481e4, -0.115303107290162e-3, -0.175092403171802e1,
                              0.257981687748160e3, -0.727048374179467e3, 0.121644822609198e-3,
                              0.393137871762692e-1, 0.704181005909296e-2, -0.829108200698110e2,
                              -0.265178818131250, 0.137531682453991e2, -0.522394090753046e2,
                              0.240556298941048e4, -0.227361631268929e5, 0.890746343932567e5,
                              -0.239234565822486e8, 0.568795808129714e10])

# Backward4_T_hs
Backward4_T_hs_Li = np.array([0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6,
                              8, 10, 10, 12, 14, 14, 16, 16, 18, 18, 18, 20, 28])
Backward4_T_hs_Lj = np.array([0, 3, 12, 0, 1, 2, 5, 0, 5, 8, 0, 2, 3, 4, 0, 1, 1, 2, 4, 16, 6, 8,
                              22, 1, 20, 36, 24, 1, 28, 12, 32, 14, 22, 36, 24, 36])
Backward4_T_hs_n = np.array([0.179882673606601, -0.267507455199603, 0.116276722612600e1,
                             0.147545428713616, -0.512871635973248, 0.421333567697984,
                             0.563749522189870, 0.429274443819153, -0.335704552142140e1,
                             0.108890916499278e2, -0.248483390456012, 0.304153221906390,
                             -0.494819763939905, 0.107551674933261e1, 0.733888415457688e-1,
                             0.140170545411085e-1, -0.106110975998808, 0.168324361811875e-1,
                             0.125028363714877e1, 0.101316840309509e4, -0.151791558000712e1,
                             0.524277865990866e2, 0.230495545563912e5, 0.249459806365456e-1,
                             0.210796467412137e7, 0.366836848613065e9, -0.144814105365163e9,
                             -0.179276373003590e-2, 0.489955602100459e10, 0.471262212070518e3,
                             -0.829294390198652e11, -0.171545662263191e4, 0.355777682973575e7,
                             0.586062760258436e12, -0.129887635078195e8, 0.317247449371057e11])

# Region 5
Region5_Ir = np.array([1, 1, 1, 2, 2, 3])
Region5_Jr = np.array([1, 2, 3, 3, 9, 7])
Region5_nr = np.array([0.15736404855259e-2, 0.90153761673944e-3, -0.50270077677648e-2,
                       0.22440037409485e-5, -0.41163275453471e-5, 0.37919454822955e-7])
Region5_nr_Ir_product = Region5_nr * Region5_Ir
Region5_nr_Jr_product = Region5_nr * Region5_Jr
Region5_nr_Ir_Jr_product = Region5_nr * Region5_Ir * Region5_Jr
Region5_Ir_less_1 = Region5_Ir - 1
Region5_Ir_less_2 = Region5_Ir - 2
Region5_Jr_less_1 = Region5_Jr - 1
Region5_Jr_less_2 = Region5_Jr - 2

# Region 5 cp0
Region5_cp0_Jo = np.array([0, 1, -3, -2, -1, 2])
Region5_cp0_no = np.array([-0.13179983674201e2, 0.68540841634434e1, -0.24805148933466e-1,
                           0.36901534980333, -0.31161318213925e1, -0.32961626538917])
Region5_cp0_no_Jo_product = Region5_cp0_no * Region5_cp0_Jo
Region5_cp0_Jo_less_1 = Region5_cp0_Jo - 1
Region5_cp0_Jo_less_2 = Region5_cp0_Jo - 2
Region5_cp0_no_Jo_Jo_less_1_product = Region5_cp0_no * Region5_cp0_Jo * Region5_cp0_Jo_less_1
