/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.progress;

import java.util.ArrayList;

public class ProgressManager {

	private final ArrayList<ProgressListener> listeners;

	public ProgressManager(ArrayList<ProgressListener> listeners) {

		this.listeners = listeners;

		if (listeners == null) {
			listeners = new ArrayList<ProgressListener>();
		}
	}

	public ProgressManager(ProgressListener listener) {

		this.listeners = new ArrayList<ProgressListener>();
		listeners.add(listener);
	}

	public void setProgressMaximum(int max) {

		for (ProgressListener listener : listeners) {
			listener.setProgressMaximum(max);
		}
	}

	public void setStageCount(int stageCount) {

		for (ProgressListener listener : listeners) {

			if (listener instanceof StageProgressListener) {
				((StageProgressListener) listener).setStageCount(stageCount);
			}
		}
	}


	public void nextStage() {

		for (ProgressListener listener : listeners) {

			if (listener instanceof StageProgressListener) {
				((StageProgressListener) listener).nextStage();
			}
		}
	}

	public boolean fireProgressEvent(ProgressEvent event) {

		boolean rc = true;

		if (listeners != null) {
			for (ProgressListener listener : listeners) {
				if (listener.progress(event) == false) {
					rc = false;
				}
			}
		}

		return rc;
	}

	public void finished(String text) {

		for (ProgressListener listener : listeners) {

			if (listener instanceof StageProgressListener) {
				((StageProgressListener) listener).finished(text);
			}
		}
	}
}
