      program     he5_sw_writedimscaleF_32
! This code creates fields and with just one call to HE5_SWdefdimscale creates dimmension scales
! for all fields that share the same dimension (both geofoelds and datafields). You need to call
! he5_sw_setupF_32 and he5_sw_definefieldsF_32 before calling the 
! he5_sw_definefields_and_all_dimscalesF_32
      implicit    none

      include     'hdfeos5.inc'

      integer     status
      integer     i, j
      integer     he5_swopen
      integer     he5_swattach
      integer     he5_swwrfld
      integer     he5_swwrattr
      integer     he5_swwrgattr
      integer     he5_ehwrglatt
      integer     he5_swwrlattr 
      integer     he5_swdetach
      integer     he5_swclose
      integer     HE5_SWsetdimscale
      integer     HE5_SWwritedscaleattr

      integer     swfid,swid1
      integer*4   datbuf_i1(1) 
      integer*4   datbuf_i(15)
      integer*4    count(2)
      integer*4   nbands
      integer     bands(3)
      integer*4   datbuf_i2(2)
      integer     xdim, ydim, ntime
      integer     data(15)
      integer     data2(20)
      integer     FAIL
      parameter   (FAIL=-1)
      integer     nscanline



!  /*
!   * We first open the HDF-EOS swath file, "swath.he5".  Because this file
!   * already exist and we wish to write to it, we use the H5F_ACC_RDWR access
!   * code in the open statement.  The HE5_SWopen routine returns the swath file
!   * id, swfid, which is used to identify the file in subsequent routines.
!   */ 
      nbands = 15
      do j=1,nbands
         data(j)=(j+1)*2
      enddo

      nscanline = 20
      do j=1,nscanline
         data2(j)=(j+1)*2
      enddo

      swfid = HE5_SWopen("swath.he5", HE5F_ACC_RDWR)
      write(*,*) 'File ID returned by he5_swopen(): ',swfid
!  /*
!   * If the swath file cannot be found, HE5_SWopen will return -1 for the file
!   * handle (swfid).  We there check that this is not the case before
!   * proceeding with the other routines.
!   * 
!   * The HE5_SWattach routine returns the handle to the existing swath "Swath1",
!   * SWid.  If the swath is not found, HE5_SWattach returns -1 for the handle.
!   */ 

      if (swfid .ne. FAIL) then
 
         SWid1 = HE5_SWattach(swfid, "Swath1")
         write(*,*) 'Swath ID returned by he5_swattach(): ',swid1

!      /* the field Spectra has Bands,Res2tr,Res2xtr dimensions. 
!	 xdim = 120;
!	 ydim = 200;
!	 Time dim is set to 10
!      */

         if (SWid1 .eq. -1) then
            
            write(*,*) 'Error: Cannot attach to swath Swath1. Stpped.'
            status = HE5_SWclose(swfid)
            stop
            
         endif
 
         status = HE5_SWsetdimscale2(SWid1, "Latitude", "GeoTrack",
     1        "geograck", nscanline, HE5T_NATIVE_INT, data2)
         write(*,*) 'Status returned by HE5_SWsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for GeoTrack',
     1                 ' dimemnsion in field Latitude'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif

         count(1)= 12
         status = HE5_SWwritedscaleattr(SWid1, "GeoTrack", "label", 
     1                         HE5T_NATIVE_CHAR, count, "GeoTrack Dim")
         write(*,*) 'Status returned by HE5_SWwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for',
     1                ' GeoTrack dimemnsion in field '
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif


         status = HE5_SWsetdimscale(SWid1, "Density", "GeoTrack",
     1                             nscanline, HE5T_NATIVE_INT, data2)
         write(*,*) 'Status returned by HE5_SWsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for GeoTrack',
     1                 ' dimemnsion in field Density'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif

 
         status = HE5_SWsetdimscale2(SWid1, "Temperature", "GeoTrack",
     1        "geotrack_2",nscanline, HE5T_NATIVE_INT, data2)
         write(*,*) 'Status returned by HE5_SWsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for GeoTrack',
     1                 ' dimemnsion in field Temperature'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif

                  
         status = HE5_SWsetdimscale(SWid1, "Spectra", "Bands", nbands,
     1                               HE5T_NATIVE_INT, data)
         write(*,*) 'Status returned by HE5_SWsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for Bands',
     1                 ' dimemnsion in field Vegetation'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif

         count(1)= 9
         status = HE5_SWwritedscaleattr(SWid1, "Bands", "label", 
     1                         HE5T_NATIVE_CHAR, count, "Bands Dim")
         write(*,*) 'Status returned by HE5_SWwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1                ' dimemnsion in field Spectra'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif
         
         count(1)= 4
         status = HE5_SWwritedscaleattr(SWid1, "Bands", "unit", 
     1                              HE5T_NATIVE_CHAR, count, "None")
         write(*,*) 'Status returned by HE5_SWwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1                 ' dimemnsion in field Spectra'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif
         
         count(1)= 2
         status = HE5_SWwritedscaleattr(SWid1, "Bands", "format", 
     1                                 HE5T_NATIVE_CHAR, count, "I2")
         write(*,*) 'Status returned by HE5_SWwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1                 ' dimemnsion in field Spectra'
            status = HE5_SWdetach(SWid1)
            status =  HE5_SWclose(swfid)
            stop
         endif

         datbuf_i1(1) = -999
         count(1)= 1
         status = HE5_SWwritedscaleattr(SWid1, "Bands", "MissingValue",
     1                             HE5T_NATIVE_INT, count, datbuf_i1)
         write(*,*) 'Status returned by HE5_SWwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1                 ' dimemnsion in field Spectra'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif
         
         datbuf_i(1) =  -999
         datbuf_i(2) =  0
         datbuf_i(3) =  999


         count(1)= 3
         status = HE5_SWwritedscaleattr(SWid1, "Bands", "IntValues", 
     1                               HE5T_NATIVE_INT, count, datbuf_i)
         write(*,*) 'Status returned by HE5_SWwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1         ' dimemnsion in field Spectra'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif
         
         status = HE5_SWdetach(SWid1)
         write(*,*) 'Status returned by he5_swdetach(): ',status

         status = HE5_SWclose(swfid)
         write(*,*) 'Status returned by he5_swclose(): ',status

      endif
      stop
      end

