// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/secrets/v1beta1/resources.proto

package secretmanager

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The state of a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion], indicating if it can be accessed.
type SecretVersion_State int32

const (
	// Not specified. This value is unused and invalid.
	SecretVersion_STATE_UNSPECIFIED SecretVersion_State = 0
	// The [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] may be accessed.
	SecretVersion_ENABLED SecretVersion_State = 1
	// The [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] may not be accessed, but the secret data
	// is still available and can be placed back into the [ENABLED][google.cloud.secrets.v1beta1.SecretVersion.State.ENABLED]
	// state.
	SecretVersion_DISABLED SecretVersion_State = 2
	// The [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] is destroyed and the secret data is no longer
	// stored. A version may not leave this state once entered.
	SecretVersion_DESTROYED SecretVersion_State = 3
)

var SecretVersion_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "ENABLED",
	2: "DISABLED",
	3: "DESTROYED",
}

var SecretVersion_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"ENABLED":           1,
	"DISABLED":          2,
	"DESTROYED":         3,
}

func (x SecretVersion_State) String() string {
	return proto.EnumName(SecretVersion_State_name, int32(x))
}

func (SecretVersion_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ec76e968c0470a1a, []int{1, 0}
}

// A [Secret][google.cloud.secrets.v1beta1.Secret] is a logical secret whose value and versions can
// be accessed.
//
// A [Secret][google.cloud.secrets.v1beta1.Secret] is made up of zero or more [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion] that
// represent the secret data.
type Secret struct {
	// Output only. The resource name of the [Secret][google.cloud.secrets.v1beta1.Secret] in the format `projects/*/secrets/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The replication policy of the secret data attached to the [Secret][google.cloud.secrets.v1beta1.Secret].
	//
	// The replication policy cannot be changed after the Secret has been created.
	Replication *Replication `protobuf:"bytes,2,opt,name=replication,proto3" json:"replication,omitempty"`
	// Output only. The time at which the [Secret][google.cloud.secrets.v1beta1.Secret] was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The labels assigned to this Secret.
	//
	// Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
	// of maximum 128 bytes, and must conform to the following PCRE regular
	// expression: `[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}`
	//
	// Label values must be between 0 and 63 characters long, have a UTF-8
	// encoding of maximum 128 bytes, and must conform to the following PCRE
	// regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`
	//
	// No more than 64 labels can be assigned to a given resource.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Secret) Reset()         { *m = Secret{} }
func (m *Secret) String() string { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()    {}
func (*Secret) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec76e968c0470a1a, []int{0}
}

func (m *Secret) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Secret.Unmarshal(m, b)
}
func (m *Secret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Secret.Marshal(b, m, deterministic)
}
func (m *Secret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Secret.Merge(m, src)
}
func (m *Secret) XXX_Size() int {
	return xxx_messageInfo_Secret.Size(m)
}
func (m *Secret) XXX_DiscardUnknown() {
	xxx_messageInfo_Secret.DiscardUnknown(m)
}

var xxx_messageInfo_Secret proto.InternalMessageInfo

func (m *Secret) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Secret) GetReplication() *Replication {
	if m != nil {
		return m.Replication
	}
	return nil
}

func (m *Secret) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Secret) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// A secret version resource in the Secret Manager API.
type SecretVersion struct {
	// Output only. The resource name of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] in the
	// format `projects/*/secrets/*/versions/*`.
	//
	// [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] IDs in a [Secret][google.cloud.secrets.v1beta1.Secret] start at 1 and
	// are incremented for each subsequent version of the secret.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] was destroyed.
	// Only present if [state][google.cloud.secrets.v1beta1.SecretVersion.state] is
	// [DESTROYED][google.cloud.secrets.v1beta1.SecretVersion.State.DESTROYED].
	DestroyTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=destroy_time,json=destroyTime,proto3" json:"destroy_time,omitempty"`
	// Output only. The current state of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
	State                SecretVersion_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.secrets.v1beta1.SecretVersion_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *SecretVersion) Reset()         { *m = SecretVersion{} }
func (m *SecretVersion) String() string { return proto.CompactTextString(m) }
func (*SecretVersion) ProtoMessage()    {}
func (*SecretVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec76e968c0470a1a, []int{1}
}

func (m *SecretVersion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecretVersion.Unmarshal(m, b)
}
func (m *SecretVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecretVersion.Marshal(b, m, deterministic)
}
func (m *SecretVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretVersion.Merge(m, src)
}
func (m *SecretVersion) XXX_Size() int {
	return xxx_messageInfo_SecretVersion.Size(m)
}
func (m *SecretVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretVersion.DiscardUnknown(m)
}

var xxx_messageInfo_SecretVersion proto.InternalMessageInfo

func (m *SecretVersion) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SecretVersion) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *SecretVersion) GetDestroyTime() *timestamp.Timestamp {
	if m != nil {
		return m.DestroyTime
	}
	return nil
}

func (m *SecretVersion) GetState() SecretVersion_State {
	if m != nil {
		return m.State
	}
	return SecretVersion_STATE_UNSPECIFIED
}

// A policy that defines the replication configuration of data.
type Replication struct {
	// The replication policy for this secret.
	//
	// Types that are valid to be assigned to Replication:
	//	*Replication_Automatic_
	//	*Replication_UserManaged_
	Replication          isReplication_Replication `protobuf_oneof:"replication"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Replication) Reset()         { *m = Replication{} }
func (m *Replication) String() string { return proto.CompactTextString(m) }
func (*Replication) ProtoMessage()    {}
func (*Replication) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec76e968c0470a1a, []int{2}
}

func (m *Replication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Replication.Unmarshal(m, b)
}
func (m *Replication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Replication.Marshal(b, m, deterministic)
}
func (m *Replication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Replication.Merge(m, src)
}
func (m *Replication) XXX_Size() int {
	return xxx_messageInfo_Replication.Size(m)
}
func (m *Replication) XXX_DiscardUnknown() {
	xxx_messageInfo_Replication.DiscardUnknown(m)
}

var xxx_messageInfo_Replication proto.InternalMessageInfo

type isReplication_Replication interface {
	isReplication_Replication()
}

type Replication_Automatic_ struct {
	Automatic *Replication_Automatic `protobuf:"bytes,1,opt,name=automatic,proto3,oneof"`
}

type Replication_UserManaged_ struct {
	UserManaged *Replication_UserManaged `protobuf:"bytes,2,opt,name=user_managed,json=userManaged,proto3,oneof"`
}

func (*Replication_Automatic_) isReplication_Replication() {}

func (*Replication_UserManaged_) isReplication_Replication() {}

func (m *Replication) GetReplication() isReplication_Replication {
	if m != nil {
		return m.Replication
	}
	return nil
}

func (m *Replication) GetAutomatic() *Replication_Automatic {
	if x, ok := m.GetReplication().(*Replication_Automatic_); ok {
		return x.Automatic
	}
	return nil
}

func (m *Replication) GetUserManaged() *Replication_UserManaged {
	if x, ok := m.GetReplication().(*Replication_UserManaged_); ok {
		return x.UserManaged
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Replication) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Replication_Automatic_)(nil),
		(*Replication_UserManaged_)(nil),
	}
}

// A replication policy that replicates the [Secret][google.cloud.secrets.v1beta1.Secret] payload without any
// restrictions.
type Replication_Automatic struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Replication_Automatic) Reset()         { *m = Replication_Automatic{} }
func (m *Replication_Automatic) String() string { return proto.CompactTextString(m) }
func (*Replication_Automatic) ProtoMessage()    {}
func (*Replication_Automatic) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec76e968c0470a1a, []int{2, 0}
}

func (m *Replication_Automatic) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Replication_Automatic.Unmarshal(m, b)
}
func (m *Replication_Automatic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Replication_Automatic.Marshal(b, m, deterministic)
}
func (m *Replication_Automatic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Replication_Automatic.Merge(m, src)
}
func (m *Replication_Automatic) XXX_Size() int {
	return xxx_messageInfo_Replication_Automatic.Size(m)
}
func (m *Replication_Automatic) XXX_DiscardUnknown() {
	xxx_messageInfo_Replication_Automatic.DiscardUnknown(m)
}

var xxx_messageInfo_Replication_Automatic proto.InternalMessageInfo

// A replication policy that replicates the [Secret][google.cloud.secrets.v1beta1.Secret] payload into the
// locations specified in [Secret.replication.user_managed.replicas][]
type Replication_UserManaged struct {
	// Required. The list of Replicas for this [Secret][google.cloud.secrets.v1beta1.Secret].
	//
	// Cannot be empty.
	Replicas             []*Replication_UserManaged_Replica `protobuf:"bytes,1,rep,name=replicas,proto3" json:"replicas,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *Replication_UserManaged) Reset()         { *m = Replication_UserManaged{} }
func (m *Replication_UserManaged) String() string { return proto.CompactTextString(m) }
func (*Replication_UserManaged) ProtoMessage()    {}
func (*Replication_UserManaged) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec76e968c0470a1a, []int{2, 1}
}

func (m *Replication_UserManaged) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Replication_UserManaged.Unmarshal(m, b)
}
func (m *Replication_UserManaged) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Replication_UserManaged.Marshal(b, m, deterministic)
}
func (m *Replication_UserManaged) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Replication_UserManaged.Merge(m, src)
}
func (m *Replication_UserManaged) XXX_Size() int {
	return xxx_messageInfo_Replication_UserManaged.Size(m)
}
func (m *Replication_UserManaged) XXX_DiscardUnknown() {
	xxx_messageInfo_Replication_UserManaged.DiscardUnknown(m)
}

var xxx_messageInfo_Replication_UserManaged proto.InternalMessageInfo

func (m *Replication_UserManaged) GetReplicas() []*Replication_UserManaged_Replica {
	if m != nil {
		return m.Replicas
	}
	return nil
}

// Represents a Replica for this [Secret][google.cloud.secrets.v1beta1.Secret].
type Replication_UserManaged_Replica struct {
	// The canonical IDs of the location to replicate data.
	// For example: `"us-east1"`.
	Location             string   `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Replication_UserManaged_Replica) Reset()         { *m = Replication_UserManaged_Replica{} }
func (m *Replication_UserManaged_Replica) String() string { return proto.CompactTextString(m) }
func (*Replication_UserManaged_Replica) ProtoMessage()    {}
func (*Replication_UserManaged_Replica) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec76e968c0470a1a, []int{2, 1, 0}
}

func (m *Replication_UserManaged_Replica) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Replication_UserManaged_Replica.Unmarshal(m, b)
}
func (m *Replication_UserManaged_Replica) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Replication_UserManaged_Replica.Marshal(b, m, deterministic)
}
func (m *Replication_UserManaged_Replica) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Replication_UserManaged_Replica.Merge(m, src)
}
func (m *Replication_UserManaged_Replica) XXX_Size() int {
	return xxx_messageInfo_Replication_UserManaged_Replica.Size(m)
}
func (m *Replication_UserManaged_Replica) XXX_DiscardUnknown() {
	xxx_messageInfo_Replication_UserManaged_Replica.DiscardUnknown(m)
}

var xxx_messageInfo_Replication_UserManaged_Replica proto.InternalMessageInfo

func (m *Replication_UserManaged_Replica) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

// A secret payload resource in the Secret Manager API. This contains the
// sensitive secret data that is associated with a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
type SecretPayload struct {
	// The secret data. Must be no larger than 64KiB.
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecretPayload) Reset()         { *m = SecretPayload{} }
func (m *SecretPayload) String() string { return proto.CompactTextString(m) }
func (*SecretPayload) ProtoMessage()    {}
func (*SecretPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec76e968c0470a1a, []int{3}
}

func (m *SecretPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecretPayload.Unmarshal(m, b)
}
func (m *SecretPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecretPayload.Marshal(b, m, deterministic)
}
func (m *SecretPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretPayload.Merge(m, src)
}
func (m *SecretPayload) XXX_Size() int {
	return xxx_messageInfo_SecretPayload.Size(m)
}
func (m *SecretPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretPayload.DiscardUnknown(m)
}

var xxx_messageInfo_SecretPayload proto.InternalMessageInfo

func (m *SecretPayload) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.secrets.v1beta1.SecretVersion_State", SecretVersion_State_name, SecretVersion_State_value)
	proto.RegisterType((*Secret)(nil), "google.cloud.secrets.v1beta1.Secret")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.secrets.v1beta1.Secret.LabelsEntry")
	proto.RegisterType((*SecretVersion)(nil), "google.cloud.secrets.v1beta1.SecretVersion")
	proto.RegisterType((*Replication)(nil), "google.cloud.secrets.v1beta1.Replication")
	proto.RegisterType((*Replication_Automatic)(nil), "google.cloud.secrets.v1beta1.Replication.Automatic")
	proto.RegisterType((*Replication_UserManaged)(nil), "google.cloud.secrets.v1beta1.Replication.UserManaged")
	proto.RegisterType((*Replication_UserManaged_Replica)(nil), "google.cloud.secrets.v1beta1.Replication.UserManaged.Replica")
	proto.RegisterType((*SecretPayload)(nil), "google.cloud.secrets.v1beta1.SecretPayload")
}

func init() {
	proto.RegisterFile("google/cloud/secrets/v1beta1/resources.proto", fileDescriptor_ec76e968c0470a1a)
}

var fileDescriptor_ec76e968c0470a1a = []byte{
	// 767 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0xcd, 0x6e, 0xeb, 0x44,
	0x14, 0xae, 0xed, 0x24, 0x6d, 0xc6, 0x69, 0x15, 0x46, 0x20, 0x82, 0x55, 0x89, 0x28, 0x55, 0x51,
	0x40, 0xc8, 0x26, 0xa9, 0x90, 0xc0, 0xa8, 0x12, 0x76, 0x63, 0x9a, 0xa2, 0xa6, 0x8d, 0xec, 0xb4,
	0x12, 0x55, 0x45, 0x34, 0x71, 0xa6, 0xc1, 0xd4, 0xf1, 0x44, 0xf6, 0x24, 0x52, 0x54, 0x75, 0xcb,
	0x8a, 0x25, 0x4f, 0xc0, 0x92, 0x07, 0xe0, 0x21, 0x78, 0x8a, 0xae, 0xbb, 0x63, 0xc7, 0x12, 0x79,
	0x66, 0x9c, 0x9f, 0xab, 0x7b, 0xab, 0xf4, 0xee, 0x66, 0x8e, 0xbf, 0xef, 0x9b, 0xef, 0x9c, 0x33,
	0x67, 0x0c, 0xbe, 0x1c, 0x11, 0x32, 0x0a, 0xb1, 0xe1, 0x87, 0x64, 0x3a, 0x34, 0x12, 0xec, 0xc7,
	0x98, 0x26, 0xc6, 0xac, 0x31, 0xc0, 0x14, 0x35, 0x8c, 0x18, 0x27, 0x64, 0x1a, 0xfb, 0x38, 0xd1,
	0x27, 0x31, 0xa1, 0x04, 0xee, 0x73, 0xb4, 0xce, 0xd0, 0xba, 0x40, 0xeb, 0x02, 0xad, 0x7d, 0x2a,
	0xb4, 0xd0, 0x24, 0x30, 0xee, 0x02, 0x1c, 0x0e, 0xfb, 0x03, 0xfc, 0x0b, 0x9a, 0x05, 0x24, 0xe6,
	0x74, 0xed, 0x93, 0x15, 0x40, 0x26, 0x2d, 0x3e, 0x65, 0x5c, 0xb6, 0x1b, 0x4c, 0xef, 0x0c, 0x1a,
	0x8c, 0x71, 0x42, 0xd1, 0x78, 0x22, 0x00, 0xfb, 0x2b, 0x5c, 0x14, 0x45, 0x84, 0x22, 0x1a, 0x90,
	0x48, 0x18, 0xab, 0xfd, 0xae, 0x80, 0x82, 0xc7, 0xec, 0xc0, 0x8f, 0x41, 0x2e, 0x42, 0x63, 0x5c,
	0x91, 0xaa, 0x52, 0xbd, 0x68, 0x2b, 0x4f, 0x96, 0xe2, 0xb2, 0x00, 0xf4, 0x80, 0x1a, 0xe3, 0x49,
	0x18, 0xf8, 0x8c, 0x59, 0x91, 0xab, 0x52, 0x5d, 0x6d, 0x7e, 0xae, 0xbf, 0x94, 0x92, 0xee, 0x2e,
	0x09, 0x76, 0xe1, 0xc9, 0xca, 0x3f, 0x59, 0xb2, 0xbb, 0xaa, 0x02, 0xbf, 0x07, 0xaa, 0x1f, 0x63,
	0x44, 0x71, 0x3f, 0x35, 0x5c, 0x51, 0x98, 0xa8, 0x96, 0x89, 0x66, 0xd9, 0xe8, 0xbd, 0x2c, 0x1b,
	0x6e, 0x08, 0x70, 0x4e, 0x1a, 0x85, 0x6d, 0x50, 0x08, 0xd1, 0x00, 0x87, 0x49, 0x25, 0x57, 0x55,
	0xea, 0x6a, 0xf3, 0xab, 0x97, 0x1d, 0xf1, 0x2c, 0xf5, 0x73, 0x46, 0x71, 0x22, 0x1a, 0xcf, 0x5d,
	0xc1, 0xd7, 0xbe, 0x05, 0xea, 0x4a, 0x18, 0x96, 0x81, 0x72, 0x8f, 0xe7, 0xbc, 0x0e, 0x6e, 0xba,
	0x84, 0x1f, 0x82, 0xfc, 0x0c, 0x85, 0x53, 0xcc, 0x72, 0x2f, 0xba, 0x7c, 0x63, 0xca, 0xdf, 0x48,
	0x66, 0xe7, 0xd9, 0xfa, 0x11, 0x1c, 0xf0, 0xb3, 0xc6, 0x28, 0x42, 0x23, 0x1c, 0x0b, 0x1b, 0x68,
	0x12, 0x24, 0xba, 0x4f, 0xc6, 0x86, 0x28, 0xef, 0xc1, 0x24, 0x26, 0xbf, 0x62, 0x9f, 0x26, 0xc6,
	0x83, 0x58, 0x3d, 0x2e, 0xae, 0xcd, 0x03, 0x5f, 0x3c, 0xd6, 0xfe, 0x56, 0xc0, 0x2e, 0xc7, 0x5f,
	0xe3, 0x38, 0x49, 0xeb, 0xf4, 0xce, 0xae, 0xbc, 0x51, 0x40, 0xf9, 0xf5, 0x05, 0xb4, 0x41, 0x69,
	0x88, 0x13, 0x1a, 0x93, 0xf9, 0xab, 0x7a, 0xa0, 0x0a, 0x12, 0xd3, 0x38, 0x07, 0xf9, 0x84, 0x22,
	0x8a, 0x2b, 0xb9, 0xaa, 0x54, 0xdf, 0x6b, 0x36, 0x36, 0xe9, 0x81, 0x48, 0x4d, 0xf7, 0x52, 0x22,
	0xd7, 0xe4, 0x22, 0xb5, 0x36, 0xc8, 0xb3, 0x20, 0xfc, 0x08, 0x7c, 0xe0, 0xf5, 0xac, 0x9e, 0xd3,
	0xbf, 0xba, 0xf0, 0xba, 0xce, 0xc9, 0xd9, 0x0f, 0x67, 0x4e, 0xab, 0xbc, 0x05, 0x55, 0xb0, 0xed,
	0x5c, 0x58, 0xf6, 0xb9, 0xd3, 0x2a, 0x4b, 0xb0, 0x04, 0x76, 0x5a, 0x67, 0x1e, 0xdf, 0xc9, 0x70,
	0x17, 0x14, 0x5b, 0x8e, 0xd7, 0x73, 0x2f, 0x7f, 0x72, 0x5a, 0x65, 0xc5, 0x8c, 0x9e, 0xad, 0x7b,
	0xf0, 0xc5, 0x06, 0x7d, 0xc9, 0xea, 0x7c, 0xbc, 0x41, 0x7b, 0x8c, 0x19, 0x07, 0x2f, 0x22, 0x7d,
	0x11, 0x78, 0xac, 0xfd, 0x2b, 0x03, 0x75, 0xe5, 0xce, 0x43, 0x0f, 0x14, 0xd1, 0x94, 0x92, 0x31,
	0xa2, 0x81, 0xcf, 0x7a, 0xa7, 0x36, 0x8f, 0x36, 0x9e, 0x18, 0xdd, 0xca, 0xa8, 0xed, 0x2d, 0x77,
	0xa9, 0x03, 0x6f, 0x40, 0x69, 0x9a, 0xe0, 0xb8, 0xcf, 0x13, 0x1a, 0x8a, 0x9e, 0x7f, 0xbd, 0xb9,
	0xee, 0x55, 0x82, 0xe3, 0x0e, 0x27, 0xb7, 0xb7, 0x5c, 0x75, 0xba, 0xdc, 0x6a, 0x2a, 0x28, 0x2e,
	0x4e, 0xd5, 0xfe, 0x90, 0x80, 0xba, 0x82, 0x85, 0x3f, 0x83, 0x1d, 0x31, 0xbb, 0x49, 0x45, 0x62,
	0xc3, 0x76, 0xfc, 0x5e, 0x87, 0x66, 0xf1, 0xb4, 0xe9, 0xb2, 0xbb, 0xd0, 0xd4, 0x0e, 0xc1, 0xb6,
	0xf8, 0x02, 0x35, 0xb0, 0x13, 0x12, 0xf1, 0xd2, 0xf0, 0x09, 0x5c, 0xec, 0xed, 0xdd, 0xb5, 0x87,
	0xa8, 0x76, 0x90, 0xcd, 0x4a, 0x17, 0xcd, 0x43, 0x82, 0x86, 0x10, 0x82, 0xdc, 0x10, 0x51, 0xc4,
	0x78, 0x25, 0x97, 0xad, 0xed, 0xdf, 0x64, 0xf0, 0x99, 0x4f, 0xc6, 0x6f, 0xb3, 0x9b, 0xdd, 0x0b,
	0x61, 0xda, 0xde, 0x73, 0xb3, 0x57, 0xbb, 0x9b, 0x5e, 0xfd, 0xae, 0x74, 0x73, 0x29, 0x58, 0x23,
	0x12, 0xa2, 0x68, 0xa4, 0x93, 0x78, 0x64, 0x8c, 0x70, 0xc4, 0x06, 0xc3, 0x58, 0xde, 0xa6, 0xb5,
	0x7f, 0x80, 0x10, 0xcd, 0xfe, 0x04, 0xdf, 0xad, 0x45, 0xff, 0x93, 0xa4, 0x3f, 0x65, 0xe5, 0xd4,
	0xeb, 0xfc, 0x25, 0xd7, 0x4e, 0xb9, 0xf4, 0x09, 0x33, 0xc4, 0xf3, 0xe8, 0x08, 0x43, 0xd7, 0x0d,
	0x3b, 0xe5, 0xfe, 0x93, 0x81, 0x6e, 0x19, 0xe8, 0x76, 0x0d, 0x74, 0x7b, 0xcd, 0x0f, 0x78, 0x96,
	0x0f, 0x39, 0xc8, 0x34, 0x19, 0xca, 0x34, 0xd7, 0x60, 0xa6, 0x29, 0x70, 0x83, 0x02, 0xb3, 0x7d,
	0xf4, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x17, 0x20, 0x21, 0xc1, 0xb9, 0x06, 0x00, 0x00,
}
