// Code generated by protoc-gen-ts_proto. DO NOT EDIT.
// versions:
//   protoc-gen-ts_proto  v2.6.1
//   protoc               v5.29.4
// source: events.proto

/* eslint-disable */
import { Any } from "./google/protobuf/any";
import { Timestamp } from "./google/protobuf/timestamp";

export interface CloudEvent {
  /** Required Attributes */
  id: string;
  /** URI-reference */
  source: string;
  specVersion: string;
  type: string;
  /** Optional & Extension Attributes */
  attributes: { [key: string]: CloudEvent_CloudEventAttributeValue };
  /** -- CloudEvent Data (Bytes, Text, or Proto) */
  data?: { $case: "binaryData"; binaryData: Buffer } | { $case: "textData"; textData: string } | {
    $case: "protoData";
    protoData: Any;
  } | undefined;
}

export interface CloudEvent_AttributesEntry {
  key: string;
  value: CloudEvent_CloudEventAttributeValue | undefined;
}

export interface CloudEvent_CloudEventAttributeValue {
  attr?:
    | { $case: "ceBoolean"; ceBoolean: boolean }
    | { $case: "ceInteger"; ceInteger: number }
    | { $case: "ceString"; ceString: string }
    | { $case: "ceBytes"; ceBytes: Buffer }
    | { $case: "ceUri"; ceUri: string }
    | { $case: "ceUriRef"; ceUriRef: string }
    | { $case: "ceTimestamp"; ceTimestamp: Date }
    | undefined;
}

export interface CloudEventBatch {
  events: CloudEvent[];
}

export const CloudEvent: MessageFns<CloudEvent> = {
  fromJSON(object: any): CloudEvent {
    return {
      id: isSet(object.id) ? globalThis.String(object.id) : "",
      source: isSet(object.source) ? globalThis.String(object.source) : "",
      specVersion: isSet(object.specVersion) ? globalThis.String(object.specVersion) : "",
      type: isSet(object.type) ? globalThis.String(object.type) : "",
      attributes: isObject(object.attributes)
        ? Object.entries(object.attributes).reduce<{ [key: string]: CloudEvent_CloudEventAttributeValue }>(
          (acc, [key, value]) => {
            acc[key] = CloudEvent_CloudEventAttributeValue.fromJSON(value);
            return acc;
          },
          {},
        )
        : {},
      data: isSet(object.binaryData)
        ? { $case: "binaryData", binaryData: Buffer.from(bytesFromBase64(object.binaryData)) }
        : isSet(object.textData)
        ? { $case: "textData", textData: globalThis.String(object.textData) }
        : isSet(object.protoData)
        ? { $case: "protoData", protoData: Any.fromJSON(object.protoData) }
        : undefined,
    };
  },

  toJSON(message: CloudEvent): unknown {
    const obj: any = {};
    if (message.id !== "") {
      obj.id = message.id;
    }
    if (message.source !== "") {
      obj.source = message.source;
    }
    if (message.specVersion !== "") {
      obj.specVersion = message.specVersion;
    }
    if (message.type !== "") {
      obj.type = message.type;
    }
    if (message.attributes) {
      const entries = Object.entries(message.attributes);
      if (entries.length > 0) {
        obj.attributes = {};
        entries.forEach(([k, v]) => {
          obj.attributes[k] = CloudEvent_CloudEventAttributeValue.toJSON(v);
        });
      }
    }
    if (message.data?.$case === "binaryData") {
      obj.binaryData = base64FromBytes(message.data.binaryData);
    } else if (message.data?.$case === "textData") {
      obj.textData = message.data.textData;
    } else if (message.data?.$case === "protoData") {
      obj.protoData = Any.toJSON(message.data.protoData);
    }
    return obj;
  },
};

export const CloudEvent_AttributesEntry: MessageFns<CloudEvent_AttributesEntry> = {
  fromJSON(object: any): CloudEvent_AttributesEntry {
    return {
      key: isSet(object.key) ? globalThis.String(object.key) : "",
      value: isSet(object.value) ? CloudEvent_CloudEventAttributeValue.fromJSON(object.value) : undefined,
    };
  },

  toJSON(message: CloudEvent_AttributesEntry): unknown {
    const obj: any = {};
    if (message.key !== "") {
      obj.key = message.key;
    }
    if (message.value !== undefined) {
      obj.value = CloudEvent_CloudEventAttributeValue.toJSON(message.value);
    }
    return obj;
  },
};

export const CloudEvent_CloudEventAttributeValue: MessageFns<CloudEvent_CloudEventAttributeValue> = {
  fromJSON(object: any): CloudEvent_CloudEventAttributeValue {
    return {
      attr: isSet(object.ceBoolean)
        ? { $case: "ceBoolean", ceBoolean: globalThis.Boolean(object.ceBoolean) }
        : isSet(object.ceInteger)
        ? { $case: "ceInteger", ceInteger: globalThis.Number(object.ceInteger) }
        : isSet(object.ceString)
        ? { $case: "ceString", ceString: globalThis.String(object.ceString) }
        : isSet(object.ceBytes)
        ? { $case: "ceBytes", ceBytes: Buffer.from(bytesFromBase64(object.ceBytes)) }
        : isSet(object.ceUri)
        ? { $case: "ceUri", ceUri: globalThis.String(object.ceUri) }
        : isSet(object.ceUriRef)
        ? { $case: "ceUriRef", ceUriRef: globalThis.String(object.ceUriRef) }
        : isSet(object.ceTimestamp)
        ? { $case: "ceTimestamp", ceTimestamp: fromJsonTimestamp(object.ceTimestamp) }
        : undefined,
    };
  },

  toJSON(message: CloudEvent_CloudEventAttributeValue): unknown {
    const obj: any = {};
    if (message.attr?.$case === "ceBoolean") {
      obj.ceBoolean = message.attr.ceBoolean;
    } else if (message.attr?.$case === "ceInteger") {
      obj.ceInteger = Math.round(message.attr.ceInteger);
    } else if (message.attr?.$case === "ceString") {
      obj.ceString = message.attr.ceString;
    } else if (message.attr?.$case === "ceBytes") {
      obj.ceBytes = base64FromBytes(message.attr.ceBytes);
    } else if (message.attr?.$case === "ceUri") {
      obj.ceUri = message.attr.ceUri;
    } else if (message.attr?.$case === "ceUriRef") {
      obj.ceUriRef = message.attr.ceUriRef;
    } else if (message.attr?.$case === "ceTimestamp") {
      obj.ceTimestamp = message.attr.ceTimestamp.toISOString();
    }
    return obj;
  },
};

export const CloudEventBatch: MessageFns<CloudEventBatch> = {
  fromJSON(object: any): CloudEventBatch {
    return {
      events: globalThis.Array.isArray(object?.events) ? object.events.map((e: any) => CloudEvent.fromJSON(e)) : [],
    };
  },

  toJSON(message: CloudEventBatch): unknown {
    const obj: any = {};
    if (message.events?.length) {
      obj.events = message.events.map((e) => CloudEvent.toJSON(e));
    }
    return obj;
  },
};

function bytesFromBase64(b64: string): Uint8Array {
  return Uint8Array.from(globalThis.Buffer.from(b64, "base64"));
}

function base64FromBytes(arr: Uint8Array): string {
  return globalThis.Buffer.from(arr).toString("base64");
}

function fromTimestamp(t: Timestamp): Date {
  let millis = (globalThis.Number(t.seconds) || 0) * 1_000;
  millis += (t.nanos || 0) / 1_000_000;
  return new globalThis.Date(millis);
}

function fromJsonTimestamp(o: any): Date {
  if (o instanceof globalThis.Date) {
    return o;
  } else if (typeof o === "string") {
    return new globalThis.Date(o);
  } else {
    return fromTimestamp(Timestamp.fromJSON(o));
  }
}

function isObject(value: any): boolean {
  return typeof value === "object" && value !== null;
}

function isSet(value: any): boolean {
  return value !== null && value !== undefined;
}

interface MessageFns<T> {
  fromJSON(object: any): T;
  toJSON(message: T): unknown;
}
