// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package m2iface provides an interface to enable mocking the AWSMainframeModernization service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package m2iface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/m2"
)

// M2API provides an interface to enable mocking the
// m2.M2 service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWSMainframeModernization.
//	func myFunc(svc m2iface.M2API) bool {
//	    // Make svc.CancelBatchJobExecution request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := m2.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockM2Client struct {
//	    m2iface.M2API
//	}
//	func (m *mockM2Client) CancelBatchJobExecution(input *m2.CancelBatchJobExecutionInput) (*m2.CancelBatchJobExecutionOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockM2Client{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type M2API interface {
	CancelBatchJobExecution(*m2.CancelBatchJobExecutionInput) (*m2.CancelBatchJobExecutionOutput, error)
	CancelBatchJobExecutionWithContext(aws.Context, *m2.CancelBatchJobExecutionInput, ...request.Option) (*m2.CancelBatchJobExecutionOutput, error)
	CancelBatchJobExecutionRequest(*m2.CancelBatchJobExecutionInput) (*request.Request, *m2.CancelBatchJobExecutionOutput)

	CreateApplication(*m2.CreateApplicationInput) (*m2.CreateApplicationOutput, error)
	CreateApplicationWithContext(aws.Context, *m2.CreateApplicationInput, ...request.Option) (*m2.CreateApplicationOutput, error)
	CreateApplicationRequest(*m2.CreateApplicationInput) (*request.Request, *m2.CreateApplicationOutput)

	CreateDataSetImportTask(*m2.CreateDataSetImportTaskInput) (*m2.CreateDataSetImportTaskOutput, error)
	CreateDataSetImportTaskWithContext(aws.Context, *m2.CreateDataSetImportTaskInput, ...request.Option) (*m2.CreateDataSetImportTaskOutput, error)
	CreateDataSetImportTaskRequest(*m2.CreateDataSetImportTaskInput) (*request.Request, *m2.CreateDataSetImportTaskOutput)

	CreateDeployment(*m2.CreateDeploymentInput) (*m2.CreateDeploymentOutput, error)
	CreateDeploymentWithContext(aws.Context, *m2.CreateDeploymentInput, ...request.Option) (*m2.CreateDeploymentOutput, error)
	CreateDeploymentRequest(*m2.CreateDeploymentInput) (*request.Request, *m2.CreateDeploymentOutput)

	CreateEnvironment(*m2.CreateEnvironmentInput) (*m2.CreateEnvironmentOutput, error)
	CreateEnvironmentWithContext(aws.Context, *m2.CreateEnvironmentInput, ...request.Option) (*m2.CreateEnvironmentOutput, error)
	CreateEnvironmentRequest(*m2.CreateEnvironmentInput) (*request.Request, *m2.CreateEnvironmentOutput)

	DeleteApplication(*m2.DeleteApplicationInput) (*m2.DeleteApplicationOutput, error)
	DeleteApplicationWithContext(aws.Context, *m2.DeleteApplicationInput, ...request.Option) (*m2.DeleteApplicationOutput, error)
	DeleteApplicationRequest(*m2.DeleteApplicationInput) (*request.Request, *m2.DeleteApplicationOutput)

	DeleteApplicationFromEnvironment(*m2.DeleteApplicationFromEnvironmentInput) (*m2.DeleteApplicationFromEnvironmentOutput, error)
	DeleteApplicationFromEnvironmentWithContext(aws.Context, *m2.DeleteApplicationFromEnvironmentInput, ...request.Option) (*m2.DeleteApplicationFromEnvironmentOutput, error)
	DeleteApplicationFromEnvironmentRequest(*m2.DeleteApplicationFromEnvironmentInput) (*request.Request, *m2.DeleteApplicationFromEnvironmentOutput)

	DeleteEnvironment(*m2.DeleteEnvironmentInput) (*m2.DeleteEnvironmentOutput, error)
	DeleteEnvironmentWithContext(aws.Context, *m2.DeleteEnvironmentInput, ...request.Option) (*m2.DeleteEnvironmentOutput, error)
	DeleteEnvironmentRequest(*m2.DeleteEnvironmentInput) (*request.Request, *m2.DeleteEnvironmentOutput)

	GetApplication(*m2.GetApplicationInput) (*m2.GetApplicationOutput, error)
	GetApplicationWithContext(aws.Context, *m2.GetApplicationInput, ...request.Option) (*m2.GetApplicationOutput, error)
	GetApplicationRequest(*m2.GetApplicationInput) (*request.Request, *m2.GetApplicationOutput)

	GetApplicationVersion(*m2.GetApplicationVersionInput) (*m2.GetApplicationVersionOutput, error)
	GetApplicationVersionWithContext(aws.Context, *m2.GetApplicationVersionInput, ...request.Option) (*m2.GetApplicationVersionOutput, error)
	GetApplicationVersionRequest(*m2.GetApplicationVersionInput) (*request.Request, *m2.GetApplicationVersionOutput)

	GetBatchJobExecution(*m2.GetBatchJobExecutionInput) (*m2.GetBatchJobExecutionOutput, error)
	GetBatchJobExecutionWithContext(aws.Context, *m2.GetBatchJobExecutionInput, ...request.Option) (*m2.GetBatchJobExecutionOutput, error)
	GetBatchJobExecutionRequest(*m2.GetBatchJobExecutionInput) (*request.Request, *m2.GetBatchJobExecutionOutput)

	GetDataSetDetails(*m2.GetDataSetDetailsInput) (*m2.GetDataSetDetailsOutput, error)
	GetDataSetDetailsWithContext(aws.Context, *m2.GetDataSetDetailsInput, ...request.Option) (*m2.GetDataSetDetailsOutput, error)
	GetDataSetDetailsRequest(*m2.GetDataSetDetailsInput) (*request.Request, *m2.GetDataSetDetailsOutput)

	GetDataSetImportTask(*m2.GetDataSetImportTaskInput) (*m2.GetDataSetImportTaskOutput, error)
	GetDataSetImportTaskWithContext(aws.Context, *m2.GetDataSetImportTaskInput, ...request.Option) (*m2.GetDataSetImportTaskOutput, error)
	GetDataSetImportTaskRequest(*m2.GetDataSetImportTaskInput) (*request.Request, *m2.GetDataSetImportTaskOutput)

	GetDeployment(*m2.GetDeploymentInput) (*m2.GetDeploymentOutput, error)
	GetDeploymentWithContext(aws.Context, *m2.GetDeploymentInput, ...request.Option) (*m2.GetDeploymentOutput, error)
	GetDeploymentRequest(*m2.GetDeploymentInput) (*request.Request, *m2.GetDeploymentOutput)

	GetEnvironment(*m2.GetEnvironmentInput) (*m2.GetEnvironmentOutput, error)
	GetEnvironmentWithContext(aws.Context, *m2.GetEnvironmentInput, ...request.Option) (*m2.GetEnvironmentOutput, error)
	GetEnvironmentRequest(*m2.GetEnvironmentInput) (*request.Request, *m2.GetEnvironmentOutput)

	GetSignedBluinsightsUrl(*m2.GetSignedBluinsightsUrlInput) (*m2.GetSignedBluinsightsUrlOutput, error)
	GetSignedBluinsightsUrlWithContext(aws.Context, *m2.GetSignedBluinsightsUrlInput, ...request.Option) (*m2.GetSignedBluinsightsUrlOutput, error)
	GetSignedBluinsightsUrlRequest(*m2.GetSignedBluinsightsUrlInput) (*request.Request, *m2.GetSignedBluinsightsUrlOutput)

	ListApplicationVersions(*m2.ListApplicationVersionsInput) (*m2.ListApplicationVersionsOutput, error)
	ListApplicationVersionsWithContext(aws.Context, *m2.ListApplicationVersionsInput, ...request.Option) (*m2.ListApplicationVersionsOutput, error)
	ListApplicationVersionsRequest(*m2.ListApplicationVersionsInput) (*request.Request, *m2.ListApplicationVersionsOutput)

	ListApplicationVersionsPages(*m2.ListApplicationVersionsInput, func(*m2.ListApplicationVersionsOutput, bool) bool) error
	ListApplicationVersionsPagesWithContext(aws.Context, *m2.ListApplicationVersionsInput, func(*m2.ListApplicationVersionsOutput, bool) bool, ...request.Option) error

	ListApplications(*m2.ListApplicationsInput) (*m2.ListApplicationsOutput, error)
	ListApplicationsWithContext(aws.Context, *m2.ListApplicationsInput, ...request.Option) (*m2.ListApplicationsOutput, error)
	ListApplicationsRequest(*m2.ListApplicationsInput) (*request.Request, *m2.ListApplicationsOutput)

	ListApplicationsPages(*m2.ListApplicationsInput, func(*m2.ListApplicationsOutput, bool) bool) error
	ListApplicationsPagesWithContext(aws.Context, *m2.ListApplicationsInput, func(*m2.ListApplicationsOutput, bool) bool, ...request.Option) error

	ListBatchJobDefinitions(*m2.ListBatchJobDefinitionsInput) (*m2.ListBatchJobDefinitionsOutput, error)
	ListBatchJobDefinitionsWithContext(aws.Context, *m2.ListBatchJobDefinitionsInput, ...request.Option) (*m2.ListBatchJobDefinitionsOutput, error)
	ListBatchJobDefinitionsRequest(*m2.ListBatchJobDefinitionsInput) (*request.Request, *m2.ListBatchJobDefinitionsOutput)

	ListBatchJobDefinitionsPages(*m2.ListBatchJobDefinitionsInput, func(*m2.ListBatchJobDefinitionsOutput, bool) bool) error
	ListBatchJobDefinitionsPagesWithContext(aws.Context, *m2.ListBatchJobDefinitionsInput, func(*m2.ListBatchJobDefinitionsOutput, bool) bool, ...request.Option) error

	ListBatchJobExecutions(*m2.ListBatchJobExecutionsInput) (*m2.ListBatchJobExecutionsOutput, error)
	ListBatchJobExecutionsWithContext(aws.Context, *m2.ListBatchJobExecutionsInput, ...request.Option) (*m2.ListBatchJobExecutionsOutput, error)
	ListBatchJobExecutionsRequest(*m2.ListBatchJobExecutionsInput) (*request.Request, *m2.ListBatchJobExecutionsOutput)

	ListBatchJobExecutionsPages(*m2.ListBatchJobExecutionsInput, func(*m2.ListBatchJobExecutionsOutput, bool) bool) error
	ListBatchJobExecutionsPagesWithContext(aws.Context, *m2.ListBatchJobExecutionsInput, func(*m2.ListBatchJobExecutionsOutput, bool) bool, ...request.Option) error

	ListDataSetImportHistory(*m2.ListDataSetImportHistoryInput) (*m2.ListDataSetImportHistoryOutput, error)
	ListDataSetImportHistoryWithContext(aws.Context, *m2.ListDataSetImportHistoryInput, ...request.Option) (*m2.ListDataSetImportHistoryOutput, error)
	ListDataSetImportHistoryRequest(*m2.ListDataSetImportHistoryInput) (*request.Request, *m2.ListDataSetImportHistoryOutput)

	ListDataSetImportHistoryPages(*m2.ListDataSetImportHistoryInput, func(*m2.ListDataSetImportHistoryOutput, bool) bool) error
	ListDataSetImportHistoryPagesWithContext(aws.Context, *m2.ListDataSetImportHistoryInput, func(*m2.ListDataSetImportHistoryOutput, bool) bool, ...request.Option) error

	ListDataSets(*m2.ListDataSetsInput) (*m2.ListDataSetsOutput, error)
	ListDataSetsWithContext(aws.Context, *m2.ListDataSetsInput, ...request.Option) (*m2.ListDataSetsOutput, error)
	ListDataSetsRequest(*m2.ListDataSetsInput) (*request.Request, *m2.ListDataSetsOutput)

	ListDataSetsPages(*m2.ListDataSetsInput, func(*m2.ListDataSetsOutput, bool) bool) error
	ListDataSetsPagesWithContext(aws.Context, *m2.ListDataSetsInput, func(*m2.ListDataSetsOutput, bool) bool, ...request.Option) error

	ListDeployments(*m2.ListDeploymentsInput) (*m2.ListDeploymentsOutput, error)
	ListDeploymentsWithContext(aws.Context, *m2.ListDeploymentsInput, ...request.Option) (*m2.ListDeploymentsOutput, error)
	ListDeploymentsRequest(*m2.ListDeploymentsInput) (*request.Request, *m2.ListDeploymentsOutput)

	ListDeploymentsPages(*m2.ListDeploymentsInput, func(*m2.ListDeploymentsOutput, bool) bool) error
	ListDeploymentsPagesWithContext(aws.Context, *m2.ListDeploymentsInput, func(*m2.ListDeploymentsOutput, bool) bool, ...request.Option) error

	ListEngineVersions(*m2.ListEngineVersionsInput) (*m2.ListEngineVersionsOutput, error)
	ListEngineVersionsWithContext(aws.Context, *m2.ListEngineVersionsInput, ...request.Option) (*m2.ListEngineVersionsOutput, error)
	ListEngineVersionsRequest(*m2.ListEngineVersionsInput) (*request.Request, *m2.ListEngineVersionsOutput)

	ListEngineVersionsPages(*m2.ListEngineVersionsInput, func(*m2.ListEngineVersionsOutput, bool) bool) error
	ListEngineVersionsPagesWithContext(aws.Context, *m2.ListEngineVersionsInput, func(*m2.ListEngineVersionsOutput, bool) bool, ...request.Option) error

	ListEnvironments(*m2.ListEnvironmentsInput) (*m2.ListEnvironmentsOutput, error)
	ListEnvironmentsWithContext(aws.Context, *m2.ListEnvironmentsInput, ...request.Option) (*m2.ListEnvironmentsOutput, error)
	ListEnvironmentsRequest(*m2.ListEnvironmentsInput) (*request.Request, *m2.ListEnvironmentsOutput)

	ListEnvironmentsPages(*m2.ListEnvironmentsInput, func(*m2.ListEnvironmentsOutput, bool) bool) error
	ListEnvironmentsPagesWithContext(aws.Context, *m2.ListEnvironmentsInput, func(*m2.ListEnvironmentsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*m2.ListTagsForResourceInput) (*m2.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *m2.ListTagsForResourceInput, ...request.Option) (*m2.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*m2.ListTagsForResourceInput) (*request.Request, *m2.ListTagsForResourceOutput)

	StartApplication(*m2.StartApplicationInput) (*m2.StartApplicationOutput, error)
	StartApplicationWithContext(aws.Context, *m2.StartApplicationInput, ...request.Option) (*m2.StartApplicationOutput, error)
	StartApplicationRequest(*m2.StartApplicationInput) (*request.Request, *m2.StartApplicationOutput)

	StartBatchJob(*m2.StartBatchJobInput) (*m2.StartBatchJobOutput, error)
	StartBatchJobWithContext(aws.Context, *m2.StartBatchJobInput, ...request.Option) (*m2.StartBatchJobOutput, error)
	StartBatchJobRequest(*m2.StartBatchJobInput) (*request.Request, *m2.StartBatchJobOutput)

	StopApplication(*m2.StopApplicationInput) (*m2.StopApplicationOutput, error)
	StopApplicationWithContext(aws.Context, *m2.StopApplicationInput, ...request.Option) (*m2.StopApplicationOutput, error)
	StopApplicationRequest(*m2.StopApplicationInput) (*request.Request, *m2.StopApplicationOutput)

	TagResource(*m2.TagResourceInput) (*m2.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *m2.TagResourceInput, ...request.Option) (*m2.TagResourceOutput, error)
	TagResourceRequest(*m2.TagResourceInput) (*request.Request, *m2.TagResourceOutput)

	UntagResource(*m2.UntagResourceInput) (*m2.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *m2.UntagResourceInput, ...request.Option) (*m2.UntagResourceOutput, error)
	UntagResourceRequest(*m2.UntagResourceInput) (*request.Request, *m2.UntagResourceOutput)

	UpdateApplication(*m2.UpdateApplicationInput) (*m2.UpdateApplicationOutput, error)
	UpdateApplicationWithContext(aws.Context, *m2.UpdateApplicationInput, ...request.Option) (*m2.UpdateApplicationOutput, error)
	UpdateApplicationRequest(*m2.UpdateApplicationInput) (*request.Request, *m2.UpdateApplicationOutput)

	UpdateEnvironment(*m2.UpdateEnvironmentInput) (*m2.UpdateEnvironmentOutput, error)
	UpdateEnvironmentWithContext(aws.Context, *m2.UpdateEnvironmentInput, ...request.Option) (*m2.UpdateEnvironmentOutput, error)
	UpdateEnvironmentRequest(*m2.UpdateEnvironmentInput) (*request.Request, *m2.UpdateEnvironmentOutput)
}

var _ M2API = (*m2.M2)(nil)
