// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The operation failed because the client token input parameter matched one that
// was used with a previous call to the operation, but at least one of the other
// input parameters is different from the previous call.
type IdempotentParameterMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IdempotentParameterMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IdempotentParameterMismatchException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IdempotentParameterMismatchException"
	}
	return *e.ErrorCodeOverride
}
func (e *IdempotentParameterMismatchException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The operation failed because the specified client token isn't valid.
type InvalidClientTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidClientTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClientTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClientTokenException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidClientTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidClientTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the specified value for MaxResults isn't valid.
type InvalidMaxResultsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidMaxResultsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMaxResultsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMaxResultsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidMaxResultsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidMaxResultsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the specified value for NextToken isn't valid. You
// must specify a value you received in the NextToken response of a previous call
// to this operation.
type InvalidNextTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNextTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNextTokenException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidNextTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidNextTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because a parameter you specified isn't valid.
type InvalidParameterException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because a policy you specified isn't valid.
type InvalidPolicyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPolicyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidPolicyException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPolicyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the specified resource type isn't valid.
type InvalidResourceTypeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidResourceTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResourceTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResourceTypeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidResourceTypeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidResourceTypeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the requested operation isn't valid for the
// resource share in its current state.
type InvalidStateTransitionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidStateTransitionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidStateTransitionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidStateTransitionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidStateTransitionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidStateTransitionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the specified [Amazon Resource Name (ARN)] has a format that isn't valid.
//
// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
type MalformedArnException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MalformedArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MalformedArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MalformedArnException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MalformedArnException"
	}
	return *e.ErrorCodeOverride
}
func (e *MalformedArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the policy template that you provided isn't valid.
type MalformedPolicyTemplateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MalformedPolicyTemplateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MalformedPolicyTemplateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MalformedPolicyTemplateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MalformedPolicyTemplateException"
	}
	return *e.ErrorCodeOverride
}
func (e *MalformedPolicyTemplateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because a required input parameter is missing.
type MissingRequiredParameterException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MissingRequiredParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MissingRequiredParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MissingRequiredParameterException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MissingRequiredParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *MissingRequiredParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the requested operation isn't permitted.
type OperationNotPermittedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperationNotPermittedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationNotPermittedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationNotPermittedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperationNotPermittedException"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationNotPermittedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because a permission with the specified name already
// exists in the requested Amazon Web Services Region. Choose a different name.
type PermissionAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PermissionAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PermissionAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PermissionAlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PermissionAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *PermissionAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because it would exceed the maximum number of permissions
// you can create in each Amazon Web Services Region. To view the limits for your
// Amazon Web Services account, see the [RAM page in the Service Quotas console].
//
// [RAM page in the Service Quotas console]: https://console.aws.amazon.com/servicequotas/home/services/ram/quotas
type PermissionLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PermissionLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PermissionLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PermissionLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PermissionLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *PermissionLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because it would exceed the limit for the number of
// versions you can have for a permission. To view the limits for your Amazon Web
// Services account, see the [RAM page in the Service Quotas console].
//
// [RAM page in the Service Quotas console]: https://console.aws.amazon.com/servicequotas/home/services/ram/quotas
type PermissionVersionsLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PermissionVersionsLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PermissionVersionsLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PermissionVersionsLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PermissionVersionsLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *PermissionVersionsLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The operation failed because the specified [Amazon Resource Name (ARN)] was not found.
//
// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
type ResourceArnNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceArnNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceArnNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceArnNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceArnNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceArnNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the specified invitation was already accepted.
type ResourceShareInvitationAlreadyAcceptedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceShareInvitationAlreadyAcceptedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareInvitationAlreadyAcceptedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareInvitationAlreadyAcceptedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceShareInvitationAlreadyAcceptedException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceShareInvitationAlreadyAcceptedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The operation failed because the specified invitation was already rejected.
type ResourceShareInvitationAlreadyRejectedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceShareInvitationAlreadyRejectedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareInvitationAlreadyRejectedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareInvitationAlreadyRejectedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceShareInvitationAlreadyRejectedException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceShareInvitationAlreadyRejectedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The operation failed because the specified [Amazon Resource Name (ARN)] for an invitation was not found.
//
// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
type ResourceShareInvitationArnNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceShareInvitationArnNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareInvitationArnNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareInvitationArnNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceShareInvitationArnNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceShareInvitationArnNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The operation failed because the specified invitation is past its expiration
// date and time.
type ResourceShareInvitationExpiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceShareInvitationExpiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareInvitationExpiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareInvitationExpiredException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceShareInvitationExpiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceShareInvitationExpiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The operation failed because it would exceed the limit for resource shares for
// your account. To view the limits for your Amazon Web Services account, see the [RAM page in the Service Quotas console].
//
// [RAM page in the Service Quotas console]: https://console.aws.amazon.com/servicequotas/home/services/ram/quotas
type ResourceShareLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceShareLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceShareLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceShareLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The operation failed because the service could not respond to the request due
// to an internal problem. Try again later.
type ServerInternalException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServerInternalException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServerInternalException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServerInternalException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServerInternalException"
	}
	return *e.ErrorCodeOverride
}
func (e *ServerInternalException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The operation failed because the service isn't available. Try again later.
type ServiceUnavailableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceUnavailableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceUnavailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceUnavailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The operation failed because it would exceed the limit for tags for your Amazon
// Web Services account.
type TagLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TagLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *TagLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because the specified tag key is a reserved word and can't
// be used.
type TagPolicyViolationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagPolicyViolationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagPolicyViolationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagPolicyViolationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TagPolicyViolationException"
	}
	return *e.ErrorCodeOverride
}
func (e *TagPolicyViolationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because it exceeded the rate at which you are allowed to
// perform this operation. Please try again later.
type ThrottlingException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ThrottlingException"
	}
	return *e.ErrorCodeOverride
}
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation failed because a specified resource couldn't be found.
type UnknownResourceException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnknownResourceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnknownResourceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnknownResourceException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnknownResourceException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnknownResourceException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There isn't an existing managed permission defined in RAM that has the same IAM
// permissions as the resource-based policy attached to the resource. You should
// first run PromotePermissionCreatedFromPolicyto create that managed permission.
type UnmatchedPolicyPermissionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnmatchedPolicyPermissionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnmatchedPolicyPermissionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnmatchedPolicyPermissionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnmatchedPolicyPermissionException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnmatchedPolicyPermissionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}
