// Code generated by smithy-go-codegen DO NOT EDIT.

package grafana

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/grafana/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpAssociateLicense struct {
}

func (*awsRestjson1_serializeOpAssociateLicense) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateLicense) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateLicenseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/licenses/{licenseType}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateLicenseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateLicenseInput(v *AssociateLicenseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.LicenseType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member licenseType must not be empty")}
	}
	if len(v.LicenseType) > 0 {
		if err := encoder.SetURI("licenseType").String(string(v.LicenseType)); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateWorkspace struct {
}

func (*awsRestjson1_serializeOpCreateWorkspace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWorkspace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkspaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWorkspaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWorkspaceInput(v *CreateWorkspaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWorkspaceInput(v *CreateWorkspaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AccountAccessType) > 0 {
		ok := object.Key("accountAccessType")
		ok.String(string(v.AccountAccessType))
	}

	if v.AuthenticationProviders != nil {
		ok := object.Key("authenticationProviders")
		if err := awsRestjson1_serializeDocumentAuthenticationProviders(v.AuthenticationProviders, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.OrganizationRoleName != nil {
		ok := object.Key("organizationRoleName")
		ok.String(*v.OrganizationRoleName)
	}

	if len(v.PermissionType) > 0 {
		ok := object.Key("permissionType")
		ok.String(string(v.PermissionType))
	}

	if v.StackSetName != nil {
		ok := object.Key("stackSetName")
		ok.String(*v.StackSetName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.WorkspaceDataSources != nil {
		ok := object.Key("workspaceDataSources")
		if err := awsRestjson1_serializeDocumentDataSourceTypesList(v.WorkspaceDataSources, ok); err != nil {
			return err
		}
	}

	if v.WorkspaceDescription != nil {
		ok := object.Key("workspaceDescription")
		ok.String(*v.WorkspaceDescription)
	}

	if v.WorkspaceName != nil {
		ok := object.Key("workspaceName")
		ok.String(*v.WorkspaceName)
	}

	if v.WorkspaceNotificationDestinations != nil {
		ok := object.Key("workspaceNotificationDestinations")
		if err := awsRestjson1_serializeDocumentNotificationDestinationsList(v.WorkspaceNotificationDestinations, ok); err != nil {
			return err
		}
	}

	if v.WorkspaceOrganizationalUnits != nil {
		ok := object.Key("workspaceOrganizationalUnits")
		if err := awsRestjson1_serializeDocumentOrganizationalUnitList(v.WorkspaceOrganizationalUnits, ok); err != nil {
			return err
		}
	}

	if v.WorkspaceRoleArn != nil {
		ok := object.Key("workspaceRoleArn")
		ok.String(*v.WorkspaceRoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateWorkspaceApiKey struct {
}

func (*awsRestjson1_serializeOpCreateWorkspaceApiKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWorkspaceApiKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkspaceApiKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/apikeys")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateWorkspaceApiKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWorkspaceApiKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWorkspaceApiKeyInput(v *CreateWorkspaceApiKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWorkspaceApiKeyInput(v *CreateWorkspaceApiKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyName != nil {
		ok := object.Key("keyName")
		ok.String(*v.KeyName)
	}

	if v.KeyRole != nil {
		ok := object.Key("keyRole")
		ok.String(*v.KeyRole)
	}

	if v.SecondsToLive != nil {
		ok := object.Key("secondsToLive")
		ok.Integer(*v.SecondsToLive)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWorkspace struct {
}

func (*awsRestjson1_serializeOpDeleteWorkspace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWorkspace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkspaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWorkspaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWorkspaceInput(v *DeleteWorkspaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWorkspaceApiKey struct {
}

func (*awsRestjson1_serializeOpDeleteWorkspaceApiKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWorkspaceApiKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkspaceApiKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/apikeys/{keyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWorkspaceApiKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWorkspaceApiKeyInput(v *DeleteWorkspaceApiKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.KeyName == nil || len(*v.KeyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member keyName must not be empty")}
	}
	if v.KeyName != nil {
		if err := encoder.SetURI("keyName").String(*v.KeyName); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeWorkspace struct {
}

func (*awsRestjson1_serializeOpDescribeWorkspace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeWorkspace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeWorkspaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeWorkspaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeWorkspaceInput(v *DescribeWorkspaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeWorkspaceAuthentication struct {
}

func (*awsRestjson1_serializeOpDescribeWorkspaceAuthentication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeWorkspaceAuthentication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeWorkspaceAuthenticationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/authentication")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeWorkspaceAuthenticationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeWorkspaceAuthenticationInput(v *DescribeWorkspaceAuthenticationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateLicense struct {
}

func (*awsRestjson1_serializeOpDisassociateLicense) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateLicense) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateLicenseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/licenses/{licenseType}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateLicenseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateLicenseInput(v *DisassociateLicenseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.LicenseType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member licenseType must not be empty")}
	}
	if len(v.LicenseType) > 0 {
		if err := encoder.SetURI("licenseType").String(string(v.LicenseType)); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPermissions struct {
}

func (*awsRestjson1_serializeOpListPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPermissionsInput(v *ListPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GroupId != nil {
		encoder.SetQuery("groupId").String(*v.GroupId)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	if len(v.UserType) > 0 {
		encoder.SetQuery("userType").String(string(v.UserType))
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListWorkspaces struct {
}

func (*awsRestjson1_serializeOpListWorkspaces) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWorkspaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkspacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListWorkspacesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWorkspacesInput(v *ListWorkspacesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePermissions struct {
}

func (*awsRestjson1_serializeOpUpdatePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePermissionsInput(v *UpdatePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePermissionsInput(v *UpdatePermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UpdateInstructionBatch != nil {
		ok := object.Key("updateInstructionBatch")
		if err := awsRestjson1_serializeDocumentUpdateInstructionBatch(v.UpdateInstructionBatch, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWorkspace struct {
}

func (*awsRestjson1_serializeOpUpdateWorkspace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWorkspace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWorkspaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWorkspaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWorkspaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWorkspaceInput(v *UpdateWorkspaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWorkspaceInput(v *UpdateWorkspaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AccountAccessType) > 0 {
		ok := object.Key("accountAccessType")
		ok.String(string(v.AccountAccessType))
	}

	if v.OrganizationRoleName != nil {
		ok := object.Key("organizationRoleName")
		ok.String(*v.OrganizationRoleName)
	}

	if len(v.PermissionType) > 0 {
		ok := object.Key("permissionType")
		ok.String(string(v.PermissionType))
	}

	if v.StackSetName != nil {
		ok := object.Key("stackSetName")
		ok.String(*v.StackSetName)
	}

	if v.WorkspaceDataSources != nil {
		ok := object.Key("workspaceDataSources")
		if err := awsRestjson1_serializeDocumentDataSourceTypesList(v.WorkspaceDataSources, ok); err != nil {
			return err
		}
	}

	if v.WorkspaceDescription != nil {
		ok := object.Key("workspaceDescription")
		ok.String(*v.WorkspaceDescription)
	}

	if v.WorkspaceName != nil {
		ok := object.Key("workspaceName")
		ok.String(*v.WorkspaceName)
	}

	if v.WorkspaceNotificationDestinations != nil {
		ok := object.Key("workspaceNotificationDestinations")
		if err := awsRestjson1_serializeDocumentNotificationDestinationsList(v.WorkspaceNotificationDestinations, ok); err != nil {
			return err
		}
	}

	if v.WorkspaceOrganizationalUnits != nil {
		ok := object.Key("workspaceOrganizationalUnits")
		if err := awsRestjson1_serializeDocumentOrganizationalUnitList(v.WorkspaceOrganizationalUnits, ok); err != nil {
			return err
		}
	}

	if v.WorkspaceRoleArn != nil {
		ok := object.Key("workspaceRoleArn")
		ok.String(*v.WorkspaceRoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWorkspaceAuthentication struct {
}

func (*awsRestjson1_serializeOpUpdateWorkspaceAuthentication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWorkspaceAuthentication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWorkspaceAuthenticationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/authentication")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWorkspaceAuthenticationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWorkspaceAuthenticationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWorkspaceAuthenticationInput(v *UpdateWorkspaceAuthenticationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWorkspaceAuthenticationInput(v *UpdateWorkspaceAuthenticationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthenticationProviders != nil {
		ok := object.Key("authenticationProviders")
		if err := awsRestjson1_serializeDocumentAuthenticationProviders(v.AuthenticationProviders, ok); err != nil {
			return err
		}
	}

	if v.SamlConfiguration != nil {
		ok := object.Key("samlConfiguration")
		if err := awsRestjson1_serializeDocumentSamlConfiguration(v.SamlConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAllowedOrganizations(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAssertionAttributes(v *types.AssertionAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Email != nil {
		ok := object.Key("email")
		ok.String(*v.Email)
	}

	if v.Groups != nil {
		ok := object.Key("groups")
		ok.String(*v.Groups)
	}

	if v.Login != nil {
		ok := object.Key("login")
		ok.String(*v.Login)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Org != nil {
		ok := object.Key("org")
		ok.String(*v.Org)
	}

	if v.Role != nil {
		ok := object.Key("role")
		ok.String(*v.Role)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuthenticationProviders(v []types.AuthenticationProviderTypes, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSourceTypesList(v []types.DataSourceType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentIdpMetadata(v types.IdpMetadata, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.IdpMetadataMemberUrl:
		av := object.Key("url")
		av.String(uv.Value)

	case *types.IdpMetadataMemberXml:
		av := object.Key("xml")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentNotificationDestinationsList(v []types.NotificationDestinationType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentOrganizationalUnitList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRoleValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRoleValues(v *types.RoleValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Admin != nil {
		ok := object.Key("admin")
		if err := awsRestjson1_serializeDocumentRoleValueList(v.Admin, ok); err != nil {
			return err
		}
	}

	if v.Editor != nil {
		ok := object.Key("editor")
		if err := awsRestjson1_serializeDocumentRoleValueList(v.Editor, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSamlConfiguration(v *types.SamlConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedOrganizations != nil {
		ok := object.Key("allowedOrganizations")
		if err := awsRestjson1_serializeDocumentAllowedOrganizations(v.AllowedOrganizations, ok); err != nil {
			return err
		}
	}

	if v.AssertionAttributes != nil {
		ok := object.Key("assertionAttributes")
		if err := awsRestjson1_serializeDocumentAssertionAttributes(v.AssertionAttributes, ok); err != nil {
			return err
		}
	}

	if v.IdpMetadata != nil {
		ok := object.Key("idpMetadata")
		if err := awsRestjson1_serializeDocumentIdpMetadata(v.IdpMetadata, ok); err != nil {
			return err
		}
	}

	if v.LoginValidityDuration != 0 {
		ok := object.Key("loginValidityDuration")
		ok.Integer(v.LoginValidityDuration)
	}

	if v.RoleValues != nil {
		ok := object.Key("roleValues")
		if err := awsRestjson1_serializeDocumentRoleValues(v.RoleValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdateInstruction(v *types.UpdateInstruction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if len(v.Role) > 0 {
		ok := object.Key("role")
		ok.String(string(v.Role))
	}

	if v.Users != nil {
		ok := object.Key("users")
		if err := awsRestjson1_serializeDocumentUserList(v.Users, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateInstructionBatch(v []types.UpdateInstruction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentUpdateInstruction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUser(v *types.User, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentUserList(v []types.User, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentUser(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
