/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ast;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.ast.ASTAnnotation;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.CanSuppressWarnings;
import net.sourceforge.pmd.ast.Dimensionable;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.JavaParserVisitor;

public class ASTFormalParameter
extends AccessNode
implements Dimensionable,
CanSuppressWarnings {
    private boolean isVarargs;

    public void setVarargs() {
        this.isVarargs = true;
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    public ASTFormalParameter(int id) {
        super(id);
    }

    public ASTFormalParameter(JavaParser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean hasSuppressWarningsAnnotationFor(Rule rule) {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ASTAnnotation a;
            if (!(this.jjtGetChild(i) instanceof ASTAnnotation) || !(a = (ASTAnnotation)this.jjtGetChild(i)).suppresses(rule)) continue;
            return true;
        }
        return false;
    }

    public boolean isArray() {
        return this.checkType() + this.checkDecl() > 0;
    }

    public int getArrayDepth() {
        if (!this.isArray()) {
            return 0;
        }
        return this.checkType() + this.checkDecl();
    }

    public ASTType getTypeNode() {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            if (!(this.jjtGetChild(i) instanceof ASTType)) continue;
            return (ASTType)this.jjtGetChild(i);
        }
        throw new IllegalStateException("ASTType not found");
    }

    private int checkType() {
        return this.getTypeNode().getArrayDepth();
    }

    private ASTVariableDeclaratorId getDecl() {
        return (ASTVariableDeclaratorId)this.jjtGetChild(this.jjtGetNumChildren() - 1);
    }

    private int checkDecl() {
        return this.getDecl().getArrayDepth();
    }

    public void dump(String prefix) {
        System.out.println(this.collectDumpedModifiers(prefix));
        this.dumpChildren(prefix);
    }
}

