;
; finnish_duration.scm - duration model based on 692 sentences
;
; Copyright (c) 2000-2003
; Department of General Linguistics, University of Helsinki
; Department of Foreign Languages, University of Joensuu
; All Rights Reserved.
;
; Author: Nicholas Volk (nvolk@ling.helsinki.fi)

; This program is distributed under Gnu Lesser General Public License (cf. the
; file LICENSE in distribution).
 
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU Lesser General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU Lesser General Public License for more details.

; FEATURE    1 R:SylStructure.parent.position_type: 0.2493
; FEATURE    2 lisp_end_of_phrase: 0.3704
; FEATURE    3 n.ph_ctype: 0.4334
; FEATURE    4 pos_in_syl: 0.5047
; FEATURE    5 p.ph_vc: 0.5382
; FEATURE    6 ph_ctype: 0.5784
; FEATURE    7 lisp_mora: 0.6033
; FEATURE    8 p.ph_ctype: 0.6158
; FEATURE    9 p.ph_cplace2: 0.6267
; FEATURE    10 n.seg_onsetcoda: 0.6330
; FEATURE    11 ph_cplace2: 0.6385
; FEATURE    12 n.ph_vfront: 0.6427
; FEATURE    13 p.ph_clng: 0.6460
; FEATURE    14 n.ph_cplace: 0.6492
; FEATURE    15 pp.ph_vlng: 0.6530
; RMSE 0.7550 Correlation is 0.6530 Mean (abs) Error 0.5636 (0.5024)
; ;;; Test the duration model
; ;; RMSE 0.7679 Correlation is 0.6300 Mean (abs) Error 0.5778 (0.5059)



;; averages durations and deviations as counted by Festvox 1.6
;; from 692 mv sentences + some modifications
(set! 
 hy_fi_mv2::phone_durs '
 (
  (# 0.2 0.1)
  (## 0.050 0.1) 
  (7  0.074 0.021091)
  (7: 0.144 0.0343)
  (@  0.066 0.02502)
  (@: 0.142 0.039752)
  (N  0.054 0.019307)
  (N: 0.105 0.031537)
  (S  0.107 0.074051)
  (S: 0.162 0.002122)
  (T  0.100 0.02)
  (T: 0.150 0.02)
  (a  0.072 0.027)
  (a: 0.134 0.034379)
  (b  0.087 0.020942)
  (b: 0.150 0.05)
  (d  0.052 0.017189)
  (d: 0.150 0.05)
  (e  0.068 0.02284)
  (e: 0.118 0.031648)
  ;; (f  0.111 0.04366)
  ;; (f: 0.123 0.025)
  (f  0.090 0.04366)
  (f: 0.160 0.025)
  (g  0.083 0.028302)
  (g: 0.150 0.05)
  (h  0.068 0.022465)
  (h: 0.128 0.014142)
  (i  0.057 0.02158)
  (i: 0.117 0.028321)
  (j  0.062 0.019587)
  (j: 0.078 0.011561)
  (k  0.089 0.026993)
  (k: 0.163 0.037839)
  (l  0.058 0.014875)
  ;; (l: 0.085 0.026515)
  (l: 0.130 0.025)
  (m  0.067 0.018604)
  (m: 0.101 0.021473)
  (n  0.052 0.01586)
  (n: 0.093 0.028081)
  (o  0.075 0.024718)
  (o: 0.139 0.045108)
  (p  0.096 0.028916)
  (p: 0.176 0.043074)
  (r  0.062 0.015694)
  (r: 0.103 0.040321)
  (s  0.078 0.023607)
  (s: 0.146 0.038235)
  (t  0.088 0.026786)
  (t: 0.150 0.036228)
  (u  0.066 0.023676)
  (u: 0.132 0.036521)
  (v  0.060 0.015418)
  (v: 0.093 0.022544)
  (y  0.070 0.027444)
  (y: 0.130 0.030567)
  ))



(set! hy_fi_mv2::zdur_tree '
((name is ##)
 ((0.0 0.0))
 ((name is #)
  ((n.name is #) ;; lauseen loppu (tunnus 2*#)
   ((0.0 -1.8)) ;; lyhennetn niin maan perkeleesti
   ((p.name is 0) ;; puhunnoksen alku
    ((0.0 -1.8)) ;; ja taas lyhyen (emacspeakin vasteajan takia)
    ((p.R:SylStructure.parent.parent.pbreak is BB)
     ((0.0 0.0))
     ((0.0 0.0)))))

((R:SylStructure.parent.position_type is initial)
 ((lisp_end_of_phrase is 0)
  ((pos_in_syl < 1.2)
   ((p.ph_vc is 0)
    ((ph_ctype is s)
     ((ph_cplace2 is r) ((0.414358 -2.16199)) ((0.874005 -2.4695)))
     ((ph_ctype is 0)
      ((pp.ph_vlng is 0)
       ((n.seg_onsetcoda is coda)
        ((1.05861 1.62942))
        ((1.172 1.17007)))
       ((1.08052 0.293028)))
      ((ph_cplace2 is a)
       ((n.ph_vfront is 1)
        ((1.14796 0.487189))
        ((ph_ctype is f) ((0.584116 0.460911)) ((1.5297 1.02475))))
       ((ph_ctype is n)
        ((lisp_mora is 2) ((0.880194 -1.15771)) ((1.17857 -0.557597)))
        ((lisp_mora is 2) ((1.1581 0.0696902)) ((1.00619 -0.432983)))))))
    ((n.ph_ctype is s)
     ((pos_in_syl < 0.1)
      ((n.seg_onsetcoda is coda)
       ((0.697916 1.4032))
       ((p.ph_ctype is n)
        ((1.0436 1.18853))
        ((lisp_mora is 2) ((1.02962 -0.0361715)) ((0.952024 0.580176)))))
      ((n.seg_onsetcoda is coda)
       ((p.ph_cplace2 is r)
        ((0.691754 0.228866))
        ((p.ph_cplace2 is l)
         ((0.442573 0.720269))
         ((0.593858 0.55871))))
       ((ph_ctype is f)
        ((pp.ph_vlng is s)
         ((0.625067 -0.431548))
         ((0.521233 -0.571476)))
        ((p.ph_ctype is n)
         ((n.ph_cplace is a)
          ((0.778804 -0.56443))
          ((0.750129 0.0464458)))
         ((p.ph_ctype is r)
          ((pp.ph_vlng is s)
           ((1.07725 -0.16798))
           ((0.891796 -0.425804)))
          ((lisp_mora is 2)
           ((p.ph_ctype is s)
            ((0.521263 0.500136))
            ((pp.ph_vlng is 0)
             ((n.ph_cplace is a)
              ((0.699937 -0.0663515))
              ((0.838917 0.306609)))
             ((0.732822 0.411336))))
           ((p.ph_cplace2 is l)
            ((0.610493 0.304215))
            ((n.ph_cplace is l)
             ((0.440354 0.190908))
             ((p.ph_vc is +)
              ((0.708797 -0.181432))
              ((p.ph_cplace2 is a)
               ((p.ph_ctype is s)
                ((0.507732 0.162633))
                ((0.701973 -0.0615322)))
               ((0.497253 -0.0607969))))))))))))
     ((ph_ctype is 0)
      ((lisp_mora is 2)
       ((pos_in_syl < 0.1)
        ((n.seg_onsetcoda is coda)
         ((n.ph_cplace is a)
          ((p.ph_ctype is n) ((0.846843 1.98492)) ((1.28616 1.76399)))
          ((1.10419 1.37166)))
         ((n.ph_ctype is l) ((1.09167 0.707285)) ((1.00628 1.5813))))
        ((n.ph_ctype is r)
         ((n.seg_onsetcoda is coda)
          ((p.ph_ctype is s)
           ((pp.ph_vlng is 0) ((0.793108 1.6759)) ((0.686577 1.46816)))
           ((p.ph_cplace2 is l)
            ((1.02811 1.5475))
            ((0.797975 1.08187))))
          ((1.23028 0.848184)))
         ((p.ph_ctype is r)
          ((p.ph_cplace2 is a)
           ((1.03257 0.930175))
           ((0.844828 -0.17997)))
          ((n.ph_ctype is n)
           ((n.seg_onsetcoda is coda)
            ((pp.ph_vlng is 0)
             ((0.566015 1.01837))
             ((0.641936 1.2535)))
            ((pp.ph_vlng is s)
             ((0.958101 1.00167))
             ((0.756233 0.717495))))
           ((n.ph_cplace is a)
            ((n.seg_onsetcoda is coda)
             ((p.ph_cplace2 is a)
              ((0.565396 1.10786))
              ((n.ph_ctype is f)
               ((p.ph_cplace2 is r)
                ((0.785843 0.922216))
                ((0.620961 0.483967)))
               ((p.ph_cplace2 is l)
                ((0.518981 1.07022))
                ((0.777028 0.626201)))))
             ((p.ph_cplace2 is a)
              ((0.854425 0.404668))
              ((0.883663 0.766847))))
            ((n.ph_cplace is g)
             ((p.ph_ctype is s)
              ((0.588436 0.573801))
              ((0.875701 0.741857)))
             ((p.ph_cplace2 is l)
              ((0.812018 0.592433))
              ((0.8093 0.408434)))))))))
       ((n.ph_cplace is b)
        ((pos_in_syl < 0.1)
         ((1.15445 -0.163448))
         ((p.ph_cplace2 is a)
          ((0.663495 0.537209))
          ((0.687391 0.141296))))
        ((pos_in_syl < 0.1)
         ((n.ph_ctype is l)
          ((p.ph_ctype is n)
           ((1.11183 0.916437))
           ((pp.ph_vlng is 0)
            ((1.09516 0.399922))
            ((1.18411 -0.276583))))
          ((pp.ph_vlng is 0)
           ((n.seg_onsetcoda is coda)
            ((1.08438 0.911585))
            ((0.820251 1.1614)))
           ((p.ph_ctype is s) ((1.00213 1.07576)) ((1.24814 1.58642)))))
         ((n.seg_onsetcoda is coda)
          ((p.ph_ctype is s)
           ((n.ph_cplace is a)
            ((0.727405 0.660093))
            ((p.ph_cplace2 is l)
             ((0.742461 1.11747))
             ((pp.ph_vlng is 0)
              ((0.734555 0.927789))
              ((0.73705 0.806348)))))
           ((p.ph_cplace2 is r)
            ((0.852441 0.239643))
            ((pp.ph_vlng is 0)
             ((n.ph_vfront is 3)
              ((0.822279 0.306066))
              ((p.ph_cplace2 is a)
               ((0.853881 0.699284))
               ((0.871431 0.446849))))
             ((p.ph_ctype is n)
              ((1.03132 0.965835))
              ((n.ph_vfront is 1)
               ((0.873465 0.816313))
               ((0.917851 0.467496)))))))
          ((p.ph_cplace2 is l)
           ((p.ph_ctype is n)
            ((0.642136 0.211476))
            ((n.ph_ctype is r)
             ((0.652363 0.978806))
             ((p.ph_ctype is f)
              ((0.633854 0.697683))
              ((0.665691 0.477371)))))
           ((p.ph_ctype is f)
            ((p.ph_cplace2 is a)
             ((0.551109 0.143966))
             ((0.876272 -0.22467)))
            ((p.ph_cplace2 is r)
             ((pp.ph_vlng is 0)
              ((0.717158 0.387737))
              ((0.704496 0.14666)))
             ((pp.ph_vlng is s)
              ((p.ph_ctype is s)
               ((0.756359 0.404007))
               ((0.95238 0.722275)))
              ((n.ph_ctype is l)
               ((0.600341 0.275517))
               ((n.ph_ctype is f)
                ((0.63293 0.300704))
                ((0.743196 0.509984))))))))))))
      ((p.ph_cplace2 is a)
       ((p.ph_ctype is s)
        ((ph_cplace2 is l)
         ((n.ph_vfront is 1)
          ((0.658511 -1.04505))
          ((0.764273 -0.579458)))
         ((ph_ctype is f)
          ((0.67381 -0.385443))
          ((ph_ctype is s)
           ((0.669678 -0.387274))
           ((1.24196 0.0205493)))))
        ((ph_ctype is f)
         ((ph_cplace2 is a)
          ((n.ph_vfront is 3)
           ((0.727442 0.566241))
           ((0.727165 0.75547)))
          ((n.ph_vfront is 1)
           ((ph_cplace2 is l)
            ((0.909459 -0.0993548))
            ((0.980587 0.321758)))
           ((n.seg_onsetcoda is coda)
            ((0.903312 0.625847))
            ((0.813008 0.375792)))))
         ((ph_ctype is r)
          ((ph_cplace2 is a)
           ((1.28399 0.917389))
           ((0.843269 0.424056)))
          ((ph_cplace2 is l)
           ((ph_ctype is n)
            ((n.ph_vfront is 1)
             ((0.665766 -0.560041))
             ((0.688994 -0.1633)))
            ((n.seg_onsetcoda is coda)
             ((n.ph_vfront is 1)
              ((0.612282 -0.212725))
              ((0.622185 0.0863764)))
             ((0.799478 0.339492))))
           ((ph_ctype is s)
            ((pp.ph_vlng is s)
             ((p.ph_ctype is n)
              ((n.ph_vfront is 3)
               ((n.seg_onsetcoda is coda)
                ((ph_cplace2 is a)
                 ((0.593878 0.0926664))
                 ((0.597355 -0.0915215)))
                ((0.559002 0.134849)))
               ((0.80247 0.218785)))
              ((1.43028 0.546898)))
             ((ph_cplace2 is a)
              ((0.443011 -0.381483))
              ((0.704263 0.0768767))))
            ((0.848131 0.435969)))))))
       ((n.ph_ctype is f)
        ((ph_ctype is s) ((0.565053 -0.295846)) ((1.07037 0.259748)))
        ((ph_ctype is r)
         ((ph_cplace2 is a)
          ((n.ph_vfront is 3)
           ((0.949098 0.360166))
           ((0.574453 0.066609)))
          ((0.891948 0.717105)))
         ((ph_cplace2 is a)
          ((ph_ctype is s)
           ((pp.ph_vlng is 0)
            ((0.998088 0.854391))
            ((0.701013 0.508697)))
           ((n.ph_vfront is 1)
            ((lisp_mora is 1)
             ((0.919257 0.855378))
             ((1.04349 1.02608)))
            ((n.seg_onsetcoda is coda)
             ((0.906812 0.977146))
             ((1.0171 1.22371)))))
          ((ph_ctype is f)
           ((ph_cplace2 is l)
            ((n.seg_onsetcoda is coda)
             ((n.ph_vfront is 1)
              ((0.871274 0.435394))
              ((1.04888 0.673423)))
             ((1.06361 0.865767)))
            ((pos_in_syl < 0.1)
             ((n.ph_vfront is 1)
              ((1.19273 0.164819))
              ((0.989494 0.412502)))
             ((0.957089 -0.0737841))))
           ((n.ph_vfront is 3)
            ((ph_ctype is n)
             ((0.940868 1.07394))
             ((lisp_mora is 2)
              ((0.868656 0.728722))
              ((ph_cplace2 is l)
               ((0.781457 0.821993))
               ((1.04734 0.988019)))))
            ((ph_cplace2 is l)
             ((ph_ctype is n)
              ((0.951098 0.80061))
              ((lisp_mora is 2)
               ((0.653205 0.478247))
               ((0.632344 0.169985))))
             ((lisp_mora is 2)
              ((0.942891 1.12906))
              ((0.838455 0.830946)))))))))))))
   ((pp.ph_vlng is 0)
    ((lisp_mora is 2)
     ((ph_ctype is n)
      ((n.ph_cplace is a) ((0.992075 0.715216)) ((0.966096 0.45234)))
      ((n.ph_cplace is b)
       ((0.997309 0.462189))
       ((ph_ctype is s)
        ((n.ph_ctype is f)
         ((0.705022 -0.0571909))
         ((0.68043 0.408178)))
        ((n.ph_cplace is l)
         ((0.953455 0.163587))
         ((ph_cplace2 is r)
          ((0.81628 -0.329822))
          ((n.ph_cplace is p)
           ((0.558684 -0.351913))
           ((ph_ctype is f)
            ((0.869936 0.0522303))
            ((0.837145 -0.127896)))))))))
     ((n.ph_ctype is s)
      ((n.ph_cplace is a)
       ((ph_ctype is 0) ((0.666094 -0.561262)) ((0.67667 -0.90291)))
       ((0.716715 -0.154598)))
      ((n.ph_ctype is r)
       ((0.849713 0.305567))
       ((n.ph_cplace is a)
        ((n.ph_ctype is n)
         ((0.810898 0.0721763))
         ((0.757718 -0.365141)))
        ((n.ph_ctype is n)
         ((0.644913 -0.0967719))
         ((0.831196 0.100217)))))))
    ((ph_ctype is f) ((0.678479 -0.884737)) ((0.774502 -0.714391)))))
  ((ph_ctype is 0)
   ((pos_in_syl < 1.2)
    ((n.ph_ctype is s)
     ((0.998406 1.39843))
     ((n.ph_vfront is 1)
      ((0.968515 2.57223))
      ((lisp_mora is 2) ((0.917282 2.32119)) ((1.09961 1.84692)))))
    ((0.920013 0.866701)))
   ((lisp_mora is 2)
    ((pp.ph_vlng is 0)
     ((ph_cplace2 is a) ((1.2236 2.06478)) ((1.26739 1.56763)))
     ((1.00706 1.12254)))
    ((ph_cplace2 is r) ((1.29876 0.73761)) ((1.15951 1.07969))))))
 ((lisp_end_of_phrase is 0)
  ((n.ph_ctype is 0)
   ((pos_in_syl < 0.3)
    ((n.seg_onsetcoda is onset)
     ((p.ph_ctype is n)
      ((n.ph_vfront is 1)
       ((0.568545 -0.372535))
       ((0.691604 -0.0313148)))
      ((ph_ctype is f)
       ((lisp_mora is 1)
        ((ph_cplace2 is a)
         ((0.594369 0.581908))
         ((n.ph_vfront is 1)
          ((0.721584 0.130575))
          ((0.930026 0.396382))))
        ((1.11599 0.746493)))
       ((ph_ctype is l)
        ((n.ph_vfront is 1)
         ((0.900054 0.261192))
         ((0.697786 -0.106809)))
        ((p.ph_cplace2 is a)
         ((ph_ctype is s)
          ((R:SylStructure.parent.position_type is final)
           ((0.562343 0.100754))
           ((0.671633 -0.13135)))
          ((1.20928 0.372015)))
         ((R:SylStructure.parent.position_type is single)
          ((1.22288 0.626556))
          ((ph_ctype is r)
           ((0.86283 0.040434))
           ((pp.ph_vlng is s)
            ((0.441464 0.410568))
            ((lisp_mora is 1)
             ((0.535682 0.30082))
             ((ph_ctype is s)
              ((0.509292 0.278067))
              ((0.612567 -0.00251823)))))))))))
     ((R:SylStructure.parent.position_type is final)
      ((lisp_mora is 3)
       ((p.ph_cplace2 is a)
        ((0.886962 0.182227))
        ((ph_cplace2 is a)
         ((ph_ctype is n)
          ((0.585278 -0.182946))
          ((n.ph_vfront is 1)
           ((ph_ctype is f)
            ((0.643504 0.0106825))
            ((0.431145 0.241959)))
           ((0.680088 -0.0184326))))
         ((n.ph_vfront is 1)
          ((0.701176 -0.260645))
          ((ph_ctype is s) ((0.52602 0.102609)) ((0.752803 -0.186949))))))
       ((p.ph_ctype is r)
        ((0.934638 -0.0194497))
        ((p.ph_vc is +)
         ((ph_ctype is f)
          ((ph_cplace2 is l)
           ((lisp_mora is 1)
            ((0.638637 -0.263461))
            ((n.ph_vfront is 1)
             ((0.665793 -0.7841))
             ((0.669529 -0.508022))))
           ((n.ph_vfront is 1)
            ((0.639215 -0.335894))
            ((0.507619 -0.521445))))
          ((lisp_mora is 2)
           ((ph_ctype is s)
            ((n.ph_vfront is 1)
             ((ph_cplace2 is a)
              ((pp.ph_vlng is 0)
               ((0.56605 -0.290392))
               ((0.587672 -0.427569)))
              ((0.600395 0.0798048)))
             ((ph_cplace2 is r)
              ((0.626045 -0.156842))
              ((0.604648 0.0259143))))
            ((ph_ctype is l)
             ((0.815216 -0.185746))
             ((ph_ctype is r)
              ((n.ph_vfront is 1)
               ((0.640864 -0.444553))
               ((0.773282 -0.788709)))
              ((n.ph_vfront is 1)
               ((0.619612 -0.484726))
               ((0.789049 -0.322862))))))
           ((ph_ctype is n)
            ((ph_cplace2 is a)
             ((0.609116 -0.121808))
             ((0.631903 -0.277501)))
            ((ph_ctype is s)
             ((ph_cplace2 is a)
              ((0.520252 -0.576212))
              ((pp.ph_vlng is 0)
               ((0.536619 -0.399986))
               ((0.548853 -0.546965))))
             ((ph_cplace2 is a)
              ((pp.ph_vlng is s)
               ((0.571261 -0.549291))
               ((0.61215 -0.369827)))
              ((0.701239 -0.0779188)))))))
         ((p.ph_ctype is l)
          ((lisp_mora is 1)
           ((0.51591 -0.442291))
           ((0.751446 -0.011766)))
          ((p.ph_cplace2 is r)
           ((p.ph_ctype is f)
            ((0.823907 0.0602389))
            ((0.609257 -0.608541)))
           ((p.ph_ctype is s)
            ((0.710088 -0.74423))
            ((lisp_mora is 1)
             ((n.ph_vfront is 1)
              ((p.ph_ctype is f)
               ((0.434611 -0.519039))
               ((0.500458 -0.660443)))
              ((ph_ctype is f)
               ((0.416119 -0.526136))
               ((0.41308 -0.666634))))
             ((p.ph_ctype is f)
              ((0.551416 -0.58939))
              ((0.49131 -0.343446))))))))))
      ((p.ph_ctype is s)
       ((ph_ctype is f)
        ((p.ph_cplace2 is a)
         ((0.558559 -1.06672))
         ((0.546486 -0.503908)))
        ((ph_cplace2 is r)
         ((0.62139 -0.761093))
         ((R:SylStructure.parent.position_type is 0)
          ((0.538951 -0.241701))
          ((1.09057 0.263472)))))
       ((lisp_mora is 3)
        ((R:SylStructure.parent.position_type is mid)
         ((ph_cplace2 is a)
          ((0.672133 0.230903))
          ((0.80338 0.0400124)))
         ((1.69056 0.50114)))
        ((ph_ctype is 0)
         ((p.ph_vc is 0)
          ((n.ph_vfront is 1)
           ((0.501554 0.26615))
           ((0.416151 0.388289)))
          ((lisp_mora is 1)
           ((0.987786 0.206331))
           ((n.seg_onsetcoda is 0)
            ((pp.ph_vlng is s)
             ((3.63498 0.300449))
             ((p.ph_vc is +)
              ((0.316186 -0.0912046))
              ((0.378855 -0.137722))))
            ((0.63434 -0.490483)))))
         ((p.ph_ctype is n)
          ((ph_cplace2 is r)
           ((n.ph_vfront is 1)
            ((0.620663 -0.502778))
            ((1.0622 -0.222376)))
           ((R:SylStructure.parent.position_type is mid)
            ((ph_cplace2 is a)
             ((n.ph_vfront is 1)
              ((0.599848 -0.462058))
              ((0.582839 -0.617057)))
             ((0.754908 -0.661127)))
            ((0.707766 -0.325685))))
          ((p.ph_cplace2 is r)
           ((ph_ctype is s)
            ((lisp_mora is 1)
             ((0.485732 0.262402))
             ((0.639091 0.395967)))
            ((0.75426 -0.415642)))
           ((p.ph_ctype is f)
            ((ph_ctype is s)
             ((ph_cplace2 is r)
              ((0.522713 -0.507001))
              ((0.516307 -0.413684)))
             ((1.44597 -0.00853439)))
            ((ph_ctype is f)
             ((ph_cplace2 is a)
              ((lisp_mora is 1)
               ((0.659259 -0.034664))
               ((n.ph_vfront is 1)
                ((0.664414 0.0984968))
                ((0.658419 0.382264))))
              ((lisp_mora is 2)
               ((n.ph_vfront is 1)
                ((ph_cplace2 is l)
                 ((0.693631 -0.643123))
                 ((0.649306 -0.281858)))
                ((0.83365 -0.135963)))
               ((ph_cplace2 is l)
                ((0.867115 0.0178028))
                ((0.724301 -0.31404)))))
             ((p.ph_vc is 0)
              ((1.53813 -0.682428))
              ((ph_cplace2 is a)
               ((ph_ctype is n)
                ((0.784693 -0.0930149))
                ((n.ph_vfront is 1)
                 ((ph_ctype is s)
                  ((lisp_mora is 1)
                   ((0.606571 -0.136641))
                   ((pp.ph_vlng is 0)
                    ((0.500308 -0.257488))
                    ((0.580499 -0.36123))))
                  ((pp.ph_vlng is 0)
                   ((ph_ctype is l)
                    ((lisp_mora is 1)
                     ((0.616096 -0.341244))
                     ((0.602307 -0.132246)))
                    ((0.591382 -0.46949)))
                   ((0.670605 -0.53436))))
                 ((ph_ctype is l)
                  ((pp.ph_vlng is s)
                   ((0.91185 0.177441))
                   ((0.720048 -0.0126887)))
                  ((p.ph_vc is +)
                   ((pp.ph_vlng is 0)
                    ((0.5792 -0.2432))
                    ((0.525133 -0.365416)))
                   ((0.398956 -0.147817))))))
               ((ph_ctype is s)
                ((pp.ph_vlng is s)
                 ((p.ph_vc is +)
                  ((n.ph_vfront is 1)
                   ((0.520408 -0.228262))
                   ((0.611901 -0.437854)))
                  ((0.631179 -0.126642)))
                 ((ph_cplace2 is l)
                  ((0.45656 -0.246684))
                  ((lisp_mora is 1)
                   ((0.557288 -0.0837172))
                   ((n.ph_vfront is 1)
                    ((0.686151 -0.00979517))
                    ((0.635011 0.193597))))))
                ((R:SylStructure.parent.position_type is mid)
                 ((ph_ctype is n)
                  ((p.ph_vc is +)
                   ((0.635443 -0.0443977))
                   ((0.667539 -0.192734)))
                  ((pp.ph_vlng is s)
                   ((1.07378 0.0364854))
                   ((0.906008 0.377596))))
                 ((0.714999 -0.158161)))))))))))))))
    ((pos_in_syl < 2)
     ((p.ph_clng is l)
      ((n.ph_vfront is 1)
       ((p.ph_cplace2 is a)
        ((0.700828 0.0274336))
        ((0.677255 -0.111315)))
       ((p.ph_ctype is s)
        ((0.618852 -0.193819))
        ((0.724311 -0.329287))))
      ((pp.ph_vlng is s)
       ((p.ph_ctype is r)
        ((p.ph_cplace2 is a)
         ((0.937351 0.317126))
         ((0.849952 -0.139897)))
        ((lisp_mora is 1)
         ((p.ph_ctype is f)
          ((n.ph_vfront is 1)
           ((R:SylStructure.parent.position_type is mid)
            ((0.76535 0.790169))
            ((1.03739 0.558797)))
           ((0.90394 0.524563)))
          ((R:SylStructure.parent.position_type is final)
           ((n.ph_vfront is 1)
            ((0.864259 0.530013))
            ((p.ph_ctype is n)
             ((0.925474 0.385941))
             ((0.839374 0.0860296))))
           ((p.ph_cplace2 is r)
            ((0.842425 0.331699))
            ((p.ph_ctype is l)
             ((0.846849 0.421375))
             ((p.ph_ctype is n)
              ((0.794562 0.498626))
              ((p.ph_cplace2 is a)
               ((0.664718 0.548134))
               ((0.866985 0.820401))))))))
         ((p.ph_ctype is n)
          ((0.720299 -0.150627))
          ((ph_ctype is 0)
           ((p.ph_cplace2 is l)
            ((0.801496 0.738192))
            ((p.ph_cplace2 is a)
             ((0.765104 0.419409))
             ((0.705522 0.243006))))
           ((1.22977 0.000188928))))))
       ((p.ph_vc is +)
        ((lisp_mora is 3)
         ((n.ph_vfront is 1)
          ((0.93838 0.197776))
          ((0.701688 -0.0627497)))
         ((ph_ctype is n) ((0.881802 0.595966)) ((0.708916 0.403764))))
        ((p.ph_ctype is s)
         ((R:SylStructure.parent.position_type is final)
          ((p.ph_cplace2 is a)
           ((0.71706 -0.0729048))
           ((0.793548 0.133463)))
          ((R:SylStructure.parent.position_type is mid)
           ((0.680685 0.145939))
           ((0.60824 0.307953))))
         ((R:SylStructure.parent.position_type is single)
          ((0.914759 -0.423949))
          ((p.ph_cplace2 is r)
           ((0.81343 -0.284817))
           ((pp.ph_vlng is 0)
            ((p.ph_cplace2 is a)
             ((0.671806 -0.0742459))
             ((0.703139 0.137603)))
            ((0.794418 0.203018)))))))))
     ((p.ph_vc is +) ((0.93074 0.182872)) ((0.181943 -2.7517)))))
   ((lisp_mora is 1)
    ((p.ph_clng is l)
     ((n.ph_ctype is r)
      ((R:SylStructure.parent.position_type is final)
       ((0.66389 -0.180732))
       ((0.599906 -0.595642)))
      ((R:SylStructure.parent.position_type is mid)
       ((p.ph_ctype is s)
        ((n.ph_cplace is l)
         ((0.533117 -0.968386))
         ((n.ph_ctype is l)
          ((0.523188 -0.989232))
          ((0.418059 -0.825256))))
        ((n.ph_ctype is f)
         ((0.530341 -0.816161))
         ((0.609714 -0.468383))))
       ((p.ph_ctype is f)
        ((n.ph_ctype is s) ((0.255965 -1.16391)) ((0.281458 -1.08328)))
        ((p.ph_ctype is s)
         ((n.ph_ctype is s)
          ((0.309995 -1.09552))
          ((0.373794 -0.968148)))
         ((n.ph_ctype is s)
          ((0.55278 -0.916649))
          ((0.386578 -0.73261)))))))
     ((pp.ph_vlng is s)
      ((n.ph_cplace is v)
       ((R:SylStructure.parent.position_type is mid)
        ((0.66849 -0.385247))
        ((0.561963 -0.639861)))
       ((p.ph_ctype is r)
        ((R:SylStructure.parent.position_type is single)
         ((0.431664 -0.72181))
         ((n.ph_cplace is a)
          ((0.563895 -0.386133))
          ((0.773353 -0.214832))))
        ((n.ph_ctype is r)
         ((n.ph_cplace is a)
          ((0.80164 0.449338))
          ((R:SylStructure.parent.position_type is mid)
           ((0.608827 -0.427038))
           ((0.713475 -0.129587))))
         ((R:SylStructure.parent.position_type is final)
          ((p.ph_ctype is n)
           ((0.675759 -0.0711996))
           ((n.ph_cplace is a)
            ((p.ph_ctype is s)
             ((0.536365 -0.150662))
             ((0.547778 -0.288462)))
            ((0.600451 -0.517365))))
          ((p.ph_ctype is l)
           ((n.ph_ctype is n)
            ((0.7461 0.146578))
            ((n.ph_ctype is s)
             ((0.677136 -0.0470136))
             ((0.604616 -0.224768))))
           ((p.ph_cplace2 is l)
            ((p.ph_ctype is n)
             ((0.667951 -0.494344))
             ((0.667624 -0.0213202)))
            ((p.ph_ctype is n)
             ((0.86803 0.12581))
             ((n.ph_ctype is l)
              ((0.715877 -0.0238713))
              ((p.ph_cplace2 is a)
               ((n.ph_ctype is s)
                ((0.642383 -0.163298))
                ((0.725958 -0.441871)))
               ((n.ph_cplace is a)
                ((0.796113 -0.368086))
                ((0.551508 0.0142687))))))))))))
      ((pos_in_syl < 0.3)
       ((1.00356 0.0241227))
       ((n.ph_ctype is r)
        ((n.ph_cplace is a)
         ((0.7926 -0.0106655))
         ((R:SylStructure.parent.position_type is mid)
          ((0.564627 -0.715817))
          ((0.713114 -0.326565))))
        ((p.ph_ctype is r)
         ((R:SylStructure.parent.position_type is single)
          ((0.342482 -1.24585))
          ((0.591421 -0.842725)))
         ((p.ph_cplace2 is a)
          ((n.ph_cplace is v)
           ((0.37148 -0.997771))
           ((pp.ph_vlng is 0)
            ((R:SylStructure.parent.position_type is mid)
             ((p.ph_ctype is f)
              ((0.566184 -0.883607))
              ((n.ph_cplace is b)
               ((0.486445 -0.860645))
               ((0.519562 -0.746008))))
             ((n.ph_cplace is b)
              ((0.537189 -0.651737))
              ((n.ph_ctype is s)
               ((0.297647 -1.00349))
               ((n.ph_cplace is a)
                ((n.ph_ctype is f)
                 ((0.307224 -1.01861))
                 ((0.413763 -0.777775)))
                ((0.452027 -0.803768))))))
            ((0.566495 -0.631796))))
          ((n.ph_cplace is a)
           ((n.ph_ctype is s)
            ((0.475403 -0.761056))
            ((p.ph_ctype is f)
             ((0.694206 -0.439748))
             ((R:SylStructure.parent.position_type is mid)
              ((n.ph_ctype is l)
               ((0.513707 -0.725154))
               ((0.511479 -0.623081)))
              ((0.721193 -0.488443)))))
           ((p.ph_cplace2 is r)
            ((n.ph_cplace is l)
             ((0.547292 -0.739571))
             ((0.506041 -0.875932)))
            ((R:SylStructure.parent.position_type is final)
             ((n.ph_ctype is s)
              ((0.469445 -0.722393))
              ((0.608242 -0.332834)))
             ((0.674525 -0.325557)))))))))))
    ((p.ph_vc is 0)
     ((n.ph_ctype is f)
      ((0.490377 0.14904))
      ((n.ph_cplace is a)
       ((n.ph_ctype is n) ((0.610979 0.235261)) ((0.46348 0.372425)))
       ((0.541258 0.237457))))
     ((n.ph_ctype is s)
      ((ph_ctype is s)
       ((n.seg_onsetcoda is coda)
        ((0.798423 2.41817))
        ((n.ph_cplace is v)
         ((0.445275 -0.171309))
         ((0.796616 0.315213))))
       ((ph_ctype is n)
        ((lisp_mora is 2)
         ((pp.ph_vlng is s)
          ((n.ph_cplace is v)
           ((0.94266 -0.290003))
           ((0.706687 -0.862965)))
          ((n.ph_cplace is v)
           ((R:SylStructure.parent.position_type is mid)
            ((0.77751 -0.167354))
            ((0.794132 -0.0397283)))
           ((n.ph_cplace is a)
            ((R:SylStructure.parent.position_type is final)
             ((0.717463 -0.395321))
             ((0.859088 -0.10108)))
            ((R:SylStructure.parent.position_type is final)
             ((0.676595 -0.214784))
             ((0.976023 -0.662831))))))
         ((R:SylStructure.parent.position_type is final)
          ((0.683003 -0.641977))
          ((0.461195 -0.846843))))
        ((ph_cplace2 is a)
         ((n.ph_cplace is v)
          ((0.782669 -0.332275))
          ((pos_in_syl < 2)
           ((ph_ctype is f)
            ((0.567608 -0.900861))
            ((0.941499 -0.732118)))
           ((0.497955 -1.24758))))
         ((p.ph_clng is l)
          ((p.ph_ctype is n)
           ((0.377335 -0.827169))
           ((0.43858 -0.961623)))
          ((pos_in_syl < 0.3)
           ((0.694012 -0.153702))
           ((R:SylStructure.parent.position_type is final)
            ((pp.ph_vlng is s)
             ((p.ph_ctype is n)
              ((0.393129 -0.498547))
              ((p.ph_cplace2 is l)
               ((0.379415 -0.591128))
               ((p.ph_ctype is f)
                ((0.519226 -0.826579))
                ((0.550936 -0.619726)))))
             ((p.ph_ctype is f)
              ((0.344598 -0.974665))
              ((0.467213 -0.760801))))
            ((p.ph_ctype is r)
             ((0.557746 -0.788657))
             ((ph_ctype is 0)
              ((pp.ph_vlng is s)
               ((p.ph_ctype is f)
                ((p.ph_cplace2 is a)
                 ((0.657189 -0.461298))
                 ((0.804463 -0.0564339)))
                ((p.ph_cplace2 is a)
                 ((n.ph_cplace is a)
                  ((0.516349 -0.487186))
                  ((0.652126 -0.24901)))
                 ((0.516932 -0.599442))))
               ((n.ph_cplace is v)
                ((p.ph_ctype is s)
                 ((0.45193 -0.584097))
                 ((0.526092 -0.839978)))
                ((n.seg_onsetcoda is coda)
                 ((0.828519 -0.366318))
                 ((0.501974 -0.642094)))))
              ((0.998996 -0.207612))))))))))
      ((ph_cplace2 is a)
       ((n.ph_ctype is f)
        ((n.ph_cplace is a)
         ((ph_ctype is n)
          ((lisp_mora is 2)
           ((R:SylStructure.parent.position_type is final)
            ((0.845547 -0.490197))
            ((0.868322 -0.86479)))
           ((0.583089 -1.32664)))
          ((0.659799 -0.166974)))
         ((pp.ph_vlng is s)
          ((pos_in_syl < 1.2)
           ((0.545178 -0.0838595))
           ((0.745166 -0.343245)))
          ((lisp_mora is 2)
           ((ph_ctype is s)
            ((0.553365 0.210636))
            ((0.809561 0.399364)))
           ((0.696307 -0.116787)))))
        ((ph_ctype is l)
         ((0.990092 -0.339027))
         ((lisp_mora is 3)
          ((n.ph_cplace is a)
           ((1.07935 -0.12981))
           ((0.882304 0.0823764)))
          ((pp.ph_vlng is 0)
           ((n.ph_cplace is l)
            ((ph_ctype is s) ((0.646903 1.15249)) ((1.10717 0.496918)))
            ((1.01146 0.434096)))
           ((n.ph_ctype is n)
            ((0.887008 -0.0745151))
            ((0.812587 0.169537)))))))
       ((n.ph_ctype is f)
        ((n.ph_cplace is a)
         ((pp.ph_vlng is 0)
          ((p.ph_cplace2 is l)
           ((0.56388 -0.836105))
           ((p.ph_cplace2 is r)
            ((0.681996 -0.798265))
            ((R:SylStructure.parent.position_type is single)
             ((0.722674 -0.240226))
             ((n.seg_onsetcoda is coda)
              ((pos_in_syl < 1.2)
               ((0.532268 -0.482672))
               ((0.573514 -0.810443)))
              ((0.486268 -0.535983))))))
          ((p.ph_clng is s)
           ((p.ph_cplace2 is r)
            ((0.840044 -0.137973))
            ((R:SylStructure.parent.position_type is mid)
             ((p.ph_ctype is s)
              ((0.676392 -0.317128))
              ((p.ph_cplace2 is a)
               ((p.ph_ctype is r)
                ((0.717006 -0.533094))
                ((p.ph_ctype is f)
                 ((0.742985 -0.454561))
                 ((0.7368 -0.27739))))
               ((0.533025 -0.571322))))
             ((0.619673 -0.514244))))
           ((p.ph_cplace2 is a)
            ((0.497439 -0.806519))
            ((0.476752 -0.693539)))))
         ((n.seg_onsetcoda is coda)
          ((0.95952 -0.135029))
          ((p.ph_cplace2 is a)
           ((0.598809 -0.486134))
           ((0.495617 -0.20274)))))
        ((R:SylStructure.parent.position_type is mid)
         ((pp.ph_vlng is s)
          ((n.ph_cplace is a)
           ((p.ph_ctype is n)
            ((p.ph_clng is l)
             ((0.521479 -0.175804))
             ((0.682339 -0.0022929)))
            ((lisp_mora is 2)
             ((n.seg_onsetcoda is coda)
              ((0.702162 0.465337))
              ((p.ph_cplace2 is r)
               ((0.730895 -0.0114749))
               ((0.716493 0.313177))))
             ((0.747677 0.00177269))))
           ((p.ph_ctype is f)
            ((0.922175 0.203941))
            ((n.ph_cplace is l)
             ((0.687174 -0.0363329))
             ((0.797603 -0.344224)))))
          ((n.ph_ctype is r)
           ((1.02108 0.282636))
           ((p.ph_ctype is r)
            ((0.54182 -0.5994))
            ((p.ph_cplace2 is a)
             ((p.ph_ctype is f)
              ((0.52293 -0.613554))
              ((0.61755 -0.265341)))
             ((p.ph_ctype is f)
              ((0.861973 0.0372255))
              ((n.ph_ctype is l)
               ((0.730478 -0.349741))
               ((0.757481 -0.145898))))))))
         ((p.ph_clng is s)
          ((lisp_mora is 3)
           ((p.ph_ctype is s)
            ((pp.ph_vlng is 0)
             ((0.517808 -0.479629))
             ((0.534339 -0.339318)))
            ((p.ph_cplace2 is l)
             ((0.603803 -0.640758))
             ((pp.ph_vlng is s)
              ((0.712351 -0.330568))
              ((0.568915 -0.560679)))))
           ((p.ph_cplace2 is r)
            ((p.ph_ctype is r)
             ((0.476332 -0.66412))
             ((R:SylStructure.parent.position_type is single)
              ((0.555318 -0.445519))
              ((p.ph_ctype is f)
               ((0.692326 -0.584272))
               ((0.649426 -0.235355)))))
            ((pp.ph_vlng is s)
             ((p.ph_ctype is f)
              ((p.ph_cplace2 is a)
               ((0.694916 -0.403756))
               ((0.648391 -0.0108221)))
              ((n.seg_onsetcoda is coda)
               ((p.ph_ctype is l)
                ((0.634274 0.189092))
                ((p.ph_cplace2 is a)
                 ((0.622436 -0.0801574))
                 ((0.659552 0.0564502))))
               ((0.613115 -0.274092))))
             ((R:SylStructure.parent.position_type is single)
              ((0.890316 0.100146))
              ((0.555715 -0.393896))))))
          ((lisp_mora is 3)
           ((0.470997 -0.778816))
           ((pos_in_syl < 1.2)
            ((R:SylStructure.parent.position_type is single)
             ((0.786515 -0.460109))
             ((pp.ph_vlng is s)
              ((p.ph_ctype is n)
               ((0.580053 -0.392255))
               ((0.506821 -0.529974)))
              ((R:SylStructure.parent.position_type is 0)
               ((0.297801 -0.379085))
               ((0.845351 -0.117591)))))
            ((R:SylStructure.parent.position_type is final)
             ((0.58491 -0.464601))
             ((0.637256 -0.652212)))))))))))))
  ((n.ph_vfront is 0)
   ((lisp_mora is 1)
    ((R:SylStructure.parent.position_type is final)
     ((p.ph_clng is l)
      ((p.ph_ctype is l)
       ((0.581768 -1.19027))
       ((p.ph_ctype is f) ((0.751442 -0.985889)) ((0.81301 -0.645655))))
      ((p.ph_ctype is s)
       ((pp.ph_vlng is 0)
        ((0.706418 -0.704896))
        ((0.971941 -0.206601)))
       ((p.ph_ctype is f)
        ((0.910496 -0.223875))
        ((0.955915 -0.378582)))))
     ((n.ph_ctype is s)
      ((0.720567 0.000321504))
      ((n.ph_ctype is f)
       ((0.847069 0.243405))
       ((pp.ph_vlng is 0) ((0.698901 0.345199)) ((0.912286 0.674266))))))
    ((n.ph_ctype is n)
     ((p.ph_ctype is n)
      ((0.702047 0.319904))
      ((lisp_mora is 2)
       ((R:SylStructure.parent.position_type is final)
        ((0.865349 0.460549))
        ((1.08463 1.00808)))
       ((pp.ph_vlng is 0) ((0.922977 1.0134)) ((1.12538 1.26623)))))
     ((ph_ctype is f)
      ((0.996002 0.871986))
      ((ph_ctype is s)
       ((ph_cplace2 is a) ((0.824457 1.24974)) ((0.543244 0.450197)))
       ((lisp_mora is 3)
        ((ph_cplace2 is a)
         ((0.777385 -0.343544))
         ((0.956584 0.337526)))
        ((n.ph_ctype is s)
         ((p.ph_cplace2 is a)
          ((0.594385 -0.37777))
          ((0.940047 -0.0249902)))
         ((n.ph_ctype is f)
          ((p.ph_cplace2 is a)
           ((pp.ph_vlng is s)
            ((0.736129 0.0641271))
            ((0.653832 -0.371453)))
           ((pos_in_syl < 1.2)
            ((0.847296 0.149207))
            ((1.13276 0.4653))))
          ((pos_in_syl < 1.2)
           ((n.ph_ctype is l)
            ((0.842123 0.474713))
            ((p.ph_ctype is s)
             ((1.06371 0.634879))
             ((1.10028 1.26986))))
           ((1.03168 0.11122))))))))))
   ((lisp_end_of_phrase is 1)
    ((p.ph_cplace2 is a)
     ((p.ph_ctype is f)
      ((lisp_mora is 1)
       ((n.ph_vfront is 1) ((0.858409 0.569369)) ((0.600806 0.297108)))
       ((0.966558 1.03672)))
      ((lisp_mora is 1)
       ((ph_cplace2 is a) ((0.75622 0.996286)) ((0.898703 1.26713)))
       ((1.09981 1.37918))))
     ((ph_ctype is s)
      ((n.ph_vfront is 1)
       ((ph_cplace2 is r) ((1.15655 1.42386)) ((1.16713 1.80448)))
       ((1.08963 1.38385)))
      ((ph_ctype is r)
       ((0.807953 0.43703))
       ((lisp_mora is 2)
        ((pp.ph_vlng is 0) ((0.853256 0.60538)) ((1.17451 1.00819)))
        ((ph_ctype is n)
         ((1.11399 0.823994))
         ((n.ph_vfront is 1)
          ((ph_ctype is l)
           ((0.90164 1.2336))
           ((p.ph_ctype is s) ((0.734892 1.24618)) ((1.02358 1.614))))
          ((0.888684 1.27728))))))))
    ((ph_ctype is 0)
     ((p.ph_cplace2 is a) ((0.718485 1.10805)) ((0.932929 1.2986)))
     ((n.seg_onsetcoda is coda)
      ((p.ph_cplace2 is a)
       ((lisp_mora is 1) ((0.590999 0.228387)) ((0.699974 0.413645)))
       ((ph_cplace2 is l)
        ((ph_ctype is n) ((0.700411 0.449788)) ((0.564384 0.214491)))
        ((lisp_mora is 2)
         ((ph_ctype is f)
          ((0.698342 0.453959))
          ((pp.ph_vlng is 0)
           ((0.827512 0.514166))
           ((0.801421 0.748086))))
         ((ph_ctype is s)
          ((0.782835 0.90533))
          ((ph_ctype is l) ((0.886991 0.499058)) ((0.55558 0.703079)))))))
      ((pp.ph_vlng is s) ((0.806638 1.23657)) ((0.748911 0.750108)))))))))
)
))

(define (Duration_Finnish utt)
  "(Duration_Finnish)
Lengthens the final phone after the duration cart tree."
  (if hy_debug (format stderr "<PHONE DURATIONS>\n"))
  (let ((end 0))
    (if hy_debug (format stderr "Phone\tDur\tEnd"))
    (mapcar
     (lambda (s)
       (item.get_utt s)
       (let ((dur (wagon_predict s duration_cart_tree))
	     (di (assoc_string (item.name s) hy_fi_mv2::phone_durs)))
	 ;;  (nth 1 di) mean
	 ;;  (nth 2 di) dev
	 (set! dur (+ (nth 1 di) (* dur (nth 2 di))))
	 
	 ;; lengthening of the final phoneme
	 ;; (we're not perfectly happy of duration in phrase final position)
	 (if (and (item.next s) 
		  (string-equal (item.name (item.next s)) "#"))
	     (begin
	       (set! dur (* dur 1.0)))) ;; 1.3
	 
	 
	 
	 (set! dur (* (Parameter.get 'Duration_Stretch) dur))
	 (if (> 0.03 dur) 
	     (begin
	       (set! dur 0.03)
	       (if hy_debug
		   (format stderr 
			   "  %s is shorter than 30 ms! Lengthening it!\n"
			   (item.name s))))
	     (if hy_debug (format stderr "\n")))

	 ;; too short final phoneme can cause a crash...
	 ;; an awfully terrible bug fix...	 
	 (if (not (item.next s))
	     (begin
	       (set! dur 0.2)))

	 (set! end (+ dur end))
			      
	 (if hy_debug (format stderr "%s\t%s\t%s " (item.name s) dur end))
	 (if (and hy_debug (not (item.next s))) (format stderr "\n"))
	 (item.set_feat s "target_dur" dur)
	 (item.set_function s "start" "unisyn_start")
	 (item.set_feat s "end" end)
	 (item.set_feat s "dur" dur)
	 );; end of let
       ) ;; end of lambda
     (utt.relation.items utt 'Segment)) ;; end of mapcar
    utt))


(define (mora aanne) 
  "(mora PHONE)
Counts the number of morae in the syllable.
Used by the duration model."
;; if syllable ends in a long C, is it counted as 1 (as it should be)
;; or as 2 (as it probably is)????
  (let ((coda (item.feat aanne 'R:SylStructure.parent.syl_codasize))
	(onset (item.feat aanne 'R:SylStructure.parent.syl_onsetsize))
	(head (if (item.parent (item.relation aanne 'SylStructure))
		  (item.relation (item.daughter1 (item.parent (item.relation aanne 'SylStructure))) 'Segment)
		  nil))
	(mora 0))
    (while (> onset 0)
	   (set! onset (- onset 1))
	   (set! head (item.next head)))
    (while (> coda 0)
	   (if (string-matches (item.name head) "^[abdefghijklmnoprstuvy@7NT]:$" )
			
	       (set! mora (+ mora 2))
	       (set! mora (+ mora 1)))
	   (set! coda (- coda 1))
	   (set! head (item.next head)))
    (if (and head
	     (string-matches (item.name head) "^[abdefghijklmnoprstuvy@7NT]:$" )
	     (string-matches (item.name head) "^[bdfghjklmnprstvNT]:?$" ))
	(set! mora (+ mora 1)))
;;    (print mora)
    mora))


(define (end_of_phrase phone)
  "(end_of_phrase PHONE)
Used by the duration tree to detect phrase boundary.
Returns either 1 (last syllable), 2 (penultimate syllable of the phrase)
or 0 (other). Somehow I'm sure that there are easier and faster
ways to do this..."
  (cond
   ((not (item.relation phone 'SylStructure))
    0)
   ((string-equal "#" (item.feat phone "R:SylStructure.parent.daughtern.R:Segment.n.name"))
;;    (format stderr "1: %s\n" (item.name phone))    
    1)
   
   ((string-equal "#" (item.feat phone "R:SylStructure.parent.n.daughtern.R:Segment.n.name"))
;;    (format stderr "2: %s\n" (item.name phone))
    2)
   (t
    0)))


(provide 'finnish_duration

)


