from typing import Generator, Optional, Union, Tuple, Iterable, Callable, Any, Iterator, TextIO, BinaryIO, Dict
from . import rdata, zone, rdataclass, name, rdataclass, message, rdatatype, exception, node, rdataset, rrset, rdatatype

class BadZone(exception.DNSException): ...
class NoSOA(BadZone): ...
class NoNS(BadZone): ...
class UnknownOrigin(BadZone): ...

class Zone:
    def __getitem__(self, key : str) -> node.Node:
        ...
    def __init__(self, origin : Union[str,name.Name], rdclass : int = rdataclass.IN, relativize : bool = True) -> None:
        self.nodes : Dict[str,node.Node]
        self.origin = origin
    def values(self):
        return self.nodes.values()
    def iterate_rdatas(self, rdtype : Union[int,str] = rdatatype.ANY, covers : Union[int,str] = None) -> Iterable[Tuple[name.Name, int, rdata.Rdata]]:
        ...
    def __iter__(self) -> Iterator[str]:
        ...
    def get_node(self, name : Union[name.Name,str], create=False) -> Optional[node.Node]:
        ...
    def find_rrset(self, name : Union[str,name.Name], rdtype : Union[int,str], covers=rdatatype.NONE) -> rrset.RRset:
        ...
    def find_rdataset(self, name : Union[str,name.Name], rdtype : Union[str,int], covers=rdatatype.NONE,
                      create=False) -> rdataset.Rdataset:
        ...
    def get_rdataset(self, name : Union[str,name.Name], rdtype : Union[str,int], covers=rdatatype.NONE, create=False) -> Optional[rdataset.Rdataset]:
        ...
    def get_rrset(self, name : Union[str,name.Name], rdtype : Union[str,int], covers=rdatatype.NONE) -> Optional[rrset.RRset]:
        ...
    def replace_rdataset(self, name : Union[str,name.Name], replacement : rdataset.Rdataset) -> None:
        ...
    def delete_rdataset(self, name : Union[str,name.Name], rdtype : Union[str,int], covers=rdatatype.NONE) -> None:
        ...
    def iterate_rdatasets(self, rdtype : Union[str,int] =rdatatype.ANY,
                          covers : Union[str,int] =rdatatype.NONE):
        ...
    def to_file(self, f : Union[TextIO, BinaryIO, str], sorted=True, relativize=True, nl : Optional[bytes] = None):
        ...
    def to_text(self, sorted=True, relativize=True, nl : Optional[str] = None) -> str:
        ...

def from_xfr(xfr : Generator[Any,Any,message.Message], zone_factory : Callable[..., zone.Zone] = zone.Zone, relativize=True, check_origin=True):
    ...

def from_text(text : str, origin : Optional[Union[str,name.Name]] = None, rdclass : int = rdataclass.IN,
              relativize=True, zone_factory : Callable[...,zone.Zone] = zone.Zone, filename : Optional[str] = None,
              allow_include=False, check_origin=True) -> zone.Zone:
    ...

def from_file(f, origin : Optional[Union[str,name.Name]] = None, rdclass=rdataclass.IN,
              relativize=True, zone_factory : Callable[..., zone.Zone] = Zone, filename : Optional[str] = None,
              allow_include=True, check_origin=True) -> zone.Zone:
    ...
