# Table of Contents

- [What is ceilometer-instance-poller](#what-is-ceilometer-instance-poller)
  * [General description](#general-description)
  * [Values being polled](#values-being-polled)
  * [What for](#what-for)

# What is ceilometer-instance-poller

### General description

This Python package uses libvirt and libguestfs to poll data otherwise not
available through a standard Ceilometer installation on a compute node.
/usr/bin/ceilometer-instance-poller produces a json output that can be
used by Ceilometer as a compute dynamic pollster.

This relies on this patch being merged:

https://review.opendev.org/c/openstack/ceilometer/+/852021

At the time of writing, this patch is available in Debian from the
Victoria release, but in other distributions, it may only appear
after Antelope.

### Values being polled

All the metadata needed to bill OS licenses of your running VMs.

Example output:

```
[
  {
    "resource_id": "190f5907-fd86-4ade-9315-705e14aa63cd",
    "os_type": "windows",
    "os_distro": "windows",
    "os_info": "win2k16",
    "os_version_major": 10,
    "os_version_minor": 0,
    "os_product_name": "Windows Server 2022 Datacenter Evaluation",
    "os_product_variant": "Server"
  },
  {
    "resource_id": "9e92c509-0b48-43d0-a552-42de6f001e36",
    "os_type": "linux",
    "os_distro": "debian",
    "os_info": "debian11",
    "os_version_major": 11,
    "os_version_minor": 2,
    "os_product_name": "11.2",
    "os_product_variant": "unknown"
  }
]
```

### What for

Some operating systems aren't free, and needs to be charged.
Though if booted from volume, there's no way to know what the
base image was, and if your customer is running Windows. That's
what this script does: it looks into the running VMs using
read-only libguestfs to know if your customer needs to be
charged for using a Windows license.
