//
// C++ Implementation: BoatProperties
//
// Description:
//
//
// Author: Thibaut GRIDEL <tgridel@free.fr>
//
// Copyright (c) 2019 Thibaut GRIDEL
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//
#include "boatproperties.h"

#include <QFile>
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonArray>
#include <QVariant>

#include <iostream>

extern int debugLevel;

BoatProperties::BoatProperties(QString filename) {

    QFile file(filename);
    if (!file.open(QFile::ReadOnly | QFile::Text)) {
        return;
    }

    QByteArray content = file.readAll();
    m_object = QJsonDocument::fromJson(content).object();

    if (m_object.contains("series")) {
        m_series = m_object["series"].toString();
    }

    if (m_object.contains("name")) {
        QJsonObject o = m_object["name"].toObject();
        foreach (QString key, o.keys()) {
            m_name[key] = o[key].toString();
        }
    }

    if (m_object.contains("size")) {
        m_size = m_object["size"].toDouble();
    }

    if (m_object.contains("border")) {
        m_border = m_object["border"].toDouble();
    }

    if (m_object.contains("numberSize")) {
        m_numberSize = m_object["numberSize"].toDouble();
    }

    if (m_object.contains("numberPos")) {
        QJsonArray array = m_object["numberPos"].toArray();
        if (array.size() == 2) {
            m_numberPos = QPointF(array[0].toDouble(), array[1].toDouble());
        }
    }

    if (m_object.contains("sail")) {
        m_hasSail = m_object["sail"].toBool();
    }

    if (m_object.contains("sailSize")) {
        m_sailSize = m_object["sailSize"].toDouble();
    }

    if (m_object.contains("sailMaxNormalAngle")) {
        m_sailMaxNormalAngle = m_object["sailMaxNormalAngle"].toDouble();
    }

    if (m_object.contains("sailMaxSpinAngle")) {
        m_sailMaxSpinAngle = m_object["sailMaxSpinAngle"].toDouble();
    }

    if (m_object.contains("jib")) {
        m_hasJib = m_object["jib"].toBool();
    }

    if (m_object.contains("jibSize")) {
        m_jibSize = m_object["jibSize"].toDouble();
    }

    if (m_object.contains("jibTackPos")) {
        QJsonArray array = m_object["jibTackPos"].toArray();
        if (array.size() == 2) {
            m_jibTackPos = QPointF(array[0].toDouble(), array[1].toDouble());
        }
    }

    if (m_object.contains("jibMaxNormalAngle")) {
        m_jibMaxNormalAngle = m_object["jibMaxNormalAngle"].toDouble();
    }

    if (m_object.contains("jibMaxSpinAngle")) {
        m_jibMaxSpinAngle = m_object["jibMaxSpinAngle"].toDouble();
    }

    if (m_object.contains("spin")) {
        m_hasSpin = m_object["spin"].toBool();
    }

    if (m_object.contains("spinSize")) {
        m_spinSize = m_object["spinSize"].toDouble();
    }

    if (m_object.contains("gennaker")) {
        m_hasGennaker = m_object["gennaker"].toBool();
    }

    if (m_object.contains("gennakerSize")) {
        m_gennakerSize = m_object["gennakerSize"].toDouble();
    }

    if (m_object.contains("gennakerTackPos")) {
        QJsonArray array = m_object["gennakerTackPos"].toArray();
        if (array.size() == 2) {
            m_gennakerTackPos = QPointF(array[0].toDouble(), array[1].toDouble());
        }
    }

    if (m_object.contains("gennakerPoleSize")) {
        m_gennakerPoleSize = m_object["gennakerPoleSize"].toDouble();
    }

    if (m_object.contains("mastPos")) {
        QJsonArray array = m_object["mastPos"].toArray();
        if (array.size() == 2) {
            m_mastPos = QPointF(array[0].toDouble(), array[1].toDouble());
        }
    }

    if (m_object.contains("flagRect")) {
        QJsonArray array = m_object["flagRect"].toArray();
        if (array.size() == 4) {
            m_flagRect = QRectF(array[0].toDouble(), array[1].toDouble(),
                         array[2].toDouble(), array[3].toDouble());
        }
    }

    if (m_object.contains("path")) {
        QJsonArray array = m_object["path"].toArray();
        foreach(QJsonValue v, array) {
            QJsonObject o = v.toObject();
            if (o.contains("type")) {
                if (o["type"].toString() == "moveTo") {
                    appendMoveTo(o, m_path);
                }

                if (o["type"].toString() == "lineTo") {
                    appendLineTo(o, m_path);
                }

                if (o["type"].toString() == "cubicTo") {
                    appendCubicTo(o, m_path);
                }
                if (o["type"].toString() == "quadTo") {
                    appendQuadTo(o, m_path);
                }
            }
        }
    }
}

QString BoatProperties::series() {
    return m_series;
}

QString BoatProperties::name(QString locale) {
    return m_name.value(locale);
}

qreal BoatProperties::size(){
    return m_size;
}

qreal BoatProperties::border() {
    return m_border;
}

qreal BoatProperties::numberSize() {
    return m_numberSize;
}

QPointF BoatProperties::numberPos() {
    return m_numberPos;
}

bool BoatProperties::hasSail() {
    return m_hasSail;
}

qreal BoatProperties::sailSize() {
    return m_sailSize;
}

qreal BoatProperties::sailMaxNormalAngle() {
    return m_sailMaxNormalAngle;
}

qreal BoatProperties::sailMaxSpinAngle() {
    return m_sailMaxSpinAngle;
}

bool BoatProperties::hasJib() {
    return m_hasJib;
}

qreal BoatProperties::jibSize() {
    return m_jibSize;
}

QPointF BoatProperties::jibTackPos() {
    return m_jibTackPos;
}

qreal BoatProperties::jibMaxNormalAngle() {
    return m_jibMaxNormalAngle;
}

qreal BoatProperties::jibMaxSpinAngle() {
    return m_jibMaxSpinAngle;
}

bool BoatProperties::hasSpin() {
    return m_hasSpin;
}

qreal BoatProperties::spinSize() {
    return m_spinSize;
}

bool BoatProperties::hasGennaker() {
    return m_hasGennaker;
}

qreal BoatProperties::gennakerSize() {
    return m_gennakerSize;
}

QPointF BoatProperties::gennakerTackPos() {
    return m_gennakerTackPos;
}

qreal BoatProperties::gennakerPoleSize() {
    return m_gennakerPoleSize;
}

QPointF BoatProperties::mastPos() {
    return m_mastPos;
}

QRectF BoatProperties::flagRect() {
    return m_flagRect;
}

QPainterPath BoatProperties::path() {
    return m_path;
}

void BoatProperties::appendMoveTo(QJsonObject object, QPainterPath &path) {
    if (object.contains("data")) {
        QJsonArray array = object["data"].toArray();
        if (array.size() == 2) {
            path.moveTo(array[0].toDouble(), array[1].toDouble());
        } else {
            std::cout << m_series.toStdString() << ": bad moveTo" << std::endl;
        }
    }
}

void BoatProperties::appendLineTo(QJsonObject object, QPainterPath &path) {
    if (object.contains("data")) {
        QJsonArray array = object["data"].toArray();
        if (array.size() == 2) {
            path.lineTo(array[0].toDouble(), array[1].toDouble());
        } else {
            std::cout << m_series.toStdString() << ": bad lineTo" << std::endl;
        }
    }
}

void BoatProperties::appendCubicTo(QJsonObject object, QPainterPath &path) {
    if (object.contains("data")) {
        QJsonArray array = object["data"].toArray();
        if (array.size() == 6) {
            path.cubicTo(array[0].toDouble(), array[1].toDouble(),
                    array[2].toDouble(), array[3].toDouble(),
                    array[4].toDouble(), array[5].toDouble());
        } else {
            std::cout << m_series.toStdString() << ": bad cubicTo" << std::endl;
        }
    }
}

void BoatProperties::appendQuadTo(QJsonObject object, QPainterPath &path) {
    if (object.contains("data")) {
        QJsonArray array = object["data"].toArray();
        if (array.size() == 4) {
            path.quadTo(array[0].toDouble(), array[1].toDouble(),
                    array[2].toDouble(), array[3].toDouble());
        } else {
            std::cout << m_series.toStdString() << ": bad quadTo" << std::endl;
        }
    }
}
