/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgFunction;
import cz.startnet.utils.pgdiff.schema.PgIndex;
import cz.startnet.utils.pgdiff.schema.PgProcedure;
import cz.startnet.utils.pgdiff.schema.PgRelation;
import cz.startnet.utils.pgdiff.schema.PgRule;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import cz.startnet.utils.pgdiff.schema.PgTable;
import cz.startnet.utils.pgdiff.schema.PgType;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgSchema {
    private final List<PgFunction> functions = new ArrayList<PgFunction>();
    private final List<PgProcedure> procedures = new ArrayList<PgProcedure>();
    private final List<PgSequence> sequences = new ArrayList<PgSequence>();
    private final List<PgRelation> rels = new ArrayList<PgRelation>();
    private final List<PgType> types = new ArrayList<PgType>();
    private final List<PgIndex> indexes = new ArrayList<PgIndex>();
    private final List<PgConstraint> primaryKeys = new ArrayList<PgConstraint>();
    private final List<PgRule> rules = new ArrayList<PgRule>();
    private final String name;
    private String authorization;
    private String definition;
    private String comment;

    public PgSchema(String string) {
        this.name = string;
    }

    public void setAuthorization(String string) {
        this.authorization = string;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("CREATE SCHEMA ");
        stringBuilder.append(PgDiffUtils.getCreateIfNotExists());
        stringBuilder.append(PgDiffUtils.getQuotedName(this.getName()));
        if (this.getAuthorization() != null) {
            stringBuilder.append(" AUTHORIZATION ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.getAuthorization()));
        }
        stringBuilder.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("COMMENT ON SCHEMA ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(" IS ");
            stringBuilder.append(this.comment);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public PgFunction getFunction(String string) {
        for (PgFunction pgFunction : this.functions) {
            if (!pgFunction.getSignature().equals(string)) continue;
            return pgFunction;
        }
        return null;
    }

    public List<PgFunction> getFunctions() {
        return Collections.unmodifiableList(this.functions);
    }

    public PgProcedure getProcedure(String string) {
        for (PgProcedure pgProcedure : this.procedures) {
            if (!pgProcedure.getSignature().equals(string)) continue;
            return pgProcedure;
        }
        return null;
    }

    public List<PgProcedure> getProcedures() {
        return Collections.unmodifiableList(this.procedures);
    }

    public String getName() {
        return this.name;
    }

    public PgIndex getIndex(String string) {
        for (PgIndex pgIndex : this.indexes) {
            if (!pgIndex.getName().equals(string)) continue;
            return pgIndex;
        }
        return null;
    }

    public PgConstraint getPrimaryKey(String string) {
        for (PgConstraint pgConstraint : this.primaryKeys) {
            if (!pgConstraint.getName().equals(string)) continue;
            return pgConstraint;
        }
        return null;
    }

    public PgSequence getSequence(String string) {
        for (PgSequence pgSequence : this.sequences) {
            if (!pgSequence.getName().equals(string)) continue;
            return pgSequence;
        }
        return null;
    }

    public List<PgIndex> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public List<PgConstraint> getPrimaryKeys() {
        return Collections.unmodifiableList(this.primaryKeys);
    }

    public List<PgSequence> getSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    public PgRelation getRelation(String string) {
        for (PgRelation pgRelation : this.rels) {
            if (!pgRelation.getName().equals(string)) continue;
            return pgRelation;
        }
        return null;
    }

    public PgTable getTable(String string) {
        PgRelation pgRelation = this.getRelation(string);
        if (pgRelation == null || !(pgRelation instanceof PgTable)) {
            return null;
        }
        return (PgTable)pgRelation;
    }

    public List<PgTable> getTables() {
        ArrayList<PgTable> arrayList = new ArrayList<PgTable>();
        for (PgRelation pgRelation : this.rels) {
            if (!(pgRelation instanceof PgTable)) continue;
            arrayList.add((PgTable)pgRelation);
        }
        return arrayList;
    }

    public List<PgRelation> getRels() {
        return Collections.unmodifiableList(this.rels);
    }

    public PgView getView(String string) {
        PgRelation pgRelation = this.getRelation(string);
        if (pgRelation == null || !(pgRelation instanceof PgView)) {
            return null;
        }
        return (PgView)pgRelation;
    }

    public List<PgView> getViews() {
        ArrayList<PgView> arrayList = new ArrayList<PgView>();
        for (PgRelation pgRelation : this.rels) {
            if (!(pgRelation instanceof PgView)) continue;
            arrayList.add((PgView)pgRelation);
        }
        return arrayList;
    }

    public void addIndex(PgIndex pgIndex) {
        this.indexes.add(pgIndex);
    }

    public void addPrimaryKey(PgConstraint pgConstraint) {
        this.primaryKeys.add(pgConstraint);
    }

    public void addFunction(PgFunction pgFunction) {
        this.functions.add(pgFunction);
    }

    public void addProcedure(PgProcedure pgProcedure) {
        this.procedures.add(pgProcedure);
    }

    public void addSequence(PgSequence pgSequence) {
        this.sequences.add(pgSequence);
    }

    public void addRelation(PgRelation pgRelation) {
        this.rels.add(pgRelation);
    }

    public void addType(PgType pgType) {
        this.types.add(pgType);
    }

    public List<PgType> getTypes() {
        return this.types;
    }

    public PgType getType(String string) {
        for (PgType pgType : this.types) {
            if (!pgType.getName().equals(string)) continue;
            return pgType;
        }
        return null;
    }

    public List<PgRule> getRules() {
        ArrayList<PgRule> arrayList = new ArrayList<PgRule>();
        for (PgRelation pgRelation : this.rels) {
            if (!(pgRelation instanceof PgRule)) continue;
            arrayList.add((PgRule)pgRelation);
        }
        return arrayList;
    }

    public boolean containsRule(String string) {
        for (PgRule pgRule : this.rules) {
            if (!pgRule.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsType(String string) {
        for (PgType pgType : this.types) {
            if (!pgType.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsFunction(String string) {
        for (PgFunction pgFunction : this.functions) {
            if (!pgFunction.getSignature().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsProcedure(String string) {
        for (PgProcedure pgProcedure : this.procedures) {
            if (!pgProcedure.getSignature().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSequence(String string) {
        for (PgSequence pgSequence : this.sequences) {
            if (!pgSequence.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTable(String string) {
        return this.getTable(string) != null;
    }

    public boolean containsView(String string) {
        return this.getView(string) != null;
    }
}

