// Copyright 2006 David Hilvert <dhilvert@auricle.dyndns.org>, 
//                                    <dhilvert@ugcs.caltech.edu>

/*  This file is part of the Anti-Lamenessing Engine.

    The Anti-Lamenessing Engine is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    The Anti-Lamenessing Engine is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the Anti-Lamenessing Engine; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __exclusion_h__
#define __exclusion_h__

/*
 * Header file for exclusion regions.
 */

/*
 * Exclusion data structure.
 *
 * XXX: For now, we're using floating point boundary values;
 * this might be somewhat inefficient in cases where the values
 * will always be integer.
 */

struct exclusion {
	enum {RENDER, FRAME};
	char type;

	ale_pos x[6];
};

#endif
