/* 
 * frankhale@gmail.com
 * http://frankhale.org
 *
 * This code is released under the GPL license www.gnu.org
 */
#include "aewm.hh"

WindowMenu::WindowMenu(Display * dpy) : GenericMenu(dpy)
{
	updateWindowMenu();
}

void WindowMenu::updateWindowMenu()
{
	char* temp = new char[wm->getMaxDesktops()];
	for(int i=0; i<wm->getMaxDesktops(); i++)
	{
		sprintf(temp, "%d", i);
		
		insert(temp,"", SEND_TO_DESKTOP);
	}		
	delete [] temp;

	updateMenu();
	
	addToMenuList(this);
}

void WindowMenu::handleButtonReleaseEvent(XButtonEvent *e)
{
	int desktop=0;
	
	GenericMenu::handleButtonReleaseEvent(e);

	switch (e->button) 
	{
		case Button1:
			if (curr) 
			{
				switch(	curr->function )
				{
					case SEND_TO_DESKTOP:
						desktop = atoi(curr->name.c_str());
						if(client) client->setDesktop(desktop);
						hideAllVisibleSubmenus();
					break;
				
				}										
			}	
		break;
	} 
}
