% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{xgb.cb.cv.predict}
\alias{xgb.cb.cv.predict}
\title{Callback for returning cross-validation based predictions}
\usage{
xgb.cb.cv.predict(save_models = FALSE, outputmargin = FALSE)
}
\arguments{
\item{save_models}{A flag for whether to save the folds' models.}

\item{outputmargin}{Whether to save margin predictions (same effect as passing this
parameter to \link{predict.xgb.Booster}).}
}
\value{
An \code{xgb.Callback} object, which can be passed to \code{\link[=xgb.cv]{xgb.cv()}},
but \strong{not} to \code{\link[=xgb.train]{xgb.train()}}.
}
\description{
This callback function saves predictions for all of the test folds,
and also allows to save the folds' models.
}
\details{
Predictions are saved inside of the \code{pred} element, which is either a vector or a matrix,
depending on the number of prediction outputs per data row. The order of predictions corresponds
to the order of rows in the original dataset. Note that when a custom \code{folds} list is
provided in \code{\link[=xgb.cv]{xgb.cv()}}, the predictions would only be returned properly when this list is a
non-overlapping list of k sets of indices, as in a standard k-fold CV. The predictions would not be
meaningful when user-provided folds have overlapping indices as in, e.g., random sampling splits.
When some of the indices in the training dataset are not included into user-provided \code{folds},
their prediction value would be \code{NA}.
}
