.\" @(#)obmsh.1 1.1 28-Aug-97 MJF
.TH OBMSH 1 "28 Aug 1997" "X11IRAF Project"
.SH NAME
obmsh \- Object Manager GUI script interpreter
.SH SYNOPSIS
\fBobmsh\fP [\fIfile\fP]
.SH DESCRIPTION
.LP
\fBObmsh\fP is a GUI command interpreter for the IRAF Widget Server /
Object Manager (OBM) that
executes commands read from the standard input or from a file.  As with
other shell interpreters such as \fIcsh\fR if the program is a file
beginning with \fB#!\fR, the remainder of the first line specifies an
interpreter for the program, usually the path to the obmsh executable.
There are no arguments.

OBM programs are Tcl scripts consisting of application widgets to be created,
resource values for those widgets, callback procedures, and OBM-specific
functions needed to create and activate the GUI.  In applications such as
\fIXimtool\fR the GUI interacts with an underlying client program by passing
messages to the client, server (the object manager itself) or various
parameters or widgets in the script.  Obmsh scripts have no client but
will execute a default callback that outputs the client message to the
standard output, the script will continue to run until a 'q' keystroke is
detected in a client message.

Obmsh script support all features of the Tcl language but also provide a
builtin GUI capability.  For applications which do not require a client
to perform more complex operations, the obmsh provides a fully featured
GUI scripting language.  For more information on the IRAF Widget Server /
OBM see Tody, D. 1995, in ADASS IV Proceedings, ASP Conf. Ser, Vol 77, p. 89.

.SH EXAMPLE
.LP
The following GUI script program demonstrates a simple "hello world"
application:
.nf

    #!/usr/local/bin/obmsh

    reset-server
    appInitialize hello Hello {
        ! Application defaults for the hello world program.
        Hello*objects:\\
	    toplevel		Form        helloForm\\
	    helloForm		Label       helloLabel\\
	    helloForm		Command     quitButton

        *background:                 bisque
        *helloLabel.label:           Hello, world!
        *quitButton.fromHoriz:       helloLabel
        *quitButton.label:           Quit
    }

    createObjects
    proc quit args { send client gkey q; deactivate unmap }
    send quitButton addCallback quit
    activate

.fi
If the file has execute permissions set the \fB#!\fR will invoke the obmsh
to execute the file, otherwise it may be running using either
.nf

	% obmsh hello.gui	or 	 % obmsh < hello.gui
.fi
.SH SEE ALSO
xgterm(1), ximtool(1)
.SH COPYRIGHT
Copyright(c) 1986 Association of Universities for Research in Astronomy Inc.
