/*
 *  Copyright (C) 2005-2008  Maarten de Boer <maarten@resorama.com>
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *  02110-1301, USA.
 * 
 */

#ifndef __Sprite__
#define __Sprite__

#include "TextureMap.hxx"

class Sprite
{
protected:
	TextureMap *map;
public:
	Point pos;
	Point handle;
	bool ownmap;
	Rect GetRect(void)
	{
		return Rect(pos.x,pos.y,map->rect.w,map->rect.h);
	}
	Sprite()
	{
		ownmap = false;
	}
	~Sprite()
	{
		if (ownmap) delete map;
	}
	void Draw(const Rect& rect)
	{
		map->Draw(rect);
	}

	void Draw(void)
	{
		map->Draw(pos);
	}

	void Draw(float angle)
	{
		map->Draw(pos,angle);
	}

	void Move(const Point & toPos)
	{
		pos = toPos;
		pos.x -= handle.x;
		pos.y -= handle.y;
	}
	void CreateTextureMap(Texture* texture,const Rect& rect)
	{
		map = new TextureMap(texture, rect);
		ownmap = true;
	}
};

#endif
