/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCCallSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SQLServerCallableStatement
extends SQLServerPreparedStatement
implements CallableStatement {
    private ArrayList paramNames;
    int nOutParams = 0;
    int nOutParamsAssigned = 0;
    private int outParamIndex = -1;
    private Parameter lastParamAccessed;
    private Object activeStream;
    static final /* synthetic */ boolean $assertionsDisabled;

    SQLServerCallableStatement(SQLServerConnection sQLServerConnection, String string, int n, int n2) throws SQLServerException {
        super(sQLServerConnection, string, n, n2);
    }

    public void registerOutParameter(int n, int n2) throws SQLServerException {
        Object object;
        this.checkClosed();
        if (n < 1 || n > this.inOutParam.length) {
            object = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, ((Format)object).format(objectArray), "7009", false);
        }
        this.resetForReexecute();
        if (DataTypes.isUnsupportedJDBCType(n2)) {
            n2 = -2;
        }
        object = this.inOutParam[n - 1];
        if (!$assertionsDisabled && null == object) {
            throw new AssertionError();
        }
        if (!((Parameter)object).isOutput()) {
            ((Parameter)object).registerForOutput(n2);
            ++this.nOutParams;
        }
    }

    private final Parameter getOutParameter(int n) throws SQLServerException {
        this.processResults();
        if (this.inOutParam[n - 1] == this.lastParamAccessed || this.inOutParam[n - 1].isValueGotten()) {
            return this.inOutParam[n - 1];
        }
        while (this.outParamIndex != n - 1) {
            this.skipOutParameters(1, false);
        }
        return this.inOutParam[n - 1];
    }

    void startResults() {
        super.startResults();
        this.outParamIndex = -1;
        this.nOutParamsAssigned = 0;
        this.lastParamAccessed = null;
        if (!$assertionsDisabled && null != this.activeStream) {
            throw new AssertionError();
        }
    }

    void processBatch() throws SQLServerException {
        this.processResults();
        if (!$assertionsDisabled && this.nOutParams < 0) {
            throw new AssertionError();
        }
        if (this.nOutParams > 0) {
            this.processOutParameters();
            this.processBatchRemainder();
        }
    }

    final void processOutParameters() throws SQLServerException {
        if (!$assertionsDisabled && this.nOutParams <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && null == this.inOutParam) {
            throw new AssertionError();
        }
        this.closeActiveStream();
        if (this.outParamIndex >= 0) {
            for (int i = 0; i < this.inOutParam.length; ++i) {
                if (i == this.outParamIndex || !this.inOutParam[i].isValueGotten()) continue;
                if (!$assertionsDisabled && !this.inOutParam[i].isOutput()) {
                    throw new AssertionError();
                }
                this.inOutParam[i].resetOutputValue();
            }
        }
        if (!$assertionsDisabled && this.nOutParamsAssigned > this.nOutParams) {
            throw new AssertionError();
        }
        if (this.nOutParamsAssigned < this.nOutParams) {
            this.skipOutParameters(this.nOutParams - this.nOutParamsAssigned, true);
        }
        if (this.outParamIndex >= 0) {
            this.inOutParam[this.outParamIndex].skipValue(this.tdsReader, true);
            this.inOutParam[this.outParamIndex].resetOutputValue();
            this.outParamIndex = -1;
        }
    }

    private void processBatchRemainder() throws SQLServerException {
        final class ExecDoneHandler
        extends TDSTokenHandler {
            ExecDoneHandler() {
                super("ExecDoneHandler");
            }

            boolean onDone(TDSReader tDSReader) throws SQLServerException {
                StreamDone streamDone = new StreamDone();
                streamDone.setFromTDS(tDSReader);
                if (streamDone.wasRPCInBatch()) {
                    SQLServerCallableStatement.this.startResults();
                    return false;
                }
                return true;
            }
        }
        ExecDoneHandler execDoneHandler = new ExecDoneHandler();
        TDSParser.parse(this.tdsReader, execDoneHandler);
    }

    private void skipOutParameters(int n, boolean bl) throws SQLServerException {
        final class OutParamHandler
        extends TDSTokenHandler {
            final StreamRetValue srv;
            private boolean foundParam;

            final boolean foundParam() {
                return this.foundParam;
            }

            OutParamHandler() {
                super("OutParamHandler");
                this.srv = new StreamRetValue();
            }

            final void reset() {
                this.foundParam = false;
            }

            boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
                this.srv.setFromTDS(tDSReader);
                this.foundParam = true;
                return false;
            }
        }
        OutParamHandler outParamHandler = new OutParamHandler();
        if (!$assertionsDisabled && n > this.nOutParams - this.nOutParamsAssigned) {
            throw new AssertionError();
        }
        for (int i = 0; i < n; ++i) {
            if (-1 != this.outParamIndex) {
                this.inOutParam[this.outParamIndex].skipValue(this.tdsReader, bl);
                if (bl) {
                    this.inOutParam[this.outParamIndex].resetOutputValue();
                }
            }
            outParamHandler.reset();
            TDSParser.parse(this.tdsReader, outParamHandler);
            if (!outParamHandler.foundParam()) {
                if (bl) break;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(this.outParamIndex + 1)};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
            }
            if (this.connection.isYukonOrLater()) {
                this.outParamIndex = outParamHandler.srv.getOrdinalOrLength();
                this.outParamIndex -= this.outParamIndexAdjustment;
            } else {
                if (!$assertionsDisabled && this.outParamIndex >= this.inOutParam.length) {
                    throw new AssertionError();
                }
                while (!this.inOutParam[++this.outParamIndex].isOutput()) {
                }
            }
            ++this.nOutParamsAssigned;
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLServerException {
        this.checkClosed();
        this.registerOutParameter(n, n2);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.registerOutParameter(n, n2);
        this.inOutParam[n - 1].setOutScale(n3);
    }

    private Parameter getterGetParam(int n) throws SQLServerException {
        Object[] objectArray;
        MessageFormat messageFormat;
        if (n < 1 || n > this.inOutParam.length) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidOutputParameter"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        if (!this.inOutParam[n - 1].isOutput()) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_outputParameterNotRegisteredForOutput"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", true);
        }
        if (null == this.tdsReader) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementMustBeExecuted"), "07009", false);
        }
        this.closeActiveStream();
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + " Getting Param:" + n);
        }
        this.lastParamAccessed = this.getOutParameter(n);
        return this.lastParamAccessed;
    }

    public int getInt(int n) throws SQLServerException {
        this.checkClosed();
        return this.getterGetParam(n).getInt(this.tdsReader);
    }

    public int getInt(String string) throws SQLServerException {
        this.checkClosed();
        return this.getInt(this.findColumn(string));
    }

    public String getString(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(1, this.tdsReader);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public String getString(String string) throws SQLServerException {
        this.checkClosed();
        return this.getString(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLServerException {
        this.checkClosed();
        return ((BigDecimal)this.getterGetParam(n).getValue(3, this.tdsReader)).setScale(n2, 1);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLServerException {
        this.checkClosed();
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public boolean getBoolean(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(-7, this.tdsReader);
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean getBoolean(String string) throws SQLServerException {
        this.checkClosed();
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLServerException {
        this.checkClosed();
        return this.getterGetParam(n).getByte(this.tdsReader);
    }

    public byte getByte(String string) throws SQLServerException {
        this.checkClosed();
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLServerException {
        this.checkClosed();
        return (byte[])this.getterGetParam(n).getValue(-2, this.tdsReader);
    }

    public byte[] getBytes(String string) throws SQLServerException {
        this.checkClosed();
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLServerException {
        this.checkClosed();
        return this.getDate(n, null);
    }

    public Date getDate(String string) throws SQLServerException {
        this.checkClosed();
        return this.getDate(this.findColumn(string), null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return (Date)this.getterGetParam(n).getValue(91, calendar, this.tdsReader);
    }

    public Date getDate(String string, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(8, this.tdsReader);
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    public double getDouble(String string) throws SQLServerException {
        this.checkClosed();
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(6, this.tdsReader);
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public float getFloat(String string) throws SQLServerException {
        this.checkClosed();
        return this.getFloat(this.findColumn(string));
    }

    public long getLong(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(-5, this.tdsReader);
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    public long getLong(String string) throws SQLServerException {
        this.checkClosed();
        return this.getLong(this.findColumn(string));
    }

    public Object getObject(int n) throws SQLServerException {
        Object object;
        this.checkClosed();
        Parameter parameter = this.getterGetParam(n);
        int n2 = parameter.getJdbcType();
        if (6 == n2) {
            n2 = 8;
        }
        if ((object = parameter.getValue(n2, this.tdsReader)) instanceof InputStream || object instanceof Reader) {
            this.activeStream = object;
        }
        return object;
    }

    public Object getObject(String string) throws SQLServerException {
        this.checkClosed();
        return this.getObject(this.findColumn(string));
    }

    public short getShort(int n) throws SQLServerException {
        this.checkClosed();
        return this.getterGetParam(n).getShort(this.tdsReader);
    }

    public short getShort(String string) throws SQLServerException {
        this.checkClosed();
        return this.getShort(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLServerException {
        this.checkClosed();
        return this.getTime(n, null);
    }

    public Time getTime(String string) throws SQLServerException {
        this.checkClosed();
        return this.getTime(this.findColumn(string), null);
    }

    public Time getTime(int n, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return (Time)this.getterGetParam(n).getValue(92, calendar, this.tdsReader);
    }

    public Time getTime(String string, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLServerException {
        this.checkClosed();
        return this.getTimestamp(n, null);
    }

    public Timestamp getTimestamp(String string) throws SQLServerException {
        this.checkClosed();
        return this.getTimestamp(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return (Timestamp)this.getterGetParam(n).getValue(93, calendar, this.tdsReader);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public boolean wasNull() throws SQLServerException {
        this.checkClosed();
        boolean bl = false;
        if (null != this.lastParamAccessed) {
            bl = this.lastParamAccessed.isNull();
        }
        return bl;
    }

    public final InputStream getAsciiStream(int n) throws SQLServerException {
        this.checkClosed();
        Parameter parameter = this.getterGetParam(n);
        parameter.checkGetAsciiStream(this.tdsReader);
        InputStream inputStream = (InputStream)parameter.getValue(1, new InputStreamGetterArgs(3, this.getIsResponseBufferingAdaptive(), this.getIsResponseBufferingAdaptive(), this.toLogString()), null, this.tdsReader);
        this.activeStream = inputStream;
        return inputStream;
    }

    public final InputStream getAsciiStream(String string) throws SQLServerException {
        this.checkClosed();
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLServerException {
        this.checkClosed();
        return (BigDecimal)this.getterGetParam(n).getValue(3, this.tdsReader);
    }

    public BigDecimal getBigDecimal(String string) throws SQLServerException {
        this.checkClosed();
        return this.getBigDecimal(this.findColumn(string));
    }

    public final InputStream getBinaryStream(int n) throws SQLServerException {
        this.checkClosed();
        Parameter parameter = this.getterGetParam(n);
        parameter.checkGetBinaryStream(this.tdsReader);
        InputStream inputStream = (InputStream)parameter.getValue(-4, new InputStreamGetterArgs(1, this.getIsResponseBufferingAdaptive(), this.getIsResponseBufferingAdaptive(), this.toLogString()), null, this.tdsReader);
        this.activeStream = inputStream;
        return inputStream;
    }

    public final InputStream getBinaryStream(String string) throws SQLServerException {
        this.checkClosed();
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLServerException {
        this.checkClosed();
        return (Blob)this.getterGetParam(n).getValue(2004, this.tdsReader);
    }

    public Blob getBlob(String string) throws SQLServerException {
        this.checkClosed();
        return this.getBlob(this.findColumn(string));
    }

    public final Reader getCharacterStream(int n) throws SQLServerException {
        Object object;
        this.checkClosed();
        Parameter parameter = this.getterGetParam(n);
        parameter.checkGetCharacterStream(this.tdsReader);
        this.activeStream = object = parameter.getValue(-1, new InputStreamGetterArgs(2, this.getIsResponseBufferingAdaptive(), this.getIsResponseBufferingAdaptive(), this.toLogString()), null, this.tdsReader);
        if (null != object && object instanceof InputStream) {
            try {
                object = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-16LE"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
            }
        }
        return (Reader)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeActiveStream() throws SQLServerException {
        if (null != this.activeStream) {
            try {
                if (this.activeStream instanceof InputStream) {
                    ((InputStream)this.activeStream).close();
                } else if (this.activeStream instanceof Reader) {
                    ((Reader)this.activeStream).close();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
            }
            finally {
                this.activeStream = null;
            }
        }
    }

    public final Reader getCharacterStream(String string) throws SQLServerException {
        this.checkClosed();
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLServerException {
        this.checkClosed();
        SQLServerClob sQLServerClob = (SQLServerClob)this.getterGetParam(n).getValue(2005, this.tdsReader);
        if (null != sQLServerClob) {
            sQLServerClob.setSQLCollation(this.connection.getDatabaseCollation());
        }
        return sQLServerClob;
    }

    public Clob getClob(String string) throws SQLServerException {
        this.checkClosed();
        return this.getClob(this.findColumn(string));
    }

    public Object getObject(int n, Map map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLServerException {
        this.checkClosed();
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(String string) throws SQLServerException {
        this.checkClosed();
        return this.getRef(this.findColumn(string));
    }

    public Array getArray(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Array getArray(String string) throws SQLServerException {
        this.checkClosed();
        return this.getArray(this.findColumn(string));
    }

    private int findColumn(String string) throws SQLServerException {
        Object object;
        Object object2;
        if (this.paramNames == null) {
            try {
                SQLServerStatement sQLServerStatement = (SQLServerStatement)this.connection.createStatement();
                final class ThreePartNamesParser {
                    private String procedurePart = null;
                    private String ownerPart = null;
                    private String databasePart = null;
                    private final Pattern threePartName = Pattern.compile(JDBCCallSyntaxTranslator.getSQLIdentifierWithGroups());

                    ThreePartNamesParser() {
                    }

                    String getProcedurePart() {
                        return this.procedurePart;
                    }

                    String getOwnerPart() {
                        return this.ownerPart;
                    }

                    String getDatabasePart() {
                        return this.databasePart;
                    }

                    final void parseProcedureNameIntoParts(String string) {
                        if (null != string) {
                            Matcher matcher = this.threePartName.matcher(string);
                            if (matcher.matches()) {
                                if (matcher.group(2) != null) {
                                    this.databasePart = matcher.group(1);
                                    if ((matcher = this.threePartName.matcher(matcher.group(2))).matches()) {
                                        if (null != matcher.group(2)) {
                                            this.ownerPart = matcher.group(1);
                                            this.procedurePart = matcher.group(2);
                                        } else {
                                            this.ownerPart = this.databasePart;
                                            this.databasePart = null;
                                            this.procedurePart = matcher.group(1);
                                        }
                                    }
                                } else {
                                    this.procedurePart = matcher.group(1);
                                }
                            } else {
                                this.procedurePart = string;
                            }
                        }
                    }
                }
                ThreePartNamesParser threePartNamesParser = new ThreePartNamesParser();
                threePartNamesParser.parseProcedureNameIntoParts(this.procedureName);
                StringBuffer stringBuffer = new StringBuffer("exec sp_sproc_columns ");
                if (null != threePartNamesParser.getDatabasePart()) {
                    stringBuffer.append("@procedure_qualifier=");
                    stringBuffer.append(threePartNamesParser.getDatabasePart());
                    stringBuffer.append(", ");
                }
                if (null != threePartNamesParser.getOwnerPart()) {
                    stringBuffer.append("@procedure_owner=");
                    stringBuffer.append(threePartNamesParser.getOwnerPart());
                    stringBuffer.append(", ");
                }
                if (null != threePartNamesParser.getProcedurePart()) {
                    stringBuffer.append("@procedure_name=");
                    stringBuffer.append(threePartNamesParser.getProcedurePart());
                    stringBuffer.append(" , @ODBCVer=3");
                } else {
                    object2 = new MessageFormat(SQLServerException.getErrString("R_parameterNotDefinedForProcedure"));
                    object = new Object[]{string, ""};
                    SQLServerException.makeFromDriverError(this.connection, this, ((Format)object2).format(object), "07009", false);
                }
                object2 = sQLServerStatement.executeQueryInternal(stringBuffer.toString());
                this.paramNames = new ArrayList();
                while (object2.next()) {
                    object = object2.getString(4);
                    this.paramNames.add(((String)object).trim());
                }
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.connection, this, sQLException.toString(), null, false);
            }
        }
        int n = 0;
        if (this.paramNames != null) {
            n = this.paramNames.size();
        }
        int n2 = 0;
        int n3 = -1;
        for (n2 = 0; n2 < n; ++n2) {
            object2 = (String)this.paramNames.get(n2);
            if (!((String)(object2 = ((String)object2).substring(1, ((String)object2).length()))).equals(string)) continue;
            n3 = n2;
            break;
        }
        if (-1 == n3) {
            for (n2 = 0; n2 < n; ++n2) {
                object2 = (String)this.paramNames.get(n2);
                if (!((String)(object2 = ((String)object2).substring(1, ((String)object2).length()))).equalsIgnoreCase(string)) continue;
                n3 = n2;
                break;
            }
        }
        if (-1 == n3) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_parameterNotDefinedForProcedure"));
            object = new Object[]{string, this.procedureName};
            SQLServerException.makeFromDriverError(this.connection, this, ((Format)object2).format(object), "07009", false);
        }
        if (this.bReturnValueSyntax) {
            return n3 + 1;
        }
        return n3;
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTimestamp(this.findColumn(string), timestamp, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTime(this.findColumn(string), time, calendar);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setDate(this.findColumn(string), date, calendar);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLServerException {
        this.checkClosed();
        this.setCharacterStream(this.findColumn(string), reader, n);
    }

    public void setObject(String string, Object object) throws SQLServerException {
        this.checkClosed();
        this.setObject(this.findColumn(string), object);
    }

    public void setObject(String string, Object object, int n) throws SQLServerException {
        this.checkClosed();
        this.setObject(this.findColumn(string), object, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLServerException {
        this.checkClosed();
        this.setObject(this.findColumn(string), object, n, n2);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLServerException {
        this.checkClosed();
        this.setBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLServerException {
        this.checkClosed();
        this.setAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLServerException {
        this.checkClosed();
        this.setTimestamp(this.findColumn(string), timestamp);
    }

    public void setDate(String string, Date date) throws SQLServerException {
        this.checkClosed();
        this.setDate(this.findColumn(string), date);
    }

    public void setTime(String string, Time time) throws SQLServerException {
        this.checkClosed();
        this.setTime(this.findColumn(string), time);
    }

    public void setBytes(String string, byte[] byArray) throws SQLServerException {
        this.checkClosed();
        this.setBytes(this.findColumn(string), byArray);
    }

    public void setByte(String string, byte by) throws SQLServerException {
        this.checkClosed();
        this.setByte(this.findColumn(string), by);
    }

    public void setString(String string, String string2) throws SQLServerException {
        this.checkClosed();
        this.setString(this.findColumn(string), string2);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLServerException {
        this.checkClosed();
        this.setBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void setDouble(String string, double d) throws SQLServerException {
        this.checkClosed();
        this.setDouble(this.findColumn(string), d);
    }

    public void setFloat(String string, float f) throws SQLServerException {
        this.checkClosed();
        this.setFloat(this.findColumn(string), f);
    }

    public void setInt(String string, int n) throws SQLServerException {
        this.checkClosed();
        this.setInt(this.findColumn(string), n);
    }

    public void setLong(String string, long l) throws SQLServerException {
        this.checkClosed();
        this.setLong(this.findColumn(string), l);
    }

    public void setShort(String string, short s) throws SQLServerException {
        this.checkClosed();
        this.setShort(this.findColumn(string), s);
    }

    public void setBoolean(String string, boolean bl) throws SQLServerException {
        this.checkClosed();
        this.setBoolean(this.findColumn(string), bl);
    }

    public void setNull(String string, int n) throws SQLServerException {
        this.checkClosed();
        this.setNull(this.findColumn(string), n);
    }

    public void setNull(String string, int n, String string2) throws SQLServerException {
        this.checkClosed();
        this.setNull(this.findColumn(string), n);
    }

    public void setURL(String string, URL uRL) throws SQLServerException {
        this.checkClosed();
        this.setURL(this.findColumn(string), uRL);
    }

    public URL getURL(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public URL getURL(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLServerException {
        this.checkClosed();
        this.registerOutParameter(this.findColumn(string), n, string2);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        this.registerOutParameter(this.findColumn(string), n, n2);
    }

    public void registerOutParameter(String string, int n) throws SQLServerException {
        this.checkClosed();
        this.registerOutParameter(this.findColumn(string), n);
    }

    static {
        $assertionsDisabled = !SQLServerCallableStatement.class.desiredAssertionStatus();
    }
}

