/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.xml.ws.developer.servlet;

import com.sun.xml.ws.api.server.InstanceResolverAnnotation;
import com.sun.xml.ws.server.servlet.HttpSessionInstanceResolver;

import javax.jws.WebService;
import javax.servlet.http.HttpSession;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import java.lang.annotation.Documented;
import static java.lang.annotation.ElementType.TYPE;
import java.lang.annotation.Retention;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Target;

/**
 * Designates a service class that should be tied to {@link HttpSession} scope.
 *
 * <p>
 * When a service class is annotated with this annotation like the following,
 * the JAX-WS RI runtime will instanciate a new instance of the service class for
 * each {@link HttpSession}.
 *
 * <pre>
 * &#64;{@link WebService}
 * &#64;{@link HttpSessionScope}
 * class CounterService {
 *     protected int count = 0;
 *
 *     public CounterService() {}
 *
 *     public int inc() {
 *         return count++;
 *     }
 * }
 * </pre>
 *
 * <p>
 * This allows you to use instance fields for storing per-session state
 * (in the above example, it will create a separate counter for each client.)
 *
 * <p>
 * The service instance will be GCed when the corresponding {@link HttpSession}
 * is GCed. Refer to servlet documentation for how to configure the timeout behavior.
 *
 * @author Kohsuke Kawaguchi
 * @since JAX-WS 2.1
 */
@Retention(RUNTIME)
@Target(TYPE)
@Documented
@WebServiceFeatureAnnotation(id=HttpSessionScopeFeature.ID, bean=HttpSessionScopeFeature.class)
@InstanceResolverAnnotation(HttpSessionInstanceResolver.class)
public @interface HttpSessionScope {
}
